/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.gui.listcard.SolubilizationCard;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SolubilizationController
extends ListController {
    private final TableModel tableModel;
    private final ListModel<CatalogObject> listModel;

    public SolubilizationController(MainWindowController mainWindowController) {
        super(new SolubilizationCard(), mainWindowController);
        ((SolubilizationCard)this.view).addRadioButtonListener("typeDiff", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((SolubilizationCard)this.view).addRadioButtonListener("typeEQ", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((SolubilizationCard)this.view).addRadioButtonListener("baseDiffCatalog", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((SolubilizationCard)this.view).addRadioButtonListener("baseDiffIso", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((SolubilizationCard)this.view).addRadioButtonListener("baseEqCatalog", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((SolubilizationCard)this.view).addRadioButtonListener("baseEqIso", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.tableModel = new TableModel();
        this.listModel = new DefaultListModel<CatalogObject>();
    }

    @Override
    public void loadModelDataAndShowView() {
        ((DefaultListModel)this.listModel).clear();
        if (this.model.allPollutants() != null && this.model.allPollutants().size() > 0) {
            for (CatalogObject catalogObject : this.model.allPollutants()) {
                ((DefaultListModel)this.listModel).addElement((Pollutant)catalogObject);
            }
            this.tableModel.setPollutant(this.model.allPollutants().get(0));
        }
        ((SolubilizationCard)this.view).addTableModel(this.tableModel);
        ((SolubilizationCard)this.view).addSolubilizationListModel(this.listModel);
        ((SolubilizationCard)this.view).addSolubilizationListSelectionListener(new SolubilizationListSelectionListener());
        if (this.model.allPollutants() != null && ((SolubilizationCard)this.view).getPolList().getSelectedIndex() == -1) {
            ((SolubilizationCard)this.view).getPolList().setSelectedIndex(0);
            ((SolubilizationCard)this.view).getPolList().requestFocusInWindow();
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((SolubilizationCard)this.view).getTable().isEditing()) {
            ((SolubilizationCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_solubilization_tcol6)};
        private Pollutant pollutant;

        public void setPollutant(Pollutant pollutant) {
            this.pollutant = pollutant;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            if (SolubilizationController.this.model.allSurfactants().size() > 0) {
                return SolubilizationController.this.model.allSurfactants().size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return SolubilizationController.this.model.allSurfactants().get(n).getBezeichnung();
            }
            if (n2 == 2) {
                return Double.valueOf(SolubilizationController.this.model.getSolubilizationValuesForPolutantAndSurfactant(this.pollutant, SolubilizationController.this.model.allSurfactants().get(n))[n2 - 1]).intValue();
            }
            return SolubilizationController.this.model.getSolubilizationValuesForPolutantAndSurfactant(this.pollutant, SolubilizationController.this.model.allSurfactants().get(n))[n2 - 1];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 2) {
                return Integer.class;
            }
            return Double.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            double[] dArray = SolubilizationController.this.model.getSolubilizationValuesForPolutantAndSurfactant(this.pollutant, SolubilizationController.this.model.allSurfactants().get(n));
            if (n2 == 2) {
                try {
                    dArray[n2 - 1] = ((Integer)object).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    dArray[n2 - 1] = (Double)object;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            SolubilizationController.this.model.setSolubilizationValuesForPollutantAndSurfactant(this.pollutant, SolubilizationController.this.model.allSurfactants().get(n), dArray);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private final class SolubilizationListSelectionListener
    implements ListSelectionListener {
        private SolubilizationListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && SolubilizationController.this.model.allSurfactants() != null && SolubilizationController.this.model.allSurfactants().size() > 0) {
                if (((SolubilizationCard)SolubilizationController.this.view).getTable().isEditing()) {
                    ((SolubilizationCard)SolubilizationController.this.view).getTable().getCellEditor().stopCellEditing();
                }
                int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
                SolubilizationController.this.tableModel.setPollutant((Pollutant)SolubilizationController.this.listModel.getElementAt(n));
            }
        }
    }
}

