/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.ResultCard;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;

public class ResultController
extends ListController {
    private int numberOfResults;

    public ResultController(MainWindowController mainWindowController, String string) {
        super(new ResultCard(), mainWindowController);
        mainWindowController.getView().addCardToResultPanel(this.getView(), string);
        this.view.getNext().setVisible(false);
        this.view.getPrev().setVisible(false);
    }

    public ResultController(MainWindowController mainWindowController, String string, ResultCard resultCard) {
        super(resultCard, mainWindowController);
        mainWindowController.getView().addCardToResultPanel(this.getView(), string);
        resultCard.getNext().setVisible(false);
        resultCard.getPrev().setVisible(false);
    }

    @Override
    public void loadModelDataAndShowView() {
        this.view.setVisible(true);
    }

    public void addResultPlot(JPanel jPanel) {
        if (jPanel == null) {
            return;
        }
        ++this.numberOfResults;
        ((ResultCard)this.view).addCard(jPanel);
        if (this.numberOfResults > 1) {
            this.view.getNext().setVisible(true);
            this.view.getPrev().setVisible(true);
        }
    }

    public void clearResultPlots() {
        for (int i = 0; i < this.numberOfResults; ++i) {
            ((ResultCard)this.view).getCardPanel().remove(0);
        }
        this.numberOfResults = 0;
        this.view.getNext().setVisible(false);
        this.view.getPrev().setVisible(false);
    }

    @Override
    protected void addListener() {
        this.view.addNextButtonListener(new ListController.NextButtonListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ResultCard)ResultController.this.view).getCardLayout().next(((ResultCard)ResultController.this.view).getCardPanel());
            }
        });
        this.view.addPrevButtonListener(new ListController.PrevButtonListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ResultCard)ResultController.this.view).getCardLayout().previous(((ResultCard)ResultController.this.view).getCardPanel());
            }
        });
    }

    @Override
    public boolean writeUserInputToProject() {
        return true;
    }
}

