/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.ResidenceTimeCard;
import de.dsite.project.SecondaryLayer;
import de.dsite.utils.FileUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResidenceTimeController
extends ListController {
    private final ListModel<SecondaryLayer> listModel;
    private SecondaryLayer lastSelectedSecondaryLayer;
    private static final String NAME_OF_DATA_DIRECTORY = "./data/";

    public ResidenceTimeController(MainWindowController mainWindowController) {
        super(new ResidenceTimeCard(), mainWindowController);
        ((ResidenceTimeCard)this.view).addListSelectionListener(new ResidenceTimeListSelectionListener());
        ResidenceTimeTextFieldFocusListener residenceTimeTextFieldFocusListener = new ResidenceTimeTextFieldFocusListener();
        ((ResidenceTimeCard)this.view).addTextFieldFocusListenerForTextField("tf_fileChooser", residenceTimeTextFieldFocusListener);
        ((ResidenceTimeCard)this.view).addTextFieldFocusListenerForTextField("tf_alphaValue", residenceTimeTextFieldFocusListener);
        ((ResidenceTimeCard)this.view).addTextFieldFocusListenerForTextField("tf_numResidenceCells", residenceTimeTextFieldFocusListener);
        ResidenceTimeTextFieldActionListener residenceTimeTextFieldActionListener = new ResidenceTimeTextFieldActionListener();
        ((ResidenceTimeCard)this.view).addTextFieldActionListenerForTextField("tf_alphaValue", residenceTimeTextFieldActionListener);
        ((ResidenceTimeCard)this.view).addTextFieldActionListenerForTextField("tf_numResidenceCells", residenceTimeTextFieldActionListener);
        ((ResidenceTimeCard)this.view).addRadioButtonAlphaListener(new RadioButtonAlphaListener());
        ((ResidenceTimeCard)this.view).addRadioButtonFileListener(new RadioButtonFileListener());
        ((ResidenceTimeCard)this.view).addSelectFileButtonActionListener(new ButtonSelectFileListener());
        this.listModel = new DefaultListModel<SecondaryLayer>();
        ((ResidenceTimeCard)this.view).addListModel(this.listModel);
        if (this.model.getLeaves().size() > 0) {
            for (SecondaryLayer secondaryLayer : this.model.getLeaves()) {
                ((DefaultListModel)this.listModel).addElement(secondaryLayer);
            }
            File file = this.checkForData(this.model.getLeaves().get(0).getResidenceFile());
            try {
                ((ResidenceTimeCard)this.view).getTf_fileChooser().setText(file.getCanonicalPath());
            }
            catch (Exception exception) {
                ((ResidenceTimeCard)this.view).getTf_fileChooser().setText(file.getAbsolutePath());
            }
            ((ResidenceTimeCard)this.view).getTf_alphaValue().setText("" + this.model.getLeaves().get(0).getResidenceAlpha());
            ((ResidenceTimeCard)this.view).getTf_numResidenceCells().setText("" + this.model.getLeaves().get(0).getResidenceNumOfCells());
            this.lastSelectedSecondaryLayer = this.model.getLeaves().get(0);
        }
    }

    @Override
    public void loadModelDataAndShowView() {
        ((DefaultListModel)this.listModel).clear();
        for (SecondaryLayer secondaryLayer : this.model.getLeaves()) {
            ((DefaultListModel)this.listModel).addElement(secondaryLayer);
        }
        ((ResidenceTimeCard)this.view).addListModel(this.listModel);
        File file = this.checkForData(this.model.getLeaves().get(0).getResidenceFile());
        try {
            ((ResidenceTimeCard)this.view).getTf_fileChooser().setText(file.getCanonicalPath());
        }
        catch (Exception exception) {
            ((ResidenceTimeCard)this.view).getTf_fileChooser().setText(file.getAbsolutePath());
        }
        ((ResidenceTimeCard)this.view).getTf_alphaValue().setText("" + this.model.getLeaves().get(0).getResidenceAlpha());
        ((ResidenceTimeCard)this.view).getTf_numResidenceCells().setText("" + this.model.getLeaves().get(0).getResidenceNumOfCells());
        if (((ResidenceTimeCard)this.view).getListOfSecondaryLayers().getSelectedIndex() < 0) {
            ((ResidenceTimeCard)this.view).getListOfSecondaryLayers().setSelectedIndex(0);
            this.lastSelectedSecondaryLayer = this.model.getLeaves().get(0);
            if (this.model.getLeaves().get(0).isResidenceCalculationFromFile()) {
                ((ResidenceTimeCard)this.view).getFileButton().doClick();
            } else {
                ((ResidenceTimeCard)this.view).getAlphaButton().doClick();
            }
        }
        this.view.setVisible(true);
    }

    private File checkForData(String string) {
        File file = new File(string);
        if (!FileUtils.fileExists(file) && (file = FileUtils.dataSubfolderExists(file.getName())) == null) {
            file = FileUtils.getDataFolder();
        }
        return file;
    }

    private void validateAndWriteTextFieldInput(JTextField jTextField) {
        block14: {
            String string = jTextField.getName();
            jTextField.selectAll();
            int n = ((ResidenceTimeCard)this.view).getListOfSecondaryLayers().getSelectedIndex();
            SecondaryLayer secondaryLayer = this.model.getLeaves().get(n);
            if (string == "tf_fileChooser") {
                try {
                    secondaryLayer.setResidenceFile(jTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string == "tf_alphaValue") {
                try {
                    double d = Double.parseDouble(jTextField.getText());
                    if (d >= 0.0 && d <= 1.0) {
                        secondaryLayer.setResidenceAlpha(d);
                        break block14;
                    }
                    jTextField.setText("" + secondaryLayer.getResidenceAlpha());
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.setText("" + secondaryLayer.getResidenceAlpha());
                }
            } else if (string == "tf_numResidenceCells") {
                try {
                    int n2 = Integer.parseInt(jTextField.getText());
                    if (n2 > 0) {
                        secondaryLayer.setResidenceNumOfCells(n2);
                        break block14;
                    }
                    jTextField.setText("" + secondaryLayer.getResidenceNumOfCells());
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.setText("" + secondaryLayer.getResidenceNumOfCells());
                }
            } else {
                throw new IllegalArgumentException("TextField (sender) " + string + " not found!");
            }
        }
    }

    @Override
    public boolean writeUserInputToProject() {
        return true;
    }

    private final class ButtonSelectFileListener
    implements ActionListener {
        private ButtonSelectFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JFileChooser jFileChooser;
            int n = ((ResidenceTimeCard)ResidenceTimeController.this.view).getListOfSecondaryLayers().getSelectedIndex();
            SecondaryLayer secondaryLayer = ResidenceTimeController.this.model.getLeaves().get(n);
            if (secondaryLayer.getResidenceFile() != null) {
                File file2 = ResidenceTimeController.this.checkForData(secondaryLayer.getResidenceFile());
                if (FileUtils.directoryExists(file2)) {
                    jFileChooser = new JFileChooser(file2);
                } else {
                    file2 = new File(ResidenceTimeController.NAME_OF_DATA_DIRECTORY);
                    jFileChooser = new JFileChooser(file2);
                }
            } else {
                jFileChooser = new JFileChooser();
            }
            jFileChooser.setFileSelectionMode(0);
            int n2 = jFileChooser.showOpenDialog(null);
            if (n2 == 0 && (file = jFileChooser.getSelectedFile()).canWrite()) {
                try {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setText(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setText(file.getAbsolutePath());
                }
                secondaryLayer.setResidenceFile(file.getPath());
            }
        }
    }

    private final class RadioButtonFileListener
    implements ActionListener {
        private RadioButtonFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setEnabled(true);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getSelectFileButton().setEnabled(true);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_alphaValue().setEnabled(false);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_numResidenceCells().setEnabled(false);
            int n = ((ResidenceTimeCard)ResidenceTimeController.this.view).getListOfSecondaryLayers().getSelectedIndex();
            SecondaryLayer secondaryLayer = ResidenceTimeController.this.model.getLeaves().get(n);
            secondaryLayer.setResidenceCalculationFromFile(true);
        }
    }

    private final class RadioButtonAlphaListener
    implements ActionListener {
        private RadioButtonAlphaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setEnabled(false);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getSelectFileButton().setEnabled(false);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_alphaValue().setEnabled(true);
            ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_numResidenceCells().setEnabled(true);
            int n = ((ResidenceTimeCard)ResidenceTimeController.this.view).getListOfSecondaryLayers().getSelectedIndex();
            SecondaryLayer secondaryLayer = ResidenceTimeController.this.model.getLeaves().get(n);
            secondaryLayer.setResidenceCalculationFromFile(false);
        }
    }

    private final class ResidenceTimeTextFieldActionListener
    implements ActionListener {
        private ResidenceTimeTextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResidenceTimeController.this.validateAndWriteTextFieldInput((JTextField)actionEvent.getSource());
        }
    }

    private final class ResidenceTimeTextFieldFocusListener
    implements FocusListener {
        private ResidenceTimeTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ResidenceTimeController.this.validateAndWriteTextFieldInput((JTextField)focusEvent.getComponent());
        }
    }

    private final class ResidenceTimeListSelectionListener
    implements ListSelectionListener {
        private ResidenceTimeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                try {
                    double d = Double.parseDouble(((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_alphaValue().getText());
                    if (d >= 0.0 && d <= 1.0) {
                        ResidenceTimeController.this.lastSelectedSecondaryLayer.setResidenceAlpha(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    int n = Integer.parseInt(((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_numResidenceCells().getText());
                    if (n > 0) {
                        ResidenceTimeController.this.lastSelectedSecondaryLayer.setResidenceNumOfCells(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int n = ((ResidenceTimeCard)ResidenceTimeController.this.view).getListOfSecondaryLayers().getSelectedIndex();
                SecondaryLayer secondaryLayer = ResidenceTimeController.this.model.getLeaves().get(n);
                ResidenceTimeController.this.lastSelectedSecondaryLayer = secondaryLayer;
                File file = ResidenceTimeController.this.checkForData(secondaryLayer.getResidenceFile());
                try {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setText(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_fileChooser().setText(file.getAbsolutePath());
                }
                ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_alphaValue().setText("" + secondaryLayer.getResidenceAlpha());
                ((ResidenceTimeCard)ResidenceTimeController.this.view).getTf_numResidenceCells().setText("" + secondaryLayer.getResidenceNumOfCells());
                if (secondaryLayer.isResidenceCalculationFromFile()) {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getFileButton().doClick();
                } else {
                    ((ResidenceTimeCard)ResidenceTimeController.this.view).getAlphaButton().doClick();
                }
            }
        }
    }
}

