/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.OutputSpecsCard;
import de.dsite.project.VersionedProject;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class OutputSpecsController
extends ListController {
    private final TableModel tableModelBtc;
    private final TableModelProf tableModelProf;

    public OutputSpecsController(MainWindowController mainWindowController) {
        super(new OutputSpecsCard(), mainWindowController);
        ((OutputSpecsCard)this.view).addAddColumnBtcButtonListener(new AddColumnButtonListener());
        ((OutputSpecsCard)this.view).addDelColumnBtcButtonListener(new DelColumnButtonListener());
        this.tableModelBtc = new TableModel();
        ((OutputSpecsCard)this.view).addTableBtcModel(this.tableModelBtc);
        ((OutputSpecsCard)this.view).addAddColumnProfButtonListener(new AddColumnProfButtonListener());
        ((OutputSpecsCard)this.view).addDelColumnProfButtonListener(new DelColumnProfButtonListener());
        this.tableModelProf = new TableModelProf();
        ((OutputSpecsCard)this.view).addTableProfModel(this.tableModelProf);
    }

    @Override
    public void loadModelDataAndShowView() {
        int n;
        Object[][] objectArray;
        ((OutputSpecsCard)this.view).getTimeIntervallInfo().setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_output_lbl3) + ": " + this.model.getTimesteps().sumOfTimestepLengthsInSeconds() + " s  ");
        if (this.model.getMode() == VersionedProject.SimulationMode.SMART) {
            ((OutputSpecsCard)this.view).getAddColumnToBtc().setEnabled(false);
            ((OutputSpecsCard)this.view).getDelColumnFromBtc().setEnabled(false);
            if (this.model.getLeaves() != null && this.model.getLeaves().size() > 0) {
                objectArray = new Object[this.model.getLeaves().size()][2];
                for (n = 0; n < this.model.getLeaves().size(); ++n) {
                    objectArray[n][0] = n + 1;
                    objectArray[n][1] = this.model.getLeaves().get(n).getXUK();
                }
                this.tableModelBtc.setTableData(objectArray);
            }
        } else {
            ((OutputSpecsCard)this.view).getAddColumnToBtc().setEnabled(true);
            ((OutputSpecsCard)this.view).getDelColumnFromBtc().setEnabled(true);
            if (this.model.getBtcValues() != null && this.model.getLeaves() != null && this.model.getLeaves().size() > 0) {
                objectArray = new Object[this.model.getBtcValues().length + 1][2];
                objectArray[0][0] = 1;
                objectArray[0][1] = this.model.getLeaves().get(this.model.getLeaves().size() - 1).getXUK();
                for (n = 0; n < this.model.getBtcValues().length; ++n) {
                    objectArray[n + 1][0] = n + 2;
                    objectArray[n + 1][1] = this.model.getBtcValues()[n];
                }
                this.tableModelBtc.setTableData(objectArray);
            } else if (this.model.getLeaves() != null && this.model.getLeaves().size() > 0) {
                objectArray = new Object[1][2];
                objectArray[0][0] = 1;
                objectArray[0][1] = this.model.getLeaves().get(this.model.getLeaves().size() - 1).getXUK();
                this.tableModelBtc.setTableData(objectArray);
            }
        }
        if (this.model.getProfileValues() != null) {
            objectArray = new Object[this.model.getProfileValues().length][2];
            for (n = 0; n < this.model.getProfileValues().length; ++n) {
                objectArray[n][0] = n + 1;
                objectArray[n][1] = this.model.getProfileValues()[n];
            }
            this.tableModelProf.setTableData(objectArray);
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        int n;
        double[] dArray;
        if (this.model.getMode() == VersionedProject.SimulationMode.NORMAL) {
            if (((OutputSpecsCard)this.view).getTableBtc().isEditing()) {
                ((OutputSpecsCard)this.view).getTableBtc().getCellEditor().stopCellEditing();
            }
            dArray = new double[this.tableModelBtc.getTableData().length - 1];
            for (n = 0; n < this.tableModelBtc.getTableData().length - 1; ++n) {
                dArray[n] = (Double)this.tableModelBtc.getTableData()[n + 1][1];
            }
            Arrays.sort(dArray);
            this.model.setBtcValues(dArray);
        } else if (this.tableModelBtc.getTableData().length > 1) {
            dArray = new double[this.tableModelBtc.getTableData().length - 1];
            for (n = 0; n < this.tableModelBtc.getTableData().length - 1; ++n) {
                dArray[n] = (Double)this.tableModelBtc.getTableData()[n][1];
            }
            this.model.setBtcValues(dArray);
        }
        if (((OutputSpecsCard)this.view).getTableProf().isEditing()) {
            ((OutputSpecsCard)this.view).getTableProf().getCellEditor().stopCellEditing();
        }
        if (this.tableModelProf.getTableData() != null && this.tableModelProf.getTableData().length > 0) {
            dArray = new double[this.tableModelProf.getTableData().length];
            for (n = 0; n < this.tableModelProf.getTableData().length; ++n) {
                dArray[n] = (Double)this.tableModelProf.getTableData()[n][1];
            }
            Arrays.sort(dArray);
            this.model.setProfileValues(dArray);
        }
        return true;
    }

    private class TableModelProf
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_output_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_output_tcol4)};
        private Object[][] data;

        private TableModelProf() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                try {
                    object = Integer.parseInt((String)object);
                    this.data[n][n2] = (int)((Integer)object);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    object = Double.parseDouble((String)object);
                    this.data[n][n2] = (double)((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void addRow() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            Object[][] objectArray = new Object[n + 1][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    objectArray[i][j] = this.data[i][j];
                }
            }
            objectArray[n][0] = n + 1;
            objectArray[n][1] = 1.0;
            this.data = objectArray;
            this.fireTableRowsInserted(n, n);
        }

        public void deleteRowAtIndex(int n) {
            int n2 = this.data.length;
            int n3 = this.data[0].length;
            if (n2 > 0 && n >= 0 && n < n2) {
                Object[][] objectArray = new Object[n2 - 1][n3];
                for (int i = 0; i < n2 - 1; ++i) {
                    objectArray[i][0] = i + 1;
                    for (int j = 1; j < n3; ++j) {
                        if (i < n) {
                            objectArray[i][j] = this.data[i][j];
                            continue;
                        }
                        if (i < n) continue;
                        objectArray[i][j] = this.data[i + 1][j];
                    }
                }
                this.data = objectArray;
                this.fireTableRowsInserted(n2 - 1, n2 - 1);
            }
        }

        private Object[][] getTableData() {
            return this.data;
        }

        private void setTableData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableStructureChanged();
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_output_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_output_tcol2)};
        private Object[][] data = new Object[1][2];

        TableModel() {
            this.data[0][0] = 1;
            if (OutputSpecsController.this.model.getLeaves() != null && OutputSpecsController.this.model.getLeaves().size() > 0) {
                this.data[0][1] = OutputSpecsController.this.model.getLeaves().get(OutputSpecsController.this.model.getLeaves().size() - 1).getXUK();
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (OutputSpecsController.this.model.getMode() == VersionedProject.SimulationMode.SMART) {
                return false;
            }
            return n2 > 0 && n > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                try {
                    object = Integer.parseInt((String)object);
                    this.data[n][n2] = (int)((Integer)object);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    object = Double.parseDouble((String)object);
                    this.data[n][n2] = (double)((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void addRow() {
            int n = this.data.length;
            int n2 = this.data[0].length;
            Object[][] objectArray = new Object[n + 1][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    objectArray[i][j] = this.data[i][j];
                }
            }
            objectArray[n][0] = n + 1;
            objectArray[n][1] = 1.0;
            this.data = objectArray;
            this.fireTableRowsInserted(n, n);
        }

        public void deleteRowAtIndex(int n) {
            int n2 = this.data.length;
            int n3 = this.data[0].length;
            if (n2 > 1 && n > 0 && n < n2) {
                Object[][] objectArray = new Object[n2 - 1][n3];
                for (int i = 0; i < n2 - 1; ++i) {
                    objectArray[i][0] = i + 1;
                    for (int j = 1; j < n3; ++j) {
                        if (i < n) {
                            objectArray[i][j] = this.data[i][j];
                            continue;
                        }
                        if (i < n) continue;
                        objectArray[i][j] = this.data[i + 1][j];
                    }
                }
                this.data = objectArray;
                this.fireTableRowsInserted(n2 - 1, n2 - 1);
            }
        }

        private Object[][] getTableData() {
            return this.data;
        }

        private void setTableData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableStructureChanged();
        }
    }

    private final class DelColumnProfButtonListener
    implements ActionListener {
        private DelColumnProfButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((OutputSpecsCard)OutputSpecsController.this.view).getTableProf().isEditing()) {
                ((OutputSpecsCard)OutputSpecsController.this.view).getTableProf().getCellEditor().stopCellEditing();
            }
            if (((OutputSpecsCard)OutputSpecsController.this.view).getTableProf().getSelectedRow() != -1) {
                OutputSpecsController.this.tableModelProf.deleteRowAtIndex(((OutputSpecsCard)OutputSpecsController.this.view).getTableProf().getSelectedRow());
            }
        }
    }

    private final class AddColumnProfButtonListener
    implements ActionListener {
        private AddColumnProfButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OutputSpecsController.this.tableModelProf.addRow();
        }
    }

    private final class DelColumnButtonListener
    implements ActionListener {
        private DelColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((OutputSpecsCard)OutputSpecsController.this.view).getTableBtc().isEditing()) {
                ((OutputSpecsCard)OutputSpecsController.this.view).getTableBtc().getCellEditor().stopCellEditing();
            }
            if (((OutputSpecsCard)OutputSpecsController.this.view).getTableBtc().getSelectedRow() != -1) {
                OutputSpecsController.this.tableModelBtc.deleteRowAtIndex(((OutputSpecsCard)OutputSpecsController.this.view).getTableBtc().getSelectedRow());
            }
        }
    }

    private final class AddColumnButtonListener
    implements ActionListener {
        private AddColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OutputSpecsController.this.tableModelBtc.addRow();
        }
    }
}

