/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.listcard.MonomereLayerCard;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class MonomereLayerController
extends ListController {
    private final TableModel tableModel;
    private final ListModel<CatalogObject> listModel;

    public MonomereLayerController(MainWindowController mainWindowController) {
        super(new MonomereLayerCard(), mainWindowController);
        ((MonomereLayerCard)this.view).addRadioButtonListener("typeDiff", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((MonomereLayerCard)this.view).addRadioButtonListener("typeEQ", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((MonomereLayerCard)this.view).addRadioButtonListener("baseDiffCatalog", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((MonomereLayerCard)this.view).addRadioButtonListener("baseDiffIso", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((MonomereLayerCard)this.view).addRadioButtonListener("baseEqCatalog", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((MonomereLayerCard)this.view).addRadioButtonListener("baseEqIso", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.tableModel = new TableModel();
        this.listModel = new DefaultListModel<CatalogObject>();
    }

    @Override
    public void loadModelDataAndShowView() {
        ((DefaultListModel)this.listModel).clear();
        if (this.model.allSurfactants() != null && this.model.allSurfactants().size() > 0) {
            for (CatalogObject catalogObject : this.model.allSurfactants()) {
                ((DefaultListModel)this.listModel).addElement((Surfactant)catalogObject);
            }
            this.tableModel.setSurfactant(this.model.allSurfactants().get(0));
        }
        ((MonomereLayerCard)this.view).addTableModel(this.tableModel);
        ((MonomereLayerCard)this.view).addMonomereLayerListModel(this.listModel);
        ((MonomereLayerCard)this.view).addMonomereLayerListSelectionListener(new MonomereLayerListSelectionListener());
        if (this.model.allSurfactants() != null && ((MonomereLayerCard)this.view).getSurList().getSelectedIndex() == -1) {
            ((MonomereLayerCard)this.view).getSurList().setSelectedIndex(0);
            ((MonomereLayerCard)this.view).getSurList().requestFocusInWindow();
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((MonomereLayerCard)this.view).getTable().isEditing()) {
            ((MonomereLayerCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_monomerelayer_tcol6)};
        private Surfactant surfactant;

        public void setSurfactant(Surfactant surfactant) {
            this.surfactant = surfactant;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            if (MonomereLayerController.this.model.allSurfactants().size() > 0) {
                return MonomereLayerController.this.model.allAquiferMaterials().size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return MonomereLayerController.this.model.allAquiferMaterials().get(n).getBezeichnung();
            }
            if (n2 == 2) {
                return Double.valueOf(MonomereLayerController.this.model.getMonomereLayerValuesForSurfactantAndAquiferMaterial(this.surfactant, MonomereLayerController.this.model.allAquiferMaterials().get(n))[n2 - 1]).intValue();
            }
            return MonomereLayerController.this.model.getMonomereLayerValuesForSurfactantAndAquiferMaterial(this.surfactant, MonomereLayerController.this.model.allAquiferMaterials().get(n))[n2 - 1];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 2) {
                return Integer.class;
            }
            return Double.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            double[] dArray = MonomereLayerController.this.model.getMonomereLayerValuesForSurfactantAndAquiferMaterial(this.surfactant, MonomereLayerController.this.model.allAquiferMaterials().get(n));
            if (n2 == 2) {
                try {
                    dArray[n2 - 1] = ((Integer)object).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    dArray[n2 - 1] = (Double)object;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MonomereLayerController.this.model.setMonomereLayerValuesForSurfactantAndAquiferMaterial(this.surfactant, MonomereLayerController.this.model.allAquiferMaterials().get(n), dArray);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private final class MonomereLayerListSelectionListener
    implements ListSelectionListener {
        private MonomereLayerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && MonomereLayerController.this.model.allSurfactants() != null && MonomereLayerController.this.model.allSurfactants().size() > 0) {
                if (((MonomereLayerCard)MonomereLayerController.this.view).getTable().isEditing()) {
                    ((MonomereLayerCard)MonomereLayerController.this.view).getTable().getCellEditor().stopCellEditing();
                }
                int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
                MonomereLayerController.this.tableModel.setSurfactant((Surfactant)MonomereLayerController.this.listModel.getElementAt(n));
            }
        }
    }
}

