/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.GrainSize;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.gui.listcard.MaterialCard;
import de.dsite.project.Material;
import de.dsite.utils.FileUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;

public class MaterialController
extends ListController {
    private Mode mode;
    private Material selectedMaterial;
    private final ListModel<Material> listModel;
    private final TableModelAmat tableModelAmat;
    private final TableModelGrainSize tableModelGrainSize;
    private final TableModelComposition tableModelComposition;
    private final DefaultComboBoxModel<AquiferMaterial> comboBoxModelAquiferMaterials = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<GrainSize> comboBoxModelGs = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<GrainSize> comboBoxModelGsDIN = new DefaultComboBoxModel();
    private static final String defalutNameAquiferMaterial = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.aquifer_material_default_name);
    HashSet<Material> materialSet;
    private final ArrayList<GrainSize> grainsizesDIN;
    private File resultsFolder;

    /*
     * WARNING - void declaration
     */
    public MaterialController(MainWindowController mainWindowController) {
        super(new MaterialCard(), mainWindowController);
        void var5_11;
        GrainFractionDINValue grainFractionDINValue;
        void var5_9;
        GrainFractionDINValue[] grainFractionDINValueArray;
        this.tableModelComposition = new TableModelComposition();
        this.listModel = new DefaultListModel<Material>();
        this.materialSet = new HashSet();
        ((MaterialCard)this.view).addTextFieldActionListener(new TextFieldActionListener());
        ((MaterialCard)this.view).addTextFieldFocusListener(new TextFieldFocusListener());
        this.resultsFolder = FileUtils.getMaterialFolder();
        this.tableModelAmat = new TableModelAmat();
        ((MaterialCard)this.view).addTableModelAquiferMaterials(this.tableModelAmat);
        Vector<AquiferMaterial> vector = new Vector<AquiferMaterial>();
        try {
            grainFractionDINValueArray = FileUtils.convertCatalogFileToAquifermaterial(FileUtils.getCatalogFileSoil());
            for (CatalogObject catalogObject : grainFractionDINValueArray) {
                vector.add((AquiferMaterial)catalogObject);
                this.comboBoxModelAquiferMaterials.addElement((AquiferMaterial)catalogObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((MaterialCard)this.view).addAquiferComboBoxModel(this.comboBoxModelAquiferMaterials);
        ((MaterialCard)this.view).addAddNewAquiferMaterialButtonListener(new AddLithoButtonListener());
        ((MaterialCard)this.view).addAddCatalogAquiferMaterialButtonListener(new AddLithoFromCatalogButtonListener());
        ((MaterialCard)this.view).addDelAquiferMaterialButtonListener(new DelLithoButtonListener());
        ((MaterialCard)this.view).selectFileMaterialActionListener(new ButtonSelectFileListener());
        ((MaterialCard)this.view).storeFileMaterialActionListener(new ButtonStoreToFileListener());
        this.tableModelGrainSize = new TableModelGrainSize();
        ((MaterialCard)this.view).addTableModelGrainSize(this.tableModelGrainSize);
        this.grainsizesDIN = new ArrayList();
        grainFractionDINValueArray = GrainFractionDINValue.values();
        int n = grainFractionDINValueArray.length;
        boolean bl = false;
        while (var5_9 < n) {
            grainFractionDINValue = grainFractionDINValueArray[var5_9];
            this.grainsizesDIN.add(new GrainSize(grainFractionDINValue.name, grainFractionDINValue.abbreviation, grainFractionDINValue.size));
            ++var5_9;
        }
        grainFractionDINValueArray = GrainFractionDINValue.values();
        n = grainFractionDINValueArray.length;
        boolean bl2 = false;
        while (var5_11 < n) {
            grainFractionDINValue = grainFractionDINValueArray[var5_11];
            this.comboBoxModelGsDIN.addElement(new GrainSize(grainFractionDINValue.name, grainFractionDINValue.abbreviation, grainFractionDINValue.size));
            ++var5_11;
        }
        ((MaterialCard)this.view).addCompositionTableModel(this.tableModelComposition);
        this.setMode(Mode.USER);
        ((MaterialCard)this.view).setRadioButtonUserDef(true);
        ((MaterialCard)this.view).addGrainSizeComboBoxModel(this.comboBoxModelGsDIN);
        ((MaterialCard)this.view).addAddNewGrainSizeButtonListener(new AddGrainSizeButtonListener());
        ((MaterialCard)this.view).addAddDefaultOrDinGrainSizeButtonListener(new AddGrainSizeFromCatalogButtonListener());
        ((MaterialCard)this.view).addDelGrainSizeButtonListener(new DelGrainSizeButtonListener());
        ((MaterialCard)this.view).addMaterialListSelectionListener(new MaterialListSelectionListener());
        ((MaterialCard)this.view).addAddMaterialButtonListener(new AddMaterialButtonListener());
        ((MaterialCard)this.view).addDelMaterialButtonListener(new DelMaterialButtonListener());
        ((MaterialCard)this.view).addDinButtonListener(new DinButtonListener());
        ((MaterialCard)this.view).addUserDefButtonListener(new UserDefButtonListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        ((DefaultListModel)this.listModel).clear();
        if (this.model.allMaterials().size() > 0) {
            for (Material material : this.model.allMaterials()) {
                ((DefaultListModel)this.listModel).addElement(material);
            }
        }
        ((MaterialCard)this.view).addMaterialListModel(this.listModel);
        this.view.setVisible(true);
        if (this.listModel.getSize() > 0) {
            if (((MaterialCard)this.view).getMaterialList().getSelectedIndex() == -1) {
                ((MaterialCard)this.view).getMaterialList().setSelectedIndex(0);
                this.setSelectedMaterial(((MaterialCard)this.view).getMaterialList().getSelectedValue());
                ((MaterialCard)this.view).getMaterialList().requestFocusInWindow();
            }
        } else {
            this.setSelectedMaterial(null);
        }
    }

    @Override
    public boolean writeUserInputToProject() {
        return true;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.USER) {
            ((MaterialCard)this.view).disableDINAdding();
        } else {
            ((MaterialCard)this.view).enableDINAdding();
        }
        if (this.getSelectedMaterial() != null) {
            this.tableModelGrainSize.setData(this.getSelectedMaterial().getGrainSizes());
        }
    }

    public Material getSelectedMaterial() {
        return this.selectedMaterial;
    }

    public void setSelectedMaterial(Material material) {
        this.selectedMaterial = material;
        if (material != null) {
            ((MaterialCard)this.view).setTextFieldString(material.getName());
            this.tableModelAmat.setData(material.getAquiferMaterials());
            ArrayList<GrainSize> arrayList = material.getGrainSizes();
            this.tableModelGrainSize.setData(arrayList);
            if (arrayList != null && arrayList.size() > 0) {
                boolean bl = false;
                for (int i = 0; i < GrainFractionDINValue.values().length; ++i) {
                    if (!arrayList.get(0).getName().equals(GrainFractionDINValue.values()[i].getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ((MaterialCard)this.view).getDinButton().setSelected(true);
                    this.setMode(Mode.DIN);
                } else {
                    ((MaterialCard)this.view).getUserDefButton().setSelected(true);
                    this.setMode(Mode.USER);
                }
            }
            this.tableModelComposition.setData(material);
        } else {
            ((MaterialCard)this.view).setTextFieldString("");
            this.tableModelAmat.setData(null);
            this.tableModelGrainSize.setData(null);
            this.tableModelComposition.setData(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File saveMaterialDialog(File file, Material material, Component component) {
        JFileChooser jFileChooser = file != null && file.exists() ? new JFileChooser(file) : new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return ".txt-Dateien";
            }
        });
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            String string;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".txt")) {
                string = file2.getAbsolutePath() + ".txt";
                file2 = new File(string);
            }
            if (!file2.getName().equals(file2.getName().replaceAll(" ", ""))) {
                string = file2.getName().replaceAll(" ", "");
                file2 = new File(file2.getPath(), string);
            }
            string = "__NAME\n";
            string = string.concat("" + material.getName() + "\n");
            string = string.concat("\n__COMPONENTS\n");
            for (CatalogObject comparable : material.getAquiferMaterials()) {
                string = string.concat(" " + comparable.getBezeichnung());
                for (double d : comparable.getValues()) {
                    string = string.concat(" " + d);
                }
                string = string.concat("\n");
            }
            string = string.concat("\n__GRAINSIZES\n");
            for (GrainSize iOException : material.getGrainSizes()) {
                string = string.concat(" " + iOException.getName() + " " + iOException.getIdf() + " " + iOException.getDiam() + "\n");
            }
            string = string.concat("\n__COMPOSITION\n");
            for (GrainSize grainSize : material.getGrainSizes()) {
                string = string.concat(" " + material.getTotalFractionForGrainSize(grainSize));
            }
            for (CatalogObject catalogObject : material.getAquiferMaterials()) {
                string = string.concat("\n");
                Object object = material.getGrainSizes().iterator();
                while (object.hasNext()) {
                    GrainSize grainSize = (GrainSize)object.next();
                    string = string.concat(" " + material.getMassFractionValue((AquiferMaterial)catalogObject, grainSize));
                }
            }
            Object object = null;
            try {
                object = new BufferedWriter(new FileWriter(file2));
                ((Writer)object).write(string);
                ((BufferedWriter)object).flush();
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedWriter)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return file2;
        }
        return null;
    }

    private int showDialog() {
        return JOptionPane.showOptionDialog(this.getView(), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_din_mode_line1) + "\n" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont) + "\n" + "", MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes));
    }

    private final class TableModelComposition
    extends AbstractTableModel {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        private static final long serialVersionUID = 1L;
        private Material material;

        TableModelComposition() {
            this.df.applyPattern("##0.##");
            this.df.setRoundingMode(RoundingMode.HALF_UP);
        }

        @Override
        public int getRowCount() {
            if (this.material == null) {
                return 0;
            }
            if (this.material.getAquiferMaterials().size() == 0) {
                return this.material.getGrainSizes() == null ? 0 : 1;
            }
            return this.material.getAquiferMaterials().size() + 2;
        }

        @Override
        public int getColumnCount() {
            return this.material == null || this.material.getGrainSizes().size() == 0 ? 0 : this.material.getGrainSizes().size() + 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            if (n == this.material.getGrainSizes().size() + 1) {
                return "SUM";
            }
            return this.material.getGrainSizes().get(n - 1).getName();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1 && n2 <= this.getColumnCount() - 2 && n <= this.getRowCount() - 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (n == 0) {
                    return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_trowfirst);
                }
                if (n < this.getRowCount() - 1) {
                    return this.material.getAquiferMaterials().get(n - 1).getBezeichnung();
                }
                return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_trowlast);
            }
            if (n2 < this.getColumnCount() - 1) {
                if (n == 0) {
                    GrainSize grainSize = this.material.getGrainSizes().get(n2 - 1);
                    return this.material.getTotalFractionForGrainSize(grainSize);
                }
                if (n > 0 && n < this.getRowCount() - 1) {
                    AquiferMaterial aquiferMaterial = this.material.getAquiferMaterials().get(n - 1);
                    GrainSize grainSize = this.material.getGrainSizes().get(n2 - 1);
                    return this.material.getMassFractionValue(aquiferMaterial, grainSize);
                }
                double d = 0.0;
                for (int i = 1; i < this.getRowCount() - 1; ++i) {
                    d += ((Double)this.getValueAt(i, n2)).doubleValue();
                }
                this.df.format(d);
                return d;
            }
            if (n == 0) {
                double d = 0.0;
                for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                    d += ((Double)this.getValueAt(0, i)).doubleValue();
                }
                this.df.format(d);
                return d;
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n == 0) {
                GrainSize grainSize = this.material.getGrainSizes().get(n2 - 1);
                this.material.setTotalFractionForGrainSize(grainSize, Double.parseDouble((String)object));
            } else if (n > 0 && n < this.getRowCount() - 1) {
                AquiferMaterial aquiferMaterial = this.material.getAquiferMaterials().get(n - 1);
                GrainSize grainSize = this.material.getGrainSizes().get(n2 - 1);
                this.material.setMassFractionValue(aquiferMaterial, grainSize, Double.parseDouble((String)object));
            }
            this.fireTableCellUpdated(n, n2 - 1);
            this.fireTableCellUpdated(n, this.getColumnCount() - 1);
            this.fireTableCellUpdated(this.getRowCount(), n2 - 1);
        }

        public void setData(Material material) {
            this.material = material;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }
    }

    private class TableModelGrainSize
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_tcol3)};
        private ArrayList<GrainSize> grainSizes;

        private TableModelGrainSize() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.grainSizes != null ? this.grainSizes.size() : 0;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return MaterialController.this.mode == Mode.USER;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.grainSizes.get(n).getName();
            }
            if (n2 == 1) {
                return this.grainSizes.get(n).getIdf();
            }
            if (n2 == 2 && MaterialController.this.mode == Mode.USER) {
                return this.grainSizes.get(n).getDiam();
            }
            if (n2 == 2 && MaterialController.this.mode == Mode.DIN) {
                for (GrainFractionDINValue grainFractionDINValue : GrainFractionDINValue.values()) {
                    if (grainFractionDINValue.getIndex() != n) continue;
                    return grainFractionDINValue.getSizeAsString();
                }
                return "";
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                boolean bl = MaterialController.this.selectedMaterial.renameGrainSize(this.grainSizes.get(n), (String)object);
                if (bl) {
                    this.setData(MaterialController.this.selectedMaterial.getGrainSizes());
                    MaterialController.this.tableModelComposition.fireTableStructureChanged();
                }
            } else if (n2 == 1) {
                this.grainSizes.get(n).setIdf((String)object);
            } else if (n2 == 2) {
                try {
                    double d = Double.parseDouble((String)object);
                    this.grainSizes.get(n).setDiam(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        private void scrollToAndSelectGrainSize(GrainSize grainSize) {
            int n = this.grainSizes.indexOf(grainSize);
            ((MaterialCard)MaterialController.this.view).getGrainSizeTable().setRowSelectionInterval(n, n);
            ((MaterialCard)MaterialController.this.view).getGrainSizeTable().scrollRectToVisible(((MaterialCard)MaterialController.this.view).getGrainSizeTable().getCellRect(n, 0, true));
        }

        public void addRow() {
            String string = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.name);
            String string2 = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.abbrev);
            this.addRowWithGrainSize(new GrainSize(string, string2, 0.0));
        }

        public void addRowWithGrainSize(GrainSize grainSize) {
            boolean bl = MaterialController.this.selectedMaterial.addGrainSize(grainSize);
            if (bl) {
                this.setData(MaterialController.this.selectedMaterial.getGrainSizes());
                this.scrollToAndSelectGrainSize(grainSize);
                MaterialController.this.tableModelComposition.fireTableStructureChanged();
            }
        }

        public void deleteRow() {
            try {
                int n = 0;
                for (int n2 : ((MaterialCard)MaterialController.this.view).getGrainSizeTable().getSelectedRows()) {
                    MaterialController.this.selectedMaterial.deleteGrainSize(this.grainSizes.get(n2 - n));
                    this.grainSizes.remove(n2 - n);
                    ++n;
                }
                this.setData(MaterialController.this.selectedMaterial.getGrainSizes());
                MaterialController.this.tableModelComposition.fireTableStructureChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setData(ArrayList<GrainSize> arrayList) {
            this.grainSizes = arrayList;
            this.fireTableDataChanged();
        }
    }

    private final class TableModelAmat
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNamesAmat = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_litho_tcol6)};
        private ArrayList<AquiferMaterial> aquiferMaterials;

        TableModelAmat() {
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNamesAmat[n];
        }

        @Override
        public int getRowCount() {
            return this.aquiferMaterials == null ? 0 : this.aquiferMaterials.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.aquiferMaterials.get(n).getBezeichnung();
            }
            if (n2 == 1) {
                return this.aquiferMaterials.get(n).getId();
            }
            return this.aquiferMaterials.get(n).getValues()[n2 - 2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 > 1;
        }

        private void scrollToAndSelectAquiferMaterial(AquiferMaterial aquiferMaterial) {
            int n = this.aquiferMaterials.indexOf(aquiferMaterial);
            ((MaterialCard)MaterialController.this.view).getAquiferMaterialsTable().setRowSelectionInterval(n, n);
            ((MaterialCard)MaterialController.this.view).getAquiferMaterialsTable().scrollRectToVisible(((MaterialCard)MaterialController.this.view).getAquiferMaterialsTable().getCellRect(n, 0, true));
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AquiferMaterial aquiferMaterial = this.aquiferMaterials.get(n);
            if (n2 == 0) {
                boolean bl = MaterialController.this.model.renameAquiferMaterial(aquiferMaterial, (String)object);
                if (bl) {
                    this.setData(MaterialController.this.selectedMaterial.getAquiferMaterials());
                    MaterialController.this.tableModelComposition.fireTableDataChanged();
                }
            } else if (n2 != 1) {
                try {
                    double d = Double.parseDouble((String)object);
                    double[] dArray = this.aquiferMaterials.get(n).getValues();
                    dArray[n2 - 2] = d;
                    aquiferMaterial.setValues(dArray);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            this.addRowWithAquiferMaterial(new AquiferMaterial(defalutNameAquiferMaterial));
        }

        public void addRowWithAquiferMaterial(AquiferMaterial aquiferMaterial) {
            boolean bl = MaterialController.this.selectedMaterial.addAquiferMaterial(aquiferMaterial);
            if (bl) {
                MaterialController.this.model.addAquiferMaterial(aquiferMaterial);
                this.setData(MaterialController.this.selectedMaterial.getAquiferMaterials());
                this.scrollToAndSelectAquiferMaterial(aquiferMaterial);
                MaterialController.this.tableModelComposition.fireTableDataChanged();
            }
        }

        public void deleteRowAtIndex(int n) {
            AquiferMaterial aquiferMaterial = this.aquiferMaterials.get(n);
            MaterialController.this.selectedMaterial.deleteAquiferMaterial(aquiferMaterial);
            this.setData(MaterialController.this.selectedMaterial.getAquiferMaterials());
            MaterialController.this.tableModelComposition.fireTableDataChanged();
            if (!this.aquiferMaterialUsedByAnyMaterial(aquiferMaterial)) {
                MaterialController.this.model.deleteAquiferMaterial(aquiferMaterial);
            }
        }

        private boolean aquiferMaterialUsedByAnyMaterial(AquiferMaterial aquiferMaterial) {
            if (MaterialController.this.model.allMaterials() == null || MaterialController.this.model.allSurfactants().size() == 0) {
                return false;
            }
            for (Material material : MaterialController.this.model.allMaterials()) {
                if (!material.getAquiferMaterials().contains(aquiferMaterial)) continue;
                return false;
            }
            return true;
        }

        public void setData(ArrayList<AquiferMaterial> arrayList) {
            this.aquiferMaterials = arrayList;
            this.fireTableDataChanged();
        }
    }

    private final class UserDefButtonListener
    implements ActionListener {
        private UserDefButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.tableModelGrainSize.getRowCount() > 0) {
                int n = MaterialController.this.showDialog();
                if (n == 0) {
                    MaterialController.this.getSelectedMaterial().deleteAllGrainSizes();
                    MaterialController.this.setMode(Mode.USER);
                    MaterialController.this.tableModelComposition.fireTableDataChanged();
                    MaterialController.this.tableModelComposition.fireTableStructureChanged();
                } else {
                    ((MaterialCard)MaterialController.this.view).getDinButton().setSelected(true);
                }
            } else {
                MaterialController.this.setMode(Mode.USER);
            }
        }
    }

    private final class DinButtonListener
    implements ActionListener {
        private DinButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.tableModelGrainSize.getRowCount() > 0) {
                int n = MaterialController.this.showDialog();
                if (n == 0) {
                    MaterialController.this.getSelectedMaterial().deleteAllGrainSizes();
                    MaterialController.this.setMode(Mode.DIN);
                    MaterialController.this.tableModelComposition.fireTableDataChanged();
                    MaterialController.this.tableModelComposition.fireTableStructureChanged();
                } else {
                    ((MaterialCard)MaterialController.this.view).getUserDefButton().setSelected(true);
                }
            } else {
                MaterialController.this.setMode(Mode.DIN);
            }
        }
    }

    private final class DelGrainSizeButtonListener
    implements ActionListener {
        private DelGrainSizeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.getSelectedMaterial() != null) {
                if (((MaterialCard)MaterialController.this.view).getGrainSizeTable().getSelectedRows().length == 0) {
                    JOptionPane.showMessageDialog(MaterialController.this.view, "Bitte waehlen sie zuerst eine Zeile aus!\n (Mehrfachauswahl mit 'strg' bzw. 'shift'.)", "Information", 1);
                } else {
                    MaterialController.this.tableModelGrainSize.deleteRow();
                }
            }
        }
    }

    private final class AddGrainSizeFromCatalogButtonListener
    implements ActionListener {
        private AddGrainSizeFromCatalogButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.getSelectedMaterial() != null) {
                boolean bl = ((MaterialCard)MaterialController.this.view).getDinButton().isSelected();
                GrainSize grainSize = bl ? (GrainSize)MaterialController.this.comboBoxModelGsDIN.getSelectedItem() : (GrainSize)MaterialController.this.comboBoxModelGs.getSelectedItem();
                GrainSize grainSize2 = new GrainSize(grainSize.getName(), grainSize.getIdf(), grainSize.getDiam());
                MaterialController.this.tableModelGrainSize.addRowWithGrainSize(grainSize2);
            }
        }
    }

    private final class AddGrainSizeButtonListener
    implements ActionListener {
        private AddGrainSizeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.getSelectedMaterial() != null) {
                MaterialController.this.tableModelGrainSize.addRow();
            }
        }
    }

    private final class AddLithoFromCatalogButtonListener
    implements ActionListener {
        private AddLithoFromCatalogButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.getSelectedMaterial() != null) {
                AquiferMaterial aquiferMaterial = (AquiferMaterial)MaterialController.this.comboBoxModelAquiferMaterials.getSelectedItem();
                AquiferMaterial aquiferMaterial2 = new AquiferMaterial(aquiferMaterial.getBezeichnung(), aquiferMaterial.getValues()[0], aquiferMaterial.getValues()[1], aquiferMaterial.getValues()[2], aquiferMaterial.getValues()[3]);
                MaterialController.this.tableModelAmat.addRowWithAquiferMaterial(aquiferMaterial2);
            }
        }
    }

    private final class DelLithoButtonListener
    implements ActionListener {
        private DelLithoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (MaterialController.this.getSelectedMaterial() != null && (n = ((MaterialCard)MaterialController.this.view).getAquiferMaterialsTable().getSelectedRow()) >= 0) {
                AquiferMaterial aquiferMaterial = (AquiferMaterial)MaterialController.this.tableModelAmat.aquiferMaterials.get(n);
                MaterialController.this.getSelectedMaterial().deleteAquiferMaterial(aquiferMaterial);
                MaterialController.this.tableModelAmat.deleteRowAtIndex(n);
            }
        }
    }

    private final class AddLithoButtonListener
    implements ActionListener {
        private AddLithoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.getSelectedMaterial() != null) {
                MaterialController.this.tableModelAmat.addRow();
            }
        }
    }

    private class ButtonStoreToFileListener
    implements ActionListener {
        private ButtonStoreToFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.selectedMaterial == null) {
                JOptionPane.showMessageDialog(MaterialController.this.getView(), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                return;
            }
            File file = FileUtils.getMaterialFolder();
            MaterialController.saveMaterialDialog(file, MaterialController.this.selectedMaterial, MaterialController.this.getView());
        }
    }

    private class ButtonSelectFileListener
    implements ActionListener {
        private ButtonSelectFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = MaterialController.this.resultsFolder != null ? new JFileChooser(MaterialController.this.resultsFolder) : new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = FileUtils.getFileExtension(file);
                    return file.isDirectory() || string.equals("txt") || string.equals("clg");
                }

                @Override
                public String getDescription() {
                    return "*.txt, *.clg";
                }
            });
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                MaterialController.this.resultsFolder = file;
                if (file.canWrite()) {
                    boolean bl;
                    int n2;
                    int n3 = MaterialController.this.model.allMaterials() != null ? MaterialController.this.model.allMaterials().size() : 0;
                    Material material = Material.defaultMaterialWithNameIndex(n3);
                    ArrayList<CatalogObject> arrayList = null;
                    ArrayList<GrainSize> arrayList2 = null;
                    ArrayList<double[]> arrayList3 = null;
                    try {
                        arrayList = FileUtils.componentsFromMaterialFile(MaterialController.this.resultsFolder);
                        arrayList2 = FileUtils.grainsizesFromMaterialFile(MaterialController.this.resultsFolder);
                        arrayList3 = FileUtils.compositionFromMaterialFile(MaterialController.this.resultsFolder);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (arrayList != null && arrayList.size() > 0) {
                        for (CatalogObject object : arrayList) {
                            AquiferMaterial aquiferMaterial = (AquiferMaterial)object;
                            n2 = material.addAquiferMaterial(aquiferMaterial);
                            if (n2 == 0) continue;
                            MaterialController.this.model.addAquiferMaterial(aquiferMaterial);
                        }
                    }
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        for (GrainSize grainSize : arrayList2) {
                            boolean bl2 = material.addGrainSize(grainSize);
                            if (bl2) continue;
                        }
                    }
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        int n4 = 0;
                        for (double[] dArray : arrayList3) {
                            Comparable<GrainSize> comparable;
                            if (n4 == 0) {
                                for (n2 = 0; n2 < dArray.length; ++n2) {
                                    if (arrayList2.size() <= n2) continue;
                                    comparable = arrayList2.get(n2);
                                    material.setTotalFractionForGrainSize((GrainSize)comparable, dArray[n2]);
                                }
                            } else {
                                for (n2 = 0; n2 < dArray.length; ++n2) {
                                    if (arrayList.size() <= n4 - 1 || arrayList2.size() <= n2) continue;
                                    comparable = (AquiferMaterial)arrayList.get(n4 - 1);
                                    GrainSize grainSize = arrayList2.get(n2);
                                    material.setMassFractionValue((AquiferMaterial)comparable, grainSize, dArray[n2]);
                                }
                            }
                            ++n4;
                        }
                    }
                    if (bl = MaterialController.this.model.getMaterialSet().add(material)) {
                        ((DefaultListModel)MaterialController.this.listModel).addElement(material);
                        ((MaterialCard)MaterialController.this.view).getMaterialList().setSelectedValue(material, true);
                        MaterialController.this.setSelectedMaterial(material);
                        String string = FileUtils.nameFromMaterialFile(MaterialController.this.resultsFolder);
                        boolean bl3 = MaterialController.this.model.renameMaterial(MaterialController.this.selectedMaterial, string);
                        if (bl3) {
                            ((DefaultListModel)MaterialController.this.listModel).setElementAt(MaterialController.this.selectedMaterial, ((MaterialCard)MaterialController.this.view).getMaterialList().getSelectedIndex());
                            ((MaterialCard)MaterialController.this.view).setTextFieldString(string);
                        }
                        MaterialController.this.tableModelAmat.setData(MaterialController.this.selectedMaterial.getAquiferMaterials());
                        MaterialController.this.tableModelComposition.fireTableDataChanged();
                        MaterialController.this.tableModelComposition.setData(MaterialController.this.selectedMaterial);
                        MaterialController.this.tableModelComposition.fireTableStructureChanged();
                    } else {
                        JOptionPane.showMessageDialog(MaterialController.this.getView(), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material1) + "!\n" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material2) + " \"" + material.getName() + "\" " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material3) + ".", MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                    }
                }
            }
        }
    }

    private final class DelMaterialButtonListener
    implements ActionListener {
        private DelMaterialButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Material material = ((MaterialCard)MaterialController.this.view).getMaterialList().getSelectedValue();
            boolean bl = MaterialController.this.model.deleteMaterial(material);
            if (bl) {
                ((DefaultListModel)MaterialController.this.listModel).removeElement(material);
                if (((DefaultListModel)MaterialController.this.listModel).size() > 0) {
                    MaterialController.this.setSelectedMaterial((Material)((DefaultListModel)MaterialController.this.listModel).firstElement());
                    ((MaterialCard)MaterialController.this.view).getMaterialList().setSelectedValue(MaterialController.this.selectedMaterial, true);
                } else {
                    MaterialController.this.setSelectedMaterial(null);
                }
            }
        }
    }

    private final class AddMaterialButtonListener
    implements ActionListener {
        private AddMaterialButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MaterialController.this.model.allMaterials() != null ? MaterialController.this.model.allMaterials().size() : 0;
            Material material = Material.defaultMaterialWithNameIndex(n);
            boolean bl = MaterialController.this.model.getMaterialSet().add(material);
            if (bl) {
                ((DefaultListModel)MaterialController.this.listModel).addElement(material);
                ((MaterialCard)MaterialController.this.view).getMaterialList().setSelectedValue(material, true);
                MaterialController.this.setSelectedMaterial(material);
            } else {
                JOptionPane.showMessageDialog(MaterialController.this.getView(), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material1) + "!\n" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material2) + " \"" + material.getName() + "\" " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_material3) + ".", MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
            }
        }
    }

    private final class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            boolean bl;
            String string = ((MaterialCard)MaterialController.this.view).getTextFieldString();
            if (MaterialController.this.selectedMaterial != null && MaterialController.this.selectedMaterial.getName() != string && (bl = MaterialController.this.model.renameMaterial(MaterialController.this.selectedMaterial, string))) {
                ((DefaultListModel)MaterialController.this.listModel).setElementAt(MaterialController.this.selectedMaterial, ((MaterialCard)MaterialController.this.view).getMaterialList().getSelectedIndex());
            }
        }
    }

    private final class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MaterialController.this.selectedMaterial != null) {
                String string = ((MaterialCard)MaterialController.this.view).getTextFieldString();
                boolean bl = MaterialController.this.model.renameMaterial(MaterialController.this.selectedMaterial, string);
                if (bl) {
                    ((DefaultListModel)MaterialController.this.listModel).setElementAt(MaterialController.this.selectedMaterial, ((MaterialCard)MaterialController.this.view).getMaterialList().getSelectedIndex());
                }
            }
        }
    }

    private final class MaterialListSelectionListener
    implements ListSelectionListener {
        private MaterialListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                MaterialController.this.setSelectedMaterial((Material)jList.getSelectedValue());
            }
        }
    }

    public static enum GrainFractionDINValue {
        GROBKIES(0, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din1), "gG", "20 <= d < 63", 26.9584253),
        MITTELKIES(1, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din2), "mG", "6,3 <= d < 20", 8.497912377),
        FEINKIES(2, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din3), "fG", "2 <= d < 6,3", 2.69584253),
        GROBSAND1(3, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din4), "gS1", "1 <= d < 2", 1.264911064),
        GROBSAND2(4, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din5), "gS2", "0,63 <= d <  1", 0.753829083),
        MITTELSAND(5, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din6), "mS", "0,2 <= d < 0,63", 0.269584253),
        FEINSAND1(6, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din7), "fS1", "0,1 <= d < 0,2", 0.126491106),
        FEINSAND2(7, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din8), "fS2", "0,063 <= d < 0,1", 0.075382908),
        GROBSCHLUFF1(8, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din9), "gU1", "0,05 <= d < 0,063", 0.055386889),
        GROBSCHLUFF2(9, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din10), "gU2", "0,02 <= d < 0,05", 0.026261287),
        MITTELSCHLUFF1(10, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din11), "mU1", "0,01 <= d < 0,02", 0.012649111),
        MITTELSCHLUFF2(11, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din12), "mU2", "0,0063 <= d < 0,01", 0.007538291),
        FEINSCHLUFF(12, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din13), "fU", "0,002 <= d < 0,0063", 0.002695843),
        GROBTON(13, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din14), "gT", "0,00063 <= d < 0,002", 8.49791E-4),
        MITTELTON(14, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din15), "mT", "0,0002 <= d < 0,00063", 2.69584E-4),
        FEINTON(15, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_din16), "fT", "0,0001 d < 0,0002", 1.26491E-4);

        private final int index;
        private final String name;
        private final String abbreviation;
        private final String sizeAsString;
        private final double size;

        private GrainFractionDINValue(int n2, String string2, String string3, String string4, double d) {
            this.index = n2;
            this.name = string2;
            this.abbreviation = string3;
            this.sizeAsString = string4;
            this.size = d;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getSizeAsString() {
            return this.sizeAsString;
        }

        public double getSize() {
            return this.size;
        }
    }

    private static enum Mode {
        USER,
        DIN;

    }
}

