/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.AdsolubilizationController;
import de.dsite.controller.BioReductionController;
import de.dsite.controller.BoundaryConditionFlowController;
import de.dsite.controller.BoundaryConditionTransportController;
import de.dsite.controller.CatalogController;
import de.dsite.controller.GeometryController;
import de.dsite.controller.GroundPropertyController;
import de.dsite.controller.HydraulicsController;
import de.dsite.controller.ListController;
import de.dsite.controller.MaterialController;
import de.dsite.controller.ModelSettingsController;
import de.dsite.controller.MonomereLayerController;
import de.dsite.controller.OutputSpecsController;
import de.dsite.controller.ResidenceTimeController;
import de.dsite.controller.ResultController;
import de.dsite.controller.ScenarioController;
import de.dsite.controller.SolubilizationController;
import de.dsite.controller.SorptionController;
import de.dsite.controller.TimePropertyController;
import de.dsite.data.Material;
import de.dsite.data.Project;
import de.dsite.data.Series;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.DataProvider;
import de.dsite.gui.FortranPanel;
import de.dsite.gui.MainWindow;
import de.dsite.gui.NewProjectDialog;
import de.dsite.gui.Plotter;
import de.dsite.gui.ProjectListener;
import de.dsite.gui.ResultPlot;
import de.dsite.gui.ResultPlotBuilder;
import de.dsite.gui.SubjectListener;
import de.dsite.gui.listcard.ResultCardFile;
import de.dsite.io.BuildProperties;
import de.dsite.io.FortranOutputConverter;
import de.dsite.io.FortranSwingWorker;
import de.dsite.io.XMLParser;
import de.dsite.main.ResourceManager;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.VersionedProject;
import de.dsite.utils.FileUtils;
import de.dsite.utils.FortranUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class MainWindowController
implements ListSelectionListener,
SubjectListener {
    public static final ResourceManager resourceManager = ResourceManager.createInstance();
    private MainWindow view;
    protected VersionedProject project;
    private final ArrayList<ListController> inputItemcontroller;
    private final ArrayList<ListController> outputItemcontroller;
    private FortranSwingWorker fortranTask;
    private FortranOutputConverter converter;
    private Series.Unit selectedUnit;
    private ResultPlotBuilder.AxisRelation axisRelation;
    protected int currentTabIndex;
    private File currentFile;
    private ListController currentController;
    private boolean fullVersion;
    private boolean fortranIsDone;
    private File fortranOutputFolder;

    public MainWindowController(File file, boolean bl) {
        Object object;
        VersionedProject versionedProject;
        block17: {
            block15: {
                block16: {
                    this();
                    versionedProject = null;
                    String string = FileUtils.getFileExtension(file);
                    if (!string.equals("xml")) break block15;
                    boolean bl2 = XMLParser.validateXMLFileUsingSAX(file.getAbsolutePath());
                    if (bl2) break block16;
                    System.err.println("MainWindowController: File " + file.toString() + " does not fit to schema. Program starts with empty project!");
                    break block17;
                }
                versionedProject = XMLParser.parseXMLFile(file);
                if (versionedProject != null) break block17;
                System.err.println("MainWindowController: File " + file.toString() + " could not generate a Project. Program starts with empty project!");
                break block17;
            }
            Object object2 = FileUtils.openProject(file);
            if (object2 == null) {
                System.err.println("MainWindowController: File " + file.toString() + " could not generate a Project. Program starts with empty project!");
            } else {
                if (object2 instanceof Project) {
                    object = (Project)object2;
                    this.versionCheckForProject((Project)object);
                    versionedProject = new VersionedProject((Project)object);
                } else if (object2 instanceof VersionedProject) {
                    versionedProject = (VersionedProject)object2;
                }
                if (versionedProject != null) {
                    for (Pollutant catalogObject : versionedProject.allPollutants()) {
                        catalogObject.setBezeichnung(catalogObject.getBezeichnung());
                    }
                    for (Surfactant surfactant : versionedProject.allSurfactants()) {
                        surfactant.setBezeichnung(surfactant.getBezeichnung());
                    }
                    for (AquiferMaterial aquiferMaterial : versionedProject.allAquiferMaterials()) {
                        aquiferMaterial.setBezeichnung(aquiferMaterial.getBezeichnung());
                    }
                }
            }
        }
        if (versionedProject != null) {
            this.setVersionedProject(versionedProject);
        }
        this.setCurrentFile(file);
        this.setSelectedUnit(this.project.getUnit());
        this.updateInputTab(this.project);
        this.updateResultTab(this.project);
        this.updateSmartModeItems(this.project);
        this.setDefaultListAndTabSelection();
        this.getView().setTitle("WinSmart - " + this.currentFile.getName());
        if (bl && versionedProject != null) {
            File file2 = this.prepareFortranCalculation();
            object = "";
            if (file2 != null) {
                try {
                    object = FortranUtils.checkTimeStepRangesForProject(this.project);
                    FortranUtils.generateFortranInputFileWithProjectData(this.project, file2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line3) + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                    return;
                }
                this.setFortranOutputFolder(file2);
                this.view.showTab(MainWindow.TabValue.FORTRANLOGPANEL);
                ((FortranPanel)this.view.getTab4()).enableFCancelButton();
                this.getView().setMenuItemsRunEnabled(false);
                ((FortranPanel)this.view.getTab4()).clearLogArea();
                ((FortranPanel)this.view.getTab4()).setProgress(0);
                this.prepareAndRunFortranWithFolder(file2);
                if (object != null) {
                    ((FortranPanel)this.getView().getTab4()).appendLineToLogArea((String)object);
                }
            }
        }
    }

    public MainWindowController() {
        Object object5;
        Object object2;
        Object object3;
        Object object4;
        block12: {
            this.setFortranIsDone(false);
            try {
                object4 = BuildProperties.getInstance();
                object3 = ((BuildProperties)object4).getProperty(BuildProperties.PropertyName.LANGUAGE);
                if ("us".equals(object3)) {
                    if (resourceManager.supportsLocale(Locale.getDefault())) {
                        resourceManager.activateLocale(Locale.US);
                    }
                } else if (resourceManager.supportsLocale(Locale.getDefault())) {
                    resourceManager.activateLocale(Locale.getDefault());
                }
                this.fullVersion = ((String)(object2 = ((BuildProperties)object4).getProperty(BuildProperties.PropertyName.VERSION))).equals("full");
            }
            catch (IOException iOException) {
                System.err.println("Build properies file could not be loaded!");
                if (!resourceManager.supportsLocale(Locale.getDefault())) break block12;
                resourceManager.activateLocale(Locale.getDefault());
            }
        }
        JComponent.setDefaultLocale(resourceManager.getCurrentLocale());
        this.project = new VersionedProject();
        this.view = new MainWindow(this);
        object4 = new Plotter(this.project, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab2));
        this.view.setTab2((JPanel)object4);
        this.project.notifyListener();
        object3 = new DefaultListModel();
        for (InputCardValue inputCardValue : InputCardValue.values()) {
            if (this.fullVersion) {
                ((DefaultListModel)object3).addElement(inputCardValue);
                continue;
            }
            ((DefaultListModel)object3).addElement(inputCardValue);
        }
        this.view.addInputListModel((DefaultListModel<InputCardValue>)object3);
        this.view.disableListItemAtIndex(2);
        if (!this.fullVersion) {
            this.view.disableListItemAtIndex(12);
            this.view.disableListItemAtIndex(13);
            this.view.disableListItemAtIndex(14);
        }
        object2 = new DefaultListModel();
        for (Object object5 : OutputCardValue.values()) {
            if (this.fullVersion) {
                ((DefaultListModel)object2).addElement(object5);
                continue;
            }
            ((DefaultListModel)object2).addElement(object5);
        }
        this.view.addOutputListModel((DefaultListModel<OutputCardValue>)object2);
        this.inputItemcontroller = new ArrayList();
        ScenarioController scenarioController = new ScenarioController(this);
        this.inputItemcontroller.add(scenarioController);
        ((ScenarioController)scenarioController).addSmartModeSelectedActionListener(new SmartModeSelectedListener());
        ((ScenarioController)scenarioController).addSmartModeUnselectedActionListener(new SmartModeUnselectedListener());
        GeometryController geometryController = new GeometryController(this);
        this.inputItemcontroller.add(geometryController);
        ResidenceTimeController residenceTimeController = new ResidenceTimeController(this);
        this.inputItemcontroller.add(residenceTimeController);
        object5 = new TimePropertyController(this);
        this.inputItemcontroller.add((ListController)object5);
        MaterialController materialController = new MaterialController(this);
        this.inputItemcontroller.add(materialController);
        HydraulicsController hydraulicsController = new HydraulicsController(this);
        this.inputItemcontroller.add(hydraulicsController);
        GroundPropertyController groundPropertyController = new GroundPropertyController(this);
        this.inputItemcontroller.add(groundPropertyController);
        CatalogController catalogController = new CatalogController(this);
        this.inputItemcontroller.add(catalogController);
        BoundaryConditionFlowController boundaryConditionFlowController = new BoundaryConditionFlowController(this);
        this.inputItemcontroller.add(boundaryConditionFlowController);
        BoundaryConditionTransportController boundaryConditionTransportController = new BoundaryConditionTransportController(this);
        this.inputItemcontroller.add(boundaryConditionTransportController);
        BioReductionController bioReductionController = new BioReductionController(this);
        this.inputItemcontroller.add(bioReductionController);
        SorptionController sorptionController = new SorptionController(this);
        this.inputItemcontroller.add(sorptionController);
        SolubilizationController solubilizationController = new SolubilizationController(this);
        this.inputItemcontroller.add(solubilizationController);
        AdsolubilizationController adsolubilizationController = new AdsolubilizationController(this);
        this.inputItemcontroller.add(adsolubilizationController);
        MonomereLayerController monomereLayerController = new MonomereLayerController(this);
        this.inputItemcontroller.add(monomereLayerController);
        ModelSettingsController modelSettingsController = new ModelSettingsController(this);
        this.inputItemcontroller.add(modelSettingsController);
        OutputSpecsController outputSpecsController = new OutputSpecsController(this);
        this.inputItemcontroller.add(outputSpecsController);
        ((ListController)scenarioController).loadModelDataAndShowView();
        this.currentController = scenarioController;
        this.outputItemcontroller = new ArrayList();
        ResultController resultController = new ResultController(this, OutputCardValue.RESULTBTC.name());
        this.outputItemcontroller.add(resultController);
        ResultController resultController2 = new ResultController(this, OutputCardValue.RESULTBTCSUR.name());
        this.outputItemcontroller.add(resultController2);
        ResultController resultController3 = new ResultController(this, OutputCardValue.RESULTPROFILE.name());
        this.outputItemcontroller.add(resultController3);
        ResultController resultController4 = new ResultController(this, OutputCardValue.RESULTPROFILESUR.name());
        this.outputItemcontroller.add(resultController4);
        ResultCardFile resultCardFile = new ResultCardFile();
        ResultController resultController5 = new ResultController(this, OutputCardValue.RESULTFILE.name(), resultCardFile);
        this.outputItemcontroller.add(resultController5);
        if (!this.fullVersion) {
            this.view.disableOutputListItemAtIndex(2);
            this.view.disableOutputListItemAtIndex(3);
        }
        this.addMenuItemListener();
        this.addListener();
    }

    private void addListener() {
        this.view.addInputListFocusListener(new InputListFocusListener());
        this.view.addInputListMouseListener(new InputListMouseListener());
        this.view.addInputListSelectionListener(this);
        this.view.addOutputListFocusListener(new OutputListFocusListener());
        this.view.addOutputListMouseListener(new OutputListMouseListener());
        this.view.addOutputListSelectionListener(new OutputListSelectionListener());
        this.view.addTabChangeListener(new TabChangeListener());
        ((FortranPanel)this.view.getTab4()).addFCancelButtonActionListener(new addFCancelButtonListener());
    }

    private void addMenuItemListener() {
        this.view.addMenuItemNewListener(new MenuItemNewListener());
        this.view.addMenuItemLoadProjectListener(new MenuItemLoadProjectListener());
        this.view.addMenuItemSaveWithoutDialogListener(new MenuItemSaveWithoutDialogListener());
        this.view.addMenuItemSaveProjectListener(new MenuItemSaveProjectListener());
        this.view.addMenuItemStartListener(new MenuItemStartListener());
        this.view.addMenuItemRunListener(new MenuItemRunListener());
        this.view.addMenuItemExitListener(new MenuItemExitListener());
        this.view.addMenuItemHelpBookListener(new MenuItemHelpBookListener());
        this.view.addMenuItemAboutListener(new MenuItemAboutListener());
        this.view.addMenuItemUnitsListener(new MenuItemUnitsListener());
        this.view.addMenuItemAxisRangeListener(new MenuItemAxisRangeListener());
        this.view.addMenuItemLanguageListener(new MenuItemLanguageListener());
    }

    private void versionCheckForProject(Project project) {
        HashSet<Project.ConcentrationValue> hashSet;
        if (project == null) {
            throw new IllegalArgumentException("Parameter 'project' must not be null!");
        }
        if (project.getObserver() == null) {
            project.setObserver(new ArrayList<ProjectListener>());
        }
        if (project.getTimestepRange() == null) {
            hashSet = (HashSet<Project.ConcentrationValue>)new int[]{0, 0};
            project.setTimestepRange((int[])hashSet);
        }
        if (project.getFormatBTCAndProfileOutput() == null) {
            project.setFormatBTCAndProfileOutput(Project.FileFormat.CSV);
        }
        if (project.getConcentrationPollutant() == null) {
            hashSet = new HashSet();
            hashSet.add(Project.ConcentrationValue.DISS);
            project.setConcentrationPollutant(hashSet);
        }
        if (project.getConcentrationAquiferMaterial() == null) {
            hashSet = new HashSet<Project.ConcentrationValue>();
            project.setConcentrationAquiferMaterial(hashSet);
        }
        if (project.getLeaves().size() > 0) {
            int n = 0;
            for (de.dsite.data.SecondaryLayer secondaryLayer : project.getLeaves()) {
                Object object;
                if (secondaryLayer.getHydraulic().getValues().length == 3) {
                    object = secondaryLayer.getHydraulic().getValues();
                    double[] dArray = new double[4];
                    for (int i = 0; i < ((double[])object).length; ++i) {
                        dArray[i] = object[i];
                    }
                    dArray[3] = 1.0;
                    secondaryLayer.getHydraulic().setValues(dArray);
                }
                if (secondaryLayer.getMaterial().getIndex() != 0) continue;
                object = new Material(secondaryLayer.getMaterial().getName(), ++n);
                ((Material)object).setMfm(secondaryLayer.getMaterial().getMfm());
                secondaryLayer.setMaterial((Material)object);
            }
        }
        project.notifyListener();
        if (project.getXvalues() == null) {
            double[] dArray = new double[]{0.0};
            project.setXvalues(dArray);
        }
        if (!(project.isModInterpolAB() || project.isModEVAB() || project.isModNVAB())) {
            project.setModInterpolAB(true);
        }
        if (project.getXvaluesSur() == null) {
            double[] dArray = new double[]{0.0};
            project.setXvaluesSur(dArray);
        }
        if (!(project.isModInterpolSur() || project.isModEVSur() || project.isModNVSur())) {
            project.setModInterpolSur(true);
        }
        if (!(project.isModInterpolABSur() || project.isModEVABSur() || project.isModNVABSur())) {
            project.setModInterpolABSur(true);
        }
        if (project.isStageCompactSur()) {
            project.setStageCompactSur(false);
        }
        if (!project.isSteadyStageSur()) {
            project.setSteadyStageSur(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File prepareFortranCalculation() {
        File file;
        String string;
        this.currentController.writeUserInputToProject();
        if (this.getCurrentFile() == null) {
            int n = JOptionPane.showOptionDialog(this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_save_changes_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_save_changes_line2) + "\n" + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_save_changes_option_yes), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_save_changes_option_no)}, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_save_changes_option_yes));
            if (n != 0) return null;
            this.saveProject();
        }
        if (FileUtils.projectSubfolderExists(string = this.getCurrentFile().getName().substring(0, this.getCurrentFile().getName().length() - 4))) {
            int n = JOptionPane.showOptionDialog(this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_line3), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_option_yes), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_option_no)}, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_overwrite_changes_option_no));
            if (n != 0) return null;
            file = FileUtils.createProjectSubFolder(string, false);
        } else {
            file = FileUtils.createProjectSubFolder(string);
        }
        FortranUtils.prepareDirectoryForFortranCalculation(file);
        if (FileUtils.getCatalogFilePollutantInDirectory(file) != null) {
            FileUtils.pollutantsToFile(this.project.allPollutants(), FileUtils.getCatalogFilePollutantInDirectory(file));
        }
        if (FileUtils.getCatalogFileSurfactantInDirectory(file) != null) {
            FileUtils.surfactantsToFile(this.project.allSurfactants(), FileUtils.getCatalogFileSurfactantInDirectory(file));
        }
        if (FileUtils.getCatalogFileSoilInDirectory(file) != null) {
            FileUtils.aquiferMaterialsToFile(this.project.allAquiferMaterials(), FileUtils.getCatalogFileSoilInDirectory(file));
        }
        if (this.project.getMode() != VersionedProject.SimulationMode.SMART) return file;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            if (!secondaryLayer.isResidenceCalculationFromFile()) continue;
            File file2 = new File(secondaryLayer.getResidenceFile());
            if (!FileUtils.fileExists(file2) && (file2 = FileUtils.dataSubfolderExists(file2.getName())) == null) {
                JOptionPane.showMessageDialog(this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_filepath_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_filepath_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_filepath_line3) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_filepath_line4) + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                return null;
            }
            FileUtils.copyFileToDirectory(file2, file);
        }
        return file;
    }

    private File getPreparedFortranFolder() {
        if (this.getCurrentFile() == null) {
            System.err.println("'currentFile' not available");
            return null;
        }
        String string = this.getCurrentFile().getName().substring(0, this.getCurrentFile().getName().length() - 4);
        if (!FileUtils.projectSubfolderExists(string)) {
            System.err.println("No subfolders for chosen scenario!");
            return null;
        }
        return FileUtils.getProjectSubfolder(string);
    }

    private void prepareAndRunFortranWithFolder(File file) {
        this.fortranTask = new FortranSwingWorker(this.project, (FortranPanel)this.getView().getTab4(), file);
        this.fortranTask.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                    ((FortranPanel)MainWindowController.this.view.getTab4()).setProgress((Integer)propertyChangeEvent.getNewValue());
                } else if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    MainWindowController.this.enableFurtherResultsListItem();
                    MainWindowController.this.getView().setMenuItemsRunEnabled(true);
                    if (!MainWindowController.this.fortranTask.isCancelled()) {
                        MainWindowController.this.convertFortranResults();
                    }
                }
            }
        });
        this.fortranTask.execute();
    }

    private void refreshView() {
        this.getView().updateMenu();
        this.addMenuItemListener();
        this.getView().invalidate();
        this.getView().validate();
        this.getView().repaint();
    }

    public VersionedProject getVersionedProject() {
        return this.project;
    }

    public File getFortranOutputFolder() {
        return this.fortranOutputFolder;
    }

    public void setFortranOutputFolder(File file) {
        this.fortranOutputFolder = file;
    }

    private void setVersionedProject(VersionedProject versionedProject) {
        if (versionedProject == null) {
            throw new IllegalArgumentException("Parameter 'project' must not be null!");
        }
        this.project = versionedProject;
        this.project.setObserver(new ArrayList<ProjectListener>());
        ((Plotter)this.getView().getTab2().getComponent(this.getView().getTab2().getComponentCount() - 1)).updateSubject(versionedProject);
        versionedProject.notifyListener();
    }

    private void updateResultTab(VersionedProject versionedProject) {
        for (ListController object : this.outputItemcontroller) {
            if (!(object.getView() instanceof ResultCardFile)) {
                ((ResultController)object).clearResultPlots();
                continue;
            }
            ((ResultCardFile)object.getView()).clearFileOutputs();
        }
        this.getView().disableOutputListItems();
        String string = this.getCurrentFile().getName().substring(0, this.getCurrentFile().getName().length() - 4);
        if (FileUtils.projectSubfolderExists(string)) {
            File file = FileUtils.getProjectSubfolder(string);
            this.setFortranOutputFolder(file);
            ((ResultCardFile)this.outputItemcontroller.get(this.outputItemcontroller.size() - 1).getView()).setResultsFolder(this.fortranOutputFolder);
            this.enableFurtherResultsListItem();
            this.convertFortranResults();
        }
    }

    private void convertFortranResults() {
        this.converter = new FortranOutputConverter(this.getFortranOutputFolder(), this.project);
        this.converter.addListener(this);
        this.converter.setUnit(this.selectedUnit);
        this.converter.generatePlots();
        ((ResultCardFile)this.outputItemcontroller.get(this.outputItemcontroller.size() - 1).getView()).setResultsFolder(this.getFortranOutputFolder());
        this.setFortranIsDone(true);
    }

    private void enableFurtherResultsListItem() {
        this.getView().enableOutputListItemAtIndex(this.outputItemcontroller.size() - 1);
    }

    private void updateInputTab(VersionedProject versionedProject) {
        for (ListController listController : this.inputItemcontroller) {
            listController.updateModelData(versionedProject);
        }
    }

    private void updateSmartModeItems(VersionedProject versionedProject) {
        if (versionedProject.getMode() == VersionedProject.SimulationMode.SMART) {
            this.view.enableListItemAtIndex(2);
        } else {
            this.view.disableListItemAtIndex(2);
        }
    }

    private void setDefaultListAndTabSelection() {
        if (this.currentController != null) {
            this.currentController.loadModelDataAndShowView();
        } else {
            this.inputItemcontroller.get(0).loadModelDataAndShowView();
        }
        this.view.getInputList().setSelectedValue((Object)InputCardValue.SZENARIOINFORMATIONEN, true);
        this.showTabOnIndex(InputCardValue.SZENARIOINFORMATIONEN);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.currentController != null && !listSelectionEvent.getValueIsAdjusting()) {
            this.currentController.writeUserInputToProject();
            JList jList = (JList)listSelectionEvent.getSource();
            this.showTabOnIndex((InputCardValue)((Object)jList.getSelectedValue()));
        }
    }

    private void showTabOnIndex(InputCardValue inputCardValue) {
        CardLayout cardLayout = (CardLayout)this.view.getTab1().getLayout();
        cardLayout.show(this.view.getTab1(), inputCardValue.name());
        this.inputItemcontroller.get(inputCardValue.getIndex()).loadModelDataAndShowView();
        this.currentController = this.inputItemcontroller.get(inputCardValue.getIndex());
    }

    private File loadNewProjectDialog() {
        NewProjectDialog newProjectDialog = new NewProjectDialog(this.view);
        newProjectDialog.pack();
        newProjectDialog.setVisible(true);
        File file = newProjectDialog.getNewProject();
        if (file != null && !file.getName().toLowerCase().endsWith(".ser")) {
            String string = file.getAbsolutePath() + ".ser";
            return new File(string);
        }
        return file;
    }

    private static File loadFileDialog(File file, Component component) {
        JFileChooser jFileChooser = file != null && file.exists() ? new JFileChooser(file) : new JFileChooser();
        jFileChooser.setLocale(resourceManager.getCurrentLocale());
        jFileChooser.setDialogType(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".ser") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_filedescriptor);
            }
        });
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (file2.canWrite() && file2.getName().toLowerCase().endsWith(".ser") && file2.getName().equals(file2.getName().replace(" ", ""))) {
                return file2;
            }
            JOptionPane.showMessageDialog(component, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line3) + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
            return null;
        }
        if (n == 1) {
            return null;
        }
        return null;
    }

    private static File saveFileDialog(File file, VersionedProject versionedProject, Component component) {
        JFileChooser jFileChooser = file != null && file.exists() ? (versionedProject.getSzenarioName() != null && versionedProject.getSzenarioName() != "" ? new JFileChooser(file) : new JFileChooser(file)) : new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".ser");
            }

            @Override
            public String getDescription() {
                return ".ser-Dateien";
            }
        });
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            String string;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".ser")) {
                string = file2.getAbsolutePath() + ".ser";
                file2 = new File(string);
            }
            if (!file2.getName().equals(file2.getName().replaceAll(" ", ""))) {
                string = file2.getName().replaceAll(" ", "");
                file2 = new File(file2.getPath(), string);
            }
            FileUtils.saveProject(file2, versionedProject);
            return file2;
        }
        return null;
    }

    private void setCurrentFile(File file) {
        if (file == null || file.getName() == null || file.getName() == "") {
            throw new IllegalArgumentException("parameter 'file' must not be null");
        }
        this.currentFile = file;
    }

    private File getCurrentFile() {
        return this.currentFile;
    }

    public MainWindow getView() {
        return this.view;
    }

    public ResourceManager getResourceManager() {
        return resourceManager;
    }

    private void saveProject() {
        this.currentController.writeUserInputToProject();
        this.getVersionedProject().setUnit(this.getSelectedUnit());
        if (this.currentFile == null || this.currentFile.getName() == "") {
            File file = MainWindowController.saveFileDialog(FileUtils.getExapmlesFolder(), this.project, this.getView());
            if (file != null) {
                this.currentFile = file;
                this.getView().setTitle("WinSmart - " + file.getName());
            }
        } else {
            if (!this.currentFile.getName().toLowerCase().endsWith(".ser")) {
                String string = this.currentFile.getAbsolutePath();
                if (string.endsWith(".xml")) {
                    string = string.substring(0, string.length() - 4);
                }
                String string2 = string + ".ser";
                this.currentFile = new File(string2);
            }
            FileUtils.saveProject(this.currentFile, this.project);
        }
    }

    @Override
    public void update(DataProvider dataProvider) {
        for (ListController object : this.outputItemcontroller) {
            if (object.getView() instanceof ResultCardFile) continue;
            ((ResultController)object).clearResultPlots();
        }
        this.getView().disableOutputListItemsButLast();
        if (dataProvider.getBTCsPollutants() != null) {
            this.getView().enableOutputListItemAtIndex(0);
            for (ResultPlot resultPlot : dataProvider.getBTCsPollutants()) {
                ((ResultController)this.outputItemcontroller.get(0)).addResultPlot(resultPlot);
            }
        }
        if (dataProvider.getProfilesPollutants() != null) {
            this.getView().enableOutputListItemAtIndex(1);
            for (ResultPlot resultPlot : dataProvider.getProfilesPollutants()) {
                ((ResultController)this.outputItemcontroller.get(2)).addResultPlot(resultPlot);
            }
        }
        if (dataProvider.getBTCsSurfactants() != null) {
            this.getView().enableOutputListItemAtIndex(2);
            for (ResultPlot resultPlot : dataProvider.getBTCsSurfactants()) {
                ((ResultController)this.outputItemcontroller.get(1)).addResultPlot(resultPlot);
            }
        }
        if (dataProvider.getProfilesSurfactants() != null) {
            this.getView().enableOutputListItemAtIndex(3);
            for (ResultPlot resultPlot : dataProvider.getProfilesSurfactants()) {
                ((ResultController)this.outputItemcontroller.get(3)).addResultPlot(resultPlot);
            }
        }
    }

    private Series.Unit getSelectedUnit() {
        if (this.selectedUnit == null) {
            this.selectedUnit = Series.Unit.SEC;
        }
        return this.selectedUnit;
    }

    private void setSelectedUnit(Series.Unit unit) {
        this.selectedUnit = unit;
    }

    public ResultPlotBuilder.AxisRelation getAxisRelation() {
        if (this.axisRelation == null) {
            this.axisRelation = ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE;
        }
        return this.axisRelation;
    }

    public void setAxisRelation(ResultPlotBuilder.AxisRelation axisRelation) {
        this.axisRelation = axisRelation;
    }

    public boolean isFullVersion() {
        return this.fullVersion;
    }

    public boolean isFortranDone() {
        return this.fortranIsDone;
    }

    public void setFortranIsDone(boolean bl) {
        this.fortranIsDone = bl;
    }

    private final class OutputListSelectionListener
    implements ListSelectionListener {
        private OutputListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && ((JList)listSelectionEvent.getSource()).getSelectedIndex() >= 0) {
                CardLayout cardLayout = (CardLayout)MainWindowController.this.getView().getTab3().getLayout();
                JList jList = (JList)listSelectionEvent.getSource();
                OutputCardValue outputCardValue = (OutputCardValue)((Object)jList.getSelectedValue());
                switch (outputCardValue) {
                    case RESULTBTC: {
                        cardLayout.show(MainWindowController.this.getView().getTab3(), OutputCardValue.RESULTBTC.name());
                        ((ListController)MainWindowController.this.outputItemcontroller.get(0)).loadModelDataAndShowView();
                        return;
                    }
                    case RESULTPROFILE: {
                        cardLayout.show(MainWindowController.this.getView().getTab3(), OutputCardValue.RESULTPROFILE.name());
                        ((ListController)MainWindowController.this.outputItemcontroller.get(2)).loadModelDataAndShowView();
                        return;
                    }
                    case RESULTBTCSUR: {
                        cardLayout.show(MainWindowController.this.getView().getTab3(), OutputCardValue.RESULTBTCSUR.name());
                        ((ListController)MainWindowController.this.outputItemcontroller.get(1)).loadModelDataAndShowView();
                        return;
                    }
                    case RESULTPROFILESUR: {
                        cardLayout.show(MainWindowController.this.getView().getTab3(), OutputCardValue.RESULTPROFILESUR.name());
                        ((ListController)MainWindowController.this.outputItemcontroller.get(3)).loadModelDataAndShowView();
                        return;
                    }
                    case RESULTFILE: {
                        cardLayout.show(MainWindowController.this.getView().getTab3(), OutputCardValue.RESULTFILE.name());
                        ((ListController)MainWindowController.this.outputItemcontroller.get(MainWindowController.this.outputItemcontroller.size() - 1)).loadModelDataAndShowView();
                        return;
                    }
                }
            }
        }
    }

    private final class addFCancelButtonListener
    implements ActionListener {
        private addFCancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainWindowController.this.getView().setMenuItemsRunEnabled(true);
            ((FortranPanel)MainWindowController.this.getView().getTab4()).disableFCancelButton();
            if (MainWindowController.this.fortranTask != null) {
                MainWindowController.this.fortranTask.cancel(true);
            }
        }
    }

    private final class MenuItemAxisRangeListener
    implements ActionListener {
        private MenuItemAxisRangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JOptionPane.showInputDialog(MainWindowController.this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_settings_lbl2), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_axisrange), -1, null, (Object[])ResultPlotBuilder.AxisRelation.values(), (Object)MainWindowController.this.getAxisRelation());
            if (object != null) {
                MainWindowController.this.setAxisRelation((ResultPlotBuilder.AxisRelation)((Object)object));
                if (MainWindowController.this.converter != null) {
                    MainWindowController.this.converter.setAxisRelation((ResultPlotBuilder.AxisRelation)((Object)object));
                    MainWindowController.this.converter.generatePlots();
                }
            }
        }
    }

    private final class MenuItemUnitsListener
    implements ActionListener {
        private MenuItemUnitsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JOptionPane.showInputDialog(MainWindowController.this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_settings_lbl1), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_units), -1, null, (Object[])Series.Unit.values(), (Object)MainWindowController.this.getSelectedUnit());
            if (object != null) {
                MainWindowController.this.setSelectedUnit((Series.Unit)((Object)object));
                if (MainWindowController.this.converter != null) {
                    MainWindowController.this.converter.setUnit((Series.Unit)((Object)object));
                    MainWindowController.this.converter.generatePlots();
                }
            }
        }
    }

    private final class MenuItemLanguageListener
    implements ActionListener {
        private MenuItemLanguageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{Locale.GERMANY.getDisplayLanguage(), Locale.US.getDisplayLanguage()};
            String string = (String)JOptionPane.showInputDialog(MainWindowController.this.getView(), "", "Sprachauswahl", -1, null, objectArray, "Deutsch");
            if (string != null) {
                if (string.equals(Locale.GERMANY.getDisplayLanguage())) {
                    resourceManager.activateLocale(Locale.GERMANY);
                    MainWindowController.this.refreshView();
                } else if (string.equals(Locale.US.getDisplayLanguage())) {
                    resourceManager.activateLocale(Locale.US);
                    MainWindowController.this.refreshView();
                }
                return;
            }
        }
    }

    private final class MenuItemAboutListener
    implements ActionListener {
        private MenuItemAboutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File("./images/bmbf_115.gif");
            File file2 = new File("./images/tasklogo_115.gif");
            File file3 = new File("./images/mwfk.gif");
            String string = file.toURI().toString();
            String string2 = file2.toURI().toString();
            String string3 = file3.toURI().toString();
            JLabel jLabel = new JLabel("<HTML><BODY><img src=\"" + string + "\"" + " hspace=40 align=\"top\"" + ">" + "<img src=\"" + string2 + "\"" + " hspace=40 align=\"top\"" + ">" + "<img src=\"" + string3 + "\"" + " hspace=40 align=\"top\"" + ">" + "</BODY></HTML>", 0);
            String string4 = new String("\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section1_title) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section1_phrase1) + " " + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section1_phrase2) + " " + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section1_phrase3) + "\n\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section2_title) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section2_phrase1) + " " + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section2_phrase2) + " " + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section2_phrase3) + "\n\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_title) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line3) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line4) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line5) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line6) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line7) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line8) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line9) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section3_line10) + "\n\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section4_title) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section4_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section4_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_section4_line3) + "\n");
            JTextArea jTextArea = new JTextArea(string4);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setPreferredSize(new Dimension(1030, 510));
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            jPanel.add(jTextArea);
            jPanel.setPreferredSize(new Dimension(1060, 620));
            jPanel.setBackground(Color.WHITE);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JOptionPane.showMessageDialog(MainWindowController.this.view, jPanel, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_help_title), -1);
        }
    }

    private final class MenuItemHelpBookListener
    implements ActionListener {
        private MenuItemHelpBookListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JHelp jHelp = null;
            try {
                object = MainWindowController.class.getClassLoader();
                URL uRL = HelpSet.findHelpSet((ClassLoader)object, "jhelpset.hs");
                jHelp = new JHelp(new HelpSet((ClassLoader)object, uRL));
                Enumeration enumeration = jHelp.getHelpNavigators();
                while (enumeration.hasMoreElements()) {
                    JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
                    if (!(jHelpNavigator instanceof JHelpIndexNavigator)) continue;
                    jHelp.removeHelpNavigator(jHelpNavigator);
                }
            }
            catch (Exception exception) {
                System.err.println("API Help Set not found");
            }
            object = new JFrame();
            ((Frame)object).setTitle(resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.help_manual_title));
            ((Window)object).setSize(800, 600);
            ((JFrame)object).getContentPane().add(jHelp);
            ((JFrame)object).setDefaultCloseOperation(2);
            ((Window)object).setVisible(true);
        }
    }

    private final class MenuItemSaveWithoutDialogListener
    implements ActionListener {
        private MenuItemSaveWithoutDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainWindowController.this.saveProject();
        }
    }

    private final class MenuItemSaveProjectListener
    implements ActionListener {
        private MenuItemSaveProjectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            MainWindowController.this.currentController.writeUserInputToProject();
            if (MainWindowController.this.currentFile == null || MainWindowController.this.currentFile.getName() == "") {
                MainWindowController.this.currentFile = FileUtils.getExapmlesFolder();
            }
            if ((file = MainWindowController.saveFileDialog(MainWindowController.this.currentFile, MainWindowController.this.project, MainWindowController.this.getView())) != null) {
                MainWindowController.this.currentFile = file;
                MainWindowController.this.getView().setTitle("WinSmart - " + file.getName());
            }
        }
    }

    private final class MenuItemExitListener
    implements ActionListener {
        private MenuItemExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showOptionDialog(null, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_exit_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont) + "\n", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
            if (n == 0) {
                MainWindowController.this.getView().setVisible(false);
                MainWindowController.this.getView().dispose();
                System.exit(0);
            }
        }
    }

    private final class MenuItemStartListener
    implements ActionListener {
        private MenuItemStartListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = MainWindowController.this.getPreparedFortranFolder();
            if (file != null) {
                MainWindowController.this.setFortranOutputFolder(file);
                MainWindowController.this.view.showTab(MainWindow.TabValue.FORTRANLOGPANEL);
                ((FortranPanel)MainWindowController.this.view.getTab4()).enableFCancelButton();
                MainWindowController.this.getView().setMenuItemsRunEnabled(false);
                ((FortranPanel)MainWindowController.this.view.getTab4()).clearLogArea();
                ((FortranPanel)MainWindowController.this.view.getTab4()).setProgress(0);
                MainWindowController.this.prepareAndRunFortranWithFolder(file);
            }
        }
    }

    private final class MenuItemRunListener
    implements ActionListener {
        private MenuItemRunListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = MainWindowController.this.prepareFortranCalculation();
            String string = "";
            if (file != null) {
                try {
                    string = FortranUtils.checkTimeStepRangesForProject(MainWindowController.this.project);
                    FortranUtils.generateFortranInputFileWithProjectData(MainWindowController.this.project, file);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MainWindowController.this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_generate_fortranfile_line3) + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                    return;
                }
                MainWindowController.this.setFortranOutputFolder(file);
                MainWindowController.this.view.showTab(MainWindow.TabValue.FORTRANLOGPANEL);
                ((FortranPanel)MainWindowController.this.view.getTab4()).enableFCancelButton();
                MainWindowController.this.getView().setMenuItemsRunEnabled(false);
                ((FortranPanel)MainWindowController.this.view.getTab4()).clearLogArea();
                ((FortranPanel)MainWindowController.this.view.getTab4()).setProgress(0);
                MainWindowController.this.prepareAndRunFortranWithFolder(file);
                if (string != null) {
                    ((FortranPanel)MainWindowController.this.getView().getTab4()).appendLineToLogArea(string);
                }
            }
        }
    }

    private final class MenuItemLoadProjectListener
    implements ActionListener {
        private MenuItemLoadProjectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            if (MainWindowController.this.currentFile != null && MainWindowController.this.currentFile.getName() != "") {
                MainWindowController.this.getVersionedProject().setUnit(MainWindowController.this.getSelectedUnit());
                FileUtils.saveProject(MainWindowController.this.currentFile, MainWindowController.this.project);
            }
            if ((file = MainWindowController.loadFileDialog(FileUtils.getExapmlesFolder(), MainWindowController.this.getView())) != null) {
                Object object = FileUtils.openProject(file);
                if (object != null && object instanceof Project) {
                    Project project = (Project)object;
                    MainWindowController.this.versionCheckForProject(project);
                    VersionedProject versionedProject = new VersionedProject(project);
                    for (Pollutant pollutant : versionedProject.allPollutants()) {
                        pollutant.setBezeichnung(pollutant.getBezeichnung());
                    }
                    for (Surfactant surfactant : versionedProject.allSurfactants()) {
                        surfactant.setBezeichnung(surfactant.getBezeichnung());
                    }
                    for (AquiferMaterial aquiferMaterial : versionedProject.allAquiferMaterials()) {
                        aquiferMaterial.setBezeichnung(aquiferMaterial.getBezeichnung());
                    }
                    MainWindowController.this.setVersionedProject(versionedProject);
                    MainWindowController.this.setCurrentFile(file);
                    MainWindowController.this.setSelectedUnit(MainWindowController.this.project.getUnit());
                    MainWindowController.this.updateInputTab(MainWindowController.this.project);
                    MainWindowController.this.updateResultTab(MainWindowController.this.project);
                    MainWindowController.this.updateSmartModeItems(MainWindowController.this.project);
                    MainWindowController.this.setDefaultListAndTabSelection();
                    MainWindowController.this.getView().setTitle("WinSmart - " + MainWindowController.this.currentFile.getName());
                } else if (object != null && object instanceof VersionedProject) {
                    VersionedProject versionedProject = (VersionedProject)object;
                    for (Pollutant pollutant : versionedProject.allPollutants()) {
                        pollutant.setBezeichnung(pollutant.getBezeichnung());
                    }
                    for (Surfactant surfactant : versionedProject.allSurfactants()) {
                        surfactant.setBezeichnung(surfactant.getBezeichnung());
                    }
                    for (AquiferMaterial aquiferMaterial : versionedProject.allAquiferMaterials()) {
                        aquiferMaterial.setBezeichnung(aquiferMaterial.getBezeichnung());
                    }
                    MainWindowController.this.setCurrentFile(file);
                    MainWindowController.this.setVersionedProject(versionedProject);
                    MainWindowController.this.setSelectedUnit(MainWindowController.this.project.getUnit());
                    MainWindowController.this.updateInputTab(MainWindowController.this.project);
                    MainWindowController.this.updateResultTab(MainWindowController.this.project);
                    MainWindowController.this.updateSmartModeItems(MainWindowController.this.project);
                    MainWindowController.this.setDefaultListAndTabSelection();
                    MainWindowController.this.getView().setTitle("WinSmart - " + MainWindowController.this.currentFile.getName());
                } else {
                    JOptionPane.showMessageDialog(MainWindowController.this.getView(), resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line1) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line2) + "\n" + resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_load_fileformat_line3) + "", resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                }
            }
        }
    }

    private final class MenuItemNewListener
    implements ActionListener {
        private MenuItemNewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            if (MainWindowController.this.currentFile != null) {
                MainWindowController.this.currentController.writeUserInputToProject();
                MainWindowController.this.getVersionedProject().setUnit(MainWindowController.this.getSelectedUnit());
                FileUtils.saveProject(MainWindowController.this.currentFile, MainWindowController.this.project);
            }
            if ((file = MainWindowController.this.loadNewProjectDialog()) != null) {
                MainWindowController.this.setCurrentFile(file);
                VersionedProject versionedProject = new VersionedProject();
                versionedProject.setSzenarioName((String)file.getName().subSequence(0, file.getName().length() - 4));
                MainWindowController.this.setVersionedProject(versionedProject);
                MainWindowController.this.setSelectedUnit(versionedProject.getUnit());
                MainWindowController.this.updateInputTab(versionedProject);
                MainWindowController.this.updateResultTab(versionedProject);
                MainWindowController.this.updateSmartModeItems(versionedProject);
                MainWindowController.this.setDefaultListAndTabSelection();
                MainWindowController.this.getView().setTitle("WinSmart - " + MainWindowController.this.currentFile.getName());
                if (MainWindowController.this.currentFile != null && MainWindowController.this.currentFile.getName() != "") {
                    MainWindowController.this.getVersionedProject().setUnit(MainWindowController.this.getSelectedUnit());
                    FileUtils.saveProject(MainWindowController.this.currentFile, MainWindowController.this.project);
                }
            }
        }
    }

    private final class OutputListMouseListener
    implements MouseListener {
        private OutputListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MainWindowController.this.view.showTab(MainWindow.TabValue.OUTPUTPANEL);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private final class OutputListFocusListener
    implements FocusListener {
        private OutputListFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MainWindowController.this.currentController.writeUserInputToProject();
        }
    }

    private final class InputListMouseListener
    implements MouseListener {
        private InputListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MainWindowController.this.view.showTab(MainWindow.TabValue.INPUTPANEL);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private final class InputListFocusListener
    implements FocusListener {
        private InputListFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MainWindowController.this.currentController.writeUserInputToProject();
        }
    }

    private final class SmartModeUnselectedListener
    implements ActionListener {
        private SmartModeUnselectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainWindowController.this.project != null) {
                MainWindowController.this.project.setMode(VersionedProject.SimulationMode.NORMAL);
            }
            MainWindowController.this.view.disableListItemAtIndex(2);
        }
    }

    private final class SmartModeSelectedListener
    implements ActionListener {
        private SmartModeSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainWindowController.this.project != null) {
                MainWindowController.this.project.setMode(VersionedProject.SimulationMode.SMART);
            }
            MainWindowController.this.view.enableListItemAtIndex(2);
        }
    }

    private final class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
            if (MainWindowController.this.currentTabIndex == 0) {
                MainWindowController.this.currentController.writeUserInputToProject();
            }
            MainWindowController.this.currentTabIndex = n;
        }
    }

    public static enum OutputCardValue {
        RESULTBTC(0),
        RESULTPROFILE(1),
        RESULTBTCSUR(0),
        RESULTPROFILESUR(1),
        RESULTFILE(2);

        private final int index;

        private OutputCardValue(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return resourceManager.getLangString(OutputCardValue.valueOf(OutputCardValue.class, super.toString()));
        }
    }

    public static enum InputCardValue {
        SZENARIOINFORMATIONEN(0),
        MODELLGEOMETRIE(1),
        VERWEILZEITEN(2),
        SIMULATIONSZEITEN(3),
        MATERIAL(4),
        HYDPARAMETER(5),
        UNTERGRUNDEIGENSCHAFTEN(6),
        KOMPONENTEN(7),
        STROEMUNGEN(8),
        TRANSPORT(9),
        BIOABBAU(10),
        SORPTION(11),
        SOLUBILISIERUNG(12),
        ADSOLUBILISIERUNG(13),
        MONOMERSCHICHTFORMATION(14),
        MODELLEINSTELLUNGEN(15),
        AUSGABESPEZIFIKATION(16);

        private final int index;

        private InputCardValue(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return resourceManager.getLangString(InputCardValue.valueOf(InputCardValue.class, super.toString()));
        }
    }
}

