/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.ListCard;
import de.dsite.project.VersionedProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;

public abstract class ListController {
    protected final ListCard view;
    protected VersionedProject model;
    protected MainWindowController parent;

    public ListController(ListCard listCard, MainWindowController mainWindowController) {
        this.view = listCard;
        this.parent = mainWindowController;
        this.model = mainWindowController.getVersionedProject();
        this.view.setFocusable(true);
        String string = this.view.cardName();
        if (string != "") {
            mainWindowController.getView().addCardToInputPanel(this.view, string);
        }
        this.addListener();
    }

    public JPanel getView() {
        return this.view;
    }

    protected void addListener() {
        this.view.addFocusListener(new UpadteOnFocusLostListener());
        this.view.addNextButtonListener(new NextButtonListener());
        this.view.addPrevButtonListener(new PrevButtonListener());
    }

    public void updateModelData(VersionedProject versionedProject) {
        this.model = versionedProject;
    }

    public abstract boolean writeUserInputToProject();

    public abstract void loadModelDataAndShowView();

    protected class PrevButtonListener
    implements ActionListener {
        protected PrevButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListController.this.parent.getView().getInputList().getSelectedIndex();
            ListController.this.parent.getView().getInputList().setSelectedIndex(--n);
        }
    }

    protected class NextButtonListener
    implements ActionListener {
        protected NextButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ListController.this.writeUserInputToProject()) {
                int n = ListController.this.parent.getView().getInputList().getSelectedIndex();
                ListController.this.parent.getView().getInputList().setSelectedIndex(++n);
            }
        }
    }

    private final class UpadteOnFocusLostListener
    implements FocusListener {
        private UpadteOnFocusLostListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ListController.this.loadModelDataAndShowView();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ListController.this.writeUserInputToProject();
        }
    }
}

