/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.HydraulicsCard;
import de.dsite.project.Hydraulic;
import de.dsite.project.SecondaryLayer;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class HydraulicsController
extends ListController {
    private final TableModel tableModel = new TableModel();
    private final ArrayList<Hydraulic> hydraulicList = new ArrayList();

    public HydraulicsController(MainWindowController mainWindowController) {
        super(new HydraulicsCard(), mainWindowController);
        ((HydraulicsCard)this.view).addTableModel(this.tableModel);
        ((HydraulicsCard)this.view).addListenerAddHydraulic(new AddColumnButtonListener());
        ((HydraulicsCard)this.view).addListenerDelHydraulic(new DelColumnButtonListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        this.hydraulicList.clear();
        if (this.model.getLeaves() != null && this.model.getLeaves().size() > 0) {
            for (SecondaryLayer secondaryLayer : this.model.getLeaves()) {
                Hydraulic hydraulic = secondaryLayer.getHydraulic();
                if (this.hydraulicList.contains(hydraulic)) continue;
                this.hydraulicList.add(hydraulic);
            }
            this.tableModel.fireTableDataChanged();
        }
        ((HydraulicsCard)this.view).addTableModel(this.tableModel);
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((HydraulicsCard)this.view).getTable().isEditing()) {
            ((HydraulicsCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    private final class DelColumnButtonListener
    implements ActionListener {
        private DelColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HydraulicsController.this.model.allHydraulics() != null) {
                int[] nArray = ((HydraulicsCard)HydraulicsController.this.view).getTable().getSelectedRows();
                if (nArray.length > 0) {
                    HydraulicsController.this.model.deleteHydraulicsWithIndices(nArray);
                }
                HydraulicsController.this.tableModel.fireTableDataChanged();
            }
        }
    }

    private final class AddColumnButtonListener
    implements ActionListener {
        private AddColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = HydraulicsController.this.model.addHydraulic();
            if (bl) {
                HydraulicsController.this.tableModel.fireTableDataChanged();
            }
        }
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_hydraulic_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_hydraulic_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_hydraulic_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_hydraulic_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_hydraulic_tcol5)};

        private TableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return HydraulicsController.this.model.allHydraulics() != null ? HydraulicsController.this.model.allHydraulics().size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return HydraulicsController.this.model.allHydraulics().get(n).getName();
            }
            return HydraulicsController.this.model.allHydraulics().get(n).getValues()[n2 - 1];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            try {
                object = Double.parseDouble((String)object);
                HydraulicsController.this.model.allHydraulics().get((int)n).getValues()[n2 - 1] = (Double)object;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

