/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.GroundPropertyCard;
import de.dsite.project.Hydraulic;
import de.dsite.project.Material;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GroundPropertyController
extends ListController {
    private final ComboTableModel tableModel;
    private final ComboTableCellRenderer renderer = new ComboTableCellRenderer();
    final JComboBox<Material> comboBoxMaterial = new JComboBox();
    final JComboBox<Hydraulic> comboBoxHydraulic = new JComboBox();
    final TableCellEditor editorMaterial = new DefaultCellEditor(this.comboBoxMaterial);
    final TableCellEditor editorHydraulic = new DefaultCellEditor(this.comboBoxHydraulic);

    public GroundPropertyController(MainWindowController mainWindowController) {
        super(new GroundPropertyCard(), mainWindowController);
        this.comboBoxMaterial.setRenderer(this.renderer);
        this.comboBoxHydraulic.setRenderer(this.renderer);
        this.tableModel = new ComboTableModel();
        ((GroundPropertyCard)this.view).addTableModel(this.tableModel);
    }

    @Override
    public void loadModelDataAndShowView() {
        this.view.setVisible(true);
        Material[] materialArray = this.model.allMaterials().toArray(new Material[0]);
        Hydraulic[] hydraulicArray = this.model.allHydraulics().toArray(new Hydraulic[0]);
        this.comboBoxMaterial.removeAllItems();
        this.comboBoxHydraulic.removeAllItems();
        for (Material comparable : materialArray) {
            this.comboBoxMaterial.addItem(comparable);
        }
        for (Comparable<Material> comparable : hydraulicArray) {
            this.comboBoxHydraulic.addItem((Hydraulic)comparable);
        }
        if (this.model.getLeaves() != null && this.model.getLeaves().size() > 0) {
            TableColumn tableColumn = ((GroundPropertyCard)this.view).getTable().getColumnModel().getColumn(5);
            TableColumn tableColumn2 = ((GroundPropertyCard)this.view).getTable().getColumnModel().getColumn(4);
            tableColumn.setCellRenderer(this.renderer);
            tableColumn.setCellEditor(this.editorMaterial);
            tableColumn2.setCellRenderer(this.renderer);
            tableColumn2.setCellEditor(this.editorHydraulic);
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((GroundPropertyCard)this.view).getTable().isEditing()) {
            ((GroundPropertyCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    class ComboTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_groundproperty_tcol6)};

        ComboTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return GroundPropertyController.this.model.getLeaves() == null ? 0 : GroundPropertyController.this.model.getLeaves().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return GroundPropertyController.this.model.getLeaves().get(n).getName();
            }
            if (n2 == 2) {
                return GroundPropertyController.this.model.getLeaves().get(n).getXOK();
            }
            if (n2 == 3) {
                return GroundPropertyController.this.model.getLeaves().get(n).getXUK();
            }
            if (n2 == 4) {
                return GroundPropertyController.this.model.getLeaves().get(n).getHydraulic();
            }
            if (n2 == 5) {
                return GroundPropertyController.this.model.getLeaves().get(n).getMaterial();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n) != null ? this.getValueAt(0, n).getClass() : String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 4) {
                GroundPropertyController.this.model.setHydraulicForLayer(GroundPropertyController.this.model.getLeaves().get(n), (Hydraulic)object);
            } else if (n2 == 5) {
                GroundPropertyController.this.model.setMaterialForLayer(GroundPropertyController.this.model.getLeaves().get(n), (Material)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 3;
        }
    }

    class ComboTableCellRenderer
    implements ListCellRenderer<Object>,
    TableCellRenderer {
        DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();

        ComboTableCellRenderer() {
        }

        private void configureRenderer(JLabel jLabel, Object object) {
            if (object != null && object instanceof Material) {
                jLabel.setText(object.toString());
            } else if (object != null && object instanceof Hydraulic) {
                jLabel.setText(object.toString());
            } else {
                jLabel.setText((String)object);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.listRenderer = (DefaultListCellRenderer)this.listRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.configureRenderer(this.listRenderer, object);
            return this.listRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.tableRenderer = (DefaultTableCellRenderer)this.tableRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.configureRenderer(this.tableRenderer, object);
            return this.tableRenderer;
        }
    }
}

