/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.Layer;
import de.dsite.gui.TreePanel;
import de.dsite.gui.listcard.GeometryCard;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.VersionedProject;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GeometryController
extends ListController {
    private Layer selectedLayer = null;

    public GeometryController(MainWindowController mainWindowController) {
        super(new GeometryCard(), mainWindowController);
        ((GeometryCard)this.view).addAddButtonListener(new AddButtonListener());
        ((GeometryCard)this.view).addRemoveButtonListener(new RemoveButtonListener());
        GeometryTextFieldActionListener geometryTextFieldActionListener = new GeometryTextFieldActionListener();
        ((GeometryCard)this.view).addTextField1Listener(geometryTextFieldActionListener);
        ((GeometryCard)this.view).addTextField2Listener(geometryTextFieldActionListener);
        ((GeometryCard)this.view).addTextField3Listener(geometryTextFieldActionListener);
        ((GeometryCard)this.view).addTextField4Listener(geometryTextFieldActionListener);
        ((GeometryCard)this.view).addTextField5Listener(geometryTextFieldActionListener);
        GeometryTextFieldFocusListener geometryTextFieldFocusListener = new GeometryTextFieldFocusListener();
        ((GeometryCard)this.view).addTextField1Listener(geometryTextFieldFocusListener);
        ((GeometryCard)this.view).addTextField2Listener(geometryTextFieldFocusListener);
        ((GeometryCard)this.view).addTextField3Listener(geometryTextFieldFocusListener);
        ((GeometryCard)this.view).addTextField4Listener(geometryTextFieldFocusListener);
        ((GeometryCard)this.view).addTextField5Listener(geometryTextFieldFocusListener);
        ((GeometryCard)this.view).getTreePanel().getTree().addTreeSelectionListener(new NodeSelectionChangedListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        if (this.model.getCrossSection() != 0.0) {
            ((GeometryCard)this.view).getTreeEditor().getTextField5().setText("" + this.model.getCrossSection());
        }
        if (this.model.getLayers().size() > 0) {
            GeometryController.arrayListToTree(((GeometryCard)this.view).getTreePanel(), this.model.getLayers());
        }
        this.view.setVisible(true);
    }

    @Override
    public void updateModelData(VersionedProject versionedProject) {
        super.updateModelData(versionedProject);
        if (versionedProject.getLayers().size() > 0) {
            GeometryController.arrayListToTree(((GeometryCard)this.view).getTreePanel(), versionedProject.getLayers());
        }
    }

    private int indexOfSecondaryLayer(SecondaryLayer secondaryLayer) {
        int n = 0;
        for (Layer layer : this.model.getLayers()) {
            if (layer instanceof SecondaryLayer && layer.equals(secondaryLayer) && layer.getXOK() == secondaryLayer.getXOK() && layer.getXUK() == secondaryLayer.getXUK()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean writeXOKValueToLayer(double d, Layer layer) {
        if (d >= layer.getXUK()) {
            return false;
        }
        if (!(layer instanceof SecondaryLayer)) {
            return false;
        }
        int n = this.indexOfSecondaryLayer((SecondaryLayer)layer);
        Layer layer2 = this.model.getLayers().get(n - 1);
        if (!(layer2 instanceof SecondaryLayer)) {
            return false;
        }
        if (!(layer2.getXOK() < d)) {
            return false;
        }
        layer2.setXUK(d);
        layer.setXOK(d);
        this.model.notifyListener();
        return true;
    }

    private boolean writeXUKValueToLayer(double d, Layer layer) {
        if (d <= layer.getXOK()) {
            return false;
        }
        if (layer instanceof SecondaryLayer) {
            int n = this.indexOfSecondaryLayer((SecondaryLayer)layer);
            if (d < this.model.getLayers().get(n + 1).getXUK()) {
                layer.setXUK(d);
                this.model.getLayers().get(n + 1).setXOK(d);
                return true;
            }
            return false;
        }
        int n = this.model.getLayers().indexOf(layer);
        SecondaryLayer secondaryLayer = this.getLastSecondaryLayerAfterLayerInList(this.model.getLayers(), layer);
        double d2 = layer.getXUK();
        double d3 = layer.getXOK();
        double d4 = d2 - d3;
        layer.setXUK(d);
        Layer layer2 = this.model.getLayers().get(n + 1);
        layer2.setXUK(d3 + (layer2.getXUK() - d3) / d4 * (d - d3));
        secondaryLayer.setXUK(d);
        secondaryLayer.setXOK(d3 + (secondaryLayer.getXOK() - d3) / d4 * (d - d3));
        Layer layer3 = this.getNextLayerInList(this.model.getLayers(), layer);
        if (layer3 == null) {
            if (n + 1 != this.model.getLayers().size() - 1) {
                for (int i = n + 2; i < this.model.getLayers().size() - 1; ++i) {
                    Layer layer4 = this.model.getLayers().get(i);
                    layer4.setXUK(d3 + (layer4.getXUK() - d3) / d4 * (d - d3));
                    layer4.setXOK(d3 + (layer4.getXOK() - d3) / d4 * (d - d3));
                }
            }
            this.model.notifyListener();
            return true;
        }
        int n2 = this.model.getLayers().indexOf(layer3);
        if (n + 1 != n2 - 1) {
            for (int i = n + 2; i < n2 - 1; ++i) {
                Layer layer5 = this.model.getLayers().get(i);
                layer5.setXUK(d3 + (layer5.getXUK() - d3) / d4 * (d - d3));
                layer5.setXOK(d3 + (layer5.getXOK() - d3) / d4 * (d - d3));
            }
        }
        double d5 = d - this.model.getLayers().get(n2).getXOK();
        for (int i = n2; i < this.model.getLayers().size(); ++i) {
            Layer layer6 = this.model.getLayers().get(i);
            layer6.setXUK(layer6.getXUK() + d5);
            layer6.setXOK(layer6.getXOK() + d5);
        }
        this.model.notifyListener();
        return true;
    }

    private Layer getLastLayerInList(List<Layer> list) {
        int n = list.size();
        while (n >= 0) {
            if (list.get(--n) instanceof SecondaryLayer) continue;
            return list.get(n);
        }
        return null;
    }

    private int getNumberOfLayerInList(List<Layer> list, Layer layer) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof SecondaryLayer) continue;
            ++n;
            if (!layer.equals(list.get(i))) continue;
            return n;
        }
        return -1;
    }

    private Layer getNextLayerInList(List<Layer> list, Layer layer) {
        if (!(layer instanceof Layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be of Type Layer");
        }
        if (!list.contains(layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be in LayersList 'al'");
        }
        int n = list.indexOf(layer) + 1;
        if (n < list.size()) {
            while (n < list.size() && list.get(n) instanceof SecondaryLayer) {
                ++n;
            }
            if (n < list.size() - 1) {
                return list.get(n);
            }
        }
        return null;
    }

    private int getNumberOfSecondaryLayersAfterLayerInList(List<Layer> list, Layer layer) {
        if (!(layer instanceof Layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be of Type Layer");
        }
        if (!list.contains(layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be in LayersList 'al'");
        }
        int n = list.indexOf(layer) + 1;
        int n2 = 0;
        while (list.size() > n + n2 && list.get(n + n2) instanceof SecondaryLayer) {
            ++n2;
        }
        return n2;
    }

    private SecondaryLayer getLastSecondaryLayerAfterLayerInList(List<Layer> list, Layer layer) {
        if (!(layer instanceof Layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be of Type Layer");
        }
        if (!list.contains(layer)) {
            throw new IllegalArgumentException("Parameter 'l' must be in LayersList 'al'");
        }
        int n = list.indexOf(layer);
        if (n < list.size() - 1) {
            ++n;
            while (list.size() > n && list.get(n) instanceof SecondaryLayer) {
                ++n;
            }
            if (list.get(n - 1) instanceof SecondaryLayer) {
                return (SecondaryLayer)list.get(n - 1);
            }
        }
        return null;
    }

    private int containsName(String string) {
        int n = 0;
        for (Layer layer : this.model.getLayers()) {
            if (layer.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void replaceOccuranceOfName(String string) {
        int n = 0;
        for (Layer layer : this.model.getLayers()) {
            if (layer.getName().equals(string)) {
                if (layer instanceof SecondaryLayer) {
                    int n2 = 0;
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (!(this.model.getLayers().get(i) instanceof SecondaryLayer)) {
                            ++n2;
                            n3 = 0;
                            continue;
                        }
                        ++n3;
                    }
                    String string2 = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + "." + n2 + "." + (n3 + 1));
                    layer.setName(string2);
                    return;
                }
                int n4 = this.getNumberOfLayerInList(this.model.getLayers(), layer);
                String string3 = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_mainlayer) + "." + n4);
                layer.setName(string3);
                return;
            }
            ++n;
        }
    }

    private SecondaryLayer createAndAddLayerAfterLayer(Layer layer) {
        SecondaryLayer secondaryLayer = null;
        if (!(layer instanceof Layer)) {
            throw new IllegalArgumentException("Parameter 'layer' must be of Type Layer");
        }
        if (!this.model.getLayers().contains(layer)) {
            throw new IllegalArgumentException("Parameter 'layer' must be in LayersList 'model.layers'");
        }
        int n = this.model.getLayers().indexOf(layer) + this.getNumberOfSecondaryLayersAfterLayerInList(this.model.getLayers(), layer) + 1;
        SecondaryLayer secondaryLayer2 = this.getLastSecondaryLayerAfterLayerInList(this.model.getLayers(), layer);
        if (secondaryLayer2 != null) {
            double d = (secondaryLayer2.getXUK() + secondaryLayer2.getXOK()) / 2.0;
            secondaryLayer2.setXUK(d);
            String object = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + "." + this.getNumberOfLayerInList(this.model.getLayers(), layer) + "." + (this.getNumberOfSecondaryLayersAfterLayerInList(this.model.getLayers(), layer) + 1));
            this.replaceOccuranceOfName(object);
            secondaryLayer = new SecondaryLayer(object, d, layer.getXUK());
        } else {
            String string = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + "." + this.getNumberOfLayerInList(this.model.getLayers(), layer) + ".1");
            this.replaceOccuranceOfName(string);
            secondaryLayer = new SecondaryLayer(string, layer.getXOK(), layer.getXUK());
        }
        if (n == this.model.getLayers().size()) {
            this.model.addLayer(secondaryLayer);
            this.model.addLeave(secondaryLayer);
        } else {
            this.model.addLayerAtPosition(secondaryLayer, n);
            ArrayList<SecondaryLayer> arrayList = new ArrayList<SecondaryLayer>();
            for (Layer layer2 : this.model.getLayers()) {
                if (!(layer2 instanceof SecondaryLayer)) continue;
                arrayList.add((SecondaryLayer)layer2);
            }
            this.model.setLeaves(arrayList);
        }
        return secondaryLayer;
    }

    private Layer createAndAddLayer() {
        Layer layer = null;
        if (this.model.getLayers().size() == 0) {
            String string = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_mainlayer) + ".1";
            this.replaceOccuranceOfName(string);
            layer = new Layer(string, 0.0, 1.0);
            this.model.addLayer(layer);
            ((GeometryCard)this.view).getTreePanel().addObject(layer);
            string = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + ".1.1";
            this.replaceOccuranceOfName(string);
            SecondaryLayer secondaryLayer = new SecondaryLayer(string, 0.0, 1.0);
            this.model.addLayer(secondaryLayer);
            this.model.addLeave(secondaryLayer);
            return secondaryLayer;
        }
        Layer layer2 = this.getLastLayerInList(this.model.getLayers());
        int n = this.getNumberOfLayerInList(this.model.getLayers(), layer2);
        String string = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_mainlayer) + "." + (n + 1));
        this.replaceOccuranceOfName(string);
        layer = new Layer(string, layer2.getXUK(), layer2.getXUK() + 1.0);
        this.model.addLayer(layer);
        ((GeometryCard)this.view).getTreePanel().addObject(layer);
        string = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + "." + (n + 1) + ".1");
        this.replaceOccuranceOfName(string);
        SecondaryLayer secondaryLayer = new SecondaryLayer(string, layer2.getXUK(), layer2.getXUK() + 1.0);
        this.model.addLayer(secondaryLayer);
        this.model.addLeave(secondaryLayer);
        return secondaryLayer;
    }

    private boolean isOnlyChild(int n) {
        Layer layer = this.model.getLayers().get(n);
        if (!(layer instanceof SecondaryLayer)) {
            return false;
        }
        if (this.model.getLayers().get(n - 1) instanceof SecondaryLayer) {
            return false;
        }
        return this.model.getLayers().size() <= n + 1 || !(this.model.getLayers().get(n + 1) instanceof SecondaryLayer);
    }

    private int indexOfSecondaryLayerInLeaves(SecondaryLayer secondaryLayer) {
        int n = 0;
        for (SecondaryLayer secondaryLayer2 : this.model.getLeaves()) {
            if (secondaryLayer2.equals(secondaryLayer) && secondaryLayer2.getXOK() == secondaryLayer.getXOK() && secondaryLayer2.getXUK() == secondaryLayer.getXUK()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void removeLayer(int n) {
        Layer layer = this.model.getLayers().get(n);
        if (!(layer instanceof SecondaryLayer)) {
            Layer layer2 = this.getNextLayerInList(this.model.getLayers(), layer);
            if (layer2 != null) {
                layer2.setXOK(layer.getXOK());
                if (this.getNumberOfSecondaryLayersAfterLayerInList(this.model.getLayers(), layer2) > 0) {
                    this.model.getLayers().get(this.model.getLayers().indexOf(layer2) + 1).setXOK(layer.getXOK());
                }
            }
            this.model.removeLayerAtPosition(n);
            while (this.model.getLayers().size() > n && this.model.getLayers().get(n) instanceof SecondaryLayer) {
                this.model.removeLeave(this.indexOfSecondaryLayerInLeaves((SecondaryLayer)this.model.getLayers().get(n)));
                this.model.removeLayerAtPosition(n);
            }
        } else {
            if (this.model.getLayers().size() > n + 1 && this.model.getLayers().get(n + 1) instanceof SecondaryLayer) {
                this.model.getLayers().get(n + 1).setXOK(layer.getXOK());
            } else if (this.model.getLayers().get(n - 1) instanceof SecondaryLayer) {
                this.model.getLayers().get(n - 1).setXUK(layer.getXUK());
            }
            int n2 = this.indexOfSecondaryLayerInLeaves((SecondaryLayer)layer);
            if (n2 >= 0) {
                this.model.removeLeave(n2);
            }
            this.model.removeLayerAtPosition(n);
        }
    }

    @Override
    public boolean writeUserInputToProject() {
        return true;
    }

    public Layer getSelectedLayer() {
        return this.selectedLayer;
    }

    public void setSelectedLayer(Layer layer) {
        this.selectedLayer = layer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndWriteTextFieldInput(JTextField jTextField) {
        String string = jTextField.getName();
        jTextField.selectAll();
        if (string == "textField1") {
            String string2 = jTextField.getText();
            if (this.containsName(string2) < 0) {
                this.selectedLayer.setName(string2);
                ((GeometryCard)this.view).getTreeEditor().getTextField1().selectAll();
                ((GeometryCard)this.view).getTreePanel().getTree().updateUI();
                return;
            } else {
                jTextField.setText("" + this.selectedLayer.getName());
            }
            return;
        } else if (string == "textField2") {
            try {
                double d = Double.parseDouble(jTextField.getText());
                if (d != this.selectedLayer.getXOK() && this.writeXOKValueToLayer(d, this.selectedLayer)) return;
            }
            catch (NumberFormatException numberFormatException) {
                jTextField.setText("" + this.selectedLayer.getXOK());
            }
            return;
        } else if (string == "textField3") {
            try {
                double d = Double.parseDouble(jTextField.getText());
                if (d != this.selectedLayer.getXUK() && this.writeXUKValueToLayer(d, this.selectedLayer)) return;
            }
            catch (NumberFormatException numberFormatException) {
                jTextField.setText("" + this.selectedLayer.getXUK());
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jTextField.setText("" + this.selectedLayer.getXUK());
            }
            return;
        } else if (string == "textField4") {
            try {
                int n = Integer.parseInt(jTextField.getText());
                if (!(this.selectedLayer instanceof SecondaryLayer)) return;
                ((SecondaryLayer)this.selectedLayer).setNumModellzellen(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                jTextField.setText("" + ((SecondaryLayer)this.selectedLayer).getNumModellzellen());
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jTextField.setText("" + ((SecondaryLayer)this.selectedLayer).getNumModellzellen());
            }
            return;
        } else {
            if (string != "textField5") throw new IllegalArgumentException("TextField (sender) " + string + " not found!");
            try {
                double d = Double.parseDouble(jTextField.getText());
                this.model.setCrossSection(d);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                jTextField.setText("" + this.model.getCrossSection());
            }
        }
        return;
        {
            // empty if block
        }
        {
            // empty if block
        }
    }

    private static void arrayListToTree(TreePanel treePanel, List<Layer> list) {
        treePanel.clear();
        Layer layer = list.get(0);
        treePanel.addObject(layer);
        ListIterator<Layer> listIterator = list.listIterator(1);
        while (listIterator.hasNext()) {
            Layer layer2 = listIterator.next();
            if (layer.getXUK() > layer2.getXOK()) {
                treePanel.addObject(layer2);
                treePanel.selectParentNode();
                continue;
            }
            treePanel.selectParentNode();
            treePanel.selectParentNode();
            treePanel.addObject(layer2);
            layer = layer2;
        }
    }

    private final class GeometryTextFieldFocusListener
    implements FocusListener {
        private GeometryTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            GeometryController.this.validateAndWriteTextFieldInput((JTextField)focusEvent.getComponent());
        }
    }

    private final class GeometryTextFieldActionListener
    implements ActionListener {
        private GeometryTextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GeometryController.this.validateAndWriteTextFieldInput((JTextField)actionEvent.getSource());
        }
    }

    private final class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((GeometryCard)GeometryController.this.view).getTreePanel().isSelected() && !((GeometryCard)GeometryController.this.view).getTreePanel().getSelectedNode().equals(((GeometryCard)GeometryController.this.view).getTreePanel().getRootNode())) {
                int n = 0;
                DefaultMutableTreeNode defaultMutableTreeNode = ((GeometryCard)GeometryController.this.view).getTreePanel().getSelectedNode();
                Enumeration<TreeNode> enumeration = ((GeometryCard)GeometryController.this.view).getTreePanel().getRootNode().preorderEnumeration();
                while (!enumeration.nextElement().equals(defaultMutableTreeNode)) {
                    ++n;
                }
                if (!GeometryController.this.isOnlyChild(n - 1)) {
                    GeometryController.this.removeLayer(n - 1);
                    ((GeometryCard)GeometryController.this.view).getTreePanel().removeCurrentNode();
                }
            }
        }
    }

    private final class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((GeometryCard)GeometryController.this.view).getTreePanel().isSelected() && ((GeometryCard)GeometryController.this.view).getTreePanel().getLevel() < 2) {
                int n = GeometryController.this.model.getLayers().indexOf(GeometryController.this.getSelectedLayer());
                if (n >= 0) {
                    SecondaryLayer secondaryLayer = GeometryController.this.createAndAddLayerAfterLayer(GeometryController.this.model.getLayers().get(n));
                    if (secondaryLayer != null) {
                        ((GeometryCard)GeometryController.this.view).getTreePanel().addObject(secondaryLayer);
                    }
                } else {
                    Layer layer = GeometryController.this.createAndAddLayer();
                    if (layer != null) {
                        ((GeometryCard)GeometryController.this.view).getTreePanel().addObject(layer);
                    }
                }
            }
        }
    }

    private final class NodeSelectionChangedListener
    implements TreeSelectionListener {
        private NodeSelectionChangedListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            JTextField jTextField = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField1();
            JTextField jTextField2 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField2();
            JTextField jTextField3 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField3();
            JTextField jTextField4 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField4();
            JTextField jTextField5 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField5();
            JLabel jLabel = ((GeometryCard)GeometryController.this.view).getTreeEditor().getLabel2();
            JLabel jLabel2 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getLabel3();
            JLabel jLabel3 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getLabel4();
            JLabel jLabel4 = ((GeometryCard)GeometryController.this.view).getTreeEditor().getLabel5();
            if (GeometryController.this.selectedLayer != null) {
                object = ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField1().getText();
                if (GeometryController.this.containsName((String)object) < 0) {
                    GeometryController.this.selectedLayer.setName((String)object);
                } else {
                    ((GeometryCard)GeometryController.this.view).getTreeEditor().getTextField1().setText("" + GeometryController.this.selectedLayer.getName());
                }
                if (GeometryController.this.selectedLayer instanceof Layer) {
                    double d;
                    try {
                        d = Double.parseDouble(jTextField2.getText());
                        if (d != GeometryController.this.selectedLayer.getXOK() && GeometryController.this.writeXOKValueToLayer(d, GeometryController.this.selectedLayer)) {
                            // empty if block
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextField2.setText("" + GeometryController.this.selectedLayer.getXOK());
                    }
                    try {
                        d = Double.parseDouble(jTextField3.getText());
                        if (d != GeometryController.this.selectedLayer.getXUK() && GeometryController.this.writeXUKValueToLayer(d, GeometryController.this.selectedLayer)) {
                            // empty if block
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextField3.setText("" + GeometryController.this.selectedLayer.getXUK());
                    }
                }
                if (GeometryController.this.selectedLayer instanceof SecondaryLayer) {
                    try {
                        int n = Integer.parseInt(jTextField4.getText());
                        ((SecondaryLayer)GeometryController.this.selectedLayer).setNumModellzellen(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextField4.setText("" + ((SecondaryLayer)GeometryController.this.selectedLayer).getNumModellzellen());
                    }
                }
            }
            object = (DefaultMutableTreeNode)((GeometryCard)GeometryController.this.view).getTreePanel().getTree().getLastSelectedPathComponent();
            try {
                Layer layer = (Layer)((DefaultMutableTreeNode)object).getUserObject();
                jTextField.setText(layer.getName());
                jTextField2.setText("" + layer.getXOK());
                jTextField3.setText("" + layer.getXUK());
                if (layer instanceof SecondaryLayer) {
                    jTextField4.setText("" + ((SecondaryLayer)layer).getNumModellzellen());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object == null) {
                GeometryController.this.setSelectedLayer(null);
                jTextField.setEnabled(false);
                jTextField2.setEnabled(false);
                jTextField3.setEnabled(false);
                jTextField4.setEnabled(false);
                jTextField5.setEnabled(false);
                return;
            }
            try {
                GeometryController.this.setSelectedLayer((Layer)((DefaultMutableTreeNode)object).getUserObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            jTextField.setEnabled(true);
            jTextField2.setEnabled(true);
            jTextField3.setEnabled(true);
            jTextField4.setEnabled(true);
            jTextField5.setEnabled(true);
            if (((DefaultMutableTreeNode)object).getLevel() == 0) {
                jLabel.setVisible(false);
                jTextField2.setVisible(false);
                jLabel2.setVisible(false);
                jTextField3.setVisible(false);
                jLabel3.setVisible(false);
                jTextField4.setVisible(false);
                jLabel4.setVisible(true);
                jTextField5.setVisible(true);
            }
            if (((DefaultMutableTreeNode)object).getLevel() == 1) {
                jTextField2.setEnabled(false);
                jLabel.setVisible(true);
                jTextField2.setVisible(true);
                jLabel2.setVisible(true);
                jTextField3.setVisible(true);
                jLabel3.setVisible(false);
                jTextField4.setVisible(false);
                jLabel4.setVisible(false);
                jTextField5.setVisible(false);
            }
            if (((DefaultMutableTreeNode)object).getLevel() == 2) {
                if (((DefaultMutableTreeNode)object).getPreviousNode().getLevel() < ((DefaultMutableTreeNode)object).getLevel()) {
                    jTextField2.setEnabled(false);
                }
                if (((DefaultMutableTreeNode)object).getNextNode() == null || ((DefaultMutableTreeNode)object).getNextNode().getLevel() < ((DefaultMutableTreeNode)object).getLevel()) {
                    jTextField3.setEnabled(false);
                }
                jLabel.setVisible(true);
                jTextField2.setVisible(true);
                jLabel2.setVisible(true);
                jTextField3.setVisible(true);
                jLabel3.setVisible(true);
                jTextField4.setVisible(true);
                jLabel4.setVisible(false);
                jTextField5.setVisible(false);
            }
        }
    }
}

