/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.listcard.CatalogCard;
import de.dsite.utils.FileUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CatalogController
extends ListController {
    private final TableModelPol tableModelPol;
    private final TableModelSur tableModelSur;
    static final File fileTenside = new File("files/surfact.clg");
    static final File fileBoeden = new File("files/soil.clg");
    private final DefaultListModel<CatalogValue> listModel = new DefaultListModel();
    private final DefaultComboBoxModel<CatalogObject> comboBoxModelPollutant = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<CatalogObject> comboBoxModelSurfactant = new DefaultComboBoxModel();
    private final ArrayList<Pollutant> pollutants = new ArrayList();
    private final ArrayList<Surfactant> surfactants = new ArrayList();

    public CatalogController(MainWindowController mainWindowController) {
        super(new CatalogCard(), mainWindowController);
        Object object;
        for (CatalogValue catalogValue : CatalogValue.values()) {
            if (mainWindowController.isFullVersion()) {
                this.listModel.addElement(catalogValue);
                continue;
            }
            if (catalogValue.equals((Object)CatalogValue.STOFFE)) continue;
            this.listModel.addElement(catalogValue);
        }
        ((CatalogCard)this.view).addListModel(this.listModel);
        this.tableModelPol = new TableModelPol();
        ((CatalogCard)this.view).addPolTableModel(this.tableModelPol);
        try {
            object = FileUtils.convertCatalogFileToPollutants(FileUtils.getCatalogFilePollutant());
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                CatalogObject catalogObject = (CatalogObject)iterator.next();
                this.pollutants.add((Pollutant)catalogObject);
                this.comboBoxModelPollutant.addElement((Pollutant)catalogObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((CatalogCard)this.view).addComboBoxModel(this.comboBoxModelPollutant);
        if (mainWindowController.isFullVersion()) {
            this.tableModelSur = new TableModelSur();
            ((CatalogCard)this.view).addSurTableModel(this.tableModelSur);
            try {
                object = FileUtils.convertCatalogFileToSurfactants(FileUtils.getCatalogFileSurfactant());
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    CatalogObject catalogObject = (CatalogObject)iterator.next();
                    this.surfactants.add((Surfactant)catalogObject);
                    this.comboBoxModelSurfactant.addElement((Surfactant)catalogObject);
                }
            }
            catch (Exception exception) {}
        } else {
            this.tableModelSur = null;
        }
        ((CatalogCard)this.view).addAddColumnButtonListener(new AddColumnButtonListener());
        ((CatalogCard)this.view).addDelColumnButtonListener(new DelColumnButtonListener());
        ((CatalogCard)this.view).addAddFromFileColumnButtonListener(new AddFromCatalogButtonListener());
        ((CatalogCard)this.view).addCatalogsListSelectionListener(new CatalogListSelectionListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        if (this.model.allPollutants() != null) {
            this.tableModelPol.setData(this.model.allPollutants());
        }
        if (this.tableModelSur != null && this.model.allSurfactants() != null) {
            this.tableModelSur.setData(this.model.allSurfactants());
        }
        if (((CatalogCard)this.view).getCatalogs().getSelectedIndex() < 0) {
            ((CatalogCard)this.view).getCatalogs().setSelectedIndex(0);
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        return true;
    }

    private final class AddFromCatalogButtonListener
    implements ActionListener {
        private AddFromCatalogButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CatalogValue catalogValue = ((CatalogCard)CatalogController.this.view).getCatalogs().getSelectedValue();
            switch (catalogValue) {
                case SCHADSTOFFE: {
                    Pollutant pollutant = (Pollutant)CatalogController.this.comboBoxModelPollutant.getSelectedItem();
                    Pollutant pollutant2 = new Pollutant(pollutant.getBezeichnung(), pollutant.getValues()[0], pollutant.getValues()[1], pollutant.getValues()[2]);
                    CatalogController.this.tableModelPol.addRow(pollutant2);
                    return;
                }
                case STOFFE: {
                    Surfactant surfactant = (Surfactant)CatalogController.this.comboBoxModelSurfactant.getSelectedItem();
                    Surfactant surfactant2 = new Surfactant(surfactant.getBezeichnung(), surfactant.getValues()[0]);
                    CatalogController.this.tableModelSur.addRow(surfactant2);
                    return;
                }
            }
        }
    }

    private final class DelColumnButtonListener
    implements ActionListener {
        private DelColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CatalogValue catalogValue = ((CatalogCard)CatalogController.this.view).getCatalogs().getSelectedValue();
            switch (catalogValue) {
                case SCHADSTOFFE: {
                    CatalogController.this.tableModelPol.deleteRow();
                    return;
                }
                case STOFFE: {
                    CatalogController.this.tableModelSur.deleteRow();
                    return;
                }
            }
        }
    }

    private final class AddColumnButtonListener
    implements ActionListener {
        private AddColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CatalogValue catalogValue = ((CatalogCard)CatalogController.this.view).getCatalogs().getSelectedValue();
            switch (catalogValue) {
                case SCHADSTOFFE: {
                    CatalogController.this.tableModelPol.addRow();
                    return;
                }
                case STOFFE: {
                    CatalogController.this.tableModelSur.addRow();
                    return;
                }
            }
        }
    }

    private final class CatalogListSelectionListener
    implements ListSelectionListener {
        private CatalogListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                CatalogValue catalogValue = (CatalogValue)((Object)jList.getSelectedValue());
                CardLayout cardLayout = (CardLayout)((CatalogCard)CatalogController.this.view).getTableCardPanel().getLayout();
                switch (catalogValue) {
                    case SCHADSTOFFE: {
                        cardLayout.show(((CatalogCard)CatalogController.this.view).getTableCardPanel(), CatalogValue.SCHADSTOFFE.name());
                        ((CatalogCard)CatalogController.this.view).addComboBoxModel(CatalogController.this.comboBoxModelPollutant);
                        return;
                    }
                    case STOFFE: {
                        cardLayout.show(((CatalogCard)CatalogController.this.view).getTableCardPanel(), CatalogValue.STOFFE.name());
                        ((CatalogCard)CatalogController.this.view).addComboBoxModel(CatalogController.this.comboBoxModelSurfactant);
                        return;
                    }
                }
            }
        }
    }

    private final class TableModelSur
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNamesSur = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_sur_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_sur_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_sur_tcol3)};
        private ArrayList<Surfactant> data = new ArrayList();

        TableModelSur() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNamesSur.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNamesSur[n];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.data.get(n).getId();
            }
            if (n2 == 1) {
                return this.data.get(n).getBezeichnung();
            }
            return this.data.get(n).getValues()[n2 - 2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 0) {
                if (n2 == 1) {
                    Surfactant surfactant = this.data.get(n);
                    if (CatalogController.this.model.renameSurfactant(surfactant, (String)object)) {
                        this.setData(CatalogController.this.model.allSurfactants());
                        this.fireTableDataChanged();
                        int n3 = CatalogController.this.model.allSurfactants().indexOf(surfactant);
                        ((CatalogCard)CatalogController.this.view).getSurTable().setRowSelectionInterval(n3, n3);
                    }
                } else {
                    try {
                        double d = Double.parseDouble((String)object);
                        double[] dArray = this.data.get(n).getValues();
                        dArray[n2 - 2] = d;
                        this.data.get(n).setValues(dArray);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            Surfactant surfactant = new Surfactant("Surf_0");
            this.addRow(surfactant);
        }

        public void addRow(Surfactant surfactant) {
            if (CatalogController.this.model.addSurfactant(surfactant)) {
                this.setData(CatalogController.this.model.allSurfactants());
                int n = CatalogController.this.model.allSurfactants().indexOf(surfactant);
                this.fireTableDataChanged();
                ((CatalogCard)CatalogController.this.view).getSurTable().setRowSelectionInterval(n, n);
                ((CatalogCard)CatalogController.this.view).getSurTable().scrollRectToVisible(((CatalogCard)CatalogController.this.view).getSurTable().getCellRect(n, 0, true));
            }
        }

        public void deleteRow() {
            try {
                for (int n : ((CatalogCard)CatalogController.this.view).getSurTable().getSelectedRows()) {
                    CatalogController.this.model.deleteSurfactant(this.data.get(n));
                }
                this.setData(CatalogController.this.model.allSurfactants());
                this.fireTableDataChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setData(ArrayList<Surfactant> arrayList) {
            this.data = arrayList;
            this.fireTableDataChanged();
        }
    }

    private final class TableModelPol
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNamesPol = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_pol_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_pol_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_pol_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_pol_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_pol_tcol5)};
        private ArrayList<Pollutant> data = new ArrayList();

        TableModelPol() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNamesPol.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNamesPol[n];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.data.get(n).getId();
            }
            if (n2 == 1) {
                return this.data.get(n).getBezeichnung();
            }
            return this.data.get(n).getValues()[n2 - 2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 0) {
                if (n2 == 1) {
                    Pollutant pollutant = this.data.get(n);
                    if (CatalogController.this.model.renamePollutant(pollutant, (String)object)) {
                        this.setData(CatalogController.this.model.allPollutants());
                        this.fireTableDataChanged();
                        int n3 = CatalogController.this.model.allPollutants().indexOf(pollutant);
                        ((CatalogCard)CatalogController.this.view).getPolTable().setRowSelectionInterval(n3, n3);
                    }
                } else {
                    try {
                        double d = Double.parseDouble((String)object);
                        double[] dArray = this.data.get(n).getValues();
                        dArray[n2 - 2] = d;
                        this.data.get(n).setValues(dArray);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            Pollutant pollutant = new Pollutant("Pol_0");
            this.addRow(pollutant);
        }

        public void addRow(Pollutant pollutant) {
            if (CatalogController.this.model.addPollutant(pollutant)) {
                this.setData(CatalogController.this.model.allPollutants());
                int n = CatalogController.this.model.allPollutants().indexOf(pollutant);
                this.fireTableDataChanged();
                ((CatalogCard)CatalogController.this.view).getPolTable().setRowSelectionInterval(n, n);
                ((CatalogCard)CatalogController.this.view).getPolTable().scrollRectToVisible(((CatalogCard)CatalogController.this.view).getSurTable().getCellRect(n, 0, true));
            }
        }

        public void deleteRow() {
            try {
                for (int n : ((CatalogCard)CatalogController.this.view).getPolTable().getSelectedRows()) {
                    CatalogController.this.model.deletePollutant(this.data.get(n));
                }
                this.setData(CatalogController.this.model.allPollutants());
                this.fireTableDataChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setData(ArrayList<Pollutant> arrayList) {
            this.data = arrayList;
            this.fireTableDataChanged();
        }
    }

    public static enum CatalogValue {
        SCHADSTOFFE(0),
        STOFFE(1);

        private final int index;

        private CatalogValue(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return MainWindowController.resourceManager.getLangString(CatalogValue.valueOf(CatalogValue.class, super.toString()));
        }
    }
}

