/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.listcard.BoundaryConditionTransportCard;
import de.dsite.project.BoundaryCondition;
import de.dsite.project.InitialBoundaryCondition;
import de.dsite.utils.FileUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;

public class BoundaryConditionTransportController
extends ListController {
    private final TableModelTop tableModelTop;
    private final TableModelBottom tableModelBottom;
    private final TableModelTopSur tableModelTopSur;
    private final TableModelBottomSur tableModelBottomSur;
    private File resultsFolder;

    public BoundaryConditionTransportController(MainWindowController mainWindowController) {
        super(new BoundaryConditionTransportCard(), mainWindowController);
        ((BoundaryConditionTransportCard)this.view).addCardListSelectionListener(new CardListSelectionListener());
        this.tableModelTop = new TableModelTop();
        this.tableModelBottom = new TableModelBottom();
        this.tableModelTopSur = new TableModelTopSur();
        this.tableModelBottomSur = new TableModelBottomSur();
        this.resultsFolder = FileUtils.getDataFolder();
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationConstantFirst", new RadioButtonConFixTopActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationVariableFirst", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusInterpolFirst", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusEvFirst", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusNvFirst", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationConstantSecond", new RadioButtonConFixBottomActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationVariableSecond", new RadioButtonConVarBottomActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("compact", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.SOLID);
                BoundaryConditionTransportController.this.tableModelBottom.setData();
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("liquid", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.AQUEOUS);
                BoundaryConditionTransportController.this.tableModelBottom.setData();
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("steady", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.EQUILIBRIUM);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("notSteady", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.NON_EQUILIBRIUM);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusInterpolSecond", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusEvSecond", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusNvSecond", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationConstantFirstTenside", new RadioButtonConFixTopSurActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationVariableFirstTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusInterpolFirstTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusEvFirstTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusNvFirstTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationConstantSecondTenside", new RadioButtonConFixBottomSurActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("concentrationVariableSecondTenside", new RadioButtonConVarBottomSurActionListener());
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("compactTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.SOLID);
                BoundaryConditionTransportController.this.tableModelBottomSur.setData();
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("liquidTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.AQUEOUS);
                BoundaryConditionTransportController.this.tableModelBottomSur.setData();
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("steadyTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.EQUILIBRIUM);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("notSteadyTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.EQUILIBRIUM);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusInterpolSecondTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusEvSecondTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addActionListenerForRadioButton("modusNvSecondTenside", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
            }
        });
        ((BoundaryConditionTransportCard)this.view).addAddColumnTopButtonListener(new AddColumnTopButtonListener());
        ((BoundaryConditionTransportCard)this.view).addDelColumnTopButtonListener(new DelColumnTopButtonListener());
        ((BoundaryConditionTransportCard)this.view).addSelectFileButtonActionListener(new ButtonSelectFileListener());
        ((BoundaryConditionTransportCard)this.view).addAddColumnBottomButtonListener(new AddColumnBottomButtonListener());
        ((BoundaryConditionTransportCard)this.view).addDelColumnBottomButtonListener(new DelColumnBottomButtonListener());
        ((BoundaryConditionTransportCard)this.view).addSelectFileBottomButtonActionListener(new ButtonSelectFileListener());
        ((BoundaryConditionTransportCard)this.view).addAddColumnTopButtonTensideListener(new AddColumnTopButtonSurListener());
        ((BoundaryConditionTransportCard)this.view).addDelColumnTopButtonTensideListener(new DelColumnTopButtonSurListener());
        ((BoundaryConditionTransportCard)this.view).addSelectFileButtonTensideActionListener(new ButtonSelectFileListener());
        ((BoundaryConditionTransportCard)this.view).addAddColumnBottomButtonTensideListener(new AddColumnBottomButtonSurListener());
        ((BoundaryConditionTransportCard)this.view).addDelColumnBottomButtonTensideListener(new DelColumnBottomButtonSurListener());
        ((BoundaryConditionTransportCard)this.view).addSelectFileBottomButtonTensideActionListener(new ButtonSelectFileListener());
        ((BoundaryConditionTransportCard)this.view).getRadioConFixTop().setSelected(true);
        ((BoundaryConditionTransportCard)this.view).getRadioConFixTopTenside().setSelected(true);
        ((BoundaryConditionTransportCard)this.view).getRadioConFixBottom().setSelected(true);
        ((BoundaryConditionTransportCard)this.view).getRadioConFixBottomTenside().setSelected(true);
    }

    @Override
    public void loadModelDataAndShowView() {
        BoundaryCondition.CalculationMode calculationMode = this.model.getPollutantUpperBoundary().getMode();
        switch (calculationMode) {
            case INTERPOLATION: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpol().setSelected(true);
                break;
            }
            case NEXT_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModNV().setSelected(true);
                break;
            }
            case EARLIER_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModEV().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpol().setSelected(true);
            }
        }
        if (this.model.getPollutantUpperBoundary().getIntervalCount() > 1) {
            ((BoundaryConditionTransportCard)this.view).getRadioConVarTop().setSelected(true);
        }
        calculationMode = this.model.getPollutantInitialBoundary().getMode();
        switch (calculationMode) {
            case INTERPOLATION: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolAB().setSelected(true);
                break;
            }
            case NEXT_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModNVAB().setSelected(true);
                break;
            }
            case EARLIER_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModEVAB().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolAB().setSelected(true);
            }
        }
        if (this.model.getPollutantInitialBoundary().getIntervalCount() > 1) {
            ((BoundaryConditionTransportCard)this.view).getRadioConVarBottom().setSelected(true);
        }
        InitialBoundaryCondition.Equilibrium equilibrium = this.model.getPollutantInitialBoundary().getSystemState();
        switch (equilibrium) {
            case EQUILIBRIUM: {
                ((BoundaryConditionTransportCard)this.view).getRadioSteady().setSelected(true);
                break;
            }
            case NON_EQUILIBRIUM: {
                ((BoundaryConditionTransportCard)this.view).getRadioNotSteady().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioSteady().setSelected(true);
            }
        }
        InitialBoundaryCondition.Phase phase = this.model.getPollutantInitialBoundary().getSystemPhase();
        switch (phase) {
            case SOLID: {
                ((BoundaryConditionTransportCard)this.view).getRadioCompact().setSelected(true);
                break;
            }
            case AQUEOUS: {
                ((BoundaryConditionTransportCard)this.view).getRadioLiquid().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioCompact().setSelected(true);
            }
        }
        calculationMode = this.model.getSurfactantUpperBoundary().getMode();
        switch (calculationMode) {
            case INTERPOLATION: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolTenside().setSelected(true);
                break;
            }
            case NEXT_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModNVTenside().setSelected(true);
                break;
            }
            case EARLIER_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModEVTenside().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolTenside().setSelected(true);
            }
        }
        if (this.model.getSurfactantUpperBoundary().getIntervalCount() > 1) {
            ((BoundaryConditionTransportCard)this.view).getRadioConVarTopTenside().setSelected(true);
        }
        calculationMode = this.model.getSurfactantInitialBoundary().getMode();
        switch (calculationMode) {
            case INTERPOLATION: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolABTenside().setSelected(true);
                break;
            }
            case NEXT_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModNVABTenside().setSelected(true);
                break;
            }
            case EARLIER_VALUE: {
                ((BoundaryConditionTransportCard)this.view).getRadioModEVABTenside().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioModInterpolABTenside().setSelected(true);
            }
        }
        if (this.model.getSurfactantInitialBoundary().getIntervalCount() > 1) {
            ((BoundaryConditionTransportCard)this.view).getRadioConVarBottomTenside().setSelected(true);
        }
        equilibrium = this.model.getSurfactantInitialBoundary().getSystemState();
        switch (equilibrium) {
            case EQUILIBRIUM: {
                ((BoundaryConditionTransportCard)this.view).getRadioSteadyTenside().setSelected(true);
                break;
            }
            case NON_EQUILIBRIUM: {
                ((BoundaryConditionTransportCard)this.view).getRadioNotSteadyTenside().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioSteadyTenside().setSelected(true);
            }
        }
        phase = this.model.getSurfactantInitialBoundary().getSystemPhase();
        switch (phase) {
            case SOLID: {
                ((BoundaryConditionTransportCard)this.view).getRadioCompactTenside().setSelected(true);
                break;
            }
            case AQUEOUS: {
                ((BoundaryConditionTransportCard)this.view).getRadioLiquidTenside().setSelected(true);
                break;
            }
            default: {
                ((BoundaryConditionTransportCard)this.view).getRadioCompactTenside().setSelected(true);
            }
        }
        this.tableModelTop.setData();
        this.tableModelBottom.setData();
        this.tableModelTopSur.setData();
        this.tableModelBottomSur.setData();
        ((BoundaryConditionTransportCard)this.view).addTableModelTop(this.tableModelTop);
        ((BoundaryConditionTransportCard)this.view).addTableModelBottom(this.tableModelBottom);
        ((BoundaryConditionTransportCard)this.view).addTableModelTopTenside(this.tableModelTopSur);
        ((BoundaryConditionTransportCard)this.view).addTableModelBottomTenside(this.tableModelBottomSur);
        if (((BoundaryConditionTransportCard)this.view).getCardList().getSelectedIndex() < 0) {
            ((BoundaryConditionTransportCard)this.view).getCardList().setSelectedIndex(0);
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((BoundaryConditionTransportCard)this.view).getTableTop().isEditing()) {
            ((BoundaryConditionTransportCard)this.view).getTableTop().getCellEditor().stopCellEditing();
        }
        if (((BoundaryConditionTransportCard)this.view).getTableBottom().isEditing()) {
            ((BoundaryConditionTransportCard)this.view).getTableBottom().getCellEditor().stopCellEditing();
        }
        if (((BoundaryConditionTransportCard)this.view).getTableTopTenside().isEditing()) {
            ((BoundaryConditionTransportCard)this.view).getTableTopTenside().getCellEditor().stopCellEditing();
        }
        if (((BoundaryConditionTransportCard)this.view).getTableBottomTenside().isEditing()) {
            ((BoundaryConditionTransportCard)this.view).getTableBottomTenside().getCellEditor().stopCellEditing();
        }
        this.model.getPollutantInitialBoundary().sortDateValues();
        this.model.getPollutantUpperBoundary().sortDateValues();
        this.model.getSurfactantInitialBoundary().sortDateValues();
        this.model.getSurfactantUpperBoundary().sortDateValues();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<double[]> fileToArrayList(File file, int n) {
        String[] stringArray = new ArrayList();
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray2;
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    string = string.trim();
                    stringArray2 = string.split("\\s+", 0);
                    double[] dArray = new double[stringArray2.length];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray2[i].replace("d", "e"));
                    }
                    stringArray.add(dArray);
                }
                if (!Pattern.matches("^__DATA.*", string)) continue;
                bl = true;
            }
            stringArray2 = stringArray;
            BoundaryConditionTransportController.closeFileReader(bufferedReader);
            return stringArray2;
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray3 = stringArray;
            return stringArray3;
        }
        catch (IOException iOException) {
            ArrayList<double[]> arrayList = null;
            return arrayList;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            BoundaryConditionTransportController.closeFileReader(bufferedReader);
        }
    }

    private static void closeFileReader(BufferedReader bufferedReader) {
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class TableModelBottomSur
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<String> columnNames = new ArrayList();

        public void setData() {
            this.columnNames.clear();
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol1));
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol3));
            if (BoundaryConditionTransportController.this.model.allSurfactants() != null) {
                for (CatalogObject catalogObject : BoundaryConditionTransportController.this.model.allSurfactants()) {
                    String string = BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().getSystemPhase() == InitialBoundaryCondition.Phase.SOLID ? " (mg/kg)" : " (mg/l)";
                    this.columnNames.add(catalogObject.getBezeichnung() + string);
                }
            }
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames.get(n);
        }

        @Override
        public int getRowCount() {
            return BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().getIntervalCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().getDateValueForInterval(n);
            }
            return BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().getValueForIntervalAndCatalogObject(n, BoundaryConditionTransportController.this.model.allSurfactants().get(n2 - 2));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setDateValueForInterval(d, n);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setValueForIntervalAndCatalogObject(d, n, BoundaryConditionTransportController.this.model.allSurfactants().get(n2 - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().appendInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRow() {
            BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().removeLastInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRowAtIndex(int n) {
            BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().removeInterval(n);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }

    private final class TableModelTopSur
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<String> columnNames = new ArrayList();

        public void setData() {
            ArrayList<Surfactant> arrayList = BoundaryConditionTransportController.this.model.allSurfactants();
            this.columnNames.clear();
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol1));
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol2));
            if (arrayList != null) {
                for (Surfactant surfactant : arrayList) {
                    this.columnNames.add(surfactant.getBezeichnung() + " (mg/l)");
                }
            }
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames.get(n);
        }

        @Override
        public int getRowCount() {
            return BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().getIntervalCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().getDateValueForInterval(n);
            }
            return BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().getValueForIntervalAndCatalogObject(n, BoundaryConditionTransportController.this.model.allSurfactants().get(n2 - 2));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setDateValueForInterval(d, n);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setValueForIntervalAndCatalogObject(d, n, BoundaryConditionTransportController.this.model.allSurfactants().get(n2 - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().appendInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRow() {
            BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().removeLastInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRowAtIndex(int n) {
            BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().removeInterval(n);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }

    private final class TableModelBottom
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<String> columnNames = new ArrayList();

        public void setData() {
            this.columnNames.clear();
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol1));
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol3));
            if (BoundaryConditionTransportController.this.model.allPollutants() != null) {
                for (CatalogObject catalogObject : BoundaryConditionTransportController.this.model.allPollutants()) {
                    String string = BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().getSystemPhase() == InitialBoundaryCondition.Phase.SOLID ? " (mg/kg)" : " (mg/l)";
                    this.columnNames.add(catalogObject.getBezeichnung() + string);
                }
            }
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames.get(n);
        }

        @Override
        public int getRowCount() {
            return BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().getIntervalCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().getDateValueForInterval(n);
            }
            return BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().getValueForIntervalAndCatalogObject(n, BoundaryConditionTransportController.this.model.allPollutants().get(n2 - 2));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setDateValueForInterval(d, n);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setValueForIntervalAndCatalogObject(d, n, BoundaryConditionTransportController.this.model.allPollutants().get(n2 - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().appendInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRow() {
            BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().removeLastInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRowAtIndex(int n) {
            BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().removeInterval(n);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }

    private final class TableModelTop
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<String> columnNames = new ArrayList();

        public void setData() {
            ArrayList<Pollutant> arrayList = BoundaryConditionTransportController.this.model.allPollutants();
            this.columnNames.clear();
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol1));
            this.columnNames.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_btransport_tcol2));
            if (arrayList != null) {
                for (Pollutant pollutant : arrayList) {
                    this.columnNames.add(pollutant.getBezeichnung() + " (mg/l)");
                }
            }
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames.get(n);
        }

        @Override
        public int getRowCount() {
            return BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().getIntervalCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().getDateValueForInterval(n);
            }
            return BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().getValueForIntervalAndCatalogObject(n, BoundaryConditionTransportController.this.model.allPollutants().get(n2 - 2));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setDateValueForInterval(d, n);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    double d = Double.parseDouble((String)object);
                    BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setValueForIntervalAndCatalogObject(d, n, BoundaryConditionTransportController.this.model.allPollutants().get(n2 - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addRow() {
            BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().appendInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRow() {
            BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().removeLastInterval();
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void deleteRowAtIndex(int n) {
            BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().removeInterval(n);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }

    private final class DelColumnBottomButtonSurListener
    implements ActionListener {
        private DelColumnBottomButtonSurListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottomTenside().isEditing()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottomTenside().getCellEditor().stopCellEditing();
            }
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottomTenside().getSelectedRow() != -1) {
                BoundaryConditionTransportController.this.tableModelBottomSur.deleteRowAtIndex(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottomTenside().getSelectedRow());
            }
        }
    }

    private final class DelColumnTopButtonSurListener
    implements ActionListener {
        private DelColumnTopButtonSurListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTopTenside().isEditing()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTopTenside().getCellEditor().stopCellEditing();
            }
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTopTenside().getSelectedRow() != -1) {
                BoundaryConditionTransportController.this.tableModelTopSur.deleteRowAtIndex(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTopTenside().getSelectedRow());
            }
        }
    }

    private final class AddColumnBottomButtonSurListener
    implements ActionListener {
        private AddColumnBottomButtonSurListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoundaryConditionTransportController.this.tableModelBottomSur.addRow();
            if (BoundaryConditionTransportController.this.tableModelBottomSur.getRowCount() > 1 && !((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottomTenside().isSelected()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottomTenside().doClick();
            }
        }
    }

    private final class AddColumnTopButtonSurListener
    implements ActionListener {
        private AddColumnTopButtonSurListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoundaryConditionTransportController.this.tableModelTopSur.addRow();
            if (BoundaryConditionTransportController.this.tableModelTopSur.getRowCount() > 1 && !((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTopTenside().isSelected()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTopTenside().doClick();
            }
        }
    }

    private final class RadioButtonConVarBottomSurActionListener
    implements ActionListener {
        private RadioButtonConVarBottomSurActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ButtonSelectFileListener
    implements ActionListener {
        private ButtonSelectFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BoundaryConditionTransportController.this.resultsFolder != null ? new JFileChooser(BoundaryConditionTransportController.this.resultsFolder) : new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = FileUtils.getFileExtension(file);
                    return file.isDirectory() || string.equals("txt") || string.equals("csv");
                }

                @Override
                public String getDescription() {
                    return "*.txt, *.csv";
                }
            });
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                ArrayList arrayList;
                File file = jFileChooser.getSelectedFile();
                BoundaryConditionTransportController.this.resultsFolder = file;
                if (file.canWrite() && (arrayList = BoundaryConditionTransportController.this.fileToArrayList(file, BoundaryConditionTransportController.this.model.allPollutants().size())) != null) {
                    BoundaryConditionTransportCard.TransportValue transportValue = ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardList().getSelectedValue();
                    switch (transportValue) {
                        case OBERE_RANDBEDINGUNGEN_SCHADSTOFFE: {
                            BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().setValuesFromArray(arrayList);
                            BoundaryConditionTransportController.this.tableModelTop.fireTableDataChanged();
                            break;
                        }
                        case ANFANGSBEDINGUNGEN_SCHADSTOFFE: {
                            BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().setValuesFromArray(arrayList);
                            BoundaryConditionTransportController.this.tableModelBottom.fireTableDataChanged();
                            break;
                        }
                        case OBERE_RANDBEDINGUNGEN_TENSIDE: {
                            BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().setValuesFromArray(arrayList);
                            BoundaryConditionTransportController.this.tableModelTopSur.fireTableDataChanged();
                            break;
                        }
                        case ANFANGSBEDINGUNGEN_TENSIDE: {
                            BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().setValuesFromArray(arrayList);
                            BoundaryConditionTransportController.this.tableModelBottomSur.fireTableDataChanged();
                            break;
                        }
                    }
                }
            }
        }
    }

    private final class DelColumnBottomButtonListener
    implements ActionListener {
        private DelColumnBottomButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottom().isEditing()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottom().getCellEditor().stopCellEditing();
            }
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottom().getSelectedRow() != -1) {
                BoundaryConditionTransportController.this.tableModelBottom.deleteRowAtIndex(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableBottom().getSelectedRow());
            }
        }
    }

    private final class DelColumnTopButtonListener
    implements ActionListener {
        private DelColumnTopButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTop().isEditing()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTop().getCellEditor().stopCellEditing();
            }
            if (((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTop().getSelectedRow() != -1) {
                BoundaryConditionTransportController.this.tableModelTop.deleteRowAtIndex(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getTableTop().getSelectedRow());
            }
        }
    }

    private final class AddColumnBottomButtonListener
    implements ActionListener {
        private AddColumnBottomButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoundaryConditionTransportController.this.tableModelBottom.addRow();
            if (BoundaryConditionTransportController.this.tableModelBottom.getRowCount() > 1 && !((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottom().isSelected()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottom().doClick();
            }
        }
    }

    private final class AddColumnTopButtonListener
    implements ActionListener {
        private AddColumnTopButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BoundaryConditionTransportController.this.tableModelTop.addRow();
            if (BoundaryConditionTransportController.this.tableModelTop.getRowCount() > 1 && !((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTop().isSelected()) {
                ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTop().doClick();
            }
        }
    }

    private final class RadioButtonConVarBottomActionListener
    implements ActionListener {
        private RadioButtonConVarBottomActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private final class RadioButtonConFixBottomSurActionListener
    implements ActionListener {
        private RadioButtonConFixBottomSurActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BoundaryConditionTransportController.this.tableModelBottomSur.getRowCount() > 1) {
                int n = JOptionPane.showOptionDialog(BoundaryConditionTransportController.this.view, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_bc_transport_var_to_const_line1) + "\n " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
                if (n == 0) {
                    while (BoundaryConditionTransportController.this.tableModelBottomSur.getRowCount() > 1) {
                        BoundaryConditionTransportController.this.tableModelBottomSur.deleteRow();
                    }
                } else {
                    ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottomTenside().setSelected(true);
                }
            }
        }
    }

    private final class RadioButtonConFixTopSurActionListener
    implements ActionListener {
        private RadioButtonConFixTopSurActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BoundaryConditionTransportController.this.tableModelTopSur.getRowCount() > 1) {
                int n = JOptionPane.showOptionDialog(BoundaryConditionTransportController.this.view, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_bc_transport_var_to_const_line1) + "\n " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
                if (n == 0) {
                    while (BoundaryConditionTransportController.this.tableModelTopSur.getRowCount() > 1) {
                        BoundaryConditionTransportController.this.tableModelTopSur.deleteRow();
                    }
                } else {
                    ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTopTenside().setSelected(true);
                }
            }
        }
    }

    private final class RadioButtonConFixBottomActionListener
    implements ActionListener {
        private RadioButtonConFixBottomActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BoundaryConditionTransportController.this.tableModelBottom.getRowCount() > 1) {
                int n = JOptionPane.showOptionDialog(BoundaryConditionTransportController.this.view, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_bc_transport_var_to_const_line1) + "\n " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
                if (n == 0) {
                    while (BoundaryConditionTransportController.this.tableModelBottom.getRowCount() > 1) {
                        BoundaryConditionTransportController.this.tableModelBottom.deleteRow();
                    }
                } else {
                    ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarBottom().setSelected(true);
                }
            }
        }
    }

    private final class RadioButtonConFixTopActionListener
    implements ActionListener {
        private RadioButtonConFixTopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BoundaryConditionTransportController.this.tableModelTop.getRowCount() > 1) {
                int n = JOptionPane.showOptionDialog(BoundaryConditionTransportController.this.view, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_bc_transport_var_to_const_line1) + "\n " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
                if (n == 0) {
                    while (BoundaryConditionTransportController.this.tableModelTop.getRowCount() > 1) {
                        BoundaryConditionTransportController.this.tableModelTop.deleteRow();
                    }
                } else {
                    ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getRadioConVarTop().setSelected(true);
                }
            }
        }
    }

    private final class CardListSelectionListener
    implements ListSelectionListener {
        private CardListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BoundaryConditionTransportController.this.model.getPollutantInitialBoundary().sortDateValues();
            BoundaryConditionTransportController.this.model.getPollutantUpperBoundary().sortDateValues();
            BoundaryConditionTransportController.this.model.getSurfactantInitialBoundary().sortDateValues();
            BoundaryConditionTransportController.this.model.getSurfactantUpperBoundary().sortDateValues();
            if (listSelectionEvent.getValueIsAdjusting()) {
                CardLayout cardLayout = (CardLayout)((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardPanel().getLayout();
                BoundaryConditionTransportCard.TransportValue transportValue = ((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardList().getSelectedValue();
                if (transportValue == BoundaryConditionTransportCard.TransportValue.OBERE_RANDBEDINGUNGEN_SCHADSTOFFE) {
                    cardLayout.show(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardPanel(), BoundaryConditionTransportCard.TransportValue.OBERE_RANDBEDINGUNGEN_SCHADSTOFFE.toString());
                } else if (transportValue == BoundaryConditionTransportCard.TransportValue.ANFANGSBEDINGUNGEN_SCHADSTOFFE) {
                    cardLayout.show(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardPanel(), BoundaryConditionTransportCard.TransportValue.ANFANGSBEDINGUNGEN_SCHADSTOFFE.toString());
                } else if (transportValue == BoundaryConditionTransportCard.TransportValue.OBERE_RANDBEDINGUNGEN_TENSIDE) {
                    cardLayout.show(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardPanel(), BoundaryConditionTransportCard.TransportValue.OBERE_RANDBEDINGUNGEN_TENSIDE.toString());
                } else if (transportValue == BoundaryConditionTransportCard.TransportValue.ANFANGSBEDINGUNGEN_TENSIDE) {
                    cardLayout.show(((BoundaryConditionTransportCard)BoundaryConditionTransportController.this.view).getCardPanel(), BoundaryConditionTransportCard.TransportValue.ANFANGSBEDINGUNGEN_TENSIDE.toString());
                } else {
                    System.err.println("No matches for listEntry");
                }
            }
        }
    }
}

