/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.gui.listcard.BioReductionCard;
import de.dsite.project.BioDegradationValue;
import de.dsite.utils.ResourceBundleUtils;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class BioReductionController
extends ListController {
    private final TableModel tableModel = new TableModel();
    private final ListModel<CatalogObject> listModel = new DefaultListModel<CatalogObject>();

    public BioReductionController(MainWindowController mainWindowController) {
        super(new BioReductionCard(), mainWindowController);
        ((BioReductionCard)this.view).addTableModel(this.tableModel);
        ((BioReductionCard)this.view).addListModel(this.listModel);
        ((BioReductionCard)this.view).addListSelectionListener(new BioReductionListSelectionListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        ((DefaultListModel)this.listModel).clear();
        for (CatalogObject catalogObject : this.model.allPollutants()) {
            ((DefaultListModel)this.listModel).addElement(catalogObject);
        }
        if (this.model.allPollutants().size() > 0 && this.model.getLeaves().size() > 0) {
            this.tableModel.setPollutant(this.model.allPollutants().get(0));
        }
        if (this.model.allPollutants() != null && this.model.allPollutants().size() > 0 && ((BioReductionCard)this.view).getPolList().getSelectedIndex() == -1) {
            ((BioReductionCard)this.view).getPolList().setSelectedIndex(0);
            ((BioReductionCard)this.view).getPolList().requestFocusInWindow();
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((BioReductionCard)this.view).getTable().isEditing()) {
            ((BioReductionCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol6), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol7), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_bio_tcol8)};
        private Pollutant pollutant;

        public void setPollutant(Pollutant pollutant) {
            this.pollutant = pollutant;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return BioReductionController.this.model.getLeaves() == null || this.pollutant == null ? 0 : BioReductionController.this.model.getLeaves().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return BioReductionController.this.model.getLeaves().get(n).getName();
            }
            if (n2 == 2) {
                return BioReductionController.this.model.getLeaves().get(n).getXOK();
            }
            if (n2 == 3) {
                return BioReductionController.this.model.getLeaves().get(n).getXUK();
            }
            if (n2 >= 4 && n2 <= 7) {
                BioDegradationValue bioDegradationValue = BioReductionController.this.model.getBioDegredationValueForPollutantAndLayer(this.pollutant, BioReductionController.this.model.getLeaves().get(n));
                if (n2 == 4) {
                    return bioDegradationValue.getMode().getIndex();
                }
                if (n2 == 5) {
                    return bioDegradationValue.getHalfLifeTime();
                }
                if (n2 == 6) {
                    return bioDegradationValue.getOrder();
                }
                return bioDegradationValue.getReferenceConcentration();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 3;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            BioDegradationValue bioDegradationValue = BioReductionController.this.model.getBioDegredationValueForPollutantAndLayer(this.pollutant, BioReductionController.this.model.getLeaves().get(n));
            if (n2 == 4) {
                try {
                    int n3 = (Integer)object;
                    if (n3 == 0 || n3 == 1 || n3 == 2) {
                        if (n3 == 0) {
                            bioDegradationValue.setMode(BioDegradationValue.DegradationMode.NO_DEGRADATION);
                        } else if (n3 == 1) {
                            bioDegradationValue.setMode(BioDegradationValue.DegradationMode.DEGRADATION_OF_NTH_ORDER);
                        } else {
                            bioDegradationValue.setMode(BioDegradationValue.DegradationMode.LH_KINETICS);
                        }
                        this.fireTableDataChanged();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n2 == 5) {
                try {
                    double d = (Double)object;
                    bioDegradationValue.setHalfLifeTime(d);
                    this.fireTableDataChanged();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (n2 == 6) {
                try {
                    int n4 = (Integer)object;
                    bioDegradationValue.setOrder(n4);
                    this.fireTableDataChanged();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (n2 == 7) {
                try {
                    double d = (Double)object;
                    bioDegradationValue.setReferenceConcentration(d);
                    this.fireTableDataChanged();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return String.class;
            }
            if (n == 0 || n == 4 || n == 6) {
                return Integer.class;
            }
            return Double.class;
        }
    }

    private final class BioReductionListSelectionListener
    implements ListSelectionListener {
        private BioReductionListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && BioReductionController.this.model.allPollutants() != null && BioReductionController.this.model.getLeaves().size() > 0) {
                if (((BioReductionCard)BioReductionController.this.view).getTable().isEditing()) {
                    ((BioReductionCard)BioReductionController.this.view).getTable().getCellEditor().stopCellEditing();
                }
                int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
                BioReductionController.this.tableModel.setPollutant((Pollutant)BioReductionController.this.listModel.getElementAt(n));
            }
        }
    }
}

