DM LOG 'CLEAR';
DM OUTPUT 'CLEAR';

*----------------------------------------------------------------*
| Xprob_GFStrata_skript_v20070525               25/05.2007       |
*----------------------------------------------------------------*
| This script is running under SAS Version 8 or higher           |
| and needs the modules: BASE, STAT, IML                         |
|                                                                |
| This Script was used in the Xprob-project                      |
| for internal use only.                                         |
| This software has the status of an beta software               |
| development version and is provided AS IS                      |
| without warranty of any kind,                                  |
| either expressed or implied.                                   |
|                                                                |
*----------------------------------------------------------------*
| All control sequences are at the beginning of the skript.      |
| Please look for further details, documentation,                |
| and interpretation of output into the final report             |
| of the Xprob-project.                                          |
|                                                                |
*----------------------------------------------------------------*
|                                                                |
|  DISCLAIMER OF WARRANTY                                        |
|                                                                |
|  THE PROGRAMS AND DATA SETS ON THIS DISKETTE                   |
|  ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.            |
|  WE MAKE NO WARRANTIES, EXPRESS OR IMPLIED,                    |
|  THAT THE PROGRAMS AND DATA ARE FREE OF ERROR,                 |
|  OR ARE CONSISTENT WITH ANY PARTICULAR STANDARD                |
|  OF MERCHANTABILITY, OR THAT  THEY WILL MEET YOUR REQUIREMENTS |
|  FOR ANY PARTICULAR APPLICATION.                               |
|                                                                |
|  THEY SHOULD NOT BE RELIED ON FOR SOLVING A PROBLEM            |
|  WHOSE IN-CORRECT SOLUTION  COULD RESULT IN INJURY             |
|  TO A PERSON OR LOSS OF PROPERTY.                              |
|  IF YOU DO USE THE PROGRAMS OR PROCEDURES                      |
|  IN SUCH A MANNER, IT IS AT YOUR OWN RISK.                     |
|                                                                |
|  THE AUTHORS AND PUBLISHER DISCLAIM ALL LIABILITY              |
|  FOR DIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES              |
|  RESULTING FROM YOUR USE OF THE PROGRAMS                       |
|  OR PROCEDURES ON THIS SOFTWARE AND DATA COLLECTION.           |
|                                                                |
*----------------------------------------------------------------*
| (c) Xprob-project 2007                                         |
|     Jens Herrmann, Olaf Mosbach-Schulz, Jrgen Timm            |
|     University of Bremen, FB3: Institute of Statistics         |
|     Risk Research, Environment, Health                         |
|     P.O.Box 330 440, DE-28334 Bremen, Germany                  |
|                                                                |
|     The project group Xprob                                    |
|     (AgE/ Univ. Hamburg, IfS-RUG/Uni Bremen,                   |
|     FB Gesundheitswissenschaften Uni Bielefeld,                |
|     lgd/ NRW Bielefeld),                                      |
|     the sponsoring institution                                 |
|     (Umweltbundesamt / Berlin FG 24)                           |
|     The mission of the project,                                |
|     a list of all project partners and contact addresses       |
|     are documented on the website                              |
|     www.riskom.uni-bremen.de/xprob/                            |
*----------------------------------------------------------------*;

*----------------------------------------------------------------*
| Please specify the folder with input data set in SAS format    |
*----------------------------------------------------------------*;
LIBNAME INPUT    'x:\folder\';

*----------------------------------------------------------------*
| Please specify the data file in SAS format (only documentation)|
*----------------------------------------------------------------*;
%LET QUELLDATEI   = x:\folder\EFACTOR.sas7bdat;

*----------------------------------------------------------------*
| Please specify the folder with additional formats              |
*----------------------------------------------------------------*;
LIBNAME LIBRARY  'x:\folder\';

*----------------------------------------------------------------*
| Please specify the folder for the output                       |
*----------------------------------------------------------------*;
LIBNAME OUTPUT   'x:\folder\';

*----------------------------------------------------------------*
| Please specify the name of output file (all observations)      |
*----------------------------------------------------------------*;
%LET AUSGABE      = x:\folder\EFACTOR.txt;            

*----------------------------------------------------------------*
| Please specify the name of output file (males)                 |
*----------------------------------------------------------------*;
%LET AUSGABEMANN  = x:\folder\EFACTOR_male.txt; 

*----------------------------------------------------------------*
| Please specify the name of output file (females)               |
*----------------------------------------------------------------*;
%LET AUSGABEFRAU  = x:\folder\EFACTOR_female.txt; 

*----------------------------------------------------------------*
| Please specify the folder for data sets in RefXP               |
*----------------------------------------------------------------*;
%LET ZIELVERZ     = C:\REFVAL\;

*----------------------------------------------------------------*
| Please specify the name of the output in RefXP (all obs.)      |
*----------------------------------------------------------------*;
%LET ZIELDAT      = DS\HL\TOP\EFACTOR.dbf;  
 
*----------------------------------------------------------------*
| Please specify the name of the output in RefXP (males)         |
*----------------------------------------------------------------*;
%LET ZIELDATMANN  = DS\HL\TOP\EFACTOR.dbf; 

*----------------------------------------------------------------*
| Please specify the name of the output in RefXP (females)       |
*----------------------------------------------------------------*;
%LET ZIELDATFRAU  = DS\HL\TOP\EFACTOR.dbf; 

*----------------------------------------------------------------*
| Please specify the options for the printed output              |
*----------------------------------------------------------------*;
OPTIONS LINESIZE=90 PAGESIZE=55 NOCENTER;

*----------------------------------------------------------------*
| Please specify the input data and relevant variables           |
*----------------------------------------------------------------*;
DATA ROHDATEN (KEEP=SEX AGE EFACTOR EWEIGHT);
     SET INPUT.dataset;
	 RENAME varname1       =SEX 
            varname2       =AGE
			varname3       =EFACTOR
			varname4       =EWEIGHT
			  ;

*----------------------------------------------------------------*
| Please specify the variablename of exposure factor to analyse  |
*----------------------------------------------------------------*;
%LET ANALYSE      = EFACTOR;                                                   

*----------------------------------------------------------------*
| Please describe the exposure factor (with unit)                |
*----------------------------------------------------------------*;
%LET BESCHREIBUNG = XXX CONSUMPTION [g/d];                                                   

*----------------------------------------------------------------*
| Please specify the name of the exposure factor                 |
*----------------------------------------------------------------*;
%LET PARAMGANZ    = XXX;                                                   

*----------------------------------------------------------------*
| Please abbriviate the name of the exposure factor (max.6 char.)|
*----------------------------------------------------------------*;
%LET PARAM        = EF;                                                   

*----------------------------------------------------------------*
| Please specify the group (topic) of the exposure factor        |
*----------------------------------------------------------------*;
%LET TOPICGANZ    = XXX;                                                   

*----------------------------------------------------------------*
| Please abbriviate the group(topic) of the exposure factor      |  
*----------------------------------------------------------------*;
%LET TOPIC        = EF;                                                   

*----------------------------------------------------------------*
| Please specify the headline of the exposure factor (see RefXP) |
*----------------------------------------------------------------*;
%LET HEADLINEGANZ = FOOD CONSUMPTION;                                                   

*----------------------------------------------------------------*
| Please abbriviate the headline of the parameter (see RefXP)    |  
*----------------------------------------------------------------*;
%LET HEADLINE     = NU;                                                   

*----------------------------------------------------------------*
| Please specify the unit of the exposure factor (see RefXP)     |
*----------------------------------------------------------------*;
%LET UNIT         = %STR(g/d);                                                   

*----------------------------------------------------------------*
| Please specify the sample question / item of the factor        |
*----------------------------------------------------------------*;
%LET QUESTION     = %STR(mean of 7 consecutive daily food records);                                                   

*----------------------------------------------------------------*
| Please specify the aggregation interval                        |
*----------------------------------------------------------------*;
%LET REF_INTERVAL = %STR(seven consecutive days);                                                   

*----------------------------------------------------------------*
| Please specify the aggregation / computation method            |
*----------------------------------------------------------------*;
%LET ALGORITHM    = %STR(mean);                                                   

*----------------------------------------------------------------*
| Please specify the sample period of the factor (years)         |
*----------------------------------------------------------------*;
%LET PERIODE      = %STR(20## - 20##);                                                   

*----------------------------------------------------------------*
| Please specify the data source                                 |
*----------------------------------------------------------------*;
%LET QUELLE       = %STR(Daten);                                                   

*----------------------------------------------------------------*
| Please specify the reference of the data source                |
*----------------------------------------------------------------*;
%LET REFERENCE    = %STR(Name [####]);                                                   

*----------------------------------------------------------------*
| Please specify a reference of results (original analysis)      |
*----------------------------------------------------------------*;
%LET PUBLISH    = %STR(Name et al. [####]);                                                   

*----------------------------------------------------------------*
| Please specify other references, if existing                   |
*----------------------------------------------------------------*;
%LET REPUBLISHED = %STR(Name et al. [####]);                                                   

*----------------------------------------------------------------*
| Please specify the owner of the data source                    |
*----------------------------------------------------------------*;
%LET OWNER        = %STR(Institution, Department);                                                   

*----------------------------------------------------------------*
| Please specify your institution (analyser)                     |
*----------------------------------------------------------------*;
%LET ANALYSER     = %STR(Analyser);                                                   

*----------------------------------------------------------------*
| Please describe your analysis                                  |
*----------------------------------------------------------------*;
%LET ANALYSIS     = %STR(Secondary analysis of the puf);                                                   

*----------------------------------------------------------------*
| Please indicate the restrictions in 7-bit code                 |
*----------------------------------------------------------------*;
%LET RESTRICTIONS = %STR(0000000);                                      

*----------------------------------------------------------------*
| Comments                                                       |
*----------------------------------------------------------------*;
%LET COMMENT      = %STR(XXXX);                                                   

*----------------------------------------------------------------*
| Additional comments                                            |
*----------------------------------------------------------------*;
%LET OTHER        = %STR(XXXX);                                                   

*----------------------------------------------------------------*
| Keywords (also headline, group, name in German)                |
*----------------------------------------------------------------*;
%LET KEYWORDS     = %STR(XXXX);                                                   

*----------------------------------------------------------------*
| Please specify the variablename of weights                     |
| When data are not weighted, fill in 'NOWEIGHT'                 |
*----------------------------------------------------------------*;
%LET WICHTUNG     = NOWEIGHT;                                                   

*----------------------------------------------------------------*
| Please specify the variablename of age [in years]              |
*----------------------------------------------------------------*;
%LET ALTER        = AGE;                                                   

*----------------------------------------------------------------*
| Please specify the variablename of sex [numeric]               |
*----------------------------------------------------------------*;
%LET GSCHLECHT    = SEX;    

*----------------------------------------------------------------*
| Please specify the coding of 'males'                           |
*----------------------------------------------------------------*;
%LET MALENUMBER   = 1;      

*----------------------------------------------------------------*
| Please specify the coding of 'females'                         |
*----------------------------------------------------------------*;
%LET FEMALENUMBER = 2;      

*----------------------------------------------------------------*
| Indicator for stratification of sex: no = 69, yes = 1          |
*----------------------------------------------------------------*;
%LET WERTSTRAT1   = 1;

*----------------------------------------------------------------*
| Please specify the header of printed output                    |
| (Title 2 and following are set by the program)                 |
*----------------------------------------------------------------*;
PROC CONTENTS DATA=ROHDATEN;
     TITLE1    'Stratification and Distributional fit';
RUN;
*----------------------------------------------------------------*
| End of form                                                    |
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
*----------------------------------------------------------------*
| Begin of script                                                |
*----------------------------------------------------------------*;

*----------------------------------------------------------------*
| Indicator of additional strata (if no, it is 'KEINE')          |
*----------------------------------------------------------------*;
%LET ZUSATZSTRATIFIZIERUNG   = KEINE;      

*----------------------------------------------------------------*
| Name of additional strata (if no, it is 'KEINE')               |
*----------------------------------------------------------------*;
%LET STRATUM   = KEINE;      

*----------------------------------------------------------------*
| Indicator for possible log scale                               |
*----------------------------------------------------------------*;
%LET LOGSKALA    = 0;      

*----------------------------------------------------------------*
| Names of protocol files (automatic generated)                   |
*----------------------------------------------------------------*;
%LET GRAFIKZIEL  = OUTPUT.&PARAM;
RUN;
*----------------------------------------------------------------*
| Macro definitions                                               |
*----------------------------------------------------------------*;
%MACRO NAMES(NAME,ANZAHL);
       %DO N=1 %TO &ANZAHL;
           &NAME&N
       %END;
%MEND NAMES;
*----------------------------------------------------------------*;
%MACRO ZWEINAMES(NAME1,NAME2,ANZAHL);
       %DO N=1 %TO &ANZAHL;
       & &NAME1&N = &NAME2&N
       %END;
%MEND ZWEINAMES;
*----------------------------------------------------------------*;
%MACRO SCHREIBE(NAME1,NAME);
       %IF %LENGTH(&NAME) = 0 %THEN ;
       %ELSE PUT "&NAME" " | " "&NAME";
%MEND SCHREIBE;

*----------------------------------------------------------------*
| Additional variables                                           |
*----------------------------------------------------------------*;
DATA RAWDATA;
     SET ROHDATEN;

*----------------------------------------------------------------*
| Agegroups according to the Xprob-scheme                        |
*----------------------------------------------------------------*;
*----------------------------------------------------------------*
| Adults                                                         |
*----------------------------------------------------------------*;
     IF      20 <= &ALTER < 25 THEN ALTSTRAT = 1;
     ELSE IF 25 <= &ALTER < 35 THEN ALTSTRAT = 2;
     ELSE IF 35 <= &ALTER < 45 THEN ALTSTRAT = 3;
     ELSE IF 45 <= &ALTER < 55 THEN ALTSTRAT = 4;
     ELSE IF 55 <= &ALTER < 65 THEN ALTSTRAT = 5;
     ELSE IF 65 <= &ALTER      THEN ALTSTRAT = 6;
*----------------------------------------------------------------*
| Children an Adolescents                                        |
*----------------------------------------------------------------*;
     ELSE IF 0    <= &ALTER < 0.25 THEN ALTSTRAT = 0.001;
     ELSE IF 0.25 <= &ALTER < 0.5  THEN ALTSTRAT = 0.0025;
     ELSE IF 0.5  <= &ALTER < 1    THEN ALTSTRAT = 0.005; 
     ELSE IF 1    <= &ALTER < 1.5  THEN ALTSTRAT = 0.01; 
     ELSE IF 1.5  <= &ALTER < 2    THEN ALTSTRAT = 0.015; 
     ELSE IF 2    <= &ALTER < 2.5  THEN ALTSTRAT = 0.02; 
     ELSE IF 2.5  <= &ALTER < 3    THEN ALTSTRAT = 0.025; 
     ELSE IF 3    <= &ALTER < 4    THEN ALTSTRAT = 0.03; 
     ELSE IF 4    <= &ALTER < 5    THEN ALTSTRAT = 0.04; 
     ELSE IF 5    <= &ALTER < 6    THEN ALTSTRAT = 0.05; 
     ELSE IF 6    <= &ALTER < 7    THEN ALTSTRAT = 0.06; 
     ELSE IF 7    <= &ALTER < 8    THEN ALTSTRAT = 0.07; 
     ELSE IF 8    <= &ALTER < 9    THEN ALTSTRAT = 0.08; 
     ELSE IF 9    <= &ALTER < 10   THEN ALTSTRAT = 0.09; 
     ELSE IF 10   <= &ALTER < 11   THEN ALTSTRAT = 0.10; 
     ELSE IF 11   <= &ALTER < 12   THEN ALTSTRAT = 0.11; 
     ELSE IF 12   <= &ALTER < 13   THEN ALTSTRAT = 0.12; 
     ELSE IF 13   <= &ALTER < 14   THEN ALTSTRAT = 0.13; 
     ELSE IF 14   <= &ALTER < 15   THEN ALTSTRAT = 0.14; 
     ELSE IF 15   <= &ALTER < 16   THEN ALTSTRAT = 0.15; 
     ELSE IF 16   <= &ALTER < 17   THEN ALTSTRAT = 0.16; 
     ELSE IF 17   <= &ALTER < 18   THEN ALTSTRAT = 0.17; 
     ELSE IF 18   <= &ALTER < 19   THEN ALTSTRAT = 0.18; 
     ELSE IF 19   <= &ALTER < 20   THEN ALTSTRAT = 0.19;

*----------------------------------------------------------------*
| Weight, when unweighted                                        |
*----------------------------------------------------------------*;
    NOWEIGHT = 1;
*----------------------------------------------------------------*
| Additional strata, when not specified                          |
*----------------------------------------------------------------*;
    KEINE = 1;
*----------------------------------------------------------------*
|                                                                |
*----------------------------------------------------------------*;
    ALT2 = 1;
*----------------------------------------------------------------*
| Additional stratification                                      |
*----------------------------------------------------------------*;
    EIGENSTRAT = 0;
*----------------------------------------------------------------*
| Internal coding of sex                                         |
*----------------------------------------------------------------*;
    IF &GSCHLECHT = &MALENUMBER   THEN SEX2 = 1;
    IF &GSCHLECHT = &FEMALENUMBER THEN SEX2 = 2; 


*----------------------------------------------------------------*
| Sorting by strata                                              |
*----------------------------------------------------------------*;
PROC SORT DATA=RAWDATA OUT=ORDER;
     BY &ZUSATZSTRATIFIZIERUNG 
        &GSCHLECHT 
        ALTSTRAT 
        &ANALYSE
        ;
RUN;
*----------------------------------------------------------------*
| Minimum and maximum of age                                     |
*----------------------------------------------------------------*;
PROC UNIVARIATE DATA=ORDER NOPRINT;
     VAR &ALTER;
     OUTPUT OUT=EMPALT 
            MIN=MINIMUM 
            MAX=MAXIMUM
            ;
RUN;
*----------------------------------------------------------------*
| Characteristics of the stratified exposure factor              |
*----------------------------------------------------------------*;
PROC UNIVARIATE DATA=ORDER NOPRINT;
     VAR &ANALYSE;
     OUTPUT OUT=EMPIRIE 
            N=ANZAHL 
            MIN=MINIMUM 
            MAX=MAXIMUM 
            MEDIAN=MEDIAN 
            MEAN=MITTEL 
            QRANGe=QUARTILSABSTAND
            STD=STREUUNG
            VAR=VARIANZ 
            SKEWNESS=SCHIEFE 
            ;
     WEIGHT &WICHTUNG;
     WHERE  &WICHTUNG >.;
     BY     &ZUSATZSTRATIFIZIERUNG 
            SEX2 
            ALTSTRAT
            ;
RUN;

/*------------------------------------------------------------------------------------------------*/
/* Sortieren u. Berechnen der Empirie ohne Geschlechtsunterscheidung                              */
/*------------------------------------------------------------------------------------------------*/

proc sort data=rawdata out=order2;
by &zusatzstratifizierung altstrat &analyse;
run;

proc univariate data=order2 noprint; 
var &analyse;
by &zusatzstratifizierung altstrat;
weight &wichtung;
where &wichtung >.;
output out=empirie_alle n=anzahl min=minimum max=maximum mean=mittel var=varianz std=streuung
skewness=schiefe median=median qrange=quartilsabstand;
run;

proc univariate data=order2 noprint; 
var &analyse;
by &zusatzstratifizierung;
weight &wichtung;
where &wichtung >.;
output out=empirie_zusatz n=anzahl min=minimum max=maximum mean=mittel var=varianz std=streuung
skewness=schiefe median=median qrange=quartilsabstand;
run;

proc ttest data=order;
class sex2;
by &zusatzstratifizierung;
var &analyse;
run;


proc IML;

edit empirie_zusatz;
read all var{&zusatzstratifizierung} where (&zusatzstratifizierung > 0) into untergr;
anz_untergr = nrow(untergr);
close;

do zusatz = 1 to anz_untergr;
if &wertstrat1 = 69 then mannfraumax = 1;
                    else mannfraumax = 2;

do mannfrau = 1 to mannfraumax;

/*------------------------------------------------------------------------------------------------*/
/* Vorbereitung zur Stratifizierung: Konstruktion aller zulaessigen Zerlegungen                   */                   
/*------------------------------------------------------------------------------------------------*/

if &wertstrat1 ^= 69 then do;
edit order var{eigenstrat &zusatzstratifizierung sex2} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz);
read all into abfrage;
close;
end;


else do; 
edit order2;
read all var{eigenstrat &zusatzstratifizierung} into abfrage;
close;
end;

if abfrage[1] = 0 then do;

if &wertstrat1 = 69 then do;
edit empirie_alle;
read all var{altstrat} where (anzahl > 0 & &zusatzstratifizierung = zusatz) into xprobstrat;
anzahl_klassen = nrow(xprobstrat);
r = rank(xprobstrat);
end;

if &wertstrat1 ^= 69 then do;
edit empirie;
read all var{altstrat} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz & anzahl > 0) into xprobstrat;
anzahl_klassen = nrow(xprobstrat);
r = rank(xprobstrat);
end;

hilfsmatrix = j(anzahl_klassen - 1, 2##(anzahl_klassen - 1), 1);
do i = 1 to anzahl_klassen - 1;
do j = 1 to 2##(anzahl_klassen - 1);
if j/2##(anzahl_klassen - i) - int(j/2##(anzahl_klassen - i)) < 0.5 then hilfsmatrix[i,j] = 0;
end;
end;

stratmatrix = j(anzahl_klassen + 5, 2##(anzahl_klassen - 1), 1);
do i = 1 to anzahl_klassen - 1;
stratmatrix[i+1,] = stratmatrix[i,] + hilfsmatrix[i,];
end;

/*------------------------------------------------------------------------------------------------*/
/* Datenaufbereitung und Definitionen                                                             */
/*------------------------------------------------------------------------------------------------*/

use order;
if &wertstrat1 = 69 then read all var {&analyse altstrat} where (&analyse >= 0 & &zusatzstratifizierung = zusatz) into arbeitsmatrix;
else read all var {&analyse altstrat} where (&analyse >= 0  & sex2 = mannfrau & &zusatzstratifizierung = zusatz) into arbeitsmatrix;
n = nrow(arbeitsmatrix);
alt_neu = j(n,2);
alt_neu[,1] = arbeitsmatrix[,2];
do k = 1 to anzahl_klassen;
alt_neu[loc(alt_neu[,1] = xprobstrat[k]),2] = r[k]; 
end;

gruppenmittel = j(n,1); gruppenanzahl = j(anzahl_klassen,2,0);

/*------------------------------------------------------------------------------------------------*/
/* Berechnung von F-Statistik und zugehoerigem P-Wert fuer die einzelnen Zerlegungen              */
/*------------------------------------------------------------------------------------------------*/

do k = 1 to 2##(anzahl_klassen - 1) - 1;
do i = 1 to anzahl_klassen;
gruppenanzahl[i,1] = nrow(arbeitsmatrix[loc(alt_neu[,2]=i),1]);
gruppenmax = gruppenanzahl[,1][<>];
alt_neu[loc(alt_neu[,2]=i),1] = repeat(stratmatrix[i,k],gruppenanzahl[i,1]);
end;
do i = 1 to stratmatrix[anzahl_klassen,k];
gruppenanzahl[i,2] = nrow(alt_neu[loc(alt_neu[,1]=i),1]);
gruppenmittel[loc(alt_neu[,1]=i),1] = repeat(arbeitsmatrix[loc(alt_neu[,1]=i),1][:],gruppenanzahl[i,2]);
end;
stratmatrix[anzahl_klassen + 1,k] = gruppenanzahl[,2][<>];
stratmatrix[anzahl_klassen + 2,k] = gruppenanzahl[1:stratmatrix[anzahl_klassen,k],2][><];
gesamtmittel = repeat(arbeitsmatrix[:,1],n,1);
if (stratmatrix[anzahl_klassen + 1,k] > max(368,gruppenmax)) | (stratmatrix[anzahl_klassen + 2,k] < 72) 
then do;
stratmatrix[anzahl_klassen + 3,k] = 0;
stratmatrix[anzahl_klassen + 5,k] = 0;
end;
else do;
f_zaehler = (gruppenmittel - gesamtmittel)[##] / (stratmatrix[anzahl_klassen,k] - 1);
f_nenner = (arbeitsmatrix[,1] - gesamtmittel)[##] / (n - stratmatrix[anzahl_klassen,k]);
 
stratmatrix[anzahl_klassen + 3,k] = f_zaehler / f_nenner;
stratmatrix[anzahl_klassen + 4,k] = 1 - probf((stratmatrix[anzahl_klassen + 3,k]), 
stratmatrix[anzahl_klassen,k] - 1, n - stratmatrix[anzahl_klassen,k]);
erwartungswert = (n - stratmatrix[anzahl_klassen,k]) / (n - stratmatrix[anzahl_klassen,k] - 2);
temp1 = stratmatrix[anzahl_klassen + 3,k] - erwartungswert;
temp2 = erwartungswert * sqrt((2 * n - 6) / ((stratmatrix[anzahl_klassen,k] - 1) * 
( n - 4 - stratmatrix[anzahl_klassen,k])));
stratmatrix[anzahl_klassen + 5,k] = temp1 / temp2; 
end;
end;

*print stratmatrix;

/*------------------------------------------------------------------------------------------------*/
/* Auswahl der optimalen Zerlegung und Ergaenzung im Datensatz                                    */
/*------------------------------------------------------------------------------------------------*/
 
if stratmatrix[anzahl_klassen + 4,><] > 0 then optimal_strat1 = stratmatrix[anzahl_klassen + 4,>:<];
else optimal_strat1 = stratmatrix[anzahl_klassen + 5,1:2##(anzahl_klassen - 1) - 1][<:>];
if stratmatrix[anzahl_klassen + 3,1:2##(anzahl_klassen - 1) - 1][<>] = 0 
then do;
print "UNEXPECTED CASE! USUAL PROCEDURE FAILS!";
print "YOU HAVE TO DEFINE AGE GROUPS ON YOUR OWN";
if &wertstrat1 = 69 then print "FOR SEX = FEMALE AND MALE";
else do;
if mannfrau = 1 then print "FOR SEX = MALE";
if mannfrau = 2 then print "FOR SEX = FEMALE";
end;
reset noname;
if anz_untergr > 1 then print "AND SUBGROUP NO." zusatz;
reset name;

if &wertstrat1 ^= 69 then do;
edit order;
find all where (sex2 = mannfrau & &zusatzstratifizierung = zusatz) into d;
alt2 = 1;
eigenstrat = 1;
replace point d;
end;

if &wertstrat1 = 69 then do;
edit order2;
find all where (&zusatzstratifizierung = zusatz) into d;
alt2 = 1;
eigenstrat = 1;
replace point d;
end;
end;

if (stratmatrix[anzahl_klassen + 3,1:2##(anzahl_klassen - 1) - 1][<>] > 0 & &wertstrat1 ^= 69) then do; 
edit order;
do i = 1 to anzahl_klassen;
find all where(altstrat = (xprobstrat[i]) & sex2 = mannfrau & &zusatzstratifizierung = zusatz) into d;
alt2 = (stratmatrix[i,optimal_strat1]);
eigenstrat = -1;
replace point d;
end;
end;

if (stratmatrix[anzahl_klassen + 3,1:2##(anzahl_klassen - 1) - 1][<>] > 0 & &wertstrat1 = 69) then do; 
edit order2;
do i = 1 to anzahl_klassen;
find all where(altstrat = (xprobstrat[i]) & &zusatzstratifizierung = zusatz) into d;
alt2 = (stratmatrix[i,optimal_strat1]);
eigenstrat = -1;
replace point d;
end;
end;
end;
end;
end;

quit;

/*------------------------------------------------------------------------------------------------*/
/* Neusortierung nach optimaler oder eigener Stratifizierung                                      */
/*------------------------------------------------------------------------------------------------*/

proc sort data=order out=order;
by &zusatzstratifizierung sex2 alt2 &analyse;
run;

proc univariate data=order noprint;
var &analyse;
by &zusatzstratifizierung sex2 alt2;
weight &wichtung;
where &wichtung >.;
output out=empirie2 n=anzahl min=minimum max=maximum mean=mittel var=varianz std=streuung
skewness=schiefe median=median qrange=quartilsabstand;
run;

proc univariate data=order noprint;
var &alter;
where &analyse >.;
output out=empalt min=minimum max=maximum;
run;

proc univariate data=order noprint;
var &alter;
by &zusatzstratifizierung sex2 alt2;
where &analyse >.;
output out=empalt2 min=minimum max=maximum n=anzahl;
run;

proc sort data=order2 out=order2;
by &zusatzstratifizierung alt2 &analyse;
run;

proc univariate data=order2 noprint;
var &alter;
by &zusatzstratifizierung alt2;
where &analyse >.;
output out=empalt69 min=minimum max=maximum n=anzahl;
run;

proc univariate data=order2 noprint;
var &analyse;
by &zusatzstratifizierung alt2;
weight &wichtung;
where &wichtung >.;
output out=empirie2_alle n=anzahl min=minimum max=maximum mean=mittel var=varianz std=streuung
skewness=schiefe median=median qrange=quartilsabstand;
run;

proc IML;

/*------------------------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------------------------------*/
/* Definition der spaeter benoetigten Funktion gamquot, die den Quotienten von Gamma-Funktionen berechnet */
/*--------------------------------------------------------------------------------------------------------*/

start gamquot(m2,p);
if m2 > 2 then do;
n = floor(m2); erg = gamma(m2 - n + 1 + 1 / p) / gamma(m2 - n + 1);
l = ((repeat(m2 + 1 / p, 1, n - 1) - (1:n - 1)) / (repeat(m2, 1, n - 1) - (1:n - 1)))[,#];
if erg > 1e250 | l > 1e250 | (erg > 1e125 & l > 1e125) then y = .; 
else y = l * erg;
return (y);
end;
else do;
y = gamma(m2 + 1/p) / gamma(m2);
return (y);
end;
finish;

/*------------------------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------------------*/
/* Unterprogramme log-Likelihood und Gradient GF-Verteilung                                   */
/*--------------------------------------------------------------------------------------------*/

start f_GF4(x) global(daten,weig);
n = ncol(daten);

sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * log(1 + (x[1] / x[2]) * (x[3] * temp1) ## x[4]);
end;

f = weig * log(x[4]) + weig * x[1] * (log(x[1]) - log(x[2])) + weig * x[4] * x[1] * log(x[3]) 
    - weig * (lgamma(x[1]) + lgamma(x[2]) - lgamma(x[1] + x[2])) + (x[4] * x[1] - 1) * sum1
	- (x[1] + x[2]) * sum2;

return (f);
finish f_GF4;

start g_GF4(x) global(daten,weig);
n = ncol(daten);
g = j(1,4,0.);
sum1 = 0.;
sum2 = 0.;
sum3 = 0.;
sum4 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * log(1 + (x[1] / x[2]) * (x[3] * temp1) ## x[4]);
   sum3 = sum3 + temp2 * ((x[3] * temp1) ## x[4]) / (1 + (x[1] / x[2]) * (x[3] * temp1) ## x[4]);
   sum4 = sum4 + temp2 * (log(x[3] * temp1) * (x[3] * temp1) ## x[4]) / (1 + (x[1] / x[2]) *
          (x[3] * temp1) ## x[4]);
end;

g[1] = weig * (log(x[1]) - log(x[2]) + 1) + weig * x[4] * log(x[3]) + x[4] * sum1
       + weig * (digamma(x[1] + x[2]) - digamma(x[1])) - sum2 - (1 + x[1] / x[2]) * sum3;
g[2] = weig * (digamma(x[1] + x[2]) - digamma(x[2])) - weig * x[1] / x[2] - sum2
       - (x[1] / x[2] - (x[1] * x[1]) / (x[2] * x[2])) * sum3;
g[3] = (weig * x[1] * x[4]) / x[3] - (x[1] + x[2])* x[4] * x[1] * sum3 /(x[3] * x[2]);
g[4] = weig * x[1] * log(x[3]) + weig / x[4] + x[1] * sum1 - ((x[1] * (x[1] + x[2])) / x[2]) * sum4;

return (g);
finish g_GF4;

/*-------------------------------------------------------------------------------------------------*/
/* Verteilungsfunktion der GF-Verteilung                                                           */
/*-------------------------------------------------------------------------------------------------*/

start h_GF4(y) global(xopt);
h = probf((y * xopt[3]) ## xopt[4], 2 * xopt[1], 2 * xopt[2]);
return (h);
finish h_GF4;

/*--------------------------------------------------------------------------------------------*/
/* Unterprogramme log-Likelihood und Gradient Lognormal                                                     */
/*--------------------------------------------------------------------------------------------*/

start f_LN2(x) global(daten,weig);
n = ncol(daten);

sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * (log(x[1] * temp1))##2;
end;

f = weig * (log(x[2]) - log(sqrt(2 * 3.141592))) - sum1 - (x[2] ## 2 / 2) * sum2;

return (f);
finish f_LN2;

start g_LN2(x) global(daten,weig);
n = ncol(daten);
g = j(1,2,0.);
sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * (log(x[1] * temp1)) ## 2;
end;

g[1] = - (x[2] ## 2 / x[1]) * (weig * log(x[1]) + sum1);
g[2] = weig / x[2] - x[2] * sum2;

return (g);
finish g_LN2;

/*--------------------------------------------------------------------------------------------*/
/* Unterprogramme log-Likelihood und Gradient Weibull-Verteilung                                            */
/*--------------------------------------------------------------------------------------------*/

start f_wei2(x) global(daten,weig);
n = ncol(daten); 

sum1 = 0.; 
sum2 = 0.;

do i=1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * (temp1 * x[1]) ## x[2];
end;

f = weig * log(x[2]) + weig * x[2] * log(x[1]) + (x[2] - 1) * sum1 - sum2;
return (f);
finish f_wei2;

start g_wei2(x) global(daten,weig);
n = ncol(daten);

g = j(1,2,0.);
sum1 = 0.;
sum2 = 0.;
sum3 = 0.; 

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * (temp1 * x[1]) ## x[2];
   sum3 = sum3 + temp2 * ((temp1 * x[1]) ## x[2]) * (log(temp1 * x[1]));
end;

g[1] = weig * x[2] / x[1] - sum2 * x[2] / x[1];
g[2] = weig / x[2] + weig * log(x[1]) + sum1 - sum3;

return (g);
finish g_wei2;

/*--------------------------------------------------------------------------------------------*/
/* Unterprogramme log-Likelihood und Gradient Gamma-Verteilung                                              */
/*--------------------------------------------------------------------------------------------*/

start f_Gam2(x) global(daten,weig);
n = ncol(daten);

sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp1 * temp2;
end;

f = weig * x[1] * (log(x[2]) + log(x[1])) + (x[1] - 1) * sum1 - x[1] * x[2] * sum2 
    - weig * lgamma(x[1]);

return (f);
finish f_Gam2;

start g_Gam2(x) global(daten,weig);
n = ncol(daten);

g = j(1,2,0.);
sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * temp1;
end;

g[1] = weig * ((x[1] / x[2]) + log(x[2]) + log(x[1])) + sum1 - x[2] * sum2 - weig * digamma(x[1]);
g[2] = (weig * x[1]) / x[2] - x[1] * sum2; 
       
return (g);
finish g_Gam2;

/*--------------------------------------------------------------------------------------------*/
/* Unterprogramme log-Likelihood und Gradient loglog-Verteilung                                             */
/*--------------------------------------------------------------------------------------------*/

start f_LL2(x) global(daten,weig);
n = ncol(daten);

sum1 = 0.;
sum2 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * log(1 + (x[1] * temp1) ## x[2]);
end;

f = weig * log(x[2]) + weig * x[2] * log(x[1]) + (x[2] - 1) * sum1 - 2 * sum2;

return (f);
finish f_LL2;

start g_LL2(x) global(daten,weig);
n = ncol(daten);
g = j(1,2,0.);
sum1 = 0.;
sum2 = 0.;
sum3 = 0.;

do i = 1 to n;
   temp1 = daten[1,i];
   temp2 = daten[2,i];
   sum1 = sum1 + temp2 * log(temp1);
   sum2 = sum2 + temp2 * ((x[1] * temp1) ## x[2]) / (1 + (x[1] * temp1) ## x[2]);
   sum3 = sum3 + temp2 * (log(x[1] * temp1) * (x[1] * temp1) ## x[2]) / (1 + (x[1] * temp1) ## x[2]);
end;

g[1] = (weig * x[2]) / x[1] - 2 * x[2] * sum2 / x[1];
g[2] = weig * log(x[1]) + weig / x[2] + sum1 - 2 * sum3;

return (g);
finish g_LL2;

/*------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------*/
/* Definition zweier Funktionen fuer die Grafikprogramme                                     */
/*-------------------------------------------------------------------------------------------*/

start doppelt(matrix);
n=nrow(matrix);
matneu=j(2*n,1);
do i=1 to n;
matneu[2*i] = matrix[i];
matneu[2*i - 1] = matrix[i];
end;
return(matneu);
finish;

start gscenter(x,y,str);
call gstrlen(len,str);
call gscript(x - len / 2,y,str);
finish gscenter;

/*------------------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------------------------*/
/* Initialisierung der Schleife ueber die verschiedenen Altersgruppen                             */
/*------------------------------------------------------------------------------------------------*/

edit empirie_zusatz;
read all var{&zusatzstratifizierung} where (&zusatzstratifizierung > 0) into untergr;
anz_untergr = nrow(untergr);
close;

do zusatz = 1 to anz_untergr;
if &wertstrat1 = 69 then mannfraumax = 1;
                    else mannfraumax = 2;

do mannfrau = 1 to mannfraumax;

option notes;

if &wertstrat1 ^= 69 then do;
use order;
read all var {eigenstrat} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz) into stratabfrage;
if stratabfrage[1] = 1 then do;
close;
use empirie;
read all var {altstrat anzahl} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz) into Xprobaltersgruppen;
reset noname;
if anz_untergr > 1 then print / "UNTERGRUPPE NO." zusatz;
reset name;
if mannfrau = 1 then print "SEX = MALE";
if mannfrau = 2 then print "SEX = FEMALE";
print "FINEST CLASSIFICATION";
print Xprobaltersgruppen [colname={"Age Group" "Nr of Obs."}];
abort;
end;
end;

if &wertstrat1 = 69 then do;
use order2;
read all var {eigenstrat} where (&zusatzstratifizierung = zusatz) into stratabfrage;
close;
if stratabfrage[1] = 1 then do;
use empirie_alle;
read all var {altstrat anzahl} where (&zusatzstratifizierung = zusatz) into Xprobaltersgruppen;
reset noname;
if anz_untergr > 1 then print / "UNTERGRUPPE NO." zusatz;
reset name;
print "SEX = FEMALE AND MALE";
print "FINEST CLASSIFICATION";
print Xprobaltersgruppen [colname={"Age Group" "Nr of Obs."}];
abort;
end;
end;

if stratabfrage[1] ^= 1 then do;
if &wertstrat1 ^= 69 then do;
edit empalt2;
read all var{alt2 minimum maximum} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz) into altersstratifizierung;
c = {"Group" "Minimum" "Maximum"};
reset noname;
if anz_untergr > 1 then print / "UNTERGRUPPE NO." zusatz;
reset name;
if mannfrau = 1 then print "MAENNER";
if mannfrau = 2 then print "FRAUEN";
print altersstratifizierung [colname=c];
end;
else do ;
edit empalt69;
read all var{alt2 minimum maximum} where (&zusatzstratifizierung = zusatz) into altersstratifizierung;
c = {"Group" "Minimum" "Maximum"};
reset noname;
if anz_untergr > 1 then print "UNTERGRUPPE NO." zusatz;
reset name;
print "BEIDE GESCHLECHTER";
print altersstratifizierung [colname=c] /;
end;
end;

ksex = char(mannfrau);
%let sexgroup = ksex;

kzus = char(zusatz);
%let zusgroup = kzus;

if &wertstrat1 ^= 69 then do;
use empirie2;
read all var{alt2} where (sex2 = mannfrau & &zusatzstratifizierung = zusatz) into abzaehlen;
anz_alt_grupp = nrow(abzaehlen);
end;

if &wertstrat1 = 69 then do;
use empirie2_alle;
read all var{alt2} where (&zusatzstratifizierung = zusatz) into abzaehlen;
anz_alt_grupp = nrow(abzaehlen);
end;

do group = 1 to anz_alt_grupp;
j = char(group);
%let gruppe = j;

/*------------------------------------------------------------------------------------------------*/
/*    Datenaufbereitung                                                                           */
/*------------------------------------------------------------------------------------------------*/

if &wertstrat1 ^= 69 then do;
use order;
read all var {&analyse &wichtung} into tdaten where (&analyse > 0 
& sex2 = mannfrau & alt2 = group  & &zusatzstratifizierung = zusatz);
read all var {&analyse &wichtung} into talldaten where (&analyse >= 0 
& sex2 = mannfrau & alt2 = group & &zusatzstratifizierung = zusatz);
n2 = nrow(talldaten); n2inv = 1 / n2; 
n1 = nrow(tdaten); n1inv = 1 / n1;

if n1 < 5 then do;
print "FIT NOT POSSIBLE";
file "&ausgabe";
put ' ' / "GROUP=" group / 'FIT NOT POSSIBLE';
abort;
end;
end;

if &wertstrat1 = 69 then do;
use order2;
read all var {&analyse &wichtung} into tdaten where (&analyse > 0 
& alt2 = group & &zusatzstratifizierung = zusatz);
read all var {&analyse &wichtung} into talldaten where (&analyse >= 0 
& alt2 = group & &zusatzstratifizierung = zusatz);
n2 = nrow(talldaten); n2inv = 1 / n2; 
n1 = nrow(tdaten); n1inv = 1 / n1;

if n1 < 5 then do;
print "FIT NOT POSSIBLE";
file "&ausgabe";
put ' ' / "GROUP=" group / 'FIT NOT POSSIBLE';
abort;
end;
end;

allweig = talldaten[+,2];
weig = tdaten[+,2]; 
all_emp_vfu = j(1,n2,1);
emp_vfu = j(1,n1,1);

do i=1 to n2;
all_emp_vfu[i] = talldaten[1:i,2][+] / allweig;
end;

do i=1 to n1;
emp_vfu[i] = tdaten[1:i,2][+] / weig;
end;

daten = tdaten`;
alldaten = talldaten`;
alldaten = insert(alldaten,all_emp_vfu,3);
daten = insert(daten,emp_vfu,3);

if &wertstrat1 ^= 69 then do;
use empirie2;
read all var{mittel streuung schiefe varianz median quartilsabstand}
where (sex2 = mannfrau & alt2 = group & &zusatzstratifizierung = zusatz) into kennwerte;
end;

if &wertstrat1 = 69 then do;
use empirie2_alle;
read all var{mittel streuung schiefe varianz median quartilsabstand} 
where (alt2 = group & &zusatzstratifizierung = zusatz) into kennwerte;
end;

/*------------------------------------------------------------------------------------------------*/
/*   Berechnung von Nullmasse und Anzahl der verschiedenen Datenauspraegungen                     */
/*------------------------------------------------------------------------------------------------*/

s = n2/100;
q = (n2 - n1)/n2;
if q > 0 then nullmasse = alldaten[3,(n2 - n1)];
else nullmasse = 0;

versch = 0;
vergleichswert = -1;
do i = 1 to n2;
temp = alldaten[1,i];
if temp > vergleichswert then do; 
versch = versch + 1;
vergleichswert = temp;
end;
end;

/*------------------------------------------------------------------------------------------------*/
/* Initialisierung der SAS-Dateien para, moments, quant, empquant und startval                    */
/*------------------------------------------------------------------------------------------------*/

create para var {gf4p ln2p wei2p gam2p exp1p ll2p};
do i = 1 to 11;
gf4p = 0;
append;
end;
close para;

create moments var {empm gf4m ln2m wei2m gam2m exp1m ll2m};
do i =1 to 6;
temp = kennwerte[i];
empm = temp;
append;
end;
close moments; 

create quant var {empq gf4q ln2q wei2q gam2q exp1q ll2q};
do i=1 to 99;
empq = 0;
append;
end;
close quant;

if versch < 21 then do;
create empquant var {auspraegung quantil haeufigkeit gfvt lnvt weivt gamvt expvt llvt};
do i=1 to versch;
auspraegung = 0;
append; 
end;
end;
close empquant;

create startval var {x01 x02 x03 x04};
x01 = 0; x02 = .5; x03 = 0; x04 = .5;
append;
close startval; 
 
/*------------------------------------------------------------------------------------------------*/
/* Berechnung der empirischen Quantile                                                            */
/*------------------------------------------------------------------------------------------------*/

edit quant var {empq gf4q ln2q wei2q gam2q exp1q ll2q}; 
i = 1;
do k=0.01 to 0.99 by 0.01; 
do while (alldaten[3,i] < k);
i = i + 1;
end;
empq = alldaten[1, i];
gf4q = 0.; ln2q = 0.; wei2q = 0.; gam2q = 0.; exp1q = 0.; ll2q = 0.;
temp_var = k*100; 
replace point temp_var;
end;

i=1; k=0.14;
do while (alldaten[3,i] < k);
i = i + 1;
end;
empq = alldaten[1, i];
gf4q = 0.; ln2q = 0.; wei2q = 0.; gam2q = 0.; exp1q = 0.; ll2q = 0.;
temp_var = k*100; 
replace point temp_var;
close quant;
					 
if versch < 21 then do;
edit empquant var {auspraegung quantil haeufigkeit gfvt lnvt weivt gamvt expvt llvt};
auspraegung = alldaten[1,1];
replace point 1;
temp2 = 0; temp3 = 1;
do i = 1 to n2;
temp = alldaten[1,i];
if temp > auspraegung then do;
temp3 = temp3 + 1; 
quantil = alldaten[3,i-1];
auspraegung = temp;
gfvt = 0; lnvt = 0; weivt = 0;
gamvt = 0; expvt = 0; llvt = 0;
haeufigkeit = quantil - temp2; 
temp2 = quantil;
replace point temp3;
end;
end;
read all var{auspraegung} into auspr_vektor;
read all var{quantil} into quant_vektor;
read all var{haeufigkeit} into haeuf_vektor;
haeuf_vektor[1] = 0;
nhaeufig = nrow(haeuf_vektor); haeufig_gesamt = haeuf_vektor[+,]; freq_vektor = j(nhaeufig,1);
close empquant;

do i=1 to nhaeufig - 1;
freq_vektor[i] = haeuf_vektor[i + 1];
end;
freq_vektor[nhaeufig] = 1 - haeufig_gesamt;
end;

/*------------------------------------------------------------------------------------------------*/
/* ML-Schaetzung fuer die Exponential-Verteilung                                                  */
/*------------------------------------------------------------------------------------------------*/

x0 = (daten[1,] # daten[2,])[,+];
inv_mittelwert = weig / x0;

x1 = 0.;
do i = 1 to n1;
temp = daten[1,i];
x1 = x1 + (temp - 1/inv_mittelwert) ## 2;
end;

varopt = x1 / (n1 - 1);
fopt = weig * log(inv_mittelwert) - inv_mittelwert * x0;

edit para var {exp1p};
exp1p = nullmasse;
replace point 1;
exp1p = inv_mittelwert;
replace point 4;
exp1p = 1 / inv_mittelwert;
replace point 10;
exp1p = fopt;
replace point 6;
close para;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Exponential-Momente                                                             */
/*------------------------------------------------------------------------------------------------*/

edit moments var {exp1m};
exp1m = (1 - nullmasse) / inv_mittelwert;
replace point 1;
exp1m = (1 - nullmasse) * (1 + nullmasse) / (inv_mittelwert * inv_mittelwert);
replace point 4;
exp1m = sqrt(exp1m);
replace point 2;
exp1m = 2 * (1 - nullmasse)##3 / (inv_mittelwert##3 * exp1m##3);
replace point 3;
if nullmasse >= 0.5 then exp1m = 0;
else
exp1m = (- log(1 - (0.5 - nullmasse) / (1 - nullmasse))) / inv_mittelwert;
replace point 5;
if nullmasse >= 0.75 then exp1m = 0;
else do;
h1 = (- log(1 - (0.75 - nullmasse) / (1 - nullmasse))) / inv_mittelwert;
if nullmasse >= 0.25 then exp1m = h1;
else do;
h2 = (- log(1 - (0.25 - nullmasse) / (1 - nullmasse))) / inv_mittelwert;
exp1m = h1 - h2;
end;
end;
replace point 6;
close moments;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Exponential-Quantile                                                            */
/*------------------------------------------------------------------------------------------------*/

edit quant var {exp1q};
do i=1 to 99;
t  = i*s; u = floor(t);
if u < n2 * nullmasse then exp1q = 0;
else 
exp1q = (- log(1 - (i * 0.01 - nullmasse) / (1 - nullmasse))) / inv_mittelwert;
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {expvt};
if auspr_vektor[1] = 0 then do;
expvt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * (1 - exp( - inv_mittelwert * 
(auspr_vektor[1] + auspr_vektor[2]) / 2));
replace point 1;
do i=2 to versch - 1;
expvt = (1 - haeuf_vektor[2]) * (exp( - inv_mittelwert * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2) 
- exp( - inv_mittelwert * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2));
replace point i;
end;
expvt = (1 - haeuf_vektor[2]) * (exp( - inv_mittelwert * (auspr_vektor[versch - 1] + 
auspr_vektor[versch]) / 2));
replace point versch;
end;
else do;
expvt = 1 - exp( - inv_mittelwert * (auspr_vektor[1] + auspr_vektor[2]) / 2);
replace point 1;
do i=2 to versch - 1;
expvt = exp( - inv_mittelwert * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2) - exp( - inv_mittelwert * 
(auspr_vektor[i] + auspr_vektor[i + 1]) / 2);
replace point i;
end;
expvt = exp( - inv_mittelwert * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2);
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/
/* Optimierung der GF4-Parameter                                                                  */                 
/*------------------------------------------------------------------------------------------------*/

edit startval var {x01 x02 x03 x04};
x01 = max(.5, 1 / (varopt * inv_mittelwert * inv_mittelwert)); replace;
x02 = .5; replace;
x03 = inv_mittelwert; replace;
x04 = .5; replace;

p = 4;
use startval;
read all var {x01 x02 x03 x04} into x0;
optn = {1 0};
con = {.4001 .48 1.e-6 0.05,
         .     .     .  80  };
call nlpnms(rc,xres,"f_GF4",x0,optn,con,,,,"g_GF4"); /* Erster Durchlauf */
xopt = xres`; fopt = f_GF4(xopt);
close startval;

edit para var {gf4p};
gf4p = nullmasse;
replace point 1;
do i = 1 to 4;
gf4p = xopt[i];
replace point (i + 1);
end;
gf4p = fopt;
replace point 6;
close para;

edit startval var {x01 x02 x03 x04};
x01 = 1; replace;
x02 = 1; replace;
x03 = xopt[3]; replace;
x04 = 2 * xopt[4] / 3; replace;
close;

use startval;
read all var {x01 x02 x03 x04} into x0;
optn = {1 0};
con = {.4001 .48 1.e-6 0.05,
         .     .     .  80  };
call nlpnms(rc,xres,"f_GF4",x0,optn,con,,,,"g_GF4"); /* Zweiter Durchlauf mit */
xopt = xres`; fopt = f_GF4(xopt);                    /* geaendertem Startwert */
close startval;

edit para var {gf4p};
gf4p = nullmasse;
replace point 1;
do i = 1 to 4;
gf4p = xopt[i];
replace point (i + 1);
end;
gf4p = fopt;
replace point 6;
close para;

edit startval var {x01 x02 x03 x04};
if xopt[1] > 100 then x01 = 10;
replace;
x04 = xopt[4];
replace;
close startval;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der GF-Momente                                                                      */
/*------------------------------------------------------------------------------------------------*/

edit moments var {gf4m};

if nullmasse >= 0.5 then gf4m = 0;
else
gf4m = (finv((0.5 - nullmasse)/(1 - nullmasse),2*xopt[1],2*xopt[2])##(1/xopt[4]))/xopt[3];
replace point 5;

if nullmasse >= 0.75 then gf4m = 0;
else do;
h1 = (finv((0.75 - nullmasse)/(1 - nullmasse),2*xopt[1],2*xopt[2])##(1/xopt[4]))/xopt[3];
if nullmasse >= 0.25 then gf4m = h1;
else do;
h2 = (finv((0.25 - nullmasse)/(1 - nullmasse),2*xopt[1],2*xopt[2])##(1/xopt[4]))/xopt[3];
gf4m = h1 - h2;
end;
end;
replace point 6;

if xopt[2] * xopt[4] > 1 then do;
gf4m = (1 - nullmasse) * (xopt[2] / xopt[1])##(1 / xopt[4]) * gamquot(xopt[1], xopt[4]) * 
gamquot(xopt[2], - xopt[4]) / xopt[3];
if gf4m = 0 then gf4m = .;
replace point 1;
end;

if xopt[2] * xopt[4] > 2 then do; 
gf4m = (1 - nullmasse) * (xopt[2] / xopt[1])##(2 / xopt[4]) * (gamquot(xopt[1], xopt[4] / 2) *
       gamquot(xopt[2], - xopt[4] / 2) - (1 - nullmasse) * (gamquot(xopt[1], xopt[4]) * gamquot(xopt[2],
	   - xopt[4]))##2) / xopt[3]##2; 
if gf4m = 0 then gf4m = .;
replace point 4;
gf4m = sqrt(gf4m);
if gf4m = 0 then gf4m = .;
replace point 2;
end;

if xopt[2] * xopt[4] > 3 then do;
if (xopt[2] / xopt[1])##(3 / xopt[4]) > 1e150 | gamquot(xopt[1], xopt[4] / 3) > 1e150 then gf4m = .;
else do;
gf4m = (1 - nullmasse)##3 * ((xopt[2] / xopt[1])##(3 / xopt[4]) * gamquot(xopt[1], xopt[4] / 3) * 
       gamquot(xopt[2], - xopt[4] / 3) / xopt[3]##3 - 3 * gf4m##2 * 
       (xopt[2] / xopt[1])##(1 / xopt[4]) * gamquot(xopt[1], xopt[4]) * gamquot(xopt[2],
       - xopt[4]) / xopt[3] - ((xopt[2] / xopt[1])##(1 / xopt[4]) * gamquot(xopt[1], xopt[4])
       * gamquot(xopt[2], - xopt[4]) / xopt[3])##3) / gf4m##3;
end; 
if gf4m = 0 then gf4m = .;
replace point 3;
end;
close moments; 

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Kolmogorov-Smirnov-Statistik zwischen Daten und angepasster GF                  */
/*------------------------------------------------------------------------------------------------*/

zaehler = 0; z3 = 0; 
do i = n1 to 2 by -1;
   temp = daten[1,i];
   temp2 = daten[1,i - 1];
   if temp = temp2 then zaehler = zaehler + 1;
      else do;
      a = h_GF4(temp);
      z1 = abs(a - (daten[3,i + zaehler]));
      z2 = abs(a - (daten[3,i - 1]));
      z3 = max(z1, z2, z3);
      zaehler = 0;
      end;
end;
temp = daten[1,1];
a = h_GF4(temp);
z1 = abs(a - (daten[3,1 + zaehler]));
z2 = abs(a);
z3 = max(z1, z2, z3);

edit para var {gf4p};
gf4p = (1 - nullmasse) * z3;
replace point 7;
gf4p = .;
replace point 8;
gf4p = .;
replace point 9;
gf4p = fopt;
close para;

edit para var {exp1p};
exp1p = 2 * (gf4p - exp1p);
replace point 8;
if exp1p > 0 then exp1p = 1 - probchi(exp1p, 2);
else exp1p = 1;
replace point 9;
close para;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der GF-Quantile                                                                     */
/*------------------------------------------------------------------------------------------------*/

edit quant var {gf4q};
do i=1 to 99;
t  = i*s; u = floor(t);
if u < n2 * nullmasse then gf4q = 0;
else
gf4q = (finv((i*0.01 - nullmasse)/(1 - nullmasse),2*xopt[1],2*xopt[2])##(1/xopt[4]))/xopt[3];
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {gfvt};
if auspr_vektor[1] = 0 then do;
gfvt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * (probf((xopt[3] * (auspr_vektor[1] + auspr_vektor[2])
/ 2)##xopt[4], 2 * xopt[1], 2 * xopt[2]));
replace point 1;
do i=2 to versch - 1;
gfvt = (1 - haeuf_vektor[2]) * (probf((xopt[3] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[4],
2 * xopt[1], 2 * xopt[2]) - probf((xopt[3] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[4], 
2 * xopt[1], 2 * xopt[2]));
replace point i;
end;
gfvt = (1 - haeuf_vektor[2]) * (1 - probf((xopt[3] * (auspr_vektor[versch - 1] + auspr_vektor[versch])
/ 2)##xopt[4], 2 * xopt[1], 2 * xopt[2]));
replace point versch;
end;
else do;
gfvt = probf((xopt[3] * (auspr_vektor[1] + auspr_vektor[2]) / 2)##xopt[4], 2 * xopt[1], 2 * xopt[2]);
replace point 1;
do i=2 to versch - 1;
gfvt = probf((xopt[3] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[4], 2 * xopt[1], 2 * xopt[2])
    - probf((xopt[3] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[4], 2 * xopt[1], 2 * xopt[2]);
replace point i;
end;
gfvt = 1 - probf((xopt[3] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2)##xopt[4], 2 * 
xopt[1], 2 * xopt[2]);
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/
/* Optimierung der LN2-Parameter                                                                  */
/*------------------------------------------------------------------------------------------------*/

p = 2;
use startval;
read all var {x03 x04} into x0;
optn = {1 0};
con = {1.e-6 1.e-6,
         .     .   };
call nlpnms(rc,xres,"f_LN2",x0,optn,con,,,,"g_LN2");
xopt = xres`; fopt = f_LN2(xopt);
close startval;

edit para var {ln2p};
ln2p = nullmasse;
replace point 1;
ln2p = xopt[1];
replace point 4;
ln2p = - log(ln2p);
replace point 10;
ln2p = xopt[2];
replace point 5;
ln2p = 1/ln2p;
replace point 11;
ln2p = fopt;
replace point 6;
ln2p = 2 * (gf4p - ln2p);
replace point 8;
if ln2p > 0 then ln2p = 1 - probchi(ln2p, 2);
else ln2p = 1;
replace point 9;
close para;

/*------------------------------------------------------------------------------------------------*/
/*  Berechnung der LN-Momente                                                                     */
/*------------------------------------------------------------------------------------------------*/

edit moments var {ln2m};
ln2m = (1 - nullmasse) * exp(1 / (2 * xopt[2] * xopt[2])) / xopt[1];
replace point 1;
ln2m = (1 - nullmasse) * ((exp(2 / (xopt[2] * xopt[2])) - (1 - nullmasse) 
* exp(1 / (xopt[2] * xopt[2]))) / (xopt[1] * xopt[1]));
replace point 4;
ln2m = sqrt(ln2m);
replace point 2;
ln2m = (1 - nullmasse)##3 * (exp(9 / (2 * xopt[2]##2)) - 3 * (exp(2 / xopt[2]##2) - exp(1 / xopt[2]##2))
* exp(1 / (2 * xopt[2]##2)) - exp(3 / (2 * xopt[2]##2))) / (xopt[1]##3 * ln2m##3);
replace point 3;
if nullmasse >= 0.5 then ln2m = 0;
else
ln2m = exp(probit((0.5 - nullmasse)/(1 - nullmasse))/xopt[2])/xopt[1];
replace point 5;
if nullmasse >= 0.75 then ln2m = 0;
else do;
h1 = exp(probit((0.75 - nullmasse)/(1 - nullmasse))/xopt[2])/xopt[1];
if nullmasse >= 0.25 then ln2m = h1;
else do;
h2 = exp(probit((0.25 - nullmasse)/(1 - nullmasse))/xopt[2])/xopt[1];
ln2m = h1 - h2;
end;
end;
replace point 6;
close moments;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der LN-Quantile                                                                     */
/*------------------------------------------------------------------------------------------------*/

edit quant var {ln2q};
do i=1 to 99;
t  = i*s; u = floor(t);
***JH: <;
if u <= n2 * nullmasse then ln2q = 0;
else 
ln2q = exp(probit((i*0.01 - nullmasse)/(1 - nullmasse))/xopt[2])/xopt[1];
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {lnvt};
if auspr_vektor[1] = 0 then do;
lnvt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * (probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[1] 
+ auspr_vektor[2]) / 2)));
replace point 1;
do i=2 to versch - 1;
lnvt = (1 - haeuf_vektor[2]) * (probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[i + 1] + auspr_vektor[i])
/ 2)) - probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[i] + auspr_vektor[i - 1]) / 2)));
replace point i;
end;
lnvt = (1 - haeuf_vektor[2]) * (1 - probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[versch - 1] 
+ auspr_vektor[versch]) / 2)));
replace point versch;
end;
else do;
lnvt = probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[1] + auspr_vektor[2]) / 2));
replace point 1;
do i=2 to versch - 1;
lnvt = probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[i + 1] + auspr_vektor[i]) / 2)) - probnorm(xopt[2] 
* log(xopt[1] * (auspr_vektor[i] + auspr_vektor[i - 1]) / 2));
replace point i;
end;
lnvt = 1 - probnorm(xopt[2] * log(xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2));
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/
/* Optimierung der Wei2-Parameter                                                                 */
/*------------------------------------------------------------------------------------------------*/

p = 2;
use startval;
read all var {x03 x04} into x0;
optn = {1 0};
con = {1.e-6 0.077,
         .     .   };
call nlpnms(rc,xres,"f_wei2",x0,optn,con,,,,"g_wei2");
xopt = xres`; fopt = f_wei2(xopt);
close startval;

edit para var {wei2p};
wei2p = nullmasse;
replace point 1;
wei2p = xopt[1];
replace point 4;
wei2p = 1/wei2p;
replace point 11;
wei2p = xopt[2];
replace point 5;
replace point 10;
wei2p = fopt;
replace point 6;
wei2p = 2 * (gf4p - wei2p);
replace point 8;
if wei2p > 0 then wei2p = 1 - probchi(wei2p, 2);
else wei2p = 1;
replace point 9;
close para;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Wei-Momente                                                                     */
/*------------------------------------------------------------------------------------------------*/

edit moments var {wei2m};
wei2m = (1 - nullmasse) * gamma(1 + 1 / xopt[2]) / xopt[1];
replace point 1;
wei2m = (1 - nullmasse) * (gamma(1 + 2 / xopt[2]) - (1 - nullmasse) * gamma(1 + 1 / xopt[2])##2) / 
(xopt[1] * xopt[1]);
replace point 4;
wei2m = sqrt(wei2m);
replace point 2;
wei2m = (1 - nullmasse)##3 * (gamma(1 + 3 / xopt[2]) - 3 * (gamma(1 + 2 / xopt[2]) - gamma(1 + 1 / 
        xopt[2])##2) * gamma(1 + 1 / xopt[2]) - (gamma(1 + 1 / xopt[2]))##3) / (xopt[1]##3 
        * wei2m##3);
replace point 3;
if nullmasse >= 0.5 then wei2m = 0;
else
wei2m = (- log(1 - (0.5 - nullmasse) / (1 - nullmasse))) ## (1 / xopt[2]) / xopt[1];
replace point 5;
if nullmasse >= 0.75 then wei2m = 0;
else do;
h1 = (- log(1 - (0.75 - nullmasse) / (1 - nullmasse))) ## (1 / xopt[2]) / xopt[1];
if nullmasse >= 0.25 then wei2m = h1;
else do;
h2 = (- log(1 - (0.25 - nullmasse) / (1 - nullmasse))) ## (1 / xopt[2]) / xopt[1];
wei2m = h1 - h2;
end;
end;
replace point 6;
close moments;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Weibull-Quantile                                                                */
/*------------------------------------------------------------------------------------------------*/

edit quant var {wei2q};
do i=1 to 99;
t  = i*s; u = floor(t);
if u < n2 * nullmasse then wei2q = 0;
else 
wei2q = (- log(1 - (i * 0.01 - nullmasse) / (1 - nullmasse))) ## (1 / xopt[2]) / xopt[1];
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {weivt};
if auspr_vektor[1] = 0 then do;
weivt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * (1 - exp( - (xopt[1] * (auspr_vektor[1] 
+ auspr_vektor[2]) / 2)##xopt[2]));
replace point 1;
do i=2 to versch - 1;
weivt = (1 - haeuf_vektor[2]) * (exp( - (xopt[1] * (auspr_vektor[i - 1] + auspr_vektor[i]) 
/ 2)##xopt[2]) - exp( - (xopt[1] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2]));
replace point i;
end;
weivt = (1 - haeuf_vektor[2]) * (exp( - (xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) 
/ 2)##xopt[2]));
replace point versch;
end;
else do;
weivt = 1 - exp( - (xopt[1] * (auspr_vektor[1] + auspr_vektor[2]) / 2)##xopt[2]);
replace point 1;
do i=2 to versch - 1;
weivt = exp( - (xopt[1] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[2]) 
- exp( - (xopt[1] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2]);
replace point i;
end;
weivt = exp( - (xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2)##xopt[2]);
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/
/* Optimierung der Gam2-Parameter                                                                 */                 
/*------------------------------------------------------------------------------------------------*/

p = 2;
use startval;
read all var {x01 x03} into x0; 
optn = {1 0};
con = {1.e-6 1.e-6,
         .     .   };
call nlpnms(rc,xres,"f_Gam2 ",x0,optn,con,,,,"g_Gam2");
xopt = xres`; fopt = f_Gam2(xopt);
close startval;

edit para var {gam2p};
gam2p = nullmasse;
replace point 1;
gam2p = xopt[1];
replace point 2;
replace point 10;
gam2p = xopt[2];
replace point 4;
gam2p = 1 / (xopt[1]*xopt[2]);
replace point 11;
gam2p = fopt;
replace point 6;
gam2p = 2 * (gf4p - gam2p);
replace point 8;
if gam2p > 0 then gam2p = 1 - probchi(gam2p, 2);
else gam2p = 1;
replace point 9;
close para;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Gam-Momente                                                                     */
/*------------------------------------------------------------------------------------------------*/

edit moments var {gam2m};
gam2m = (1 - nullmasse) / xopt[2];
replace point 1;
gam2m = (1 - nullmasse) * (1 + nullmasse * xopt[1]) / (xopt[1] * xopt[2] * xopt[2]);
replace point 4;
gam2m = sqrt(gam2m);
replace point 2;
gam2m = 2 * (1 - nullmasse)##3 / (xopt[1]##2 * xopt[2]##3 * gam2m##3);
replace point 3;
if nullmasse >= 0.5 then gam2m = 0;
else
gam2m = gaminv((0.5 - nullmasse) / (1 - nullmasse), xopt[1]) / ( xopt[2] * xopt[1]);
replace point 5;
if nullmasse >= 0.75 then gam2m = 0;
else do;
h1 = gaminv((0.75 - nullmasse) / (1 - nullmasse), xopt[1]) / ( xopt[2] * xopt[1]);
if nullmasse >= 0.25 then gam2m = h1;
else do;
h2 = gaminv((0.25 - nullmasse) / (1 - nullmasse), xopt[1]) / ( xopt[2] * xopt[1]);
gam2m = h1 - h2;
end;
end;
replace point 6;
close moments;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der Gam2-Quantile                                                                   */
/*------------------------------------------------------------------------------------------------*/

edit quant var {gam2q};
do i=1 to 99;
t  = i*s; u = floor(t);
if u < n2 * nullmasse then gam2q = 0;
else 
gam2q = gaminv((i * 0.01 - nullmasse) / (1 - nullmasse), xopt[1]) / ( xopt[2] * xopt[1]);
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {gamvt};
if auspr_vektor[1] = 0 then do;
gamvt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * (probgam(xopt[1] * xopt[2] * (auspr_vektor[1] 
+ auspr_vektor[2]) / 2, xopt[1]));
replace point 1;
do i=2 to versch - 1;
gamvt = (1 - haeuf_vektor[2]) * (probgam(xopt[1] * xopt[2] * (auspr_vektor[i] + auspr_vektor[i + 1]) 
/ 2, xopt[1]) - probgam(xopt[1] * xopt[2] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2, xopt[1]));
replace point i;
end;
gamvt = (1 - haeuf_vektor[2]) * (1 - probgam(xopt[1] * xopt[2] * (auspr_vektor[versch - 1] 
+ auspr_vektor[versch]) / 2, xopt[1]));
replace point versch;
end;
else do;
gamvt = probgam(xopt[1] * xopt[2] * (auspr_vektor[1] + auspr_vektor[2]) / 2, xopt[1]);
replace point 1;
do i=2 to versch - 1;
gamvt = probgam(xopt[1] * xopt[2] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2, xopt[1]) - 
probgam(xopt[1] * xopt[2] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2, xopt[1]);
replace point i;
end;
gamvt = 1 - probgam(xopt[1] * xopt[2] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2, xopt[1]);
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/
/* Optimierung der LL2-Parameter                                                                  */                 
/*------------------------------------------------------------------------------------------------*/

p = 2;
use startval;
read all var {x03 x04} into x0;
optn = {1 0};
con = {1.e-6 1.e-6,
         .   80   };
call nlpnms(rc,xres,"f_LL2",x0,optn,con,,,,"g_LL2");
xopt = xres`; fopt = f_LL2(xopt);
close startval;

edit para var {ll2p};
ll2p = nullmasse;
replace point 1;
ll2p = xopt[1];
replace point 4;
ll2p = 1/ll2p;
replace point 11;
ll2p = xopt[2];
replace point 5;
replace point 10;
ll2p = fopt;
replace point 6;
ll2p = 2 * (gf4p - ll2p);
replace point 8;
if ll2p > 0 then ll2p = 1 - probchi(ll2p, 2);
else ll2p = 1;
replace point 9;
close para;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der loglog-Momente                                                                  */
/*------------------------------------------------------------------------------------------------*/

edit moments var {ll2m};
if xopt[2] > 1 then do;
ll2m = (1 - nullmasse) * gamma(1 + 1 / xopt[2]) * gamma(1 - 1 / xopt[2]) / xopt[1];
replace point 1;
end;
if xopt[2] > 2 then do;
ll2m = (1 - nullmasse) * (gamma(1 + 2 / xopt[2]) * gamma(1 - 2 / xopt[2]) - (1 - nullmasse) 
* (gamma(1 + 1 / xopt[2]) * gamma(1 - 1 / xopt[2]))##2) / (xopt[1] * xopt[1]);
replace point 4;
ll2m = sqrt(ll2m);
replace point 2;
end;
if xopt[2] > 3 then do;
ll2m = (1 - nullmasse)##3 * (gamma(1 + 3 / xopt[2]) * gamma(1 - 3 / xopt[2]) - 3 * (gamma(1 + 2 / 
xopt[2]) * gamma(1 - 2 / xopt[2]) - (gamma(1 + 1 / xopt[2]) * gamma(1 - 1 / xopt[2]))##2) * 
gamma(1 + 1 / xopt[2]) * gamma(1 - 1 / xopt[2]) - (gamma(1 + 1 / xopt[2]) * gamma(1 - 1 / 
xopt[2]))##3) / (xopt[1]##3 * ll2m##3);
replace point 3; 
end;
if nullmasse >= 0.5 then ll2m = 0;
else
ll2m = ((0.5 - nullmasse) / (1 - 0.5)) ## (1 / xopt[2]) / xopt[1];
replace point 5;
if nullmasse >= 0.75 then ll2m = 0;
else do;
h1 = ((0.75 - nullmasse) / (1 - 0.75)) ## (1 / xopt[2]) / xopt[1];
if nullmasse >= 0.25 then ll2m = h1;
else do;
h2 = ((0.25 - nullmasse) / (1 - 0.25)) ## (1 / xopt[2]) / xopt[1];
ll2m = h1 - h2;
end;
end;
replace point 6;
close moments;

/*------------------------------------------------------------------------------------------------*/
/* Berechnung der loglog-Quantile                                                                 */
/*------------------------------------------------------------------------------------------------*/

edit quant var {ll2q};
do i=1 to 99;
t  = i*s; u = floor(t);
if u < n2 * nullmasse then ll2q = 0;
else 
ll2q = ((i * 0.01 - nullmasse) / (1 - i * 0.01)) ## (1 / xopt[2]) / xopt[1];
replace point i;
end;
close quant;

if versch < 21 then do;
edit empquant var {llvt};
if auspr_vektor[1] = 0 then do;
llvt = haeuf_vektor[2] + (1 - haeuf_vektor[2]) * ((xopt[1] * (auspr_vektor[1] + auspr_vektor[2]) 
/ 2)##xopt[2] / (1 + ((xopt[1] * (auspr_vektor[1] + auspr_vektor[2]) / 2)##xopt[2])));
replace point 1;
do i=2 to versch - 1;
llvt = (1 - haeuf_vektor[2]) * ((xopt[1] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2] / 
(1 + ((xopt[1] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2])) - (xopt[1] * 
(auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[2] / 
(1 + ((xopt[1] * (auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[2])));
replace point i;
end;
llvt = (1 - haeuf_vektor[2]) * (1 - (xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) 
/ 2)##xopt[2] / (1 + ((xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2)##xopt[2])));
replace point versch;
end;
else do;
llvt = (xopt[1] * (auspr_vektor[1] + auspr_vektor[2]) / 2)##xopt[2] / (1 + ((xopt[1] 
* (auspr_vektor[1] + auspr_vektor[2]) / 2)##xopt[2]));
replace point 1;
do i=2 to versch - 1;
llvt = (xopt[1] * (auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2] / (1 + ((xopt[1] * 
(auspr_vektor[i] + auspr_vektor[i + 1]) / 2)##xopt[2])) - (xopt[1] * 
(auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[2] / (1 + ((xopt[1] * 
(auspr_vektor[i - 1] + auspr_vektor[i]) / 2)##xopt[2]));
/*if &schranke > 0 then llvt = (&schranke * llvt) / (1 + llvt);*/
replace point i;
end;
llvt = 1 - (xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2)##xopt[2] / 
(1 + ((xopt[1] * (auspr_vektor[versch - 1] + auspr_vektor[versch]) / 2)##xopt[2]));
replace point versch;
end;
end;
close empquant;

/*------------------------------------------------------------------------------------------------*/ 
/* Ausgabe: einerseits als Output-Datei mit Ergebnissen und Grafiken,                             */
/* andererseits als ASCI-Datei zur Weiterverarbeitung (Einlesen in RefXP)                         */
/*------------------------------------------------------------------------------------------------*/

if &wertstrat1 ^= 69 then do;
edit empirie2;
read all var _num_ into empmat where (sex2 = mannfrau & &zusatzstratifizierung = zusatz);
allobs = empmat[+,4];
ngruppen = nrow(empmat);
geschl_alpha = j(ngruppen,1,"FEHLER!");
do i=1 to ngruppen;
if empmat[i,2] = 1 then geschl_alpha[i,1] = "M";
if empmat[i,2] = 2 then geschl_alpha[i,1] = "F";
end;
end;

else do;
edit empirie2_alle;
read all var _num_ into empmat where (&zusatzstratifizierung = zusatz);
allobs = empmat[+,3];
ngruppen = nrow(empmat);
geschl_alpha = j(ngruppen,1,"A");
end;

edit empalt;
read all var _num_ into alter_maxmin;
altermin = alter_maxmin[,><];
altermax = alter_maxmin[,<>];
if mannfraumax = 1 then 
file "&ausgabe";
else do;
if mannfrau = 1 then file "&ausgabemann";
if mannfrau = 2 then file "&ausgabefrau";
end;

if group = 1 then do;
if anz_untergr = 1 then do;

ref1 = {"//**************************************************//",
"//OUTPUT FOR REFVALUE",
"//DATE=&sysdate9",
"//TIME=&systime",
"//DIR=c:\refval\",
"//FILE=&quelldatei",
"//***************************************************//",
" ",
"TOPIC=&headline;//",
"PARAMETER=&topic;//",
"DATA SOURCE=&quelle;",
"DATA DIR=&zielverz;"};
do i=1 to 12;
put (ref1[i,1]);
end;
end;

else do;

put / "//**************************************************//" /
"//OUTPUT FOR REFVALUE" /
"//DATE=&sysdate9" /
"//TIME=&systime" /
"//DIR=c:\refval\" /
"//FILE=&quelldatei" /
"//SUBGROUP=" zusatz /
"//***************************************************//" /
" " /
"TOPIC=&headline;//" /
"PARAMETER=&topic;//" /
"DATA SOURCE=&quelle;" /
"DATA DIR=&zielverz;";
end;

if mannfraumax = 1 then put "DATA FILE=&zieldat;";
else do; 
if mannfrau = &malenumber then put "DATA FILE=&zieldatmann;";
if mannfrau = &femalenumber then put "DATA FILE=&zieldatfrau;";
end;
put "AGE GROUPS=" altermin";" altermax";";
if &wertstrat1 ^= 69 then do;
if mannfrau = &malenumber then do;
                             put "SEX GROUPS=M;";
							 geschlecht = "Male";
							 end;
if mannfrau = &femalenumber then do;
                             put "SEX GROUPS=F;";
							 geschlecht = "Female";
							 end;
end;
if &wertstrat1 = 69 then do;
                             put "SEX GROUPS=ALL;";
							 geschlecht = "Female and male";
							 end;
put "NGROUPS=" ngruppen ";" ;

/*------------------------------------------------------------------------------------------------*/
/* Ausgabe des Infoblocks                                                                         */
/*------------------------------------------------------------------------------------------------*/

put ' ' / 'INFO={' / "&beschreibung" / '.';
%schreibe(%str(Headline),&headlineganz);
%schreibe(%str(Topic),&topicganz);
%schreibe(%str(Variable),&paramganz);
%schreibe(%str(Unit),&unit);
%schreibe(%str(Reference interval),&ref_interval);
%schreibe(%str(Question / Item),&question);
%schreibe(%str(Algorithm),&algorithm);
put 'Sex' ' | ' geschlecht ;
put 'Age range' ' | ' altermin '   -' altermax;
put 'Effective sample size' ' |' allobs;
%schreibe(%str(Data source),&quelle);
%schreibe(%str(Survey period),&periode);
%schreibe(%str(Reference),&referenz);
%schreibe(%str(Data owner),&owner);
%schreibe(%str(Data analysed by),&analyser);
%schreibe(%str(Data analysis),&analysis);
%schreibe(%str(Published in),&publish);
%schreibe(%str(Republished in), &republished);
%schreibe(%str(Restrictions), &restrictions);
%schreibe(%str(Comments), &comment);
%schreibe(%str(Other),&other);
%schreibe(%str(Additional keywords),&keywords);
put '}'; 

put ' ' / 'VARLABELS=' '{' /
'SEX=' " sex" "," /
"AGEGRP= age group" "," /
"AGEMIN= minimal age in group" "," /
"AGEMAX= maximal age in group" "," /
"NOBS= number of observations" "," /
"MEAN= arithmetic mean" "," /
"STDDEV= standard deviation" "," /
"SKEWNESS= skewness" "," /
"VARIANCE= variance" "," /
"MAXIMUM= maximal value" "," /
"MINIMUM= minimal value" "," /
"MEDIAN= median" "," /
"IQUART= interquartile range" "," /
"}";

put " " / "DATA={";
if &wertstrat1 = 69 then do;
put "AGEGRP,SEX,NOBS,MEAN,STDDEV,SKEWNESS,VARIANCE,MAXIMUM,MINIMUM,MEDIAN,IQUART";
do i=1 to ngruppen;
put (empmat[i,2]) "," (geschl_alpha[i]) "," (empmat[i,3]) "," (empmat[i,4]) "," (empmat[i,5]) ","
(empmat[i,6]) "," (empmat[i,7]) "," (empmat[i,8]) "," (empmat[i,10]) "," (empmat[i,9]) ","
(empmat[i,11]);
end;
end;
 
if &wertstrat1 ^= 69 then do;
put "AGEGRP,SEX,NOBS,MEAN,STDDEV,SKEWNESS,VARIANCE,MAXIMUM,MINIMUM,MEDIAN,IQUART";
do i=1 to ngruppen;
put (empmat[i,3]) "," (geschl_alpha[i]) "," (empmat[i,4]) "," (empmat[i,5]) "," (empmat[i,6]) ","
(empmat[i,7]) "," (empmat[i,8]) "," (empmat[i,9]) "," (empmat[i,11]) "," (empmat[i,10]) ","
(empmat[i,12]);
end;
end;
put "}";

end;

/*------------------------------------------------------------------------------------------------*/
/* Beginn der Ausgabe der Anpassungsparameter fr spezielle Gruppe                                */
/*------------------------------------------------------------------------------------------------*/

if ngruppen > 1 then put " " / " " / "GROUP=" group ";";
else put " " / " " / "GROUP=1;"; 
put "DATA2={" / "GRP,AGEMIN,AGEMAX,AGEMID,GEOMMEAN,GEOMSTDDEV";

if &wertstrat1 ^= 69 then do;
use order;
read all var {&alter} into alter_gruppe where
(&alter < 1000 & sex2 = mannfrau & alt2 = group & &analyse > . & &zusatzstratifizierung = zusatz);
end;

else do;
use order2;
read all var {&alter} into alter_gruppe where
(&alter < 1000 & alt2 = group & &zusatzstratifizierung = zusatz);
end;

age_min = alter_gruppe[><,]; age_max = alter_gruppe[<>,]; age_mid = (age_min + age_max) / 2;
Agemin = char(age_min); Agemax = char(age_max);
if alldaten[1,><] > 0 then do; 
ln_daten = log(alldaten[1,]);
d = exp(ln_daten[:]);
e = exp(sqrt((ln_daten - repeat(log(d),1,n2))[##] / (n2 - 1)));
put group "," age_min "," age_max "," age_mid "," d "," e;
end;
else put group "," age_min "," age_max "," age_mid "," "nd" "," "nd";
put "}";

/*------------------------------------------------------------------------------------------------*/
/* Ausgabe der empfohlenen Verteilungen und der geschaetzten Parameter                            */
/*------------------------------------------------------------------------------------------------*/

ref4 = {" ",
"GENERALF={"};
do i=1 to 2;
put (ref4[i,1]);
end;
put ' ' / 'TYPE = GeneralF,';
put 'RANK = 0,';

edit para var {gf4p ln2p wei2p gam2p exp1p ll2p};
read all var {gf4p ln2p wei2p gam2p exp1p ll2p} into paramatrix;
mattrib  paramatrix format=5.3;
tgfuntermatrix = paramatrix[1:5,1]; gfuntermatrix = char(tgfuntermatrix`);
tunterparamatrix = paramatrix[,2:6]; unterparamatrix = tunterparamatrix`;
close para; 
create raenge_para var{v0 v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11};
do i=1 to 5;
v0 = i; v1 = (unterparamatrix[i,1]); v2 = (unterparamatrix[i,2]); v3 = (unterparamatrix[i,3]);
v4 = (unterparamatrix[i,4]); v5 = (unterparamatrix[i,5]); v6 = (unterparamatrix[i,6]);
v7 = (unterparamatrix[i,7]); v8 = (unterparamatrix[i,8]); v9 = (unterparamatrix[i,9]);
v10 = (unterparamatrix[i,10]); v11 = (unterparamatrix[i,11]);
append;
end;
close;
sort raenge_para by descending v9 v8;

edit raenge_para var {v0 v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11};
read all var {v0 v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11} into rang_para_matrix;
close raenge_para;

if versch < 21 then do;
edit empquant var {auspraegung haeufigkeit gfvt lnvt weivt gamvt expvt llvt};
read all var {auspraegung haeufigkeit gfvt lnvt weivt gamvt expvt llvt} into qumat;
end;
close empquant;
if versch >= 21 then do;
edit quant var {empq gf4q ln2q wei2q gam2q exp1q ll2q};
read all var {empq gf4q ln2q wei2q gam2q exp1q ll2q} into qumat;
end;
close quant;

create abstand var {x fx};
n = 100000; nr = nrow(qumat);
c = qumat[nr,1]; 
do i=1 to n;
x = 0;
fx = 0;
append;
end;
close abstand;

reset noname; 
put 'PT=' (paramatrix[1,1]) ',' (paramatrix[2,1]) ',' (paramatrix[3,1]) ',' (paramatrix[4,1]) ',' 
(paramatrix[5,1]) ',';
put 'KS=' (paramatrix[7,1]) ',';
put '// Kolmogorov-Smirnov-Abstand von GF zur Empirie' / " ";
gfpara1 = paramatrix[1,1]; gfpara2 = paramatrix[2,1]; gfpara3 = paramatrix[3,1]; 
gfpara4 = paramatrix[4,1]; gfpara5 = paramatrix[5,1];
lnpara1 = paramatrix[1,2]; lnpara2 = paramatrix[4,2]; lnpara3 = paramatrix[5,2];
lnstandard1 = paramatrix[10,2]; lnstandard2 = paramatrix[11,2];
weipara1 = paramatrix[1,3]; weipara2 = paramatrix[4,3]; weipara3 = paramatrix[5,3];
weistandard1 = paramatrix[10,3]; weistandard2 = paramatrix[11,3];
gampara1 = paramatrix[1,4]; gampara2 = paramatrix[2,4]; gampara3 = paramatrix[4,4];
gamstandard1 = paramatrix[10,4]; gamstandard2 = paramatrix[11,4];
exppara1 = paramatrix[1,5]; exppara2 = paramatrix[4,5];
llpara1 = paramatrix[1,6]; llpara2 = paramatrix[4,6]; llpara3 = paramatrix[5,6];
llstandard1 = paramatrix[10,6]; llstandard2 = paramatrix[11,6];

options nonotes;
Graf_Para_Best = j(1,6,0);
do k=1 to 5;
verteilungsnr = rang_para_matrix[k,1];

if verteilungsnr = 1 then do;
put ' ' / 'TYPE = Lognormal,' / 'RANK = ' k ','/ 'PT=' lnpara1 ',' lnpara2 ',' lnpara3 ','
/ 'FORM=' lnpara1 ',' lnstandard1 ',' lnstandard2 ',';
%let untermodell = probnorm(lnpara3 * log(lnpara2 * x));
edit abstand var {x fx};
do i=1 to n;
x = c * i / n;
fx = abs(probf((gfpara4 * x)##gfpara5, 2 * gfpara2, 2 * gfpara3) - (&untermodell));
replace point i;
end;
close;
sort abstand by fx;
use abstand;
summary var {fx} stat{max} opt{save noprint};
close abstand;
put 'AP=' (fx - nullmasse * fx) ","/ '// Kolmogorov-Smirnov-Abstand vom Untermodell zur GF';
if verteilungsnr = rang_para_matrix[1,1] then do;
Graf_Para_Best[1] = lnpara1; 
Graf_Para_Best[2] = lnpara2; 
Graf_Para_Best[3] = lnpara3; 
Graf_Para_Best[4] = lnstandard1; 
Graf_Para_Best[5] = lnstandard2; 
Graf_Para_Best[6] = (fx - nullmasse * fx);
end;
end;

else if verteilungsnr = 2 then do;
put ' ' / 'TYPE = Weibull,' / 'RANK = ' k ','/ 'PT=' weipara1 ',' weipara2 ',' weipara3 ','
/ 'FORM=' weipara1 ',' weistandard1 ',' weistandard2 ',';
%let untermodell = 1 - exp(-(weipara2 * x)##weipara3);
edit abstand var {x fx};
do i=1 to n;
x = c * i / n;
fx = abs(probf((gfpara4 * x)##gfpara5, 2 * gfpara2, 2 * gfpara3) - (&untermodell));
replace point i;
end;
close;
sort abstand by fx;
use abstand;
summary var {fx} stat{max} opt{save noprint};
close abstand;
put 'AP=' (fx - nullmasse * fx) ","/ '// Kolmogorov-Smirnov-Abstand vom Untermodell zur GF';
if verteilungsnr = rang_para_matrix[1,1] then do;
Graf_Para_Best[1] = weipara1; 
Graf_Para_Best[2] = weipara2; 
Graf_Para_Best[3] = weipara3; 
Graf_Para_Best[4] = weistandard1; 
Graf_Para_Best[5] = weistandard2; 
Graf_Para_Best[6] = (fx - nullmasse * fx);
end;
end;

else if verteilungsnr = 3 then do;
put ' ' / 'TYPE = Gamma,' / 'RANK = ' k ','/ 'PT=' gampara1 ',' gampara2 ',' gampara3 ','
/ 'FORM=' gampara1 ',' gamstandard1 ',' gamstandard2 ',';
%let untermodell = probgam(gampara2 * gampara3 * x, gampara2);
edit abstand var {x fx};
do i=1 to n;
x = c * i / n;
fx = abs(probf((gfpara4 * x)##gfpara5, 2 * gfpara2, 2 * gfpara3) - (&untermodell));
replace point i;
end;
close;
sort abstand by fx;
use abstand;
summary var {fx} stat{max} opt{save noprint};
close abstand;
put 'AP=' (fx - nullmasse * fx) ","/ '// Kolmogorov-Smirnov-Abstand vom Untermodell zur GF';
if verteilungsnr = rang_para_matrix[1,1] then do;
Graf_Para_Best[1] = gampara1; 
Graf_Para_Best[2] = gampara2; 
Graf_Para_Best[3] = gampara3; 
Graf_Para_Best[4] = gamstandard1; 
Graf_Para_Best[5] = gamstandard2; 
Graf_Para_Best[6] = (fx - nullmasse * fx);
end;
end;

else if verteilungsnr = 4 then do;
put ' ' / 'TYPE = Exponential,' / 'RANK = ' k ','/ 'PT=' exppara1 ',' exppara2 ','
/ 'FORM=' exppara1 ',' exppara2 ',';
%let untermodell = 1 - exp(-exppara2 * x);
edit abstand var {x fx};
do i=1 to n;
x = c * i / n;
fx = abs(probf((gfpara4 * x)##gfpara5, 2 * gfpara2, 2 * gfpara3) - (&untermodell));
replace point i;
end;
close;
sort abstand by fx;
use abstand;
summary var {fx} stat{max} opt{save noprint};
close abstand;
put 'AP=' (fx - nullmasse * fx) ","/ '// Kolmogorov-Smirnov-Abstand vom Untermodell zur GF';
if verteilungsnr = rang_para_matrix[1,1] then do;
Graf_Para_Best[1] = exppara1; 
Graf_Para_Best[2] = exppara2; 
Graf_Para_Best[3] = .; 
Graf_Para_Best[4] = exppara2; 
Graf_Para_Best[5] = .; 
Graf_Para_Best[6] = (fx - nullmasse * fx);
end;
end;

else if verteilungsnr = 5 then do;
put ' ' / 'TYPE = Loglogistisch,' / 'RANK = ' k ','/ 'PT=' llpara1 ',' llpara2 ',' llpara3 ','
/ 'FORM=' llpara1 ',' llstandard1 ',' llstandard2 ',';
%let untermodell = (llpara2 * x)##llpara3 / (1 + (llpara2 * x)##llpara3);
edit abstand var {x fx};
do i=1 to n;
x = c * i / n;
fx = abs(probf((gfpara4 * x)##gfpara5, 2 * gfpara2, 2 * gfpara3) - (&untermodell));
replace point i;
end;
close;
sort abstand by fx;
use abstand;
summary var {fx} stat{max} opt{save noprint};
close abstand;
put 'AP=' (fx - nullmasse * fx) ","/ '// Kolmogorov-Smirnov-Abstand vom Untermodell zur GF';
if verteilungsnr = rang_para_matrix[1,1] then do;
Graf_Para_Best[1] = llpara1; 
Graf_Para_Best[2] = llpara2; 
Graf_Para_Best[3] = llpara3; 
Graf_Para_Best[4] = llstandard1; 
Graf_Para_Best[5] = llstandard2; 
Graf_Para_Best[6] = (fx - nullmasse * fx);
end;
end;

end;
put '}';

Para_Best = char(Graf_Para_Best);
verteilungsnr = rang_para_matrix[1,1]; 
if verteilungsnr = 1 then bestverteilung = "Lognormal";
if verteilungsnr = 2 then bestverteilung = "Weibull";
if verteilungsnr = 3 then bestverteilung = "Gamma"; 
if verteilungsnr = 4 then bestverteilung = "Exponential"; 
if verteilungsnr = 5 then bestverteilung = "Loglogistic";

/*------------------------------------------------------------------------------------------------*/
/* Ausgabe der Quantile (nur in die Datei)                                                        */
/*------------------------------------------------------------------------------------------------*/

if versch < 21 then do;
put ' ' / "FREQ={" / "  VALUE" ' ' "  EMP.FREQ." ' ' "  GF-FIT" ' '   bestverteilung;
nr = nrow(qumat);
do i=1 to nr;
put (qumat[i,1]) '  '  (freq_vektor[i,1]) '  ' (qumat[i,3]) '  ' (qumat[i, verteilungsnr + 3]);
end;
end;

if versch >= 21 then do;
put ' ' / "QUANTILES={" / "QUANTIL" '  ' "EMPIR." '  ' "GENER.F" '  ' bestverteilung;
put 0.01 '  ' (qumat[1,1]) '  ' (qumat[1,2]) '  ' (qumat[1,verteilungsnr + 2]);
put 0.05 '  ' (qumat[5,1]) '  ' (qumat[5,2]) '  ' (qumat[5,verteilungsnr + 2]);
put 0.10 '  ' (qumat[10,1]) '  ' (qumat[10,2]) '  ' (qumat[10,verteilungsnr + 2]);
put 0.15 '  ' (qumat[15,1]) '  ' (qumat[15,2]) '  ' (qumat[15,verteilungsnr + 2]);
put 0.20 '  ' (qumat[20,1]) '  ' (qumat[20,2]) '  ' (qumat[20,verteilungsnr + 2]);
put 0.25 '  ' (qumat[25,1]) '  ' (qumat[25,2]) '  ' (qumat[25,verteilungsnr + 2]);
put 0.30 '  ' (qumat[30,1]) '  ' (qumat[30,2]) '  ' (qumat[30,verteilungsnr + 2]);
put 0.35 '  ' (qumat[35,1]) '  ' (qumat[35,2]) '  ' (qumat[35,verteilungsnr + 2]);
put 0.40 '  ' (qumat[40,1]) '  ' (qumat[40,2]) '  ' (qumat[40,verteilungsnr + 2]);
put 0.45 '  ' (qumat[45,1]) '  ' (qumat[45,2]) '  ' (qumat[45,verteilungsnr + 2]);
put 0.50 '  ' (qumat[50,1]) '  ' (qumat[50,2]) '  ' (qumat[50,verteilungsnr + 2]);
put 0.55 '  ' (qumat[55,1]) '  ' (qumat[55,2]) '  ' (qumat[55,verteilungsnr + 2]);
put 0.60 '  ' (qumat[60,1]) '  ' (qumat[60,2]) '  ' (qumat[60,verteilungsnr + 2]);
put 0.65 '  ' (qumat[65,1]) '  ' (qumat[65,2]) '  ' (qumat[65,verteilungsnr + 2]);
put 0.70 '  ' (qumat[70,1]) '  ' (qumat[70,2]) '  ' (qumat[70,verteilungsnr + 2]);
put 0.75 '  ' (qumat[75,1]) '  ' (qumat[75,2]) '  ' (qumat[75,verteilungsnr + 2]);
put 0.80 '  ' (qumat[80,1]) '  ' (qumat[80,2]) '  ' (qumat[80,verteilungsnr + 2]);
put 0.85 '  ' (qumat[85,1]) '  ' (qumat[85,2]) '  ' (qumat[85,verteilungsnr + 2]);
put 0.90 '  ' (qumat[90,1]) '  ' (qumat[90,2]) '  ' (qumat[90,verteilungsnr + 2]);
put 0.95 '  ' (qumat[95,1]) '  ' (qumat[95,2]) '  ' (qumat[95,verteilungsnr + 2]);
put 0.99 '  ' (qumat[99,1]) '  ' (qumat[99,2]) '  ' (qumat[99,verteilungsnr + 2]);
end;
put '}';
 
/*------------------------------------------------------------------------------------------------*/
/* Ausgabe der Momente (nur in die Datei)                                                         */
/*------------------------------------------------------------------------------------------------*/

edit moments var {empm gf4m ln2m wei2m gam2m exp1m ll2m};
read all var {empm gf4m ln2m wei2m gam2m exp1m ll2m} into momenten_matrix;
momente_bestfit = momenten_matrix[1:6,verteilungsnr + 2];
close moments;

ref7 = {" " " " " " " ",
"MOMENTS={" " " " " " "};
do i=1 to 2;
put (ref7[i,1]) (ref7[i,2]) (ref7[i,3]) (ref7[i,4]);
end;
put "TERM" '      ' "EMPIR." '   ' "GENER.F" '   ' bestverteilung;
a = momenten_matrix[1,1]; b = momenten_matrix[1,2]; c = momente_bestfit[1,1];
put 'MEAN' '      ' a '   ' b '   ' c;
a = momenten_matrix[2,1]; b = momenten_matrix[2,2]; c = momente_bestfit[2,1];
put 'STDDEV' '    ' a '   ' b '   ' c;
a = momenten_matrix[3,1]; b = momenten_matrix[3,2]; c = momente_bestfit[3,1];
put 'SKEWNESS' '  ' a '   ' b '   ' c;
a = momenten_matrix[4,1]; b = momenten_matrix[4,2]; c = momente_bestfit[4,1];
put 'VARIANCE' '  ' a '   ' b '   ' c;
a = momenten_matrix[5,1]; b = momenten_matrix[5,2]; c = momente_bestfit[5,1];
put 'MEDIAN' '    ' a '   ' b '   ' c;
a = momenten_matrix[6,1]; b = momenten_matrix[6,2]; c = momente_bestfit[6,1];
put 'IQUART' '    ' a '   ' b '   ' c / '}';

/*------------------------------------------------------------------------------------------------*/
/* Beginn der Grafikprogrammierung: Legendentext                                                  */
/*------------------------------------------------------------------------------------------------*/

if &wertstrat1 = 69 then geschlechttext = "SEX = FEMALE AND MALE";
else do;
if mannfrau = &malenumber then geschlechttext = "SEX = MALE";
if mannfrau = &femalenumber then geschlechttext = "SEX = FEMALE";
end;

/*------------------------------------------------------------------------------------------------*/
/* Festlegung des Bereichs fuer den Plot der Verteilungsfunktionen                                */
/*------------------------------------------------------------------------------------------------*/

posgewalldaten = alldaten[,loc(alldaten[2,]>0)]; 
nposgew = ncol(posgewalldaten);
zweifach_posgewalldaten = doppelt(t(posgewalldaten)[,1]);
zweifach_emp_vfu = j(2*nposgew,1);
zweifach_emp_vfu[1,1] = 0;
zweifach_emp_vfu[2:2*nposgew-1,1] = doppelt(t(posgewalldaten)[1:nposgew-1,3]);
if &logskala = 1 then lnzw_pos = log(zweifach_posgewalldaten);

if (paramatrix[9,<>] > 0 & paramatrix[9,<>] < 1) then bestpwert = paramatrix[9,<:>];
else bestpwert = paramatrix[8,>:<]; 

temp = group; 
bereich_vfplot = t(j(4,1));
bereich_vfplot[2] = 0;
bereich_vfplot[4] = 1;

if &logskala = 0 then do;

if &wertstrat1 ^= 69 then do;
bereich_vfplot[1] = 0.9 * empmat[temp,11];
bereich_vfplot[3] = 1.1 * empmat[temp,9];
end; 

if &wertstrat1 = 69 then do;
bereich_vfplot[1] = 0.9 * empmat[temp,10];
bereich_vfplot[3] = 1.1 * empmat[temp,8];
end;

end;

else do;

bereich_vfplot[1] = 0.9 * log(empmat[temp,11]);
bereich_vfplot[3] = 1.1 * log(empmat[temp,9]);
end;

/*------------------------------------------------------------------------------------------------*/
/* Simulation der angepassten parametrischen Verteilungen                                         */
/*------------------------------------------------------------------------------------------------*/
 
if bereich_vfplot[1] = 0 then stuetzstellen = do(0.001, 0.999 * bereich_vfplot[3], 0.000999 * 
(bereich_vfplot[3] - 0.001));
else stuetzstellen = do(0.999 * bereich_vfplot[1],0.999 * bereich_vfplot[3],0.001 * (bereich_vfplot[3] 
- bereich_vfplot[1]));
if &logskala = 1 then expon_stuetz = exp(stuetzstellen);
gf_stuetzen = j(1000,1);
ln_stuetzen = j(1000,1);
wei_stuetzen = j(1000,1);
gam_stuetzen = j(1000,1);
exp_stuetzen = j(1000,1);
ll_stuetzen = j(1000,1);

if &logskala = 0 then do;
do i=1 to 1000;
gf_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probf((paramatrix[4,1] * 
stuetzstellen[i])##paramatrix[5,1], 2 * paramatrix[2,1], 2 * paramatrix[3,1]);
ln_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probnorm(paramatrix[5,2] * 
log(paramatrix[4,2] * stuetzstellen[i]));
ll_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (paramatrix[4,6] * 
stuetzstellen[i])##paramatrix[5,6] / (1 + (paramatrix[4,6] * stuetzstellen[i])##paramatrix[5,6]);
exp_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (1 - exp(-paramatrix[4,5] 
* stuetzstellen[i]));
wei_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (1 - exp(-(paramatrix[4,3] 
* stuetzstellen[i])##paramatrix[5,3]));
gam_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probgam(paramatrix[2,4] * paramatrix[4,4] 
* stuetzstellen[i], paramatrix[2,4]);
end;
end;

else do;
do i=1 to 1000;
gf_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probf((paramatrix[4,1] * 
expon_stuetz[i])##paramatrix[5,1], 2 * paramatrix[2,1], 2 * paramatrix[3,1]);
ln_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probnorm(paramatrix[5,2] 
* log(paramatrix[4,2] * expon_stuetz[i]));
ll_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (paramatrix[4,6] 
* expon_stuetz[i])##paramatrix[5,6] / (1 + (paramatrix[4,6] * expon_stuetz[i])##paramatrix[5,6]);
exp_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (1 - exp(-paramatrix[4,5] 
* expon_stuetz[i]));
wei_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * (1 - exp(-(paramatrix[4,3] 
* expon_stuetz[i])##paramatrix[5,3]));
gam_stuetzen[i] = paramatrix[1,1] + (1 - paramatrix[1,1]) * probgam(paramatrix[2,4] * paramatrix[4,4] 
* expon_stuetz[i], paramatrix[2,4]);
end;
end;

/*------------------------------------------------------------------------------------------------*/
/* Erzeugen der Matrix plotwerte,                                                                 */
/* die empirische und theoretische Wahrscheinlichkeiten und Quantile enthaelt                     */
/*------------------------------------------------------------------------------------------------*/

tplotwerte = j(6,nposgew);
tplotwerte[1,] = posgewalldaten[1,];
tplotwerte[2,] = posgewalldaten[3,];

nullzaehler = 0;
do i=1 to nposgew while (tplotwerte[1,i] = 0);
tplotwerte[5,i] = 0;
tplotwerte[6,i] = 0;
nullzaehler = nullzaehler + 1;
end;

do i=nullzaehler + 1 to nposgew - 1;
tplotwerte[3,i] = nullmasse + (1 - nullmasse) * probf((paramatrix[4,1] 
* tplotwerte[1,i])##paramatrix[5,1], 2 * paramatrix[2,1], 2 * paramatrix[3,1]);
if bestpwert = 2 then
tplotwerte[4,i] = nullmasse + (1 - nullmasse) * probnorm(paramatrix[5,2] * log(paramatrix[4,2] 
* tplotwerte[1,i]));
if bestpwert = 3 then   
tplotwerte[4,i] = nullmasse + (1 - nullmasse) * (1 - exp(-(paramatrix[4,3] 
* tplotwerte[1,i])##paramatrix[5,3]));
if bestpwert = 4 then
tplotwerte[4,i] = nullmasse + (1 - nullmasse) * probgam(paramatrix[2,4] * paramatrix[4,4] 
* tplotwerte[1,i], paramatrix[2,4]);
if bestpwert = 5 then
tplotwerte[4,i] = nullmasse + (1 - nullmasse) * (1 - exp(-paramatrix[4,5] * tplotwerte[1,i]));
if bestpwert = 6 then
tplotwerte[4,i] = nullmasse + (1 - nullmasse) * (paramatrix[4,6] * tplotwerte[1,i])##paramatrix[5,6] / 
(1 + (paramatrix[4,6] * tplotwerte[1,i])##paramatrix[5,6]);
end;

do i=nullzaehler + 1 to nposgew - 1;
tplotwerte[5,i] = (finv((tplotwerte[2,i] - nullmasse) / (1 - nullmasse),2*paramatrix[2,1],
2*paramatrix[3,1])##(1/paramatrix[5,1]))/paramatrix[4,1];
if bestpwert = 2 then
tplotwerte[6,i] = exp(probit((tplotwerte[2,i] - nullmasse) / (1 - nullmasse))
/paramatrix[5,2])/paramatrix[4,2]; 
if bestpwert = 3 then
tplotwerte[6,i] = (- log(1 - (tplotwerte[2,i] - nullmasse) / (1 - nullmasse))) ## 
(1 / paramatrix[5,3]) / paramatrix[4,3];
if bestpwert = 4 then
tplotwerte[6,i] = gaminv((tplotwerte[2,i] - nullmasse) / (1 - nullmasse), paramatrix[2,4]) / 
( paramatrix[2,4] * paramatrix[4,4]); 
if bestpwert = 5 then
tplotwerte[6,i] = (- log(1 - (tplotwerte[2,i] - nullmasse) / (1 - nullmasse) / 1)) / paramatrix[4,5];
if bestpwert = 6 then
tplotwerte[6,i] = ((tplotwerte[2,i] - nullmasse) / (1 - nullmasse) / (1 - (tplotwerte[2,i] - nullmasse) 
/ (1 - nullmasse))) ## (1 / paramatrix[5,6]) / paramatrix[4,6];
end;

plotwerte = t(tplotwerte); 

/*------------------------------------------------------------------------------------------------*/
/* Festlegung des Bereichs fuer den Q-Q-Plot                                                      */
/*------------------------------------------------------------------------------------------------*/

bereich_qqplot = {0,0};
bereich_qqplot[1,1] = min(plotwerte[1,1],plotwerte[1,5],plotwerte[1,6]);
bereich_qqplot[2,1] = max(plotwerte[nposgew-1,1],plotwerte[nposgew-1,5],plotwerte[nposgew-1,6]);

/*------------------------------------------------------------------------------------------------*/
/*          Erzeugung des Plots der Verteilungsfunktionen                                         */
/*------------------------------------------------------------------------------------------------*/
 
call gstart("&grafikziel");
if anz_untergr = 1 then do;
if &wertstrat1 ^= 69 then graf1 = compress("vfp"+&sexgroup+&gruppe);
                     else graf1 = compress("vfp69"+&gruppe);
					   end;
else do;
if &wertstrat1 ^= 69 then graf1 = compress("vfp"+&zusgroup+&sexgroup+&gruppe);
                     else graf1 = compress("vfp69"+&zusgroup+&gruppe);
    end;
call gopen(graf1,1);
call gset("height", 2.0);
call gwindow(bereich_vfplot);

if &logskala = 0 then do;
call gdraw(zweifach_posgewalldaten,zweifach_emp_vfu,1,"green");
call gdraw(stuetzstellen,gf_stuetzen,1,"red");
if bestpwert = 2 then
call gdraw(stuetzstellen,ln_stuetzen,1,"blue");
if bestpwert = 6 then 
call gdraw(stuetzstellen,ll_stuetzen,1,"black");
if bestpwert = 5 then 
call gdraw(stuetzstellen,exp_stuetzen,1,"orange");
if bestpwert = 3 then 
call gdraw(stuetzstellen,wei_stuetzen,1,"brown");
if bestpwert = 4 then 
call gdraw(stuetzstellen,gam_stuetzen,1,"purple");
end;

else do;
call gdraw(lnzw_pos,zweifach_emp_vfu,1,"green");
call gdraw(stuetzstellen,gf_stuetzen,1,"red");
if bestpwert = 2 then
call gdraw(stuetzstellen,ln_stuetzen,1,"blue");
if bestpwert = 6 then 
call gdraw(stuetzstellen,ll_stuetzen,1,"black");
if bestpwert = 5 then 
call gdraw(stuetzstellen,exp_stuetzen,1,"orange");
if bestpwert = 3 then 
call gdraw(stuetzstellen,wei_stuetzen,1,"brown");
if bestpwert = 4 then 
call gdraw(stuetzstellen,gam_stuetzen,1,"purple");
end;

/*------------------------------------------------------------------------------------------------*/
/*    Erzeugung der Legende                                                                       */
/*------------------------------------------------------------------------------------------------*/

if anz_untergr = 1 then do;
if &wertstrat1 ^= 69 then graf11 = compress("vxt"+&sexgroup+&gruppe);
                     else graf11 = compress("vxt69"+&gruppe);
					   end;
else do;
if &wertstrat1 ^= 69 then graf11 = compress("vxt"+&zusgroup+&sexgroup+&gruppe);
                     else graf11 = compress("vxt69"+&zusgroup+&gruppe);
    end;
call gopen(graf11,1);
call gset('height',6);
call gset('aspect',0.65); ***JH=0.5;
call gset('font','swiss');
if anz_untergr = 1 then call gscript(0,95,"&paramganz");
else do;
call gscript(0,105,"&paramganz");
call gscript(63,105,"by");
call gscript(72,105,"&stratum");
call gscript(0,95,"Subgroup No.");
call gscript(50,95,&zusgroup);
end;
call gset('height',2); ***JH=4;
call gscript(0,82,"DATA SOURCE:");
call gscript(50,82,"&quelle");
call gscript(0,74,geschlechttext);
call gscript(0,67,"AGEMIN:");
call gscript(20,67,Agemin); ***JH=11;
call gscript(0,60,"AGEMAX:");
call gscript(20,60,Agemax); ***JH=13;
call gscript(0,53,"GROUP:");
call gscript(20,53,&gruppe); ***JH=9;
call gscript(0,45,"GF-PARAMETER:");
call gscript(40,45,gfuntermatrix[1]);
call gscript(59,45,",");
call gscript(60,45,gfuntermatrix[2]);
call gscript(79,45,",");
call gscript(5,38,gfuntermatrix[3]);
call gscript(24,38,",");
call gscript(25,38,gfuntermatrix[4]);
call gscript(44,38,",");
call gscript(45,38,gfuntermatrix[5]);
call gscript(0,30,"KS-DISTANCE GF - EMPIR.:");
kseins = char(paramatrix[7,1]);
mattrib kseins format=$5.3;
call gscript(50,30,kseins);
call gscript(0,23,"BEST-FIT-DISTRIBUTION:");
call gscript(50,23,bestverteilung);
call gscript(0,16,"BEST-FIT-PARAMETER (GF):");
call gscript(5,9,Para_Best[1]);
call gscript(24,9,",");
call gscript(25,9,Para_Best[2]);
call gscript(44,9,",");
call gscript(45,9,Para_Best[3]);
call gscript(0,2,"BEST-FIT-PARAMETER (STANDARD):");
call gscript(5,-5,Para_Best[1]);
call gscript(24,-5,",");
call gscript(25,-5,Para_Best[4]);
call gscript(44,-5,",");
call gscript(45,-5,Para_Best[5]);
call gscript(0,-12,"KS-DISTANCE BEST FIT - GF:");
call gscript(50,-12,Para_Best[6]);
call gscript(0,-24,"DATE");
call gscript(15,-24,"&sysdate9");
call gscript(50,-24,"TIME");
call gscript(65,-24,"&systime");
call gclose;

/*------------------------------------------------------------------------------------------------*/
/*          Erzeugung des P-P-Plots                                                               */
/*------------------------------------------------------------------------------------------------*/

if anz_untergr = 1 then do;
if &wertstrat1 ^= 69 then graf2 = compress("ppp"+&sexgroup+&gruppe);
                     else graf2 = compress("ppp69"+&gruppe);
					   end;
else do;
if &wertstrat1 ^= 69 then graf2 = compress("ppp"+&zusgroup+&sexgroup+&gruppe);
                     else graf2 = compress("ppp69"+&zusgroup+&gruppe);
    end;
call gopen(graf2);
call gwindow({0 0 1 1});
call gpoint(plotwerte[nullzaehler + 1:nposgew,2],plotwerte[nullzaehler + 1:nposgew,3], ,"red");
call gpoint(plotwerte[nullzaehler + 1:nposgew,2],plotwerte[nullzaehler + 1:nposgew,4], ,"blue");
call gdraw({0 1},{0 1},1,"black");

/*------------------------------------------------------------------------------------------------*/
/*          Erzeugung des Q-Q-Plots                                                               */
/*------------------------------------------------------------------------------------------------*/

if anz_untergr = 1 then do;
if &wertstrat1 ^= 69 then graf3 = compress("qqq"+&sexgroup+&gruppe);
                     else graf3 = compress("qqq69"+&gruppe);
					   end;
else do;
if &wertstrat1 ^= 69 then graf3 = compress("qqq"+&zusgroup+&sexgroup+&gruppe);
                     else graf3 = compress("qqq69"+&zusgroup+&gruppe);
    end;
call gopen(graf3);
qqfenster = t(doppelt(bereich_qqplot));
qqanfang = t(doppelt(bereich_qqplot[1,1]));
qqende = t(doppelt(bereich_qqplot[2,1]));
call gwindow(qqfenster);
call gpoint(plotwerte[1:nposgew-1,1],plotwerte[1:nposgew-1,5], , "red");
call gpoint(plotwerte[1:nposgew-1,1],plotwerte[1:nposgew-1,6], , "blue");
call gdraw(bereich_qqplot,bereich_qqplot,1,"black");

/*------------------------------------------------------------------------------------------------*/
/*  Erzeugung der Grafikseite                                                                     */
/*------------------------------------------------------------------------------------------------*/

if anz_untergr = 1 then do;
if &wertstrat1 ^= 69 then gesamt = compress("Graf"+&sexgroup+&gruppe);
                     else gesamt = compress("Gra69"+&gruppe);
					   end;
else do;
if &wertstrat1 ^= 69 then gesamt = compress("Graf"+&zusgroup+&sexgroup+&gruppe);
                     else gesamt = compress("Gra69"+&zusgroup+&gruppe);
    end;
call gopen(gesamt);
call gwindow(bereich_vfplot);
call gport({59 58, 95 86});
call ginclude(graf1);
ursprung = t(bereich_vfplot[1:2]); 
call gxaxis(ursprung, bereich_vfplot[3] - bereich_vfplot[1], 12, , ,"8.0",1.5);
call gyaxis(ursprung, 1, 21, , , ,1.5);
call gset("height",2.0);
call gscenter((bereich_vfplot[1] + bereich_vfplot[3])/ 2, 1.15, "Plotted Distribution Functions");
call gvtext(bereich_vfplot[1] - 0.15 * (bereich_vfplot[3] - bereich_vfplot[1]), 1, 
"Cumul. Probability");
call gscenter((bereich_vfplot[1] + bereich_vfplot[3])/ 2, -0.09, "green line = empirical d.f.; 
red line = fitted GF-d.f.");
call gscenter((bereich_vfplot[1] + bereich_vfplot[3])/ 2, -0.13, "third line = best fit - d.f.");
call gscenter((bereich_vfplot[1] + bereich_vfplot[3])/ 2, -0.19, "(blue = Lognormal, brown = Weibull,
purple = Gamma");
call gscenter((bereich_vfplot[1] + bereich_vfplot[3])/ 2, -0.23, 
"black = Loglogistic, orange = Exponential)");
call gwindow({0 0 1 1});
call gport({9 11, 45 39});
call gpoly({0 1 1 0}, {0 0 1 1});
call ginclude(graf2);
call gxaxis({0 0}, 1, 12, , , ,1.5);
call gyaxis({0 0}, 1, 12, , , ,1.5);
call gset("height",2.0);
call gscenter(0.5, 1.15, "Probability-Probability-Plot");
call gvtext(-0.15, 1, "Probability of fit");
call gscenter(0.5, -0.12, "Empirical Probability");
call gscenter(0.5, -0.2, "red stars = fitted GF-distribution");
call gscenter(0.5, -0.24, "blue stars = best fit-distribution");
call gwindow(qqfenster); 
call gport({59 11, 95 39});
a = (qqanfang[1]);
b = (qqende[1]);
xbereich = {0 0 0 0};
ybereich = {0 0 0 0};
xbereich[1] = a;
xbereich[2] = b;
xbereich[3] = b;
xbereich[4] = a;
ybereich[1] = a;
ybereich[2] = a;
ybereich[3] = b;
ybereich[4] = b;
call gpoly(xbereich,ybereich);
call ginclude(graf3);
call gxaxis(qqanfang, bereich_qqplot[2,1] - bereich_qqplot[1,1], 12, , , ,1.5);
call gyaxis(qqanfang, bereich_qqplot[2,1] - bereich_qqplot[1,1], 12, , , ,1.5);
call gset("height",2.0); 
call gscenter((bereich_qqplot[1,1] + bereich_qqplot[2,1])/ 2, 
bereich_qqplot[2,1] + 0.15 * (bereich_qqplot[2,1] - bereich_qqplot[1,1]), "Quantile-Quantile-Plot");
call gvtext(bereich_qqplot[1,1] - 0.15 * (bereich_qqplot[2,1] - bereich_qqplot[1,1]), 
bereich_qqplot[2,1], "Fitted Quantiles");
call gscenter((bereich_qqplot[1,1] + bereich_qqplot[2,1])/ 2, 
bereich_qqplot[1,1] - 0.12 * (bereich_qqplot[2,1] - bereich_qqplot[1,1]), "Empirical Quantiles");
call gscenter((bereich_qqplot[1,1] + bereich_qqplot[2,1])/ 2, 
bereich_qqplot[1,1] - 0.2 * (bereich_qqplot[2,1] - bereich_qqplot[1,1]), 
"red stars = fitted GF-distribution");
call gscenter((bereich_qqplot[1,1] + bereich_qqplot[2,1])/ 2, 
bereich_qqplot[1,1] - 0.24 * (bereich_qqplot[2,1] - bereich_qqplot[1,1]), 
"blue stars = best fit-distribution");
call gwindow({0 0 1 1});
call gport({9 58, 45 86});
call gportstk({10 20 90 100});
call ginclude(graf11);

call gshow(gesamt);
call gclose;

call gopen("&grafikziel");
call gdelete(graf1);
call gdelete(graf2);
call gdelete(graf3);
call gdelete(graf11);

end;
end;
end;
quit;





