/* ===========================================================================
 * File: zg2s.h
 *
 * Version 2010-07-21
 *
 * Copyright (C) 2005/2010 LANUV  NRW, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ==========================================================================*/

#ifndef _ZG2S_H
#define _ZG2S_H

#define MSG_INFO              1
#define MSG_USAGE             2
#define MSG_IFS               3
#define MSG_OFS               4
#define MSG_NON_IFS           5
#define MSG_NON_OFS           6
#define MSG_DELTA             7
#define MSG_SEQU              8
#define MSG_LHB               9
#define MSG_MEM              10
#define MSG_TERRAIN          11
#define MSG_DMNA_HEADER      12
#define MSG_DMNA_CNT         13
#define MSG_IFS_FORMAT       16
#define MSG_OFS_FORMAT       17
#define MSG_ARCINFO_HEADER   18
#define MSG_ARCINFO_CENTER   19
#define MSG_ARCINFO_CNT      20
#define MSG_ATKIS_TRIPLET    21
#define MSG_NDV              22
#define MSG_STR_FORMAT       23

#define MSG_LETTER_UNKNOWN   30

#define KL0  0
#define KL1  1
#define KL2  2
#define KL3  3

#define NON_FORMAT -1
#define IFS_DMNA    1
#define OFS_DMNA    2
#define IFS_ARCINFO 3
#define OFS_ARCINFO 4
#define IFS_ATKIS   5
#define OFS_TABLE   6

#define FSLEN 256
#define VSLEN 16
#define NSLEN 80

struct header
{
   int    lowb[2], hghb[2],
          dims,
          size;
   double xmin, ymin,
          refx, refy,
          gakrx, gakry,
          delta;
   char   locl[VSLEN],
          ggcs[VSLEN],
          formatHeight[VSLEN],
          formatHeight2[VSLEN],
          formatSlope[VSLEN],
          formatSlope2[VSLEN],
          artp[VSLEN],
          vldf[VSLEN],
          sequ[VSLEN],
          mode[VSLEN],
          unit[VSLEN],
          name[NSLEN],
          ident[NSLEN];
};

struct relHeight
{
   double height, slope;
   int    klass;
};

typedef struct relHeight RH;

struct atkis
{
   double x, y, height;
};

typedef struct atkis AT;

#endif
