/*
 * Decompiled with CFR 0.152.
 */
package de.janicke.ibjutil;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class IBJhdr {
    public static boolean CHECK = false;
    public static final long LHOUR = 3600000L;
    public static final long LDAY = 86400000L;
    public static final String date_format = "yyyy-MM-dd.HH:mm:ss";
    public static final String default_date = "2006-01-01.00:00:00";
    public static final String default_tmzn = "GMT+01:00";
    public static final String default_locl = "C";
    private static final double time_0 = 8.86091616E13;
    LinkedHashMap<String, String> p = new LinkedHashMap();
    TimeZone timezone;
    Locale locale;

    public IBJhdr() {
        this.setLocale(default_locl);
        this.setTimeZone(default_tmzn);
    }

    public IBJhdr(IBJhdr hdr) {
        this();
        if (hdr == null) {
            return;
        }
        if (hdr.p != null) {
            this.p.putAll(hdr.p);
        }
        this.setLocale(hdr.getLocale());
        this.setTimeZone(hdr.getTimeZone().getID());
    }

    public Map<String, String> getMap() {
        return this.p;
    }

    public static double[] parseDoubles(String[] ss) {
        double[] dd = null;
        try {
            int n = ss.length;
            dd = new double[n];
            int i = 0;
            while (i < n) {
                dd[i] = Double.valueOf(ss[i].replace(',', '.').trim());
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return dd;
    }

    public static double parseDouble(String s) {
        double d = Double.NaN;
        try {
            d = Double.valueOf(s.replace(',', '.').trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static float[] parseFloats(String[] ss) {
        float[] ff = null;
        try {
            int n = ss.length;
            ff = new float[n];
            int i = 0;
            while (i < n) {
                ff[i] = Float.valueOf(ss[i].replace(',', '.').trim()).floatValue();
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ff;
    }

    public static float parseFloat(String s) {
        float f = Float.NaN;
        try {
            f = Float.valueOf(s.replace(',', '.').trim()).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static int[] parseIntegers(String[] ss) {
        int[] ii;
        try {
            int n = ss.length;
            ii = new int[n];
            int i = 0;
            while (i < n) {
                ii[i] = Integer.valueOf(ss[i].trim());
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ii;
    }

    public static int parseInteger(String s) {
        int i = 0;
        try {
            i = Integer.valueOf(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static long[] parseLongs(String[] ss) {
        long[] ll = null;
        try {
            int n = ss.length;
            ll = new long[n];
            int i = 0;
            while (i < n) {
                ll[i] = Long.valueOf(ss[i].trim());
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ll;
    }

    public static long parseLong(String s) {
        long l = 0L;
        try {
            l = Long.valueOf(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static int[] parseTimes(String[] ss) {
        int[] ii;
        try {
            int n = ss.length;
            ii = new int[n];
            int i = 0;
            while (i < n) {
                ii[i] = IBJhdr.parseTime(ss[i]);
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ii;
    }

    public static int parseTime(String s) {
        int time = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (s == null) {
            return -1;
        }
        if ((s = s.toLowerCase().trim()).startsWith("-inf")) {
            return Integer.MIN_VALUE;
        }
        if (s.startsWith("+inf")) {
            return Integer.MAX_VALUE;
        }
        try {
            String[] tt;
            String[] ss = s.split("[.]");
            if (ss.length == 2) {
                days = Integer.valueOf(ss[0]);
                ss[0] = ss[1];
            }
            if ((tt = ss[0].split(":")).length == 3) {
                hours = Integer.valueOf(tt[0]);
                tt[0] = tt[1];
                tt[1] = tt[2];
            }
            if (tt.length >= 2) {
                minutes = Integer.valueOf(tt[0]);
                tt[0] = tt[1];
            }
            seconds = Integer.valueOf(tt[0]);
            time = days < 0 || hours < 0 || minutes < 0 || seconds < 0 ? -1 : seconds + 60 * (minutes + 60 * (hours + 24 * days));
        }
        catch (Exception e) {
            if (CHECK) {
                e.printStackTrace();
            }
            time = -1;
        }
        return time;
    }

    public static double[] parseDates(String[] ss, String zone) {
        if (zone == null) {
            zone = default_tmzn;
        }
        TimeZone tz = TimeZone.getTimeZone(zone);
        return IBJhdr.parseDates(ss, tz);
    }

    public static double[] parseDates(String[] ss, TimeZone tz) {
        double[] dd;
        try {
            int n = ss.length;
            dd = new double[n];
            int i = 0;
            while (i < n) {
                dd[i] = IBJhdr.parseDate(ss[i], tz);
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return dd;
    }

    public static double parseDate(String s, String zone) {
        if (zone == null) {
            zone = default_tmzn;
        }
        TimeZone tz = TimeZone.getTimeZone(zone);
        return IBJhdr.parseDate(s, tz);
    }

    public static double parseDate(String s, TimeZone tz) {
        if ((s = s.toLowerCase()).startsWith("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (s.startsWith("+inf")) {
            return Double.POSITIVE_INFINITY;
        }
        long ms = IBJhdr.parseDateLong(s, tz);
        if (ms < 0L) {
            return Double.NaN;
        }
        double d = ((double)ms + 8.86091616E13) / 8.64E7;
        return d;
    }

    public static long parseDateLong(String s, TimeZone tz) {
        if ((s = s.toLowerCase()).startsWith("-inf")) {
            return Long.MIN_VALUE;
        }
        if (s.startsWith("+inf")) {
            return Long.MAX_VALUE;
        }
        long ms = -1L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(date_format);
            Date dt = null;
            int l = s.indexOf("GMT");
            if (l > 0) {
                tz = TimeZone.getTimeZone(s.substring(l));
                s = s.substring(0, l).trim();
            } else {
                l = s.length();
                if (s.charAt(l - 5) == '-' || s.charAt(l - 5) == '+') {
                    tz = TimeZone.getTimeZone("GMT" + s.substring(l - 5));
                    s = s.substring(0, l - 5).trim();
                }
            }
            if (!s.contains(".")) {
                s = String.valueOf(s) + ".00:00:00";
            }
            sdf.setTimeZone(tz != null ? tz : TimeZone.getDefault());
            dt = sdf.parse(s);
            ms = dt.getTime();
        }
        catch (Exception e) {
            ms = -1L;
        }
        return ms;
    }

    public static String unquote(String s) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        if (l < 1 || s.charAt(0) != '\"') {
            return s;
        }
        if (s.charAt(l - 1) == '\"') {
            --l;
        }
        String t = l > 1 ? s.substring(1, l) : "";
        return t;
    }

    public static String[] unquote(String[] ss) {
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        String[] tt = new String[n];
        int i = 0;
        while (i < n) {
            tt[i] = IBJhdr.unquote(ss[i]);
            ++i;
        }
        return tt;
    }

    public static String formatTime(long f) {
        if (f == Long.MIN_VALUE) {
            return "          -inf";
        }
        if (f == Long.MAX_VALUE) {
            return "          +inf";
        }
        return IBJhdr.formatTime((int)(f / 1000L));
    }

    public static String formatTime(int f) {
        char sign;
        if (f < 0) {
            sign = '-';
            f = -f;
        } else {
            sign = ' ';
        }
        int sec = f % 60;
        int min = (f /= 60) % 60;
        int hour = (f /= 60) % 24;
        int day = f /= 24;
        String s = String.format("    %c%d.%02d:%02d:%02d", Character.valueOf(sign), day, hour, min, sec);
        s = s.substring(s.length() - 14);
        return s;
    }

    public static String formatDate(double d, TimeZone tz) {
        if (d < -1.0E-5) {
            return "-inf";
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= 9999999.0) {
            return "+inf";
        }
        long ms = Math.round(d * 3600.0 * 24.0 * 1000.0 - 8.86091616E13);
        Date dt = new Date(ms);
        SimpleDateFormat sdf = new SimpleDateFormat(date_format);
        sdf.setTimeZone(tz);
        String dstr = sdf.format(dt);
        return dstr;
    }

    public static String formatDate(long l, TimeZone tz) {
        if (l == Long.MIN_VALUE) {
            return "-inf";
        }
        if (l == Long.MAX_VALUE) {
            return "+inf";
        }
        if (l < 0L) {
            l = Calendar.getInstance().getTimeInMillis();
        }
        if (tz == null) {
            tz = TimeZone.getTimeZone(default_tmzn);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(date_format);
        sdf.setTimeZone(tz);
        String dstr = sdf.format(new Date(l));
        return dstr;
    }

    public static String formatValidDate(long l, TimeZone tz) {
        if (l <= 0L && l != Long.MIN_VALUE) {
            return "                   ";
        }
        if (l == Long.MIN_VALUE) {
            return "-inf";
        }
        if (l == Long.MAX_VALUE) {
            return "+inf";
        }
        if (tz == null) {
            tz = TimeZone.getTimeZone(default_tmzn);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(date_format);
        sdf.setTimeZone(tz);
        String dstr = sdf.format(new Date(l));
        return dstr;
    }

    public static int getDayOfWeek(long t, TimeZone tz) {
        Calendar cl = Calendar.getInstance(tz);
        cl.setTimeInMillis(t);
        int d = cl.get(7);
        d = d == 2 ? 1 : (d == 3 ? 2 : (d == 4 ? 3 : (d == 5 ? 4 : (d == 6 ? 5 : (d == 7 ? 6 : (d == 1 ? 7 : -1))))));
        return d;
    }

    public static long longDate(double d) {
        return Math.round(d * 8.64E7 - 8.86091616E13);
    }

    public static Date getJDate(double d) {
        long ms = Math.round(d * 8.64E7 - 8.86091616E13);
        return new Date(ms);
    }

    public static double getDate(Date dt) {
        return ((double)dt.getTime() + 8.86091616E13) / 8.64E7;
    }

    public static boolean isPlusInfTime(double d) {
        return d >= 9999999.0;
    }

    public static boolean isNegInfTime(double d) {
        return d < -1.0E-5;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] tokenize(String line) {
        block8: {
            block7: {
                block6: {
                    if (line == null) {
                        return null;
                    }
                    vv = new Vector<String>();
                    ss = null;
                    l = line.length();
                    i = 0;
                    break block7;
                    while (Character.isWhitespace(line.charAt(i))) {
                        ++i;
lbl10:
                        // 2 sources

                        ** while (i >= l)
lbl11:
                        // 1 sources

                    }
lbl12:
                    // 2 sources

                    if (i >= l) break block8;
                    i1 = i;
                    if (line.charAt(i) != '\"') ** GOTO lbl25
                    ++i;
                    while (i < l) {
                        if (line.charAt(i) == '\"' && line.charAt(i - 1) != '\\') {
                            ++i;
                            break block6;
                        }
                        ++i;
                    }
                    break block6;
                    while (!Character.isWhitespace(line.charAt(i))) {
                        ++i;
lbl25:
                        // 2 sources

                        if (i < l) continue;
                    }
                }
                vv.add(line.substring(i1, i));
                ++i;
            }
            if (i < l) ** GOTO lbl10
        }
        ss = vv.toArray(new String[0]);
        return ss;
    }

    public boolean contains(String key) {
        return this.p.containsKey(key);
    }

    public void setTimeZone(String zone) {
        if (zone == null) {
            zone = default_tmzn;
        }
        this.timezone = TimeZone.getTimeZone(zone);
        this.putString("tmzn", this.timezone.getID(), true);
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale == Locale.GERMAN ? "german" : default_locl);
    }

    public void setLocale(String s) {
        if (s == null) {
            s = default_locl;
        }
        if (s.equals("german")) {
            this.locale = Locale.GERMAN;
            this.putString("locl", "german", true);
        } else {
            this.locale = Locale.ENGLISH;
            this.putString("locl", default_locl, true);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public double[] getDoubles(String key) {
        if (key == null) {
            return null;
        }
        double[] dd = IBJhdr.parseDoubles(this.getStrings(key));
        return dd;
    }

    public double getDouble(String key) {
        double d = Double.NaN;
        if (key == null) {
            return d;
        }
        String s = this.getString(key);
        d = IBJhdr.parseDouble(s);
        return d;
    }

    public float[] getFloats(String key) {
        if (key == null) {
            return null;
        }
        String[] ss = this.getStrings(key);
        float[] ff = IBJhdr.parseFloats(ss);
        return ff;
    }

    public float getFloat(String key) {
        float f = Float.NaN;
        if (key == null) {
            return f;
        }
        String s = this.getString(key);
        f = IBJhdr.parseFloat(s);
        return f;
    }

    public int[] getIntegers(String key) {
        if (key == null) {
            return null;
        }
        String[] ss = this.getStrings(key);
        int[] ii = IBJhdr.parseIntegers(ss);
        return ii;
    }

    public int getInteger(String key) {
        if (key == null) {
            return 0;
        }
        String s = this.getString(key);
        int i = IBJhdr.parseInteger(s);
        return i;
    }

    public long[] getLongs(String key) {
        if (key == null) {
            return null;
        }
        String[] ss = this.getStrings(key);
        long[] ll = IBJhdr.parseLongs(ss);
        return ll;
    }

    public long getLong(String key) {
        if (key == null) {
            return 0L;
        }
        String s = this.getString(key);
        long l = IBJhdr.parseLong(s);
        return l;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, false);
    }

    public String[] getStrings(String key, boolean unquote) {
        if (key == null) {
            return null;
        }
        String[] ss = null;
        String s = null;
        int i1 = 0;
        int i2 = 0;
        int l = key.length();
        while (i2 < l) {
            i2 = key.indexOf(124, i1);
            if (i2 < 0) {
                i2 = l;
            }
            if ((s = this.p.get(key.substring(i1, i2).toLowerCase())) != null) break;
            i1 = i2 + 1;
        }
        if (s == null) {
            return null;
        }
        ss = IBJhdr.tokenize(s);
        if (unquote) {
            int i = 0;
            while (i < ss.length) {
                ss[i] = IBJhdr.unquote(ss[i]);
                ++i;
            }
        }
        return ss;
    }

    public String getString(String key) {
        return this.getString(key, false);
    }

    public String getString(String key, boolean unquote) {
        if (key == null) {
            return null;
        }
        String s = null;
        int i1 = 0;
        int i2 = 0;
        int l = key.length();
        while (i2 < l) {
            i2 = key.indexOf(124, i1);
            if (i2 < 0) {
                i2 = l;
            }
            if ((s = this.p.get(key.substring(i1, i2).toLowerCase())) != null) break;
            i1 = i2 + 1;
        }
        if (unquote && s != null) {
            s = IBJhdr.unquote(s);
        }
        return s;
    }

    public int[] getTimes(String key) {
        if (key == null) {
            return null;
        }
        String[] ss = this.getStrings(key, true);
        int[] ii = IBJhdr.parseTimes(ss);
        return ii;
    }

    public int getTime(String key) {
        if (key == null) {
            return 0;
        }
        String s = this.getString(key, true);
        int i = IBJhdr.parseTime(s);
        return i;
    }

    public double[] getDates(String key) {
        if (key == null) {
            return null;
        }
        String[] ss = this.getStrings(key, true);
        double[] dd = IBJhdr.parseDates(ss, this.timezone);
        return dd;
    }

    public double getDate(String key) {
        if (key == null) {
            return 0.0;
        }
        String s = this.getString(key, true);
        double d = IBJhdr.parseDate(s, this.timezone);
        return d;
    }

    public String rename(String oldKey, String newKey) {
        if (oldKey == null) {
            return null;
        }
        String s = null;
        String key = null;
        int i1 = 0;
        int i2 = 0;
        int l = oldKey.length();
        while (i2 < l) {
            i2 = oldKey.indexOf(124, i1);
            if (i2 < 0) {
                i2 = l;
            }
            if ((s = this.p.get(key = oldKey.substring(i1, i2).toLowerCase())) != null) break;
            i1 = i2 + 1;
        }
        if (s == null) {
            key = null;
        } else {
            this.p.remove(key);
        }
        if (newKey != null) {
            this.p.put(newKey.toLowerCase(), s);
        }
        return key;
    }

    public void putDouble(String key, double d, String format) {
        String s = String.format(this.locale, format, d);
        if (this.locale == Locale.GERMAN) {
            s = s.replace('.', ',');
        }
        this.p.put(key.toLowerCase(), s);
    }

    public void putDoubles(String key, double[] dd, String format) {
        int n = dd.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            String s = String.format(this.locale, format, dd[i]);
            if (this.locale == Locale.GERMAN) {
                s = s.replace('.', ',');
            }
            sb.append(s);
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putFloat(String key, float f, String format) {
        String s = String.format(this.locale, format, Float.valueOf(f));
        if (this.locale == Locale.GERMAN) {
            s = s.replace('.', ',');
        }
        this.p.put(key.toLowerCase(), s);
    }

    public void putFloats(String key, float[] ff, String format) {
        int n = ff.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            String s = String.format(this.locale, format, Float.valueOf(ff[i]));
            if (this.locale == Locale.GERMAN) {
                s = s.replace('.', ',');
            }
            sb.append(s);
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putInteger(String key, int i, String format) {
        String s = String.format(this.locale, format, i);
        this.p.put(key.toLowerCase(), s);
    }

    public void putIntegers(String key, int[] ii, String format) {
        int n = ii.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(String.format(this.locale, format, ii[i]));
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putLong(String key, long l, String format) {
        String s = String.format(this.locale, format, l);
        this.p.put(key.toLowerCase(), s);
    }

    public void putLongs(String key, long[] ll, String format) {
        int n = ll.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(String.format(this.locale, format, ll[i]));
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putTime(String key, int i) {
        String s = IBJhdr.formatTime(i).trim();
        this.putString(key, s, true);
    }

    public void putTimes(String key, int[] ii) {
        int n = ii.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append("\"").append(IBJhdr.formatTime(ii[i]).trim()).append("\"");
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putString(String key, String s, boolean quoted) {
        if (quoted && s.length() > 0 && s.charAt(0) != '\"') {
            s = "\"" + s + "\"";
        }
        this.p.put(key.toLowerCase(), s);
    }

    public void putStrings(String key, String[] ss, boolean quoted) {
        int n = ss.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            boolean q;
            if (i > 0) {
                sb.append(' ');
            }
            boolean bl = q = quoted && ss[i].length() > 0 && ss[i].charAt(0) != '\"';
            if (q) {
                sb.append('\"');
            }
            sb.append(ss[i]);
            if (q) {
                sb.append('\"');
            }
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void putDate(String key, double d) {
        String s = IBJhdr.formatDate(d, this.timezone);
        this.p.put(key.toLowerCase(), s);
    }

    public void putDates(String key, double[] dd) {
        int n = dd.length;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(IBJhdr.formatDate(dd[i], this.timezone));
            ++i;
        }
        this.p.put(key.toLowerCase(), sb.toString());
    }

    public void print(PrintWriter pw) {
        pw.print(this.getList());
        pw.flush();
    }

    public String getList() {
        StringBuffer sb = new StringBuffer();
        Set<String> keys = this.p.keySet();
        for (String key : keys) {
            String value = this.p.get(key);
            sb.append(key).append(' ').append(value).append('\n');
        }
        return sb.toString();
    }

    public ZonedDate getReferenceDate() {
        String tmzn = this.getString("tmzn|zone", true);
        String rdat = this.getString("rdat|refdate|refdatum", true);
        return ZonedDate.getZonedDate(tmzn, rdat);
    }

    private static void test01() {
        String s = " xx\t123 \"abc\" 456\r \"AB\\\"CD\\\"EF\" 789 \n";
        String[] ss = IBJhdr.tokenize(s);
        int i = 0;
        while (i < ss.length) {
            System.out.printf("%d: %s\n", i, ss[i]);
            ++i;
        }
    }

    private static void test02() {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
        System.out.println(f.format(new Date()));
        try {
            Date d = f.parse("12:33:44");
            System.out.println("date=" + d);
            System.out.println("time=" + f.format(d));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test03() {
        try {
            TimeZone z = TimeZone.getTimeZone("GMT+03:00");
            System.out.printf("name=%s, ID=%s\n", z.getDisplayName(), z.getID());
            double d = IBJhdr.parseDate("2008-12-01.12:00:00+0100", z);
            Date date = IBJhdr.getJDate(d);
            System.out.printf("date=%s\n", date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        IBJhdr.test03();
    }

    public static class ZonedDate {
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
        private long seconds;
        private TimeZone tz;
        private Date date;

        public ZonedDate(TimeZone tz, long seconds) {
            if (tz == null) {
                tz = TimeZone.getTimeZone(IBJhdr.default_tmzn);
            }
            this.tz = tz;
            this.seconds = seconds;
            this.date = new Date(seconds * 1000L);
            this.sdf.setTimeZone(tz);
        }

        public ZonedDate(String zone, String datum) throws Exception {
            if (datum != null && !datum.contains(".")) {
                datum = String.valueOf(datum) + ".00:00:00";
            }
            this.tz = TimeZone.getTimeZone(zone);
            this.sdf.setTimeZone(this.tz);
            this.date = this.sdf.parse(datum);
            long ms = this.date.getTime();
            this.seconds = ms / 1000L;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public TimeZone getZone() {
            return this.tz;
        }

        public Date getDate() {
            return this.date;
        }

        public String toString() {
            return this.toString(0L);
        }

        public String toString(long t) {
            long ms = (this.seconds + t) * 1000L;
            Date d = new Date(ms);
            String s = String.valueOf(this.sdf.format(d)) + " " + this.tz.getID();
            return s;
        }

        public String getDateString(boolean cut) {
            String s = this.sdf.format(this.date);
            if (cut && s.endsWith(".00:00:00")) {
                s = s.substring(0, s.length() - 9);
            }
            return s;
        }

        public String getZoneString() {
            return this.tz.getID();
        }

        public static ZonedDate getZonedDate(String tmzn, String rdat) {
            int l;
            ZonedDate zd = null;
            if (rdat == null || rdat.length() == 0) {
                try {
                    zd = new ZonedDate(IBJhdr.default_tmzn, IBJhdr.default_date);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return zd;
            }
            if (tmzn == null || !tmzn.startsWith("GMT")) {
                tmzn = IBJhdr.default_tmzn;
            }
            if ((l = rdat.indexOf("GMT")) > 0) {
                tmzn = rdat.substring(l);
                rdat = rdat.substring(0, l).trim();
            } else {
                l = rdat.length();
                if (l > 5 && (rdat.charAt(l - 5) == '-' || rdat.charAt(l - 5) == '+')) {
                    tmzn = "GMT" + rdat.substring(l - 5);
                    rdat = rdat.substring(0, l - 5).trim();
                }
            }
            try {
                zd = new ZonedDate(tmzn, rdat);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return zd;
        }
    }
}

