/*
 * Decompiled with CFR 0.152.
 */
package de.janicke.ibjutil;

import de.janicke.ibjutil.IBJarr;
import de.janicke.ibjutil.IBJdcl;
import de.janicke.ibjutil.IBJhdr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IBJdmn
implements IBJdcl {
    public static boolean CHECK = false;
    public static String version = "1.9";
    public static String last_change = "2010-05-19";
    IBJhdr header;
    String name;
    String data;
    String mode;
    String locl;
    String vldf;
    String form;
    String lsbf;
    String sequ;
    String tmzn;
    String chsn;
    String drop;
    float fact;
    int cmpr;
    int dims;
    int[] lowb;
    int[] hghb;
    int[] length;
    Vector<String> vfrm = new Vector();
    Drop drp;
    boolean artm = false;
    private static PrintWriter msg;
    private static PrintWriter prn;

    public boolean setArtm(boolean artm) {
        boolean old_value = this.artm;
        this.artm = artm;
        return old_value;
    }

    private String readHeader(BufferedReader br) throws Exception {
        String line;
        String encoding = null;
        this.header = new IBJhdr();
        while ((line = br.readLine()) != null) {
            int l = line.length();
            if (l < 1) continue;
            char c = line.charAt(0);
            if (c == '*') break;
            if (!Character.isLetter(c)) continue;
            int i = 0;
            while (i < l) {
                if (Character.isWhitespace(line.charAt(i))) break;
                ++i;
            }
            if (i >= l) continue;
            String key = line.substring(0, i).toLowerCase();
            String value = line.substring(i + 1).trim();
            if (key.equals("locl") || key.equals("locale")) {
                this.header.setLocale(IBJhdr.unquote(value));
            } else if (key.equals("tmzn") || key.equals("zone")) {
                this.header.setTimeZone(IBJhdr.unquote(value));
            } else {
                this.header.putString(key, value, false);
            }
            if (!key.equals("chsn") && !key.equals("cset")) continue;
            encoding = IBJhdr.unquote(value.toUpperCase());
        }
        return encoding;
    }

    private void analyseHeader(String fn) throws Exception {
        this.name = this.header.getString("file", true);
        this.mode = this.header.getString("mode", true);
        this.data = this.header.getString("data", true);
        this.locl = this.header.getString("locl", true);
        this.vldf = this.header.getString("vldf|valdef", true);
        this.form = this.header.getString("form|format", true);
        this.lsbf = this.header.getString("lsbf", true);
        this.sequ = this.header.getString("sequ", true);
        this.tmzn = this.header.getString("tmzn", true);
        this.cmpr = this.header.getInteger("cmpr");
        this.dims = this.header.getInteger("dims");
        this.lowb = this.header.getIntegers("lowb");
        this.hghb = this.header.getIntegers("hghb");
        this.fact = this.header.getFloat("fact");
        this.drop = this.header.getString("drop", true);
        if (this.form == null) {
            throw new Exception("missing format description");
        }
        if (this.mode == null) {
            this.mode = "text";
        }
        if (this.data == null) {
            this.data = "*";
        }
        if (this.locl == null || !this.locl.equals("german")) {
            this.locl = "C";
        }
        if (this.lsbf == null) {
            this.lsbf = "1";
        }
        if (this.chsn == null) {
            this.chsn = Charset.defaultCharset().name();
        }
        if (this.dims < 1 || this.dims > 5) {
            throw new Exception("invalid number of dimensions");
        }
        if (this.lowb == null || this.lowb.length != this.dims) {
            throw new Exception("no or invalid lower bounds");
        }
        if (this.hghb == null || this.hghb.length != this.dims) {
            throw new Exception("no or invalid upper bounds");
        }
        this.length = new int[this.dims];
        int i = 0;
        while (i < this.dims) {
            this.length[i] = this.hghb[i] - this.lowb[i] + 1;
            if (this.length[i] <= 0) {
                throw new Exception("invalid bounds");
            }
            ++i;
        }
        if (this.cmpr < 0 || this.cmpr > 9) {
            throw new Exception("invalid compression mode");
        }
        if (this.data.equals("*") && (this.mode.equals("binary") || this.cmpr > 0)) {
            String n = new File(fn).getName();
            if (n.endsWith(".dmna")) {
                n = n.substring(0, n.length() - 5);
            }
            this.data = String.valueOf(n) + (this.mode.equals("binary") ? ".dmnb" : ".dmnt");
            if (this.cmpr > 0) {
                this.data = String.valueOf(this.data) + ".gz";
            }
        }
        if (Float.isNaN(this.fact)) {
            this.fact = 1.0f;
        }
        if (this.drop != null) {
            this.drp = new Drop(this.drop);
        }
        if (this.sequ != null) {
            int l = this.sequ.length();
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < l) {
                int c = this.sequ.charAt(i2);
                if (Character.isLetter((char)c)) {
                    sb.append((char)c);
                    int n = c = i2 < l - 1 ? (int)this.sequ.charAt(i2 + 1) : 59;
                    if (",;".indexOf(c) >= 0) {
                        sb.append('+');
                    }
                } else {
                    if (c == 44) {
                        c = 59;
                    }
                    sb.append((char)c);
                }
                ++i2;
            }
            this.sequ = sb.toString();
            if ("i+;j+;k+;l+;m+;".startsWith(this.sequ)) {
                if (CHECK) {
                    System.err.println("removing sequ");
                }
                this.header.p.remove("sequ");
                this.sequ = null;
            } else {
                this.header.putString("sequ", this.sequ, true);
            }
        }
        String[] forms = IBJarr.Descriptor.expandFormat(this.form);
        int i3 = 0;
        while (i3 < forms.length) {
            this.vfrm.add(forms[i3]);
            ++i3;
        }
    }

    private LineNumberReader getReader(String fn, String chsn, int cmpr) throws Exception {
        FileInputStream is;
        if (chsn == null) {
            chsn = Charset.defaultCharset().name();
        }
        if (CHECK) {
            System.err.println("reader: using chsn=" + chsn);
        }
        InputStream in = is = new FileInputStream(fn);
        if (cmpr > 0) {
            in = new GZIPInputStream(is);
            if (CHECK) {
                System.err.println("reading compressed data");
            }
        }
        InputStreamReader sr = new InputStreamReader(in, chsn);
        LineNumberReader lr = new LineNumberReader(sr);
        return lr;
    }

    private PrintWriter getWriter(String fn, String chsn, int cmpr) throws Exception {
        FileOutputStream os;
        if (chsn == null) {
            chsn = Charset.defaultCharset().name();
        }
        if (CHECK) {
            System.err.println("writer: using chsn=" + chsn);
        }
        OutputStream out = os = new FileOutputStream(fn);
        if (cmpr > 0) {
            out = new GZIPOutputStream(out);
            if (CHECK) {
                System.err.println("writing compressed data");
            }
        }
        OutputStreamWriter sw = new OutputStreamWriter(out, chsn);
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        return pw;
    }

    private BufferedInputStream getInputStream(String fn, int cmpr) throws Exception {
        FileInputStream fi;
        InputStream is = fi = new FileInputStream(fn);
        if (cmpr > 0) {
            is = new GZIPInputStream(fi);
            if (CHECK) {
                System.err.println("reading compressed data");
            }
        }
        BufferedInputStream bi = new BufferedInputStream(is);
        return bi;
    }

    private BufferedOutputStream getOutputStream(String fn, int cmpr) throws Exception {
        FileOutputStream fo;
        OutputStream os = fo = new FileOutputStream(fn);
        if (cmpr > 0) {
            os = new GZIPOutputStream(fo);
            if (CHECK) {
                System.err.println("writing compressed data");
            }
        }
        BufferedOutputStream bo = new BufferedOutputStream(os);
        return bo;
    }

    private IBJarr getDmn(String fn, boolean force) throws Exception {
        IBJarr arr = null;
        IBJarr brr = null;
        BufferedReader lr = null;
        BufferedInputStream bi = null;
        if (fn.endsWith(".dmna")) {
            fn = fn.substring(0, fn.length() - 5);
        }
        String gn = String.valueOf(fn) + ".dmna";
        File f = new File(gn);
        try {
            try {
                lr = this.getReader(f.getPath(), this.chsn, 0);
                String cn = this.readHeader(lr);
                if (!force && cn != null && !cn.equals(this.chsn)) {
                    lr.close();
                    this.header.p.clear();
                    lr = this.getReader(gn, cn, 0);
                    this.readHeader(lr);
                    this.chsn = cn;
                }
                this.analyseHeader(fn);
                if (this.name == null) {
                    this.name = fn;
                }
                arr = this.createContainer();
                if (this.mode.equals("binary")) {
                    lr.close();
                    lr = null;
                    f = new File(fn);
                    File g = f.getParentFile();
                    f = new File(g, this.data);
                    bi = this.getInputStream(f.getPath(), this.cmpr);
                    brr = this.sequ == null ? arr : arr.getSelected("mapped", this.sequ);
                    this.readBinary(bi, brr);
                    bi.close();
                    bi = null;
                } else {
                    if (!this.data.equals("*")) {
                        lr.close();
                        lr = null;
                        f = new File(fn);
                        File g = f.getParentFile();
                        f = new File(g, this.data);
                        lr = this.getReader(f.getPath(), this.chsn, this.cmpr);
                    }
                    brr = this.sequ == null ? arr : arr.getSelected("mapped", this.sequ);
                    this.readText(lr, brr);
                    lr.close();
                    lr = null;
                }
            }
            catch (Exception e) {
                String emsg = e.toString();
                if (lr != null) {
                    emsg = String.valueOf(String.format("*** error in file %s, line %d%n", f.getPath(), ((LineNumberReader)lr).getLineNumber())) + emsg;
                    try {
                        lr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bi != null) {
                    emsg = String.valueOf(String.format("%s%n", "*** error in binary read")) + emsg;
                    try {
                        bi.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (CHECK) {
                    e.printStackTrace();
                }
                throw new Exception(String.format("Can't read file \"%s\"%n%s", fn, emsg));
            }
        }
        finally {
            try {
                lr.close();
            }
            catch (Exception exception) {}
            try {
                bi.close();
            }
            catch (Exception exception) {}
        }
        return arr;
    }

    private IBJarr createContainer() throws Exception {
        IBJarr arr = null;
        try {
            arr = new IBJarr(this.name, this.length);
            arr.setFirstIndex(this.lowb);
            arr.setHeader(this.header);
            int i = 0;
            while (i < this.vfrm.size()) {
                String frm = this.vfrm.get(i);
                IBJarr.AbstractArray aa = arr.createArray(frm, null);
                if (this.vldf != null && this.vldf.length() > i) {
                    aa.valdef = this.vldf.substring(i, i + 1);
                }
                ++i;
            }
            arr.setTimeZone(this.tmzn);
            arr.setFactor(this.fact);
            arr.setLocale(this.locl);
            arr.setCharset(this.chsn);
            arr.setLSBF(!this.lsbf.equals("0"));
        }
        catch (Exception e) {
            String emsg = e.toString();
            if (CHECK) {
                e.printStackTrace();
            }
            throw new Exception(String.format("Can't create container%n%s", emsg));
        }
        return arr;
    }

    private int readBinary(BufferedInputStream bi, IBJarr arr) throws Exception {
        int na;
        int n;
        block9: {
            n = 0;
            arr.setLSBF(!this.lsbf.equals("0"));
            na = arr.arrays.size();
            if (na != 0) break block9;
            return 0;
        }
        try {
            IBJarr.AbstractArray aa = arr.arrays.get(0);
            IBJarr.Structure struc = arr.getStructure();
            int[] ff = struc.getFirstIndex();
            int[] ll = struc.getLastIndex();
            int[] ii = (int[])ff.clone();
            int ns = struc.getDims();
            int i = 0;
            block3: while (i >= 0) {
                int k = 0;
                while (k < na) {
                    int nb;
                    if (na > 1) {
                        aa = arr.arrays.get(k);
                    }
                    if ((nb = bi.read(aa.bytes, 0, aa.bytes.length)) != aa.bytes.length) {
                        throw new Exception("Only " + nb + " bytes of " + aa.bytes.length + " available");
                    }
                    aa.fromBuffer(ii);
                    ++n;
                    ++k;
                }
                i = ns - 1;
                while (i >= 0) {
                    int n2 = i;
                    ii[n2] = ii[n2] + 1;
                    if (ii[i] <= ll[i]) continue block3;
                    ii[i] = ff[i];
                    --i;
                }
            }
        }
        catch (Exception e) {
            String emsg = e.toString();
            if (CHECK) {
                e.printStackTrace();
            }
            throw new Exception(String.format("Can't read binary data (n=%d)%n%s", n, emsg));
        }
        return n;
    }

    private int readText(BufferedReader br, IBJarr arr) throws Exception {
        int na;
        int n;
        block9: {
            n = 0;
            na = arr.arrays.size();
            if (na != 0) break block9;
            return 0;
        }
        try {
            IBJarr.AbstractArray aa = arr.arrays.get(0);
            IBJarr.Structure struc = arr.getStructure();
            int[] ff = struc.getFirstIndex();
            int[] ll = struc.getLastIndex();
            int[] ii = (int[])ff.clone();
            int ns = struc.getDims();
            StringBuffer sb = new StringBuffer();
            if (this.drp != null) {
                this.drp.active = true;
            }
            int i = 0;
            block3: while (i >= 0) {
                int k = 0;
                while (k < na) {
                    if (na > 1) {
                        aa = arr.arrays.get(k);
                    }
                    this.nextToken(br, sb);
                    aa.parse(sb.toString(), ii);
                    ++n;
                    ++k;
                }
                i = ns - 1;
                while (i >= 0) {
                    int n2 = i;
                    ii[n2] = ii[n2] + 1;
                    if (ii[i] <= ll[i]) continue block3;
                    ii[i] = ff[i];
                    --i;
                }
            }
        }
        catch (Exception e) {
            String emsg = e.toString();
            if (CHECK) {
                e.printStackTrace();
            }
            throw new Exception(String.format("Can't read text data (n=%d)%n%s", n, emsg));
        }
        return n;
    }

    private boolean nextToken(BufferedReader br, StringBuffer sb) throws Exception {
        sb.setLength(0);
        boolean string = false;
        boolean checking = false;
        boolean dropping = false;
        int pos = 0;
        int chk = 0;
        int n = 0;
        int i = 0;
        if (this.drp != null && this.drp.active) {
            checking = true;
            pos = 0;
        }
        block0: while ((i = br.read()) >= 0) {
            char c = (char)i;
            if (this.drp != null) {
                if (dropping) {
                    if (c != '\n') continue;
                    dropping = false;
                    this.drp.active = true;
                }
                if (checking) {
                    if (this.drp.count > 0) {
                        chk = 1;
                        --this.drp.count;
                    } else {
                        chk = this.drp.check(c, pos);
                    }
                    if (chk > 0) {
                        dropping = true;
                        checking = false;
                        string = false;
                        sb.setLength(0);
                        this.drp.active = false;
                        continue;
                    }
                    if (chk < 0) {
                        checking = false;
                        this.drp.active = false;
                    } else {
                        ++pos;
                    }
                }
                if (c == '\n') {
                    this.drp.active = true;
                    checking = true;
                    pos = 0;
                }
            }
            if (string) {
                if (c == '\\') {
                    i = br.read();
                    if (i < 0) break;
                    c = (char)i;
                    if (c != '\"') {
                        throw new Exception("invalid escape sequence");
                    }
                } else if (c == '\"') {
                    break;
                }
            } else {
                if (c == '\'') {
                    while ((i = br.read()) >= 0) {
                        c = (char)i;
                        if (c == '\n') continue block0;
                    }
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    if (n <= 0) continue;
                    break;
                }
                if (c == '\"') {
                    if (n > 0) {
                        throw new Exception("invalid quotation");
                    }
                    string = true;
                    continue;
                }
            }
            sb.append(c);
            ++n;
        }
        if (i < 0) {
            throw new Exception("end of file found");
        }
        return string;
    }

    private void putDmn(IBJarr arr, String fn) throws Exception {
        IBJarr brr = null;
        PrintWriter pw = null;
        FilterOutputStream bo = null;
        String gn = String.valueOf(fn) + ".dmna";
        try {
            IBJhdr hdr = arr.getHeader();
            this.header = new IBJhdr(hdr);
            this.checkHeader(arr, fn);
            if (fn.equals("stdout")) {
                this.mode = "text";
                this.data = "*";
                pw = new PrintWriter(System.out);
            } else {
                pw = this.getWriter(gn, this.chsn, 0);
            }
            this.writeHeader(pw);
            if (this.sequ == null) {
                brr = arr;
            } else {
                if (CHECK) {
                    System.err.println("writing mapped array");
                }
                brr = arr.getSelected("mapped", this.sequ);
            }
            if (this.mode.equals("binary")) {
                pw.close();
                pw = null;
                File f = new File(fn);
                File g = f.getParentFile();
                f = new File(g, this.data);
                bo = this.getOutputStream(f.getPath(), this.cmpr);
                this.writeBinary((BufferedOutputStream)bo, brr);
                bo.close();
                bo = null;
            } else {
                if (!this.data.equals("*")) {
                    pw.close();
                    pw = null;
                    File f = new File(fn);
                    File g = f.getParentFile();
                    f = new File(g, this.data);
                    pw = this.getWriter(f.getPath(), this.chsn, this.cmpr);
                }
                this.writeText(pw, brr);
                pw.printf("***%n", new Object[0]);
                pw.flush();
                if (!fn.equals("stdout")) {
                    pw.close();
                }
                pw = null;
            }
        }
        catch (Exception e) {
            String emsg = e.toString();
            if (CHECK) {
                e.printStackTrace();
            }
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(String.format("Can't write file \"%s\"%n%s", fn, emsg));
        }
    }

    private void writeText(PrintWriter pw, IBJarr arr) throws Exception {
        arr.printAll(null, pw);
    }

    private void writeBinary(BufferedOutputStream bo, IBJarr arr) throws Exception {
        try {
            arr.setLSBF(!this.lsbf.equals("0"));
            int na = arr.arrays.size();
            if (na == 0) {
                return;
            }
            IBJarr.AbstractArray aa = arr.arrays.get(0);
            IBJarr.Structure strc = arr.getStructure();
            int[] ff = strc.getFirstIndex();
            int[] ll = strc.getLastIndex();
            int[] ii = (int[])ff.clone();
            int ns = strc.getDims();
            int i = 0;
            block2: while (i >= 0) {
                int k = 0;
                while (k < na) {
                    if (na > 1) {
                        aa = arr.arrays.get(k);
                    }
                    aa.toBuffer(ii);
                    bo.write(aa.bytes, 0, aa.bytes.length);
                    ++k;
                }
                i = ns - 1;
                while (i >= 0) {
                    int n = i;
                    ii[n] = ii[n] + 1;
                    if (ii[i] <= ll[i]) continue block2;
                    ii[i] = ff[i];
                    --i;
                }
            }
        }
        catch (Exception e) {
            String emsg = e.toString();
            if (CHECK) {
                e.printStackTrace();
            }
            throw new Exception(String.format("Can't write binary data%n%s", emsg));
        }
    }

    private void checkHeader(IBJarr arr, String fn) throws Exception {
        String ni;
        int size = 0;
        IBJhdr hdr = this.header;
        IBJarr.Structure struc = arr.getStructure();
        hdr.putInteger("dims", struc.getDims(), "%d");
        hdr.putIntegers("lowb", struc.getFirstIndex(), "%d");
        hdr.putIntegers("hghb", struc.getLastIndex(), "%d");
        hdr.putString("file", new File(fn).getName(), true);
        int na = arr.getSize();
        int i = 0;
        while (i < na) {
            ni = arr.arrays.get(i).getName();
            if (ni == null) {
                throw new Exception("undefined name");
            }
            ++i;
        }
        i = 0;
        while (i < na) {
            ni = arr.arrays.get(i).getName();
            int j = i + 1;
            while (j < na) {
                String nj = arr.arrays.get(j).getName();
                if (ni.equals(nj)) {
                    throw new Exception("duplicate name");
                }
                ++j;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        String[] frms = new String[na];
        int i2 = 0;
        while (i2 < na) {
            IBJarr.AbstractArray aa = arr.arrays.get(i2);
            frms[i2] = aa.desc.format;
            size += aa.desc.length;
            if (aa.valdef != null) {
                sb.append(aa.valdef);
            }
            if (sb.length() > 0 && sb.length() != i2 + 1) {
                throw new Exception("inconsistent definition of valdef");
            }
            ++i2;
        }
        hdr.putInteger("size", size, "%d");
        hdr.putStrings("form", frms, true);
        if (sb.length() > 0) {
            hdr.putString("vldf", sb.toString(), true);
        }
        this.mode = hdr.getString("mode", true);
        if (this.mode == null || !this.mode.equals("binary")) {
            this.mode = "text";
            hdr.putString("mode", this.mode, true);
        }
        this.cmpr = hdr.getInteger("cmpr");
        if (this.cmpr < 0 || this.cmpr > 9) {
            this.cmpr = 0;
            hdr.putInteger("cmpr", this.cmpr, "%d");
        }
        this.data = hdr.getString("data", true);
        if (this.data == null) {
            this.data = "*";
            hdr.putString("data", this.data, true);
        }
        if (this.data.equals("*") && (this.mode.equals("binary") || this.cmpr > 0)) {
            String n = new File(fn).getName();
            if (n.endsWith(".dmna")) {
                n = n.substring(0, n.length() - 5);
            }
            this.data = String.valueOf(n) + (this.mode.equals("binary") ? ".dmnb" : ".dmnt");
            if (this.cmpr > 0) {
                this.data = String.valueOf(this.data) + ".gz";
            }
        }
        this.sequ = hdr.getString("sequ", true);
        this.chsn = hdr.getString("chsn|cset", true);
        if (this.chsn == null) {
            this.chsn = Charset.defaultCharset().name();
            hdr.putString("chsn", this.chsn, true);
        }
        arr.setCharset(this.chsn);
        this.lsbf = hdr.getString("lsbf", true);
        if (this.lsbf == null) {
            this.lsbf = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "1" : "0";
            hdr.putString("lsbf", this.lsbf, false);
        }
        arr.setLSBF(!this.lsbf.equals("0"));
        this.tmzn = hdr.getString("tmzn", true);
        if (this.tmzn == null) {
            this.tmzn = TimeZone.getDefault().getID();
            hdr.putString("tmzn", this.tmzn, true);
        }
        arr.setTimeZone(this.tmzn);
        this.locl = hdr.getString("locl", true);
        if (this.locl == null) {
            this.locl = "C";
            hdr.putString("locl", this.locl, true);
        }
        arr.setLocale(this.locl);
    }

    private void writeHeader(PrintWriter pw) throws Exception {
        IBJhdr hdr = this.header;
        String format = this.artm ? "%s\t%s%n" : "%-8s %s%n";
        for (String key : hdr.p.keySet()) {
            String value = hdr.p.get(key);
            pw.printf(format, key, value);
        }
        pw.printf("*%n", new Object[0]);
        pw.flush();
    }

    public static IBJarr readDmn(String fn) throws Exception {
        return IBJdmn.readDmn(fn, null, false);
    }

    public static IBJarr readDmn(String fn, String chsn, boolean force) throws Exception {
        IBJarr arr = null;
        if (fn.endsWith(".dmna")) {
            fn = fn.substring(0, fn.length() - 5);
            IBJdmn dmn = new IBJdmn();
            dmn.chsn = chsn == null ? Charset.defaultCharset().name() : chsn;
            arr = dmn.getDmn(fn, force);
        }
        return arr;
    }

    public static IBJhdr readDmnHeader(String fn) {
        return IBJdmn.readDmnHeader(fn, null, false);
    }

    public static IBJhdr readDmnHeader(String fn, String chsn, boolean force) {
        if (chsn == null) {
            chsn = Charset.defaultCharset().name();
        }
        if (fn.endsWith(".dmna")) {
            fn = fn.substring(0, fn.length() - 5);
        }
        String gn = String.valueOf(fn) + ".dmna";
        File f = new File(gn);
        return IBJdmn.readDmnHeader(f, chsn, force);
    }

    public static IBJhdr readDmnHeader(File f, String chsn, boolean force) {
        IBJdmn dmn = new IBJdmn();
        if (chsn == null) {
            chsn = Charset.defaultCharset().name();
        }
        dmn.chsn = chsn;
        LineNumberReader lr = null;
        try {
            lr = dmn.getReader(f.getPath(), dmn.chsn, 0);
            String cn = dmn.readHeader(lr);
            if (!force && cn != null && !cn.equals(chsn)) {
                lr.close();
                dmn.header.p.clear();
                lr = dmn.getReader(f.getPath(), cn, 0);
                dmn.readHeader(lr);
            }
        }
        catch (Exception e) {
            if (CHECK) {
                e.printStackTrace();
            }
            return null;
        }
        return dmn.header;
    }

    public static void writeDmn(IBJarr arr, String fn) throws Exception {
        if (fn.endsWith(".dmna")) {
            fn = fn.substring(0, fn.length() - 5);
        }
        IBJdmn dmn = new IBJdmn();
        dmn.putDmn(arr, fn);
    }

    public static void writeDmn(IBJarr arr, String fn, boolean artm) throws Exception {
        if (fn.endsWith(".dmna")) {
            fn = fn.substring(0, fn.length() - 5);
        }
        IBJdmn dmn = new IBJdmn();
        dmn.setArtm(artm);
        dmn.putDmn(arr, fn);
    }

    private static void help() {
        prn.printf("IBJdmn:   Input and Output of data arrays, version %s\n", version);
        prn.printf("usage:    IBJdmn <path> <option ...>\n", new Object[0]);
        prn.printf("<path>    working directory\n", new Object[0]);
        prn.printf("<option>  -a<factor>    : scaling factor\n", new Object[0]);
        prn.printf("          -C<chsn>      : character set name\n", new Object[0]);
        prn.printf("          -c<level>     : compression level (0..9)\n", new Object[0]);
        prn.printf("          -d<data>      : name of output data file\n", new Object[0]);
        prn.printf("          -f<format>    : format of output data\n", new Object[0]);
        prn.printf("          -g<nodata>    : output as \"grid ascii\" with NODATA_value=nodata\n", new Object[0]);
        prn.printf("          -i<input>     : name of input file\n", new Object[0]);
        prn.printf("          -l<locale>    : \"C\" or \"german\"\n", new Object[0]);
        prn.printf("          -m<mode>      : \"binary\" or \"text\"\n", new Object[0]);
        prn.printf("          -o<name>      : name of ouput file\n", new Object[0]);
        prn.printf("          -p            : print output to screen\n", new Object[0]);
        prn.printf("          -S<selection> : selection of data for output\n", new Object[0]);
        prn.printf("          -s<sequence>  : index order in formatted output\n", new Object[0]);
        prn.printf("          -t<timezone>  : time zone as GMT[+|-]hh:mm\n", new Object[0]);
        prn.printf("          -u<options>   : use these options [acmst] from input for output\n", new Object[0]);
        System.exit(0);
    }

    private static void vMsg(String s, Object ... p) {
        prn.printf(s, p);
        prn.println();
        prn.flush();
        if (msg != null) {
            msg.printf("%tF.%<tT ", new Date());
            msg.printf(s, p);
            msg.println();
            msg.flush();
        }
    }

    public void putASC(IBJarr arr, String fn, double noda) throws Exception {
        double yref;
        IBJarr brr = null;
        PrintWriter pw = null;
        if (arr == null || fn == null) {
            throw new Exception("Missing argument in putASC()");
        }
        if (fn.endsWith(".asc")) {
            fn = fn.substring(0, fn.length() - 4);
        }
        String gn = String.valueOf(fn) + ".asc";
        IBJhdr hdr = arr.getHeader();
        Locale locale = hdr.getLocale();
        this.header = new IBJhdr(hdr);
        this.checkHeader(arr, fn);
        if (fn.equals("stdout")) {
            this.mode = "text";
            this.data = "*";
            pw = prn;
        } else {
            pw = this.getWriter(gn, this.chsn, 0);
        }
        if (Double.isNaN(noda)) {
            noda = -9999.0;
        }
        if (this.sequ == null) {
            brr = arr;
        } else {
            if (CHECK) {
                System.err.println("writing mapped array");
            }
            brr = arr.getSelected("mapped", this.sequ);
        }
        IBJarr.Structure struct = brr.getStructure();
        if (struct.getDims() != 2) {
            throw new Exception("GRID ASCII requires 2-dimensional array");
        }
        int[] ll = struct.getLength();
        double xmin = hdr.getDouble("xmin|x0");
        double ymin = hdr.getDouble("ymin|y0");
        double delt = hdr.getDouble("delta|delt|dd");
        double xref = hdr.getDouble("gakrx|refx");
        if (!Double.isNaN(xref)) {
            xmin += xref;
        }
        if (!Double.isNaN(yref = hdr.getDouble("gakry|refy"))) {
            ymin += yref;
        }
        pw.printf("nrows %10d%n", ll[1]);
        pw.printf("ncols %10d%n", ll[0]);
        pw.printf(locale, "xllcorner %s%n", this.shortFFormat(xmin));
        pw.printf(locale, "yllcorner %s%n", this.shortFFormat(ymin));
        pw.printf(locale, "cellsize  %s%n", this.shortFFormat(delt));
        pw.printf("NODATA_value  %s%n", this.shortFFormat(noda));
        brr.printAll(null, pw);
        pw.flush();
        if (pw != prn) {
            pw.close();
        }
    }

    private String shortFFormat(double f) {
        String s = String.format(Locale.ENGLISH, "%f", f);
        int id = s.indexOf(46);
        if (id < 0) {
            return s;
        }
        int i = 0;
        i = s.length() - 1;
        while (i >= id) {
            if (s.charAt(i) != '0' && s.charAt(i) != '.') break;
            --i;
        }
        s = s.substring(0, i + 1);
        return s;
    }

    public void putCSV(IBJarr arr, String fn) throws Exception {
        IBJarr brr = null;
        PrintWriter pw = null;
        if (arr == null || fn == null) {
            throw new Exception("Missing argument in putCSV()");
        }
        if (fn.endsWith(".csv")) {
            fn = fn.substring(0, fn.length() - 4);
        }
        String gn = String.valueOf(fn) + ".csv";
        IBJhdr hdr = arr.getHeader();
        this.header = new IBJhdr(hdr);
        this.checkHeader(arr, fn);
        if (fn.equals("stdout")) {
            this.mode = "text";
            this.data = "*";
            pw = prn;
        } else {
            pw = this.getWriter(gn, this.chsn, 0);
        }
        if (this.sequ == null) {
            brr = arr;
        } else {
            if (CHECK) {
                System.err.println("writing mapped array");
            }
            brr = arr.getSelected("mapped", this.sequ);
        }
        IBJarr.Structure structure = brr.getStructure();
        int ns = structure.getDims();
        if (ns != 2) {
            throw new Exception("CSV requires 2-dimensional array");
        }
        int na = brr.getSize();
        if (na != 1) {
            throw new Exception("CSV requires simple data elements");
        }
        Map<String, String> map = this.header.getMap();
        for (String key : map.keySet()) {
            String[] ss = this.header.getStrings(key, false);
            pw.printf("%s", key);
            int i = 0;
            while (i < ss.length) {
                pw.printf(";%s", ss[i]);
                ++i;
            }
            pw.println();
        }
        pw.printf("*%n", new Object[0]);
        if (this.sequ == null) {
            this.sequ = "i+,j+";
        }
        pw.printf("\"%s\"", this.sequ);
        brr.printAll(null, pw, ';');
        pw.flush();
        if (pw != prn) {
            pw.close();
        }
    }

    public static void main(String[] args) {
        prn = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        String Path2 = null;
        try {
            IBJarr out;
            IBJhdr hdr;
            IBJarr arr;
            String onam = null;
            String data = null;
            String inam = null;
            String fn = null;
            String form = null;
            String sequ = null;
            String mode = null;
            String locl = null;
            String use = null;
            String tmzn = null;
            String chsn = null;
            String gras = null;
            String selection = null;
            double noda = Double.NaN;
            if (args.length == 0) {
                IBJdmn.help();
            }
            onam = "test";
            int cmpr = -1;
            boolean printing = false;
            int verbose = 1;
            boolean list_format = false;
            boolean arcinfo = false;
            double fact = Double.NaN;
            int n = 0;
            while (n < args.length) {
                block80: {
                    String s;
                    block79: {
                        s = args[n];
                        if (s.charAt(0) != '-' || s.length() <= 1) break block79;
                        String t = s.substring(2).trim();
                        switch (s.charAt(1)) {
                            case 'A': {
                                arcinfo = true;
                                break;
                            }
                            case 'a': {
                                fact = Double.valueOf(t);
                                break;
                            }
                            case 'C': {
                                chsn = t;
                                break;
                            }
                            case 'c': {
                                cmpr = Integer.valueOf(t);
                                break;
                            }
                            case 'd': {
                                data = t;
                                break;
                            }
                            case 'f': {
                                form = t;
                                break;
                            }
                            case 'g': {
                                gras = t;
                                break;
                            }
                            case 'h': {
                                IBJdmn.help();
                                break;
                            }
                            case 'i': {
                                inam = t;
                                break;
                            }
                            case 'L': {
                                list_format = true;
                                break;
                            }
                            case 'l': {
                                locl = t;
                                break;
                            }
                            case 'm': {
                                mode = t;
                                break;
                            }
                            case 'o': {
                                onam = t;
                                break;
                            }
                            case 'p': {
                                printing = true;
                                break;
                            }
                            case 'S': {
                                selection = t;
                                break;
                            }
                            case 's': {
                                sequ = t;
                                break;
                            }
                            case 't': {
                                tmzn = t;
                                break;
                            }
                            case 'u': {
                                use = t;
                                break;
                            }
                            case 'v': {
                                if (t.length() <= 0) break block80;
                                verbose = Integer.valueOf(t);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block80;
                    }
                    Path2 = s;
                }
                ++n;
            }
            Path2 = Path2 != null ? Path2.replace('\\', '/') : "./";
            File f = new File(Path2, "IBJdmn.log");
            msg = new PrintWriter(new FileOutputStream(f), true);
            IBJdmn.vMsg("IBJdmn: Input and Output of data arrays, version %s of %s", version, last_change);
            IBJdmn.vMsg("Copyright (C) Janicke Consulting, \u00dcberlingen, Germany, 1998-2010", new Object[0]);
            int i = 0;
            while (i < n) {
                msg.printf(">%s\n", args[i]);
                ++i;
            }
            if (inam != null) {
                if (!inam.endsWith(".dmna")) {
                    inam = String.valueOf(inam) + ".dmna";
                }
                f = new File(Path2, inam);
                arr = IBJdmn.readDmn(f.getPath());
                if (verbose > 0) {
                    IBJdmn.vMsg("file \"%s\" read", f);
                }
                hdr = arr.getHeader();
                if (verbose > 1) {
                    IBJdmn.vMsg("IN  header:\n%s\n", hdr.getList());
                }
                if (use != null) {
                    if (cmpr < 0 && use.indexOf(99) >= 0) {
                        cmpr = hdr.getInteger("cmpr");
                    }
                    if (mode == null && use.indexOf(109) >= 0) {
                        mode = hdr.getString("mode", true);
                    }
                    if (sequ == null && use.indexOf(115) >= 0) {
                        sequ = hdr.getString("sequ", true);
                    }
                    if (tmzn == null && use.indexOf(116) >= 0) {
                        tmzn = hdr.getString("tmzn", true);
                    }
                    if (Double.isNaN(fact) && use.indexOf(97) >= 0) {
                        hdr.getDouble("fact");
                    }
                }
                hdr.rename("cmpr", null);
                hdr.rename("mode", null);
                hdr.rename("sequ", null);
                hdr.rename("tmzn", null);
                hdr.rename("fact", null);
                if (list_format) {
                    IBJdmn.vMsg("IN structure:\n%s\n", arr.listInfo());
                }
            } else {
                arr = new IBJarr("test-array", 3, 3, 5);
                arr.setFirstIndex(1, 2, 0);
                hdr = arr.getHeader();
                IBJarr.FloatArray fa = (IBJarr.FloatArray)arr.createArray("ff%8.2f");
                int i2 = 1;
                while (i2 <= 3) {
                    int j = 2;
                    while (j <= 4) {
                        int k = 0;
                        while (k <= 4) {
                            fa.set(100 * i2 + 10 * j + k, i2, j, k);
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                form = "%8.2f";
            }
            if (printing) {
                mode = "text";
                fn = "stdout";
            } else {
                if (onam == null) {
                    IBJdmn.vMsg("*** error: No output file name given.\n", new Object[0]);
                    return;
                }
                fn = new File(Path2, onam).getPath();
            }
            if (locl == null) {
                locl = "C";
            }
            hdr.setLocale(locl);
            if (form != null) {
                out = arr.reform(form, true);
                hdr = arr.getHeader();
            } else {
                out = arr;
            }
            arr = null;
            if (selection != null) {
                out = out.getSelected(out.getName(), selection);
                IBJarr.Mapping mapping = out.getMapping();
                hdr = out.getHeader();
                String artp = hdr.getString("artp", true);
                if (artp != null && artp.equals("C") && mapping.dst.getDims() == 4 && mapping.dst.getFirstIndex()[3] == 0) {
                    String axes = hdr.getString("axes", true);
                    String[] name = hdr.getStrings("name", true);
                    String[] unit = hdr.getStrings("unit", true);
                    String[] refc = hdr.getStrings("refc", false);
                    String[] refd = hdr.getStrings("refd", false);
                    int nc = mapping.dst.getLength()[3];
                    int dims = out.getStructure().getDims();
                    int[][] mat = mapping.mat;
                    int il = 0;
                    while (il < dims) {
                        if (mat[3][il] != 0) break;
                        ++il;
                    }
                    int[] first = out.getStructure().getFirstIndex();
                    int[] lngth = out.getStructure().getLength();
                    int nl = il < dims ? lngth[il] : 1;
                    int[] ll = new int[nl];
                    int l = 0;
                    while (l < nl) {
                        int[] ii = mapping.map(first);
                        ll[l] = ii[3];
                        if (il >= dims) break;
                        int n2 = il;
                        first[n2] = first[n2] + 1;
                        ++l;
                    }
                    if (name != null && name.length == nc) {
                        String[] new_name = new String[nl];
                        int l2 = 0;
                        while (l2 < nl) {
                            new_name[l2] = name[ll[l2]];
                            ++l2;
                        }
                        hdr.putStrings("name", new_name, true);
                    }
                    if (unit != null && unit.length == nc) {
                        String[] new_unit = new String[nl];
                        int l3 = 0;
                        while (l3 < nl) {
                            new_unit[l3] = unit[ll[l3]];
                            ++l3;
                        }
                        hdr.putStrings("unit", new_unit, true);
                    }
                    if (refc != null && refc.length == nc) {
                        String[] new_refc = new String[nl];
                        int l4 = 0;
                        while (l4 < nl) {
                            new_refc[l4] = refc[ll[l4]];
                            ++l4;
                        }
                        hdr.putStrings("refc", new_refc, false);
                    }
                    if (refd != null && refd.length == nc) {
                        String[] new_refd = new String[nl];
                        int l5 = 0;
                        while (l5 < nl) {
                            new_refd[l5] = refd[ll[l5]];
                            ++l5;
                        }
                        hdr.putStrings("refd", new_refd, false);
                    }
                    if (axes != null && axes.length() == 4) {
                        String new_axes = "";
                        int i3 = 0;
                        while (i3 < dims) {
                            int j = 0;
                            while (j < 4) {
                                if (mat[j][i3] != 0) {
                                    new_axes = String.valueOf(new_axes) + axes.substring(j, j + 1);
                                    break;
                                }
                                ++j;
                            }
                            ++i3;
                        }
                        hdr.putString("axes", new_axes, true);
                    }
                }
            }
            if (locl != null) {
                hdr.putString("locl", locl, true);
            }
            if (mode != null) {
                hdr.putString("mode", mode, true);
            }
            if (data != null) {
                hdr.putString("data", data, true);
            }
            if (sequ != null) {
                hdr.putString("sequ", sequ, true);
            }
            if (form != null) {
                hdr.putString("form", form, true);
            }
            if (cmpr >= 0) {
                hdr.putInteger("cmpr", cmpr, "%d");
            }
            if (tmzn != null) {
                hdr.putString("tmzn", tmzn, true);
            }
            if (chsn != null) {
                hdr.putString("chsn", chsn, true);
            }
            if (!Double.isNaN(fact)) {
                hdr.putDouble("fact", fact, "%12.3e");
            }
            if (list_format) {
                IBJdmn.vMsg("OUT structure:\n%s", out.listInfo());
            }
            if (verbose > 1) {
                IBJdmn.vMsg("OUT header:\n%s", hdr.getList());
            }
            if (gras != null) {
                noda = Double.parseDouble(gras);
                IBJdmn dmn = new IBJdmn();
                dmn.putASC(out, fn, noda);
            } else {
                IBJdmn.writeDmn(out, fn);
            }
            IBJdmn.vMsg("file \"%s\" written", fn);
            IBJdmn.vMsg("program finished", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            IBJdmn.vMsg("*** error:\n%s\n", e.toString());
        }
    }

    private static class Drop {
        int count = 0;
        boolean active = false;
        boolean equal = false;
        boolean any = false;
        String letters;

        private Drop(String s) throws Exception {
            int i = 0;
            if (s == null || s.length() == 0) {
                return;
            }
            String t = s;
            if (Character.isDigit(s.charAt(0))) {
                i = s.indexOf(59);
                if (i >= 0) {
                    t = s.substring(0, i);
                }
                this.count = Integer.valueOf(t);
                if (i < 0) {
                    return;
                }
                t = s.substring(i + 1);
            }
            if (t.charAt(0) == '=') {
                this.equal = true;
            } else if (t.charAt(0) != '!') {
                return;
            }
            if (t.charAt(1) == '[') {
                this.any = true;
                this.letters = t.substring(2, t.length() - 1);
            } else {
                this.letters = t.substring(1);
            }
        }

        private int check(char c, int pos) {
            if (!this.active || this.letters == null || this.letters.length() == 0) {
                return -1;
            }
            if (this.any) {
                int i = 0;
                while (i < this.letters.length()) {
                    char l = this.letters.charAt(i);
                    if (l == '@' && Character.isLetter(c) == this.equal) {
                        return 1;
                    }
                    if (this.letters.indexOf(c) >= 0 == this.equal) {
                        return 1;
                    }
                    ++i;
                }
            } else {
                if (pos < 0 || pos >= this.letters.length()) {
                    return -1;
                }
                if (this.equal) {
                    if (c == this.letters.charAt(pos)) {
                        if (pos == this.letters.length() - 1) {
                            return 1;
                        }
                        return 0;
                    }
                    return -1;
                }
                if (c == this.letters.charAt(pos)) {
                    if (pos == this.letters.length() - 1) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            return -1;
        }
    }
}

