/*
 * Decompiled with CFR 0.152.
 */
package de.janicke.ibjutil;

import de.janicke.ibjutil.IBJdcl;
import de.janicke.ibjutil.IBJhdr;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;

public class IBJarr
implements IBJdcl {
    public static boolean CHECK = false;
    public Vector<AbstractArray> arrays;
    private Charset charset = Charset.defaultCharset();
    private ByteOrder byteorder = ByteOrder.nativeOrder();
    private float factor = 1.0f;
    private String host_name;
    private Structure structure;
    private Mapping mapping;
    private IBJhdr header;

    private IBJarr(String name) {
        this.host_name = name;
    }

    public IBJarr(String name, int ... ii) throws Exception {
        this.host_name = name;
        this.structure = new Structure(ii);
        this.header = new IBJhdr();
        this.arrays = new Vector();
    }

    public String getName() {
        return this.host_name;
    }

    public IBJhdr getHeader() {
        return this.header;
    }

    public void setHeader(IBJhdr hdr) {
        this.header = new IBJhdr(hdr);
    }

    public void setFirstIndex(int ... ii) throws Exception {
        this.structure.setFirstIndex(ii);
    }

    public Structure getStructure() {
        return this.structure;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public boolean checkStructure(Object array) {
        Vector<Integer> v = new Vector<Integer>();
        int[] nArray = this.structure.length;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            v.add(i);
            ++n2;
        }
        return this.checkStructure(array, v);
    }

    private boolean checkStructure(Object array, Vector<Integer> pv) {
        boolean is_compatible;
        block7: {
            int n;
            block6: {
                is_compatible = true;
                n = Array.getLength(array);
                if (n == pv.get(0)) break block6;
                return false;
            }
            try {
                if (pv.size() <= 1) break block7;
                Vector<Integer> v = new Vector<Integer>();
                int i = 1;
                while (i < pv.size()) {
                    v.add(pv.get(i));
                    ++i;
                }
                i = 0;
                while (i < n) {
                    Object b = Array.get(array, i);
                    is_compatible = this.checkStructure(b, v);
                    if (is_compatible) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                is_compatible = false;
            }
        }
        return is_compatible;
    }

    public AbstractArray createArray(String format) throws Exception {
        Descriptor dsc = new Descriptor(format);
        return this.createArray(dsc, null);
    }

    public AbstractArray createArray(String format, Object array) throws Exception {
        Descriptor dsc = new Descriptor(format);
        return this.createArray(dsc, array);
    }

    private AbstractArray createArray(Descriptor desc, Object array) throws Exception {
        if (array != null && !this.checkStructure(array)) {
            throw new Exception("invalid structure of data array");
        }
        int i = 0;
        while (i < this.arrays.size()) {
            if (desc.name.equals(this.arrays.get(i).getName())) {
                throw new Exception("duplicate name");
            }
            ++i;
        }
        AbstractArray absarr = null;
        switch (desc.type) {
            case BYTE: {
                absarr = new ByteArray(array);
                break;
            }
            case SHORT: {
                absarr = new ShortArray(array);
                break;
            }
            case INTEGER: {
                absarr = new IntegerArray(array, null, null);
                break;
            }
            case LONG: {
                absarr = new LongArray(array);
                break;
            }
            case FLOAT: {
                absarr = new FloatArray(array);
                break;
            }
            case DOUBLE: {
                absarr = new DoubleArray(array, null, null);
                break;
            }
            case STRING: {
                absarr = new StringArray(array);
                break;
            }
            case TIME: {
                absarr = new TimeArray(array);
                break;
            }
            case DATE: {
                absarr = new DateArray(array);
                break;
            }
            default: {
                throw new Exception("type " + (Object)((Object)desc.type) + " not implemented");
            }
        }
        absarr.init(desc);
        this.arrays.add(absarr);
        if (CHECK) {
            System.err.println("array " + desc.name + " inserted at " + (this.arrays.size() - 1));
        }
        return absarr;
    }

    public int getSize() {
        return this.arrays.size();
    }

    public AbstractArray getArray(int index) throws Exception {
        if (index < 0 || index >= this.arrays.size()) {
            throw new Exception(String.format("index value %d not in range [%d,%d]", index, 0, this.arrays.size() - 1));
        }
        return this.arrays.get(index);
    }

    public AbstractArray getArray(String name) {
        AbstractArray a = null;
        int i = 0;
        while (i < this.arrays.size()) {
            a = this.arrays.get(i);
            if (name.equals(a.getName())) break;
            a = null;
            ++i;
        }
        return a;
    }

    public void setFormat(String name, String format) throws Exception {
        AbstractArray aa = this.getArray(name);
        if (aa == null) {
            throw new Exception("array not found");
        }
        Descriptor d = new Descriptor(format);
        AbstractArray bb = this.getArray(d.name);
        if (bb != null && bb != aa) {
            throw new Exception("duplicate name in format specification");
        }
        if (d.type != aa.desc.type) {
            throw new Exception("invalid data type in format specification");
        }
        aa.init(d);
    }

    public void setName(String oldName, String newName) throws Exception {
        if (oldName.equals(newName)) {
            return;
        }
        AbstractArray aa = this.getArray(oldName);
        if (aa == null) {
            throw new Exception("array not found");
        }
        AbstractArray bb = this.getArray(newName);
        if (bb != null && bb != aa) {
            throw new Exception("duplicate name");
        }
        aa.desc.name = newName;
    }

    public boolean isMapped() {
        return this.mapping != null;
    }

    public IBJarr getSelected(String name, String selection) throws Exception {
        IBJarr arr = new IBJarr(name);
        if (selection == null) {
            arr.mapping = this.mapping;
            arr.structure = this.structure;
        } else {
            arr.mapping = new Mapping(this.structure, selection, this.mapping);
            arr.structure = arr.mapping.src;
        }
        arr.header = new IBJhdr(this.header);
        arr.header.rename("sequ", null);
        arr.header.rename("lowb", null);
        arr.header.rename("hghb", null);
        arr.header.rename("dims", null);
        arr.arrays = new Vector();
        int i = 0;
        while (i < this.arrays.size()) {
            AbstractArray aa = this.arrays.get(i);
            AbstractArray bb = null;
            switch (aa.desc.type) {
                case BYTE: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new ByteArray((ByteArray)aa);
                    vector.add(bb);
                    break;
                }
                case SHORT: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new ShortArray((ShortArray)aa);
                    vector.add(bb);
                    break;
                }
                case INTEGER: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new IntegerArray((IntegerArray)aa, null, null);
                    vector.add(bb);
                    break;
                }
                case LONG: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new LongArray((LongArray)aa);
                    vector.add(bb);
                    break;
                }
                case FLOAT: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new FloatArray((FloatArray)aa);
                    vector.add(bb);
                    break;
                }
                case DOUBLE: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new DoubleArray((DoubleArray)aa, null, null);
                    vector.add(bb);
                    break;
                }
                case STRING: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new StringArray((StringArray)aa);
                    vector.add(bb);
                    break;
                }
                case TIME: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new TimeArray((TimeArray)aa);
                    vector.add(bb);
                    break;
                }
                case DATE: {
                    Vector<AbstractArray> vector = arr.arrays;
                    IBJarr iBJarr = arr;
                    iBJarr.getClass();
                    bb = iBJarr.new DateArray((DateArray)aa);
                    vector.add(bb);
                    break;
                }
                default: {
                    throw new Exception("unknown type");
                }
            }
            if (bb != null) {
                bb.fact = aa.fact;
            }
            ++i;
        }
        return arr;
    }

    public IBJarr getCopy(String name) throws Exception {
        IBJarr arr = new IBJarr(name, this.structure.length);
        arr.setFirstIndex(this.structure.first);
        arr.header = new IBJhdr(this.header);
        arr.arrays = new Vector();
        int i = 0;
        while (i < this.arrays.size()) {
            AbstractArray aa = this.arrays.get(i);
            AbstractArray cc = aa.getCopy(arr);
            arr.arrays.add(cc);
            ++i;
        }
        return arr;
    }

    public void printInfo(PrintWriter pw) {
        if (pw == null) {
            return;
        }
        pw.printf("IBJarr %s", this.host_name);
        if (this.isMapped()) {
            pw.printf(" (mapped)", new Object[0]);
        }
        pw.println();
        this.structure.print("Structure:", pw);
        pw.printf("Components:\n", new Object[0]);
        int i = 0;
        while (i < this.arrays.size()) {
            AbstractArray aa = this.arrays.get(i);
            pw.printf("%2d: %8s %12s %8s %2d %s\n", new Object[]{i + 1, aa.desc.name, aa.desc.cfrm, aa.desc.jfrm, aa.desc.length, aa.desc.type});
            ++i;
        }
    }

    public String listInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printInfo(pw);
        return sw.toString();
    }

    public void printAll(String title, PrintWriter pw) throws Exception {
        this.printAll(title, pw, ' ');
    }

    public void printAll(String title, PrintWriter pw, char sep) throws Exception {
        if (pw == null) {
            return;
        }
        if (title != null) {
            pw.println(title);
        }
        int ns = this.structure.dims;
        int[] ii = (int[])this.structure.first.clone();
        int na = this.arrays.size();
        int i = 0;
        block0: while (i >= 0) {
            int k = 0;
            while (k < na) {
                AbstractArray aa = this.arrays.get(k);
                pw.print(sep);
                if (aa.getType() == IBJdcl.DataType.STRING) {
                    pw.printf("\"%s\"", aa.format(ii));
                } else {
                    pw.print(aa.format(ii));
                }
                ++k;
            }
            if (na > 1) {
                pw.println();
            }
            i = ns - 1;
            while (i >= 0) {
                int n = i;
                ii[n] = ii[n] + 1;
                if (ii[i] < this.structure.first[i] + this.structure.length[i]) continue block0;
                ii[i] = this.structure.first[i];
                pw.println();
                --i;
            }
        }
        pw.flush();
    }

    public void setTimeZone(String s) {
        this.header.setTimeZone(s);
    }

    public String getTimeZone() {
        return this.header.getTimeZone().getID();
    }

    public void setLSBF(boolean lsbf) {
        this.byteorder = lsbf ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        int na = this.arrays.size();
        int i = 0;
        while (i < na) {
            AbstractArray aa = this.arrays.get(i);
            aa.buffer.order(this.byteorder);
            ++i;
        }
    }

    public boolean isLSBF() {
        return this.byteorder == ByteOrder.LITTLE_ENDIAN;
    }

    public void setLocale(String locale) {
        this.header.setLocale(locale);
    }

    public Locale getLocale() {
        return this.header.getLocale();
    }

    public void setCharset(String chsn) {
        this.charset = Charset.forName(chsn);
    }

    public String getCharset() {
        return this.charset.name();
    }

    public void setFactor(float f) {
        this.factor = f;
        int na = this.arrays.size();
        int i = 0;
        while (i < na) {
            AbstractArray aa = this.arrays.get(i);
            if (Float.isNaN(aa.desc.fact)) {
                aa.fact = f;
            }
            ++i;
        }
    }

    public float getFactor() {
        return this.factor;
    }

    public IBJarr reform(String form, boolean force_new) throws Exception {
        String[] forms = Descriptor.expandFormat(form);
        return this.reform(forms, force_new);
    }

    public IBJarr reform(String[] forms, boolean force_new) throws Exception {
        int k;
        Descriptor d;
        Descriptor dsc;
        ArrayList<Descriptor> list = new ArrayList<Descriptor>();
        HashSet<Integer> setk = new HashSet<Integer>();
        int nk = this.getSize();
        int i = 0;
        while (i < forms.length) {
            Descriptor dsc2 = new Descriptor(forms[i]);
            if (!dsc2.width.equals("0")) {
                list.add(dsc2);
            }
            ++i;
        }
        int nd = list.size();
        int[] kk = new int[nd];
        if (nd == nk && !force_new) {
            i = 0;
            while (i < nk) {
                dsc = (Descriptor)list.get(i);
                d = this.arrays.get(i).getDescriptor();
                if (!dsc.name.equalsIgnoreCase(d.name) || !dsc.format.equals(d.format)) break;
                ++i;
            }
            if (i >= nk) {
                return this;
            }
        }
        i = 0;
        while (i < nd) {
            dsc = (Descriptor)list.get(i);
            k = 0;
            while (k < nk) {
                d = this.arrays.get(k).getDescriptor();
                if (dsc.name.equalsIgnoreCase(d.name) && dsc.type.equals((Object)d.type)) break;
                ++k;
            }
            if (k >= nk) {
                throw new Exception("No match found for format \"" + forms[i] + "\"");
            }
            if (setk.contains(k)) {
                throw new Exception("Duplicate match for format \"" + forms[i] + "\"");
            }
            kk[i] = k;
            setk.add(k);
            ++i;
        }
        IBJarr arr = new IBJarr(this.host_name, this.structure.length);
        arr.setFirstIndex(this.structure.first);
        arr.header = new IBJhdr(this.header);
        arr.arrays = new Vector();
        String[] new_forms = new String[nd];
        i = 0;
        while (i < nd) {
            Descriptor dsc3 = (Descriptor)list.get(i);
            k = kk[i];
            AbstractArray aa = this.arrays.get(k);
            aa.setDescriptor(dsc3);
            aa.fact = !Float.isNaN(dsc3.fact) ? dsc3.fact : arr.factor;
            arr.arrays.add(aa);
            new_forms[i] = dsc3.format;
            ++i;
        }
        arr.header.putStrings("form", new_forms, true);
        arr.header.rename("size", null);
        return arr;
    }

    public void printMapping(String title, PrintWriter pw) {
        if (this.mapping == null) {
            pw.printf("%s : not mapped\n", title);
            return;
        }
        this.mapping.print(title, pw);
    }

    private static void listMapping(Mapping mm, PrintWriter pw) {
        try {
            pw.println("\nmapping:");
            int ns = mm.src.dims;
            int[] ii = (int[])mm.src.first.clone();
            int i = 0;
            block2: while (i >= 0) {
                int[] jj = mm.map(ii);
                int k = 0;
                while (k < ii.length) {
                    pw.printf(" %2d", ii[k]);
                    ++k;
                }
                pw.printf(" --> ", new Object[0]);
                k = 0;
                while (k < jj.length) {
                    pw.printf(" %2d", jj[k]);
                    ++k;
                }
                pw.println();
                i = ns - 1;
                while (i >= 0) {
                    int n = i;
                    ii[n] = ii[n] + 1;
                    if (ii[i] < mm.src.first[i] + mm.src.length[i]) continue block2;
                    ii[i] = mm.src.first[i];
                    --i;
                }
            }
            pw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test01() {
        try {
            IBJarr arr = new IBJarr("test", 3, 4);
            arr.setFirstIndex(1, 1);
            arr.setTimeZone(null);
            IBJhdr hdr = arr.getHeader();
            hdr.putString("title", "A simple example", true);
            hdr.putDate("created", IBJhdr.getDate(new Date()));
            arr.createArray("z0%(*100)5.2f");
            FloatArray fa_z0 = (FloatArray)arr.getArray("z0");
            arr.createArray("d0%5.2f");
            FloatArray fa_d0 = (FloatArray)arr.getArray("d0");
            int i = 1;
            while (i <= 3) {
                int j = 1;
                while (j <= 4) {
                    fa_z0.set(0.1f * (float)i, i, j++);
                }
                ++i;
            }
            float[][] z0 = (float[][])fa_z0.getData();
            float[][] d0 = (float[][])fa_d0.getData();
            int i2 = 0;
            while (i2 < 3) {
                int j = 0;
                while (j < 4) {
                    d0[i2][j] = 6.0f * z0[i2][j];
                    ++j;
                }
                ++i2;
            }
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            arr.printInfo(pw);
            pw.println("\nHeader:");
            hdr.print(pw);
            arr.printAll("\nThe data of " + hdr.getString("title", false), pw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        IBJarr.test01();
        try {
            int j;
            PrintWriter out = new PrintWriter(System.out);
            IBJarr arr = new IBJarr("ORG", 4, 3);
            boolean check = arr.checkStructure(new int[4][3]);
            out.println("check=" + check);
            arr.getStructure().setFirstIndex(new int[]{1, 1});
            FloatArray fa = (FloatArray)arr.createArray("ff%6.1f");
            int i = 1;
            while (i <= 4) {
                j = 1;
                while (j <= 3) {
                    fa.set(10 * i + j, i, j);
                    ++j;
                }
                ++i;
            }
            float[][] ff = (float[][])fa.getData();
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 3) {
                    out.printf(fa.desc.jfrm, Float.valueOf(ff[i][j]));
                    ++j;
                }
                out.println();
                ++i;
            }
            fa.print("float array ff", out);
            float[][] gg = new float[][]{{11.0f, 12.0f, 13.0f}, {21.0f, 22.0f, 23.0f}, {31.0f, 32.0f, 33.0f}, {41.0f, 42.0f, 43.0f}};
            FloatArray ga = (FloatArray)arr.createArray("gg%6.0f", (Object)gg);
            ga.print("float array gg", out);
            arr.printAll("all arrays", out);
            String s = "j-;i=2;";
            Mapping mm = new Mapping(arr.structure, s, null);
            mm.print("mapping " + s, out);
            IBJarr.listMapping(mm, out);
            IBJarr mrr = arr.getSelected("MAPPED", s);
            mrr.printInfo(out);
            FloatArray fm = (FloatArray)mrr.getArray("ff");
            fm.print("mapped:", out);
            IBJarr crr = mrr.getCopy("COPY");
            crr.printInfo(out);
            FloatArray fc = (FloatArray)crr.getArray("ff");
            fc.print("copied:", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract class AbstractArray {
        protected Object data;
        protected String valdef;
        protected Descriptor desc;
        protected ByteBuffer buffer;
        protected byte[] bytes;
        protected float fact = 1.0f;

        public abstract AbstractArray getCopy(IBJarr var1) throws Exception;

        public abstract String format(int ... var1) throws Exception;

        public abstract void parse(String var1, int ... var2) throws Exception;

        protected abstract void fromBuffer(int ... var1) throws Exception;

        protected abstract void toBuffer(int ... var1) throws Exception;

        public IBJdcl.DataType getType() {
            return this.desc.type;
        }

        public String getName() {
            return this.desc.name;
        }

        public String getFormat() {
            return this.desc.format;
        }

        public String getHost() {
            return IBJarr.this.host_name;
        }

        public Object getData() throws Exception {
            if (!this.isMapped()) {
                return this.data;
            }
            IBJarr arr = new IBJarr(null, IBJarr.this.structure.length);
            AbstractArray aa = this.getCopy(arr);
            return aa.data;
        }

        public Structure getStructure() {
            return IBJarr.this.structure;
        }

        public Descriptor getDescriptor() {
            return this.desc.getCopy();
        }

        public void setDescriptor(Descriptor dsc) throws Exception {
            if (dsc == null) {
                return;
            }
            if (this.desc == null) {
                throw new Exception("no old descriptor");
            }
            if (this.desc.type != dsc.type) {
                throw new Exception("invalid data type");
            }
            this.desc = dsc.getCopy();
            this.fact = !Float.isNaN(dsc.fact) ? dsc.fact : 1.0f;
        }

        public String getValdef() {
            return this.valdef;
        }

        public void setValdef(String valdef) {
            this.valdef = valdef;
        }

        public boolean isMapped() {
            return IBJarr.this.mapping != null;
        }

        public void print(String title, PrintWriter pw) throws Exception {
            if (title != null) {
                pw.println(title);
            }
            int ns = IBJarr.this.structure.dims;
            int[] ii = (int[])IBJarr.this.structure.first.clone();
            int i = 0;
            block0: while (i >= 0) {
                pw.print(' ');
                pw.print(this.format(ii));
                i = ns - 1;
                while (i >= 0) {
                    int n = i;
                    ii[n] = ii[n] + 1;
                    if (ii[i] <= IBJarr.this.structure.last[i]) continue block0;
                    ii[i] = IBJarr.this.structure.first[i];
                    pw.println();
                    --i;
                }
            }
            pw.flush();
        }

        protected void init(Descriptor desc) {
            this.desc = desc.getCopy();
            int buflen = desc.length;
            this.buffer = ByteBuffer.allocate(buflen);
            this.buffer.order(IBJarr.this.byteorder);
            this.bytes = this.buffer.array();
            this.fact = !Float.isNaN(desc.fact) ? desc.fact : IBJarr.this.factor;
        }
    }

    public class ByteArray
    extends AbstractArray {
        byte[] f1;
        byte[][] f2;
        byte[][][] f3;
        byte[][][][] f4;
        byte[][][][][] f5;

        private ByteArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new byte[ii[0]] : (byte[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new byte[ii[0]][ii[1]] : (byte[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new byte[ii[0]][ii[1]][ii[2]] : (byte[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new byte[ii[0]][ii[1]][ii[2]][ii[3]] : (byte[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new byte[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (byte[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private ByteArray(ByteArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            ByteArray fa = iBJarr.new ByteArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(byte f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public byte get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            byte f = 0;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(byte f) throws Exception {
            return String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, f);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            byte i = Integer.valueOf(s, this.desc.radix).byteValue();
            this.set(i, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            this.set(this.bytes[0], ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            this.bytes[0] = this.get(ii);
        }
    }

    public class DateArray
    extends DoubleArray {
        private DateArray(Object a) throws Exception {
            super(a);
        }

        private DateArray(DateArray src) {
            super(src);
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        @Override
        public String format(double d) throws Exception {
            return IBJhdr.formatDate(d, ((IBJarr)IBJarr.this).header.timezone);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            double d = IBJhdr.parseDate(s, ((IBJarr)IBJarr.this).header.timezone);
            this.set(d, ii);
        }
    }

    public static class Descriptor {
        String format;
        String name;
        String cfrm;
        float fact = Float.NaN;
        String flag = "";
        String width = "";
        String prcsn = "";
        String modfr = "";
        char cnvc;
        int size;
        int length;
        int radix = 10;
        IBJdcl.DataType type;
        Class clss;
        String jfrm;

        private Descriptor() {
        }

        public Descriptor(String frm) throws Exception {
            this();
            this.format = frm;
            try {
                int i = 0;
                int l = frm.length();
                int ip = frm.indexOf(37);
                this.name = frm.substring(0, ip);
                this.cfrm = frm.substring(ip);
                i = ip + 1;
                if (frm.charAt(i) == '(') {
                    while (i < l) {
                        if (frm.charAt(i) == ')') break;
                        ++i;
                    }
                    if (frm.charAt(ip + 2) == '*') {
                        this.fact = Float.valueOf(frm.substring(ip + 3, i)).floatValue();
                    }
                    ++i;
                }
                ip = i;
                if ("+- ".indexOf(frm.charAt(i)) >= 0) {
                    this.flag = frm.substring(i, i + 1);
                    ++ip;
                }
                i = ip;
                while (i < l) {
                    if (!Character.isDigit(frm.charAt(i))) break;
                    ++i;
                }
                if (i > ip) {
                    this.width = frm.substring(ip, i);
                    if (frm.charAt(i) == '.') {
                        ip = i;
                        i = ip + 1;
                        while (i < l) {
                            if (!Character.isDigit(frm.charAt(i))) break;
                            ++i;
                        }
                        this.prcsn = frm.substring(ip, i);
                    }
                }
                if ((ip = i) <= (i = l - 1)) {
                    this.modfr = frm.substring(ip, i);
                }
                this.cnvc = frm.charAt(i);
                this.jfrm = String.format("%%%s%s%s%c", this.flag, this.width, this.prcsn, Character.valueOf(this.cnvc));
                switch (this.cnvc) {
                    case 'x': {
                        this.radix = 16;
                    }
                    case 'd': {
                        if (this.modfr.equals("b")) {
                            this.size = 1;
                            this.type = IBJdcl.DataType.BYTE;
                            this.clss = Byte.TYPE;
                            break;
                        }
                        if (this.modfr.equals("h")) {
                            this.size = 2;
                            this.type = IBJdcl.DataType.SHORT;
                            this.clss = Short.TYPE;
                            break;
                        }
                        if (this.modfr.equals("L")) {
                            this.size = 8;
                            this.type = IBJdcl.DataType.LONG;
                            this.clss = Long.TYPE;
                            break;
                        }
                        this.size = 4;
                        this.type = IBJdcl.DataType.INTEGER;
                        this.clss = Integer.TYPE;
                        break;
                    }
                    case 'e': 
                    case 'f': {
                        if (this.modfr.equals("l")) {
                            this.size = 8;
                            this.type = IBJdcl.DataType.DOUBLE;
                            this.clss = Double.TYPE;
                            break;
                        }
                        this.size = 4;
                        this.type = IBJdcl.DataType.FLOAT;
                        this.clss = Float.TYPE;
                        break;
                    }
                    case 's': {
                        this.size = this.prcsn.length() > 1 ? Integer.valueOf(this.prcsn.substring(1)).intValue() : Integer.valueOf(this.width).intValue();
                        this.type = IBJdcl.DataType.STRING;
                        this.clss = String.class;
                        break;
                    }
                    case 't': {
                        if (this.modfr.equals("l")) {
                            this.size = 8;
                            this.type = IBJdcl.DataType.DATE;
                            this.clss = Long.TYPE;
                            this.jfrm = "%tF.%<tT";
                            break;
                        }
                        this.size = 4;
                        this.type = IBJdcl.DataType.TIME;
                        this.clss = Integer.TYPE;
                        this.jfrm = "%8d";
                        break;
                    }
                    default: {
                        throw new Exception("invalid conversion");
                    }
                }
                this.length = this.size;
            }
            catch (Exception e) {
                if (CHECK) {
                    e.printStackTrace();
                }
                throw new Exception("invalid format \"" + frm + "\"");
            }
        }

        private Descriptor getCopy() {
            Descriptor desc = new Descriptor();
            desc.cfrm = this.cfrm;
            desc.clss = this.clss;
            desc.cnvc = this.cnvc;
            desc.fact = this.fact;
            desc.flag = this.flag;
            desc.jfrm = this.jfrm;
            desc.modfr = this.modfr;
            desc.name = this.name;
            desc.prcsn = this.prcsn;
            desc.size = this.size;
            desc.length = this.length;
            desc.type = this.type;
            desc.width = this.width;
            desc.format = this.format;
            desc.radix = this.radix;
            return desc;
        }

        public static String[] expandFormat(String line) throws Exception {
            int len;
            String form = "tefdscx";
            Vector<String> v = new Vector<String>();
            if (line == null) {
                throw new Exception("no format string");
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) != '\"' && line.charAt(i) != ' ') {
                    sb.append(line.charAt(i));
                }
                ++i;
            }
            line = sb.toString();
            while ((len = line.length()) > 0) {
                i = line.indexOf(37);
                if (i < 0 || i >= len - 1) {
                    throw new Exception("missing format specifier");
                }
                int j = i + 1;
                int k = 0;
                while (j < len) {
                    if (line.charAt(j) == '(') {
                        ++k;
                    }
                    if (line.charAt(j) == ')') {
                        --k;
                    }
                    if (form.indexOf(line.charAt(j)) > -1 && k <= 0) break;
                    ++j;
                }
                if (j == len) {
                    throw new Exception("missing conversion specifier");
                }
                String s = line.substring(0, j + 1).trim();
                i = s.indexOf(91);
                if (i > -1) {
                    int n;
                    k = s.indexOf(93);
                    if (k < 0) {
                        throw new Exception("missing closing bracket ']'");
                    }
                    try {
                        n = Integer.parseInt(s.substring(i + 1, k));
                    }
                    catch (Exception e) {
                        throw new Exception("can't parse count");
                    }
                    String ss = String.valueOf(s.substring(0, i)) + s.substring(k + 1);
                    i = ss.indexOf(37) - 1;
                    k = 0;
                    while (k < n) {
                        sb = new StringBuffer(ss);
                        sb.setCharAt(i, (char)(ss.charAt(i) + k));
                        v.addElement(sb.toString());
                        ++k;
                    }
                } else {
                    v.addElement(s);
                }
                line = line.substring(j + 1);
            }
            String[] sa = v.toArray(new String[0]);
            return sa;
        }
    }

    public class DoubleArray
    extends AbstractArray {
        double[] f1;
        double[][] f2;
        double[][][] f3;
        double[][][][] f4;
        double[][][][][] f5;

        private DoubleArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new double[ii[0]] : (double[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new double[ii[0]][ii[1]] : (double[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new double[ii[0]][ii[1]][ii[2]] : (double[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new double[ii[0]][ii[1]][ii[2]][ii[3]] : (double[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new double[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (double[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private DoubleArray(DoubleArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            DoubleArray fa = iBJarr.new DoubleArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(double f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public double get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            double f = 0.0;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(double f) throws Exception {
            String s = String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, (double)this.fact * f);
            if (((IBJarr)IBJarr.this).header.locale == Locale.GERMAN) {
                s = s.replace('.', ',');
            }
            return s;
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            double d = Double.valueOf(s.replace(',', '.')) / (double)this.fact;
            this.set(d, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            double d = this.buffer.getDouble(0);
            this.set(d, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            double d = this.get(ii);
            this.buffer.putDouble(0, d);
        }

        /* synthetic */ DoubleArray(Object object, DoubleArray doubleArray, DoubleArray doubleArray2) throws Exception {
            this(object);
        }

        /* synthetic */ DoubleArray(DoubleArray doubleArray, DoubleArray doubleArray2, DoubleArray doubleArray3) {
            this(doubleArray);
        }
    }

    public class FloatArray
    extends AbstractArray {
        float[] f1;
        float[][] f2;
        float[][][] f3;
        float[][][][] f4;
        float[][][][][] f5;

        private FloatArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new float[ii[0]] : (float[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new float[ii[0]][ii[1]] : (float[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new float[ii[0]][ii[1]][ii[2]] : (float[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new float[ii[0]][ii[1]][ii[2]][ii[3]] : (float[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new float[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (float[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private FloatArray(FloatArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            FloatArray fa = iBJarr.new FloatArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(float f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public float get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            float f = 0.0f;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(float f) throws Exception {
            String s = String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, Float.valueOf(this.fact * f));
            if (((IBJarr)IBJarr.this).header.locale == Locale.GERMAN) {
                s = s.replace('.', ',');
            }
            return s;
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            float f = Float.valueOf(s.replace(',', '.')).floatValue() / this.fact;
            this.set(f, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            float f = this.buffer.getFloat(0);
            this.set(f, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            float f = this.get(ii);
            this.buffer.putFloat(0, f);
        }
    }

    public class IntegerArray
    extends AbstractArray {
        int[] f1;
        int[][] f2;
        int[][][] f3;
        int[][][][] f4;
        int[][][][][] f5;

        private IntegerArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new int[ii[0]] : (int[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new int[ii[0]][ii[1]] : (int[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new int[ii[0]][ii[1]][ii[2]] : (int[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new int[ii[0]][ii[1]][ii[2]][ii[3]] : (int[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new int[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (int[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private IntegerArray(IntegerArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            IntegerArray fa = iBJarr.new IntegerArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(int f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public int get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            int f = 0;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(int f) throws Exception {
            return String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, f);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            int i = Integer.valueOf(s, this.desc.radix);
            this.set(i, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            int i = this.buffer.getInt(0);
            this.set(i, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            int i = this.get(ii);
            this.buffer.putInt(0, i);
        }

        /* synthetic */ IntegerArray(Object object, IntegerArray integerArray, IntegerArray integerArray2) throws Exception {
            this(object);
        }

        /* synthetic */ IntegerArray(IntegerArray integerArray, IntegerArray integerArray2, IntegerArray integerArray3) {
            this(integerArray);
        }
    }

    public class LongArray
    extends AbstractArray {
        long[] f1;
        long[][] f2;
        long[][][] f3;
        long[][][][] f4;
        long[][][][][] f5;

        private LongArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new long[ii[0]] : (long[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new long[ii[0]][ii[1]] : (long[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new long[ii[0]][ii[1]][ii[2]] : (long[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new long[ii[0]][ii[1]][ii[2]][ii[3]] : (long[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new long[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (long[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private LongArray(LongArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            LongArray fa = iBJarr.new LongArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(long f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public long get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            long f = 0L;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(long f) throws Exception {
            return String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, f);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            long l = Long.valueOf(s, this.desc.radix);
            this.set(l, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            long l = this.buffer.getLong(0);
            this.set(l, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            long l = this.get(ii);
            this.buffer.putLong(0, l);
        }
    }

    public static class Mapping {
        public Structure src;
        public Structure dst;
        public int[][] mat;
        int[] dspl;

        private Mapping(Structure dst, String seq, Mapping mapping) throws Exception {
            this.dst = dst;
            int[][] ii = this.parse(seq);
            int nd = dst.dims;
            int ns = 0;
            int n = 0;
            while (n < nd) {
                if (ii[n][1] != 0) {
                    ++ns;
                }
                ++n;
            }
            this.src = new Structure(ns);
            int[] shift = new int[nd];
            int[][] m2 = new int[nd][ns];
            ns = 0;
            int n2 = 0;
            while (n2 < nd) {
                int m = ii[n2][0];
                if (ii[n2][1] != 0) {
                    m2[m][ns] = ii[n2][1];
                    ((Structure)this.src).first[ns] = ii[n2][4];
                    ((Structure)this.src).length[ns] = 1 + (ii[n2][1] > 0 ? ii[n2][3] - ii[n2][2] : ii[n2][2] - ii[n2][3]);
                    shift[m] = ii[n2][2];
                    ++ns;
                } else {
                    shift[m] = ii[n2][2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < ns) {
                ((Structure)this.src).last[n2] = this.src.first[n2] + this.src.length[n2] - 1;
                ++n2;
            }
            int[] d1 = new int[nd];
            int n3 = 0;
            while (n3 < nd) {
                d1[n3] = shift[n3];
                int i = 0;
                while (i < ns) {
                    int n4 = n3;
                    d1[n4] = d1[n4] - m2[n3][i] * this.src.first[i];
                    ++i;
                }
                ++n3;
            }
            if (mapping != null) {
                this.dst = mapping.dst;
                int[][] m1 = mapping.mat;
                int[] d0 = mapping.dspl;
                int n0 = m1.length;
                int n1 = m2.length;
                int n22 = ns;
                int[][] ms = new int[n0][n22];
                int i0 = 0;
                while (i0 < n0) {
                    int i2 = 0;
                    while (i2 < n22) {
                        int isum = 0;
                        int i1 = 0;
                        while (i1 < n1) {
                            isum += m1[i0][i1] * m2[i1][i2];
                            ++i1;
                        }
                        ms[i0][i2] = isum;
                        ++i2;
                    }
                    ++i0;
                }
                int[] ds = new int[n0];
                int i02 = 0;
                while (i02 < n0) {
                    ds[i02] = d0[i02];
                    int i1 = 0;
                    while (i1 < n1) {
                        int n5 = i02;
                        ds[n5] = ds[n5] + m1[i02][i1] * d1[i1];
                        ++i1;
                    }
                    ++i02;
                }
                this.dspl = ds;
                this.mat = ms;
            } else {
                this.dspl = d1;
                this.mat = m2;
            }
        }

        private void print(String title, PrintWriter pw) {
            int nd = this.dspl.length;
            int ns = this.src.first.length;
            pw.printf("%s\n", title);
            pw.printf("first\n", new Object[0]);
            int j = 0;
            while (j < ns) {
                pw.printf(" %3d  ", this.src.first[j]);
                int i = 0;
                while (i < nd) {
                    pw.printf(" %3d", this.mat[i][j]);
                    ++i;
                }
                if (j == 0) {
                    pw.printf("   ", new Object[0]);
                }
                pw.printf("\n", new Object[0]);
                ++j;
            }
            pw.printf("\ndspl: ", new Object[0]);
            int i = 0;
            while (i < nd) {
                pw.printf(" %3d", this.dspl[i]);
                ++i;
            }
            pw.printf("\n\n", new Object[0]);
            pw.flush();
        }

        private void print(String title, int[][] mm, int[] dd, int[] ff) {
            PrintWriter pw = new PrintWriter(System.out);
            int nd = dd.length;
            int ns = ff.length;
            pw.printf("%s\n", title);
            pw.printf("first\n", new Object[0]);
            int j = 0;
            while (j < ns) {
                pw.printf(" %3d  ", ff[j]);
                int i = 0;
                while (i < nd) {
                    pw.printf(" %3d", mm[i][j]);
                    ++i;
                }
                if (j == 0) {
                    pw.printf("   ", new Object[0]);
                }
                pw.printf("\n", new Object[0]);
                ++j;
            }
            pw.printf("\ndspl: ", new Object[0]);
            int i = 0;
            while (i < nd) {
                pw.printf(" %3d", dd[i]);
                ++i;
            }
            pw.printf("\n\n", new Object[0]);
            pw.flush();
        }

        public int[][] parse(String seq) throws Exception {
            int nd = this.dst.dims;
            boolean[] defined = new boolean[nd];
            seq = IBJhdr.unquote(seq);
            String[] tt = seq.split("[,;:]");
            if (CHECK) {
                int i = 0;
                while (i < tt.length) {
                    System.err.println(String.valueOf(i) + ": " + tt[i]);
                    ++i;
                }
            }
            if (tt.length != nd) {
                throw new Exception("mapping has invalid dimension");
            }
            int[][] ii = new int[nd][5];
            int nvi = Character.getNumericValue('i');
            int n = 0;
            while (n < nd) {
                String t = tt[n];
                if (t.length() < 1) {
                    throw new Exception("invalid token(" + (n + 1) + ")");
                }
                int m = Character.getNumericValue(t.charAt(0)) - nvi;
                if (m < 0 || m >= nd) {
                    throw new Exception("invalid index character \"" + t.charAt(0) + "\" (dims=" + nd + ")");
                }
                if (defined[m]) {
                    throw new Exception("duplicate specification for index \"" + t.charAt(0) + "\"");
                }
                defined[m] = true;
                ii[n][0] = m;
                if (t.length() == 1 || t.charAt(1) == '+') {
                    ii[n][1] = 1;
                    ii[n][2] = this.dst.first[m];
                    ii[n][3] = ii[n][2] + this.dst.length[m] - 1;
                    ii[n][4] = ii[n][2];
                } else if (t.charAt(1) == '-') {
                    ii[n][1] = -1;
                    ii[n][3] = this.dst.first[m];
                    ii[n][2] = ii[n][3] + this.dst.length[m] - 1;
                    ii[n][4] = ii[n][3];
                } else if (t.charAt(1) == '=') {
                    String s = t.substring(2);
                    int k = s.indexOf("..");
                    try {
                        if (k < 0) {
                            ii[n][2] = Integer.parseInt(s);
                            ii[n][4] = ii[n][2];
                        }
                        int l = s.indexOf(47, k + 2);
                        ii[n][2] = Integer.parseInt(s.substring(0, k));
                        if (l < 0) {
                            ii[n][3] = Integer.parseInt(s.substring(k + 2));
                            ii[n][4] = ii[n][3] >= ii[n][2] ? ii[n][2] : ii[n][3];
                        } else {
                            ii[n][3] = Integer.parseInt(s.substring(k + 2, l));
                            ii[n][4] = Integer.parseInt(s.substring(l + 1));
                        }
                        ii[n][1] = ii[n][3] >= ii[n][2] ? 1 : -1;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("parsing error for token \"" + t + "\"");
                    }
                } else {
                    throw new Exception("invalid mapping in token \"" + t + "\"");
                }
                if (CHECK) {
                    System.err.printf("%d: %3d %3d %3d %3d %3d\n", n, ii[n][0], ii[n][1], ii[n][2], ii[n][3], ii[n][4]);
                }
                ++n;
            }
            return ii;
        }

        public int[] map(int ... ii) throws Exception {
            int ni = this.src.dims;
            int nj = this.dst.dims;
            if (ii.length != ni) {
                throw new Exception("improper dimension");
            }
            int[] jj = new int[nj];
            int j = 0;
            while (j < nj) {
                int i = 0;
                while (i < ni) {
                    int n = j;
                    jj[n] = jj[n] + this.mat[j][i] * ii[i];
                    ++i;
                }
                int n = j;
                jj[n] = jj[n] + this.dspl[j];
                ++j;
            }
            return jj;
        }
    }

    public class ShortArray
    extends AbstractArray {
        short[] f1;
        short[][] f2;
        short[][][] f3;
        short[][][][] f4;
        short[][][][][] f5;

        private ShortArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.f1 = a == null ? new short[ii[0]] : (short[])a;
                    this.data = this.f1;
                    break;
                }
                case 2: {
                    this.f2 = a == null ? new short[ii[0]][ii[1]] : (short[][])a;
                    this.data = this.f2;
                    break;
                }
                case 3: {
                    this.f3 = a == null ? new short[ii[0]][ii[1]][ii[2]] : (short[][][])a;
                    this.data = this.f3;
                    break;
                }
                case 4: {
                    this.f4 = a == null ? new short[ii[0]][ii[1]][ii[2]][ii[3]] : (short[][][][])a;
                    this.data = this.f4;
                    break;
                }
                case 5: {
                    this.f5 = a == null ? new short[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (short[][][][][])a;
                    this.data = this.f5;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private ShortArray(ShortArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            ShortArray fa = iBJarr.new ShortArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(short f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public short get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            short f = 0;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format((int)this.get(ii));
        }

        public String format(int f) throws Exception {
            return String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, f);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            short i = Short.valueOf(s, this.desc.radix);
            this.set(i, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            short i = this.buffer.getShort(0);
            this.set(i, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            short i = this.get(ii);
            this.buffer.putShort(0, i);
        }
    }

    public class StringArray
    extends AbstractArray {
        String[] f1;
        String[][] f2;
        String[][][] f3;
        String[][][][] f4;
        String[][][][][] f5;

        private StringArray(Object a) throws Exception {
            int[] ii = IBJarr.this.structure.getLength();
            switch (ii.length) {
                case 1: {
                    this.data = this.f1 = a == null ? new String[ii[0]] : (String[])a;
                    break;
                }
                case 2: {
                    this.data = this.f2 = a == null ? new String[ii[0]][ii[1]] : (String[][])a;
                    break;
                }
                case 3: {
                    this.data = this.f3 = a == null ? new String[ii[0]][ii[1]][ii[2]] : (String[][][])a;
                    break;
                }
                case 4: {
                    this.data = this.f4 = a == null ? new String[ii[0]][ii[1]][ii[2]][ii[3]] : (String[][][][])a;
                    break;
                }
                case 5: {
                    this.data = this.f5 = a == null ? new String[ii[0]][ii[1]][ii[2]][ii[3]][ii[4]] : (String[][][][][])a;
                    break;
                }
                default: {
                    throw new Exception("invalid dimension");
                }
            }
        }

        private StringArray(StringArray src) {
            this.desc = src.desc.getCopy();
            this.data = src.data;
            this.valdef = src.valdef;
            this.f1 = src.f1;
            this.f2 = src.f2;
            this.f3 = src.f3;
            this.f4 = src.f4;
            this.f5 = src.f5;
            this.buffer = src.buffer;
            this.bytes = src.bytes;
        }

        @Override
        public AbstractArray getCopy(IBJarr arr) throws Exception {
            if (arr == null || !IBJarr.this.structure.equals(arr.getStructure())) {
                throw new Exception("incompatible structure");
            }
            if (arr.isMapped()) {
                throw new Exception("improper destination");
            }
            IBJarr iBJarr = arr;
            iBJarr.getClass();
            StringArray fa = iBJarr.new StringArray((Object)null);
            fa.init(this.desc);
            fa.valdef = this.valdef;
            boolean mapped = this.isMapped();
            int nd = IBJarr.this.structure.dims;
            int[] fi = IBJarr.this.structure.first;
            int i = 0;
            while (i < IBJarr.this.structure.length[0]) {
                if (nd == 1) {
                    fa.f1[i] = mapped ? this.get(fi[0] + i) : this.f1[i];
                } else {
                    int j = 0;
                    while (j < IBJarr.this.structure.length[1]) {
                        if (nd == 2) {
                            fa.f2[i][j] = mapped ? this.get(fi[0] + i, fi[1] + j) : this.f2[i][j];
                        } else {
                            int k = 0;
                            while (k < IBJarr.this.structure.length[2]) {
                                if (nd == 3) {
                                    fa.f3[i][j][k] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k) : this.f3[i][j][k];
                                } else {
                                    int l = 0;
                                    while (l < IBJarr.this.structure.length[3]) {
                                        if (nd == 4) {
                                            fa.f4[i][j][k][l] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l) : this.f4[i][j][k][l];
                                        } else {
                                            int m = 0;
                                            while (m < IBJarr.this.structure.length[4]) {
                                                fa.f5[i][j][k][l][m] = mapped ? this.get(fi[0] + i, fi[1] + j, fi[2] + k, fi[3] + l, fi[4] + m) : this.f5[i][j][k][l][m];
                                                ++m;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return fa;
        }

        public void set(String f, int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            switch (ii.length) {
                case 1: {
                    this.f1[ii[0] - i0[0]] = f;
                    break;
                }
                case 2: {
                    this.f2[ii[0] - i0[0]][ii[1] - i0[1]] = f;
                    break;
                }
                case 3: {
                    this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]] = f;
                    break;
                }
                case 4: {
                    this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]] = f;
                    break;
                }
                case 5: {
                    this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]] = f;
                }
            }
        }

        public String get(int ... ii) throws Exception {
            int[] i0 = IBJarr.this.structure.first;
            if (this.isMapped()) {
                ii = IBJarr.this.mapping.map(ii);
                i0 = ((IBJarr)IBJarr.this).mapping.dst.first;
            } else if (ii.length != IBJarr.this.structure.getDims()) {
                throw new Exception("invalid dimension");
            }
            String f = null;
            switch (ii.length) {
                case 1: {
                    f = this.f1[ii[0] - i0[0]];
                    break;
                }
                case 2: {
                    f = this.f2[ii[0] - i0[0]][ii[1] - i0[1]];
                    break;
                }
                case 3: {
                    f = this.f3[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]];
                    break;
                }
                case 4: {
                    f = this.f4[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]];
                    break;
                }
                case 5: {
                    f = this.f5[ii[0] - i0[0]][ii[1] - i0[1]][ii[2] - i0[2]][ii[3] - i0[3]][ii[4] - i0[4]];
                }
            }
            return f;
        }

        @Override
        public String format(int ... ii) throws Exception {
            return this.format(this.get(ii));
        }

        public String format(String f) throws Exception {
            return String.format(((IBJarr)IBJarr.this).header.locale, this.desc.jfrm, f);
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            if ((s = IBJhdr.unquote(s)).length() > this.desc.size) {
                s = s.substring(0, this.desc.size);
            }
            this.set(s, ii);
        }

        @Override
        public void fromBuffer(int ... ii) throws Exception {
            String s = new String(this.bytes, IBJarr.this.charset.name());
            s = s.trim();
            this.set(s, ii);
        }

        @Override
        public void toBuffer(int ... ii) throws Exception {
            String s = this.get(ii);
            byte[] bb = s.getBytes(IBJarr.this.charset.name());
            if (bb.length > this.bytes.length) {
                throw new Exception("buffer overflow");
            }
            int i = 0;
            while (i < bb.length) {
                this.bytes[i] = bb[i];
                ++i;
            }
            i = bb.length;
            while (i < this.bytes.length) {
                this.bytes[i] = 0;
                ++i;
            }
        }
    }

    public static class Structure {
        private int dims;
        private int[] first;
        private int[] last;
        private int[] length;

        private Structure(int dims) {
            this.dims = dims;
            this.first = new int[dims];
            this.last = new int[dims];
            this.length = new int[dims];
        }

        private Structure(int ... ii) {
            this.dims = ii.length;
            this.first = new int[this.dims];
            this.last = new int[this.dims];
            this.length = new int[this.dims];
            int i = 0;
            while (i < this.dims) {
                this.length[i] = ii[i];
                this.last[i] = ii[i] - 1;
                ++i;
            }
        }

        public boolean equals(Structure s) {
            if (s == null) {
                return false;
            }
            if (s.dims != this.dims) {
                return false;
            }
            int i = 0;
            while (i < this.dims) {
                if (s.length[i] != this.length[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void setFirstIndex(int ... ii) throws Exception {
            if (ii.length != this.dims) {
                throw new Exception("invalid length");
            }
            int i = 0;
            while (i < this.dims) {
                this.first[i] = ii[i];
                this.last[i] = ii[i] + this.length[i] - 1;
                ++i;
            }
        }

        public int getDims() {
            return this.dims;
        }

        public int[] getFirstIndex() {
            return (int[])this.first.clone();
        }

        public int[] getLastIndex() {
            return (int[])this.last.clone();
        }

        public int[] getLength() {
            return (int[])this.length.clone();
        }

        public void print(String title, PrintWriter pw) {
            pw.printf("%s\n", title);
            int i = 0;
            while (i < this.dims) {
                pw.printf("%2d: %3d ... %3d\n", i + 1, this.first[i], this.last[i]);
                ++i;
            }
            pw.flush();
        }
    }

    public class TimeArray
    extends IntegerArray {
        private TimeArray(Object a) throws Exception {
            super(a);
        }

        private TimeArray(TimeArray src) {
            super(src);
        }

        @Override
        public String format(int f) throws Exception {
            return IBJhdr.formatTime(f);
        }

        @Override
        public String format(int ... ii) throws Exception {
            return IBJhdr.formatTime(this.get(ii));
        }

        @Override
        public void parse(String s, int ... ii) throws Exception {
            int i = IBJhdr.parseTime(s);
            this.set(i, ii);
        }
    }
}

