/*
 * Decompiled with CFR 0.152.
 */
package de.janicke.ibjutil;

import de.janicke.util.CFormat;
import de.janicke.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class IBJDmnaFile {
    public String[][] data = null;
    public String[][] header;
    public String[] parFormat;
    public String[] hLabel;
    public String[] vLabel;
    public String[] parName;
    public String parSequence;
    public String fileName;
    public int nRows;
    public int nCols;
    public String errorMsg = "";
    public boolean textMode = false;
    public boolean oneDim = false;
    public boolean twoDim = false;
    public boolean onePar = false;
    private String[][] dataSorted = null;
    private int[] iLow;
    private int[] iHgh;
    private int[] indI;
    private int[] indJ;
    private boolean isIFirst = true;
    private boolean isIFwd = true;
    private boolean isJFwd = true;
    private final String CLASSNAME = new String("IBJDmnaFile");
    private final boolean DEBUG = true;

    public IBJDmnaFile(JFrame frame, String name) {
        String format = null;
        String s = null;
        BufferedReader in = null;
        File file = null;
        this.parSequence = new String("i+:j+");
        this.data = null;
        this.vLabel = null;
        this.hLabel = null;
        this.parFormat = null;
        this.parName = null;
        this.nCols = 0;
        this.nRows = 0;
        this.fileName = name;
        if (name == null) {
            return;
        }
        int i = name.indexOf(46);
        if (i < 0) {
            return;
        }
        if (!name.substring(i + 1).equals("dmna")) {
            return;
        }
        try {
            Object[] o;
            Integer ii;
            int j;
            file = new File(name);
            if (!file.exists()) {
                this.errorMsg = "Datei " + name + " existiert nicht";
                return;
            }
            in = new BufferedReader(new FileReader(name));
            int nh = 0;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).charAt(0) == '*') break;
                if (s.length() <= 0) continue;
                ++nh;
            }
            in.close();
            if (nh == 0) {
                throw new Exception("keine Daten");
            }
            this.header = new String[nh][2];
            System.out.println("DMNA: " + nh + " header lines");
            in = new BufferedReader(new FileReader(name));
            i = 0;
            while ((s = in.readLine()) != null) {
                s.trim();
                if (s.length() <= 0) continue;
                if (s.charAt(0) == '*') break;
                j = s.indexOf(32);
                if (j == -1) {
                    j = s.indexOf(9);
                }
                if (j == -1) {
                    this.header[i][0] = s.trim();
                    this.header[i][1] = " ";
                } else {
                    this.header[i][0] = s.substring(0, j).trim();
                    this.header[i][1] = s.substring(j + 1).trim();
                }
                ++i;
            }
            if (s == null) {
                throw new Exception("Startmarke '*' nicht gefunden");
            }
            s = (String)this.getValue("mode", String.class);
            if (s != null) {
                this.textMode = s.equals("text");
            }
            if ((ii = (Integer)this.getValue("dims", Integer.class)) != null) {
                this.oneDim = ii == 1;
                boolean bl = this.twoDim = ii == 2;
            }
            if ((s = (String)this.getValue("form", String.class)) != null) {
                format = s;
            }
            if ((s = (String)this.getValue("sequ", String.class)) != null) {
                this.parSequence = s;
            }
            System.out.println("DMNA: before analyseFormat");
            if (this.analyseFormat(format) < 0) {
                throw new Exception("<format> kann nicht behandelt werden");
            }
            if (!this.oneDim && !this.twoDim) {
                throw new Exception("<dims> > 2");
            }
            if (this.parFormat.length > 1 && this.twoDim) {
                throw new Exception("mehrere Parameter nur mit <dims>=1 m\ufffdglich");
            }
            System.out.println("DMNA: oneDim=" + this.oneDim + ", Format.length=" + this.parFormat.length);
            if (this.oneDim) {
                this.iLow = new int[1];
                this.iHgh = new int[1];
            } else {
                this.iLow = new int[2];
                this.iHgh = new int[2];
            }
            i = 0;
            while (i < nh) {
                if (this.header[i][0].equals("lowb")) {
                    o = this.extractObject(this.header[i][1], Integer.class, this.iLow.length, " \t");
                    j = 0;
                    while (j < this.iLow.length) {
                        this.iLow[j] = (Integer)o[j];
                        ++j;
                    }
                } else if (this.header[i][0].equals("hghb")) {
                    o = this.extractObject(this.header[i][1], Integer.class, this.iHgh.length, " \t");
                    j = 0;
                    while (j < this.iHgh.length) {
                        this.iHgh[j] = (Integer)o[j];
                        ++j;
                    }
                }
                ++i;
            }
            if (this.iLow == null || this.iHgh == null) {
                throw new Exception("<lowb> oder <hghb> nicht definiert");
            }
            System.out.println("DMNA: ilow=" + this.iLow[0] + ", ihgh=" + this.iHgh[0]);
            if (!this.oneDim) {
                System.out.println("DMNA: ilow=" + this.iLow[1] + ", ihgh=" + this.iHgh[1]);
            }
            if (this.oneDim) {
                this.nCols = this.parFormat.length;
                this.nRows = this.iHgh[0] - this.iLow[0] + 1;
                this.vLabel = new String[this.nRows];
                this.hLabel = new String[this.nCols];
                i = 0;
                while (i < this.nRows) {
                    this.vLabel[i] = Integer.toString(i + 1);
                    ++i;
                }
                i = 0;
                while (i < this.nCols) {
                    this.hLabel[i] = this.parName[i];
                    ++i;
                }
            } else if (this.analyseSequence(this.parSequence) < 0) {
                throw new Exception("<sequ> kann nicht behandelt werden");
            }
            System.out.println("DMNA: ready to read data");
            System.out.println("DMNA: nRows=" + this.nRows + ", nCols=" + this.nCols);
            this.data = new String[this.nRows][this.nCols];
            i = 0;
            while (i < this.nRows) {
                System.out.println("DMNA: einlesen Zeile " + i);
                s = in.readLine();
                if (s == null) {
                    throw new Exception("Datei zu fr\ufffdh zu Ende");
                }
                o = this.extractObject(s, String.class, this.nCols, " \t");
                if (o == null) {
                    throw new Exception("Datenzeile" + i);
                }
                j = 0;
                while (j < this.nCols) {
                    this.data[i][j] = (String)o[j];
                    ++j;
                }
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errorMsg = "Fehler beim Einlesen der Dmna-Datei (" + e.getMessage() + ")";
            System.out.println(this.errorMsg);
            this.data = null;
            this.vLabel = null;
            this.hLabel = null;
            this.parFormat = null;
            this.nCols = 0;
            this.nRows = 0;
            return;
        }
        if (this.twoDim) {
            this.sortData();
        }
    }

    void sortData() {
        this.dataSorted = this.isIFirst ? new String[this.nRows][this.nCols] : new String[this.nCols][this.nRows];
        int i = 0;
        while (i < this.nRows) {
            int ii = this.indI[i];
            int j = 0;
            while (j < this.nCols) {
                int jj = this.indJ[j];
                if (this.isIFirst) {
                    this.dataSorted[ii][jj] = this.data[i][j];
                } else {
                    this.dataSorted[jj][ii] = this.data[i][j];
                }
                ++j;
            }
            ++i;
        }
    }

    int analyseFormat(String format) {
        String df = new String("efds");
        int l = format.length();
        if (l < 2) {
            return -1;
        }
        int i = 0;
        int n = 0;
        while (i < l) {
            if (format.charAt(i) == '%') {
                ++n;
            }
            ++i;
        }
        if (n < 1) {
            return -1;
        }
        this.parName = new String[n];
        this.parFormat = new String[n];
        i = 0;
        int j = 0;
        while (i < n) {
            char c;
            StringBuffer buf = new StringBuffer(512);
            while (j < l) {
                c = format.charAt(j);
                ++j;
                buf.append(c);
                if (c == '%') break;
            }
            while (j < l) {
                c = format.charAt(j);
                ++j;
                buf.append(c);
                if (df.indexOf(c) >= 0) break;
            }
            CFormat.setString((String)buf.toString());
            this.parName[i] = CFormat.desc;
            this.parFormat[i] = buf.toString();
            System.out.println(String.valueOf(this.CLASSNAME) + ":" + this.parName[i] + ";" + this.parFormat[i] + ";");
            ++i;
        }
        return 0;
    }

    private Object[] extractObject(String s, Class cl, int n) {
        return this.extractObject(s, cl, n, " ");
    }

    private Object[] extractObject(String s, Class cl, int n, String seps) {
        int j;
        int i;
        if (s == null || n < 1) {
            return null;
        }
        if ((s = s.trim()).length() < 1) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s);
        Object[] o = cl == Integer.class ? new Integer[n] : (cl == Double.class ? new Double[n] : new String[n]);
        if (cl == String.class) {
            i = 0;
            j = -1;
            while (i < s.length()) {
                if (buf.charAt(i) == '\"') {
                    j *= -1;
                }
                if (j == 1 && buf.charAt(i) == ' ') {
                    buf.setCharAt(i, '\r');
                }
                ++i;
            }
            s = buf.toString();
        }
        StringTokenizer st = new StringTokenizer(s, seps);
        i = 0;
        while (i < n) {
            if (!st.hasMoreTokens()) break;
            String ss = st.nextToken();
            try {
                if (cl == Integer.class) {
                    o[i] = new Integer(Double.valueOf(ss).intValue());
                } else if (cl == Double.class) {
                    o[i] = Double.valueOf(ss);
                } else {
                    buf = new StringBuffer(ss.trim());
                    j = 0;
                    while (j < buf.length()) {
                        if (buf.charAt(j) == '\r') {
                            buf.setCharAt(j, ' ');
                        }
                        ++j;
                    }
                    o[i] = Util.unQuote((String)buf.toString());
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            ++i;
        }
        if (i != n) {
            return null;
        }
        return o;
    }

    public int analyseSequence(String sequence) {
        boolean hfwd;
        int j;
        int i;
        boolean vfwd;
        int i2;
        int i1;
        if (sequence.length() != 5) {
            return -1;
        }
        if (sequence.charAt(0) == 'i') {
            this.isIFirst = true;
        } else if (sequence.charAt(0) == 'j') {
            this.isIFirst = false;
        } else {
            return -1;
        }
        if (sequence.charAt(3) == 'i' && this.isIFirst) {
            return -1;
        }
        if (sequence.charAt(3) == 'j' && !this.isIFirst) {
            return -1;
        }
        if (sequence.charAt(1) == '+') {
            if (this.isIFirst) {
                this.isIFwd = true;
            } else {
                this.isJFwd = true;
            }
        } else if (sequence.charAt(1) == '-') {
            if (this.isIFirst) {
                this.isIFwd = false;
            } else {
                this.isJFwd = false;
            }
        } else {
            return -1;
        }
        if (sequence.charAt(4) == '+') {
            if (this.isIFirst) {
                this.isJFwd = true;
            } else {
                this.isIFwd = true;
            }
        } else if (sequence.charAt(4) == '-') {
            if (this.isIFirst) {
                this.isJFwd = false;
            } else {
                this.isIFwd = false;
            }
        } else {
            return -1;
        }
        if (this.isIFirst) {
            i1 = 0;
            i2 = 1;
        } else {
            i1 = 1;
            i2 = 0;
        }
        this.nRows = this.iHgh[i1] - this.iLow[i1] + 1;
        this.nCols = this.iHgh[i2] - this.iLow[i2] + 1;
        this.data = new String[this.nRows][this.nCols];
        this.hLabel = new String[this.nCols];
        this.vLabel = new String[this.nRows];
        this.indI = new int[this.nRows];
        this.indJ = new int[this.nCols];
        boolean bl = vfwd = this.isIFirst ? this.isIFwd : this.isJFwd;
        if (vfwd) {
            i = this.iLow[i1];
            j = 0;
            while (i <= this.iHgh[i1]) {
                this.vLabel[j] = Integer.toString(i);
                this.indI[j] = i - this.iLow[i1];
                ++i;
                ++j;
            }
        } else {
            i = this.iHgh[i1];
            j = 0;
            while (i >= this.iLow[i1]) {
                this.vLabel[j] = Integer.toString(i);
                this.indI[j] = i - this.iLow[i1];
                --i;
                ++j;
            }
        }
        boolean bl2 = hfwd = this.isIFirst ? this.isJFwd : this.isIFwd;
        if (hfwd) {
            i = this.iLow[i2];
            j = 0;
            while (i <= this.iHgh[i2]) {
                this.hLabel[j] = Integer.toString(i);
                this.indJ[j] = i - this.iLow[i2];
                ++i;
                ++j;
            }
        } else {
            i = this.iHgh[i2];
            j = 0;
            while (i >= this.iLow[i2]) {
                this.hLabel[j] = Integer.toString(i);
                this.indJ[j] = i - this.iLow[i2];
                --i;
                ++j;
            }
        }
        if (this.dataSorted == null) {
            return 0;
        }
        this.data = new String[this.nRows][this.nCols];
        i = 0;
        while (i < this.nRows) {
            int ii = this.indI[i];
            j = 0;
            while (j < this.nCols) {
                int jj = this.indJ[j];
                this.data[i][j] = this.isIFirst ? this.dataSorted[ii][jj] : this.dataSorted[jj][ii];
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public Object getValue(String s, Class cl) {
        String seps = cl == String.class ? " \"\t" : " \t";
        s.trim();
        int i = 0;
        while (i < this.header.length) {
            if (this.header[i][0].equals(s)) {
                Object[] o = this.extractObject(this.header[i][1], cl, 1, seps);
                if (o != null) {
                    return o[0];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public Object[] getVector(String s, Class cl, int n) {
        s.trim();
        int i = 0;
        while (i < this.header.length) {
            if (this.header[i][0].equals(s)) {
                Object[] o = this.extractObject(this.header[i][1], cl, n, " \t");
                if (o != null) {
                    return o;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    static void main(String[] args) {
        IBJDmnaFile dmna = new IBJDmnaFile(null, "con11q2.dmna");
        System.out.println(String.valueOf(dmna.nRows) + "," + dmna.nCols);
        System.out.println("HLABEL:");
        int i = 0;
        while (i < dmna.nCols) {
            System.out.println(dmna.hLabel[i]);
            ++i;
        }
        System.out.println("VLABEL:");
        i = 0;
        while (i < dmna.nRows) {
            System.out.println(dmna.vLabel[i]);
            ++i;
        }
        System.out.println("DELTA:" + dmna.getValue("DELTA", Double.class) + ":");
        System.exit(0);
    }
}

