/*
 * Decompiled with CFR 0.152.
 */
package de.janicke.gis;

import de.janicke.ibjutil.IBJarr;
import de.janicke.ibjutil.IBJdmn;
import de.janicke.ibjutil.IBJhdr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class GisViewLuc {
    public String Version = "1.0.0";
    public static final String TOOLTIP_DE = "<html>Inhalt des Textfeldes bei Ansicht eines Landnutzungs-Katasters:<br>x-Koordinate (m), y-Koordinate (m), CORINE-Klasse, Beschreibung.<br<<br>Inhalt des Textfeldes bei Ansicht eines Rauhigkeitsklassen-Katasters:<br>x-Koordinate (m), y-Koordinate (m), Z0-Klasse, Z0 (m), zugeordnete CORINE-Klassen.<br><br>Editieren des Textfeldes:<br>Angabe von x-Koordinate und y-Koordinate (m), durch ein Leerzeichen getrennt,<br>und Dr\u00fccken der RETURN-Taste bewegt den Mauszeiger an diese Position.<br><br></html>";
    public static final String TOOLTIP_EN = "<html>Contents of the text field viewing a land use register:<br>x-coordinate (m), y-coordinate (m), CORINE class, description.<br<<br>Contents of the text field viewing a roughness class register:<br>x-coordinate (m), y-coordinate (m), Z0 class, Z0 (m), attributed CORINE classes.<br><br>Editing the text field:<br>Specification of x-coordinate and y-coordinate (m), separated by a blank,<br>and bressing the RETURN key moves the mouse cursor to that position.<br><br></html>";
    public static final String[] LUC_2_Z0C = new String[]{"331 512", "132 231 321 333 421 423 511 522", "131 142 211 335 521", "124 411 412 523", "122 141 221 242 243 322 332", "123 222 324", "112 121 133 312", "311 313", "111"};
    public static final String LUC_EN = "902 Z0 class reduced by 8\n903 Z0 class reduced by 7\n904 Z0 class reduced by 6\n905 Z0 class reduced by 5\n906 Z0 class reduced by 4\n907 Z0 class reduced by 3\n908 Z0 class reduced by 2\n909 Z0 class reduced by 1\n910 Z0 class unchanged\n911 Z0 class increased by 1\n912 Z0 class increased by 2\n913 Z0 class increased by 3\n914 Z0 class increased by 4\n915 Z0 class increased by 5\n916 Z0 class increased by 6\n917 Z0 class increased by 7\n918 Z0 class increased by 8\n000 Areas outside the definition domain (0.05 m)\n001 0.01 m (331, 512)\n002 0.02 m (132, 231, 321, 333, 421, 423, 511, 522)\n003 0.05 m (131, 142, 211, 335, 521)\n004  0.1 m (124, 411, 412, 523)\n005  0.2 m (122, 141, 221, 242, 243, 322, 332)\n006  0.5 m (123, 222, 324)\n007  1.0 m (112, 121, 133, 312)\n008  1.5 m (311, 313)\n009  2.0 m (111)\n111 Continuous urban fabric\n112 Discontinuous urban fabric\n121 Industrial or commercial units\n122 Road and rail networks and associated land\n123 Port areas\n124 Airports\n131 Mineral extraction sites\n132 Dump sites\n133 Construction sites\n141 Green urban areas\n142 Sport and leisure facilities\n211 Non-irrigated arable land\n212 Permanently irrigated land\n213 Rice fields\n221 Vineyards\n222 Fruit trees and berry plantations\n223 Olive groves\n231 Pastures\n241 Annual crops associated with permanent crops\n242 Complex cultivation patterns\n243 Land occupied by agriculture, significant areas of natural vegetation\n244 Agro-forestry areas\n311 Broad-leaved forest\n312 Coniferous forest\n313 Mixed forest\n321 Natural grasslands\n322 Moors and heathland\n323 Sclerophyllous vegetation\n324 Transitional woodland-shrub\n331 Beaches, dunes, sands\n332 Bare rocks\n333 Sparsely vegetated areas\n334 Burnt areas\n335 Glaciers and perpetual snow\n411 Inland marshes\n412 Peat bogs\n421 Salt marshes\n422 Salines\n423 Intertidal flats\n511 Water courses\n512 Water bodies\n521 Coastal lagoons\n522 Estuaries\n523 Sea and ocean\n999 Areas outside the definition domain\n";
    public static final String LUC_DE = "902 Z0-Klasse erniedrigt um 8\n903 Z0-Klasse erniedrigt um 7\n904 Z0-Klasse erniedrigt um 6\n905 Z0-Klasse erniedrigt um 5\n906 Z0-Klasse erniedrigt um 4\n907 Z0-Klasse erniedrigt um 3\n908 Z0-Klasse erniedrigt um 2\n909 Z0-Klasse erniedrigt um 1\n910 Z0-Klasse unver\u00e4ndert\n911 Z0-Klasse erh\u00f6ht um 1\n912 Z0-Klasse erh\u00f6ht um 2\n913 Z0-Klasse erh\u00f6ht um 3\n914 Z0-Klasse erh\u00f6ht um 4\n915 Z0-Klasse erh\u00f6ht um 5\n916 Z0-Klasse erh\u00f6ht um 6\n917 Z0-Klasse erh\u00f6ht um 7\n918 Z0-Klasse erh\u00f6ht um 8\n000 Fl\u00e4chen au\u00dferhalb des Bearbeitungsgebietes (z0=0.05 m)\n001 0.01 m (331, 512)\n002 0.02 m (132, 231, 321, 333, 421, 423, 511, 522)\n003 0.05 m (131, 142, 211, 335, 521)\n004  0.1 m (124, 411, 412, 523)\n005  0.2 m (122, 141, 221, 242, 243, 322, 332)\n006  0.5 m (123, 222, 324)\n007  1.0 m (112, 121, 133, 312)\n008  1.5 m (311, 313)\n009  2.0 m (111)\n111 Fl\u00e4chen durchg\u00e4ngig st\u00e4dtischer Pr\u00e4gung\n112 Fl\u00e4chen nicht-durchg\u00e4ngig st\u00e4dtischer Pr\u00e4gung\n121 Industrie- und Gewerbefl\u00e4chen\n122 Stra\u00dfen und Eisenbahn\n123 Hafengebiete\n124 Flugh\u00e4fen\n131 Abbaufl\u00e4chen\n132 Deponien und Abraumhalden\n133 Baustellen\n141 St\u00e4dtische Gr\u00fcnfl\u00e4chen\n142 Sport und Freizeitanlagen\n211 Nicht bew\u00e4ssertes Ackerland\n212 Permanent bew\u00e4ssertes Ackerland\n213 Reisfelder\n221 Weinbaufl\u00e4chen\n222 Obst- und Beerenobstbest\u00e4nde\n223 Olivenhaine\n231 Wiesen und Weiden\n241 Mischung einj\u00e4hriger Fr\u00fcchte mit Dauerkulturen\n242 Komplexe Parzellenstrukturen\n243 Landwirtschaft mit nat\u00fcrlicher Bodenbedeckung\n244 Agroforstlich genutzte Fl\u00e4chen\n311 Laubwald\n312 Nadelwald\n313 Mischwald\n321 Nat\u00fcrliches Grasland\n322 Heiden und Moorheiden\n323 Hartlaubgew\u00e4chse\n324 Wald-Strauch-\u00dcbergangsstadien\n331 Str\u00e4nde, D\u00fcnen und Sandfl\u00e4chen\n332 Felsfl\u00e4chen ohne Vegetation\n333 Fl\u00e4chen mit sp\u00e4rlicher Vegetation\n334 Brandfl\u00e4chen\n335 Gletscher und Dauerschneegebiete\n411 S\u00fcmpfe\n412 Torfmoore\n421 Salzwiesen\n422 Salinen\n423 In der Gezeitenzone liegende Fl\u00e4chen\n511 Gew\u00e4sserl\u00e4ufe\n512 Wasserfl\u00e4chen\n521 Lagunen\n522 M\u00fcndungsgebiet\n523 Meere und Ozeane\n999 Fl\u00e4chen au\u00dferhalb des Bearbeitungsgebietes\n";
    public static final String LUC_RO = "902 Z0 class reduced by 8\n903 Z0 class reduced by 7\n904 Z0 class reduced by 6\n905 Z0 class reduced by 5\n906 Z0 class reduced by 4\n907 Z0 class reduced by 3\n908 Z0 class reduced by 2\n909 Z0 class reduced by 1\n910 Z0 class unchanged\n911 Z0 class increased by 1\n912 Z0 class increased by 2\n913 Z0 class increased by 3\n914 Z0 class increased by 4\n915 Z0 class increased by 5\n916 Z0 class increased by 6\n917 Z0 class increased by 7\n918 Z0 class increased by 8\n000 Suprafe\u0163e \u00een afara zonei de prelucrare (z0=0.05 m)\n001 0.01 m (331, 512)\n002 0.02 m (132, 231, 321, 333, 421, 423, 511, 522)\n003 0.05 m (131, 142, 211, 335, 521)\n004  0.1 m (124, 411, 412, 523)\n005  0.2 m (122, 141, 221, 242, 243, 322, 332)\n006  0.5 m (123, 222, 324)\n007  1.0 m (112, 121, 133, 312)\n008  1.5 m (311, 313)\n009  2.0 m (111)\n111 Suprafe\u0163e cu caracter urban continuu\n112 Suprafe\u0163e cu caracter urban discontinuu\n121 Suprafe\u0163e de industrie mare, mic\u0103 \u015fi mijlocie\n122 Strazi \u015fi c\u0103i ferate\n123 Zone porturare\n124 Aeroporturi\n131 Suprafe\u0163e exploatabile\n132 Depozite de de\u015feuri \u015fi halde de steril\n133 \u015eantiere\n141 Suprafe\u0163e verzi urbane\n142 Suprafe\u0163e pentru activit\u0103\u0163i sportive \u015fi de agrement\n211 Teren arabil neirigat\n212 Teren arabil permanent irigat\n213 C\u00e2mpuri de orez\n221 C\u00e2mpuri cu vi\u0163\u0103 de vie\n222 Culturi de pomi fructiferi \u015fi fructe de p\u0103dure\n223 C\u00e2mpuri de m\u0103slini\n231 C\u00e2mpii \u015fi p\u0103\u015funi\n241 Amestec de fructe anuale cu culturi perene\n242 Structuri complexe parcelate\n243 Agricultura cu sol acoperit natural\n244 Suprafe\u0163e utilizate agro-forestier\n311 P\u0103dure de foioase\n312 P\u0103dure de conifere\n313 P\u0103dure mixt\u0103\n321 Paji\u015fte natural\u0103\n322 Camp cu tufe \u015fi cu mla\u015ftini\n323 Arbu\u015fti de lemn tare\n324 Zona de trecere de la p\u0103dure la tufe\n331 Plaja, dune \u015fi suprafete nisipoase\n332 Suprafe\u0163e st\u00e2ncoase fara vegetatie\n333 Suprafe\u0163e cu vegetatie s\u0103r\u0103c\u0103cioas\u0103\n334 Suprafe\u0163e tampon \u00een caz de incendiu\n335 Ghe\u0163ar \u015fi zone cu z\u0103pad\u0103 permanent\u0103\n411 Bal\u0163i\n412 Mla\u015ftini argiloase\n421 C\u00e2mpuri de sare\n422 Saline\n423 Suprafe\u0163e aflate \u00eentre zonele de flux-reflux\n511 Cursuri de ap\u0103\n512 Suprafe\u0163e de ap\u0103\n521 Lagune\n522 Zon\u0103 de delt\u0103\n523 M\u0103ri \u015fi oceane\n999 Suprafe\u0163e \u00een afara zonei de prelucrare\n";
    private static String sFile = "z0-utm@278000-5226000-100.png";
    private static boolean bExpert = false;
    private static final String[] LOCALES = new String[]{"en", "de"};
    private double X0;
    private double Y0;
    private double Dd;
    private double Xorg;
    private double Yorg;
    private double X0org;
    private double Y0org;
    private double Ddorg;
    private boolean zoomed;
    private int Nx;
    private int Ny;
    private int no_data;
    private int Nxorg;
    private int Nyorg;
    private int Nxz = 41;
    private int Nyz = 41;
    private HashMap<Integer, Color> mapColor;
    private HashMap<Integer, String> mapLuc;
    private Color clrUnknown;
    private BufferedImage bim;
    private BufferedImage bimz;
    private BufferedImage currentbim;
    private ImageIcon ico;
    private JFrame frame;
    private JPanel panel;
    private JPanel pnl;
    private JPanel pnlButtons;
    private JLabel lClassesUnknown;
    private JScrollPane scp;
    private JTextField txt;
    private int nClassesUnknown;
    private JFileChooser chooser;
    private JButton btnSave;
    private MouseMotionListener mml;
    private MouseListener ml;
    private File dirRoot;
    private File dirInst;
    private JComboBox cbLocale;
    private String sFilter;
    private String sClassesUnknown;
    private long lCrc;

    public GisViewLuc() {
        this.setParams();
        this.setDirs();
    }

    private void setParams() {
        this.clrUnknown = new Color(255, 200, 255);
        this.mapColor = new HashMap();
        this.mapColor.put(111, new Color(211, 0, 0));
        this.mapColor.put(112, new Color(239, 42, 71));
        this.mapColor.put(121, new Color(211, 0, 155));
        this.mapColor.put(122, new Color(126, 126, 126));
        this.mapColor.put(123, new Color(155, 155, 211));
        this.mapColor.put(124, new Color(99, 99, 99));
        this.mapColor.put(131, new Color(155, 71, 42));
        this.mapColor.put(132, new Color(155, 13, 42));
        this.mapColor.put(133, new Color(183, 99, 126));
        this.mapColor.put(141, new Color(99, 239, 0));
        this.mapColor.put(142, new Color(239, 71, 0));
        this.mapColor.put(211, new Color(239, 239, 126));
        this.mapColor.put(212, new Color(0, 0, 1));
        this.mapColor.put(213, new Color(0, 0, 2));
        this.mapColor.put(221, new Color(239, 155, 13));
        this.mapColor.put(222, new Color(239, 211, 155));
        this.mapColor.put(223, new Color(0, 0, 3));
        this.mapColor.put(231, new Color(155, 211, 13));
        this.mapColor.put(241, new Color(0, 0, 4));
        this.mapColor.put(242, new Color(239, 211, 99));
        this.mapColor.put(243, new Color(183, 183, 71));
        this.mapColor.put(244, new Color(0, 0, 5));
        this.mapColor.put(311, new Color(0, 183, 0));
        this.mapColor.put(312, new Color(0, 126, 99));
        this.mapColor.put(313, new Color(0, 126, 0));
        this.mapColor.put(321, new Color(155, 183, 99));
        this.mapColor.put(322, new Color(211, 211, 0));
        this.mapColor.put(323, new Color(0, 0, 6));
        this.mapColor.put(324, new Color(183, 239, 0));
        this.mapColor.put(331, new Color(239, 239, 183));
        this.mapColor.put(332, new Color(211, 211, 155));
        this.mapColor.put(333, new Color(126, 211, 155));
        this.mapColor.put(334, new Color(0, 0, 7));
        this.mapColor.put(335, new Color(0, 0, 8));
        this.mapColor.put(411, new Color(183, 71, 239));
        this.mapColor.put(412, new Color(126, 71, 211));
        this.mapColor.put(421, new Color(183, 126, 211));
        this.mapColor.put(422, new Color(0, 0, 9));
        this.mapColor.put(423, new Color(239, 183, 239));
        this.mapColor.put(511, new Color(0, 99, 239));
        this.mapColor.put(512, new Color(0, 155, 239));
        this.mapColor.put(521, new Color(0, 211, 239));
        this.mapColor.put(522, new Color(99, 211, 239));
        this.mapColor.put(523, new Color(159, 215, 248));
        this.mapColor.put(999, new Color(255, 255, 255));
        this.mapColor.put(0, new Color(250, 250, 250));
        this.mapColor.put(1, this.mapColor.get(512).brighter());
        this.mapColor.put(2, this.mapColor.get(231).brighter());
        this.mapColor.put(3, this.mapColor.get(211).brighter());
        this.mapColor.put(4, this.mapColor.get(124).brighter());
        this.mapColor.put(5, this.mapColor.get(243).brighter());
        this.mapColor.put(6, this.mapColor.get(324).brighter());
        this.mapColor.put(7, this.mapColor.get(112).brighter());
        this.mapColor.put(8, this.mapColor.get(313).brighter());
        this.mapColor.put(9, this.mapColor.get(111).brighter());
        this.mapColor.put(902, new Color(242, 242, 200));
        this.mapColor.put(903, this.mapColor.get(132).brighter());
        this.mapColor.put(904, this.mapColor.get(131).brighter());
        this.mapColor.put(905, this.mapColor.get(411).brighter());
        this.mapColor.put(906, this.mapColor.get(122).brighter());
        this.mapColor.put(907, this.mapColor.get(123).brighter());
        this.mapColor.put(908, this.mapColor.get(121).brighter());
        this.mapColor.put(909, this.mapColor.get(311).brighter());
        this.mapColor.put(910, new Color(213, 213, 213));
        this.mapColor.put(911, this.mapColor.get(331).darker());
        this.mapColor.put(912, this.mapColor.get(132).darker());
        this.mapColor.put(913, this.mapColor.get(131).darker());
        this.mapColor.put(914, this.mapColor.get(411).darker());
        this.mapColor.put(915, this.mapColor.get(122).darker());
        this.mapColor.put(916, this.mapColor.get(123).darker());
        this.mapColor.put(917, this.mapColor.get(121).darker());
        this.mapColor.put(918, this.mapColor.get(311).darker());
        String[] ss = LUC_EN.split("\n");
        this.mapLuc = new HashMap();
        try {
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int luc = Integer.parseInt(s.substring(0, 3));
                Color c = this.mapColor.get(luc);
                if (this.mapLuc.get(c.getRGB()) != null) {
                    throw new Exception("Colour assignments not unique (" + luc + ")!");
                }
                this.mapLuc.put(c.getRGB(), s);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.mml = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GisViewLuc.this.mouseAt(e.getX(), e.getY());
            }
        };
        this.ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    GisViewLuc.this.zoom(e.getX(), e.getY());
                }
            }
        };
        bExpert = false;
        this.lCrc = -1L;
        this.nClassesUnknown = 0;
    }

    private void setDirs() {
        Class<?> cls = this.getClass();
        String name = cls.getName();
        URL u2 = cls.getResource(String.valueOf(cls.getSimpleName()) + ".class");
        String s2 = null;
        try {
            URI uri = u2.toURI();
            String sScheme = uri.getScheme();
            s2 = uri.getSchemeSpecificPart();
            if (sScheme.equals("jar")) {
                if (s2.startsWith("file:")) {
                    s2 = s2.substring(5);
                }
            } else if (!sScheme.equals("file")) {
                return;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        int k = s2.indexOf(name.replace('.', '/'));
        if (k > 0) {
            s2 = s2.substring(0, k - 1);
        }
        if (s2.endsWith(".jar!")) {
            s2 = s2.substring(0, s2.length() - 1);
            this.dirRoot = new File(s2).getParentFile();
        } else {
            this.dirRoot = new File(s2);
        }
        this.dirInst = this.dirRoot.getParentFile();
        this.chooser = new JFileChooser(this.dirInst);
    }

    public void readLUC(String fn) throws Exception {
        String[] ss;
        File f = new File(fn);
        this.chooser.setCurrentDirectory(f.getParentFile());
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        HashMap<String, Integer> hdr = new HashMap<String, Integer>();
        int i = 0;
        while (i < 6) {
            line = br.readLine();
            ss = line.split("[ ]+");
            hdr.put(ss[0], Integer.parseInt(ss[1]));
            ++i;
        }
        this.Nx = (Integer)hdr.get("ncols");
        this.Ny = (Integer)hdr.get("nrows");
        this.no_data = (Integer)hdr.get("NODATA_value");
        this.X0 = ((Integer)hdr.get("xllcorner")).intValue();
        this.Y0 = ((Integer)hdr.get("yllcorner")).intValue();
        this.Dd = ((Integer)hdr.get("cellsize")).intValue();
        this.bim = new BufferedImage(this.Nx, this.Ny, 2);
        int j = 0;
        while (j < this.Ny) {
            line = br.readLine();
            ss = line.trim().split("[ ]+");
            int i2 = 0;
            while (i2 < this.Nx) {
                Color c;
                int luc = Integer.parseInt(ss[i2]);
                if (luc == this.no_data) {
                    luc = 999;
                }
                if ((c = this.mapColor.get(luc)) == null) {
                    c = this.clrUnknown;
                    ++this.nClassesUnknown;
                }
                this.bim.setRGB(i2, j, c.getRGB());
                ++i2;
            }
            ++j;
        }
        br.close();
    }

    public void readPNG(String fn) throws Exception {
        File f = new File(fn);
        this.chooser.setCurrentDirectory(f.getParentFile());
        String name = f.getName();
        String[] ss = name.split("[@]");
        if (ss.length != 2) {
            throw new Exception("invalid file name format!");
        }
        if ((ss = ss[1].split("[\\-.]")).length != 4) {
            throw new Exception("invalid file name format!");
        }
        this.X0 = Double.parseDouble(ss[0]);
        this.Y0 = Double.parseDouble(ss[1]);
        this.Dd = Double.parseDouble(ss[2]);
        this.ico = new ImageIcon(fn);
        this.Nx = this.ico.getIconWidth();
        this.Ny = this.ico.getIconHeight();
        this.bim = new BufferedImage(this.Nx, this.Ny, 2);
        Graphics g = this.bim.getGraphics();
        g.drawImage(this.ico.getImage(), 0, 0, null);
    }

    public void readZ0C(String fn) throws Exception {
        File f = new File(fn);
        this.chooser.setCurrentDirectory(f.getParentFile());
        IBJarr arr = IBJdmn.readDmn(fn);
        this.X0 = arr.getHeader().getDouble("xmin");
        this.Y0 = arr.getHeader().getDouble("ymin");
        this.Dd = arr.getHeader().getDouble("delta");
        IBJarr.StringArray sa = (IBJarr.StringArray)arr.getArray("Classes");
        int dim = sa.getStructure().getDims();
        if (dim != 2) {
            throw new Exception("invalid dimension (must be 2)");
        }
        int i1 = sa.getStructure().getFirstIndex()[0];
        int i2 = sa.getStructure().getLastIndex()[0];
        if (i1 != 0 || i2 != 0) {
            throw new Exception("invalid bounds for i (must be 0)");
        }
        int j1 = sa.getStructure().getFirstIndex()[1];
        int j2 = sa.getStructure().getLastIndex()[1];
        this.Ny = j2 - j1 + 1;
        this.Nx = sa.get(0, j1).length();
        this.bim = new BufferedImage(this.Nx, this.Ny, 2);
        StringBuilder sb = new StringBuilder(this.Nx * this.Ny);
        int j = j1;
        while (j <= j2) {
            String line = sa.get(0, j);
            sb.append(line).append("\u0000");
            if (line.length() != this.Nx) {
                throw new Exception("invalid line length: " + line.length() + ", expected: " + this.Nx);
            }
            int i = 0;
            while (i < this.Nx) {
                int z0c = Integer.parseInt("" + line.charAt(i));
                Color c = this.mapColor.get(z0c);
                if (c == null) {
                    c = this.clrUnknown;
                    ++this.nClassesUnknown;
                }
                this.bim.setRGB(i, j2 - j, c.getRGB());
                ++i;
            }
            ++j;
        }
        this.lCrc = this.getCrc(sb.toString());
        sb = new StringBuilder(1);
        sb = null;
        sa = null;
        arr = null;
    }

    private void readZ0CDIFF(String fn) throws Exception {
        String[] fa = fn.split("[;]");
        File f = new File(fa[1]);
        this.chooser.setCurrentDirectory(f.getParentFile());
        IBJarr arrold = IBJdmn.readDmn(fa[0]);
        IBJarr arr = IBJdmn.readDmn(fa[1]);
        this.X0 = arr.getHeader().getDouble("xmin");
        this.Y0 = arr.getHeader().getDouble("ymin");
        this.Dd = arr.getHeader().getDouble("delta");
        double x0old = arrold.getHeader().getDouble("xmin");
        double y0old = arrold.getHeader().getDouble("ymin");
        double ddold = arrold.getHeader().getDouble("delta");
        if (x0old != this.X0 || y0old != this.Y0 || ddold != this.Dd) {
            throw new Exception("inconsistent grid!");
        }
        IBJarr.StringArray saold = (IBJarr.StringArray)arrold.getArray("Classes");
        IBJarr.StringArray sa = (IBJarr.StringArray)arr.getArray("Classes");
        int dim = sa.getStructure().getDims();
        if (dim != 2) {
            throw new Exception("invalid dimension (must be 2)");
        }
        int i1 = sa.getStructure().getFirstIndex()[0];
        int i2 = sa.getStructure().getLastIndex()[0];
        if (i1 != 0 || i2 != 0) {
            throw new Exception("invalid bounds for i (must be 0)");
        }
        int j1 = sa.getStructure().getFirstIndex()[1];
        int j2 = sa.getStructure().getLastIndex()[1];
        this.Ny = j2 - j1 + 1;
        this.Nx = sa.get(0, j1).length();
        int i1old = saold.getStructure().getFirstIndex()[0];
        int i2old = saold.getStructure().getLastIndex()[0];
        if (i1old != 0 || i2old != 0) {
            throw new Exception("invalid bounds for iold (must be 0)");
        }
        int j1old = saold.getStructure().getFirstIndex()[1];
        int j2old = saold.getStructure().getLastIndex()[1];
        int nyold = j2old - j1old + 1;
        int nxold = saold.get(0, j1old).length();
        if (nxold != this.Nx || nyold != this.Ny) {
            throw new Exception("inconsistent dimensions!");
        }
        this.bim = new BufferedImage(this.Nx, this.Ny, 2);
        int ndiff = 0;
        StringBuffer sb = new StringBuffer();
        int j = j1;
        while (j <= j2) {
            String lineold = saold.get(0, j);
            String line = sa.get(0, j);
            sb.append(line).append("\u0000");
            if (line.length() != this.Nx) {
                throw new Exception("invalid line length: " + line.length() + ", expected: " + this.Nx);
            }
            if (lineold.length() != this.Nx) {
                throw new Exception("invalid lineold length: " + lineold.length() + ", expected: " + this.Nx);
            }
            int i = 0;
            while (i < this.Nx) {
                Color c;
                int z0cold = Integer.parseInt("" + lineold.charAt(i));
                int z0c = Integer.parseInt("" + line.charAt(i));
                if (z0c != z0cold) {
                    ++ndiff;
                }
                if ((c = this.mapColor.get(910 + z0c - z0cold)) == null) {
                    c = this.clrUnknown;
                    ++this.nClassesUnknown;
                }
                this.bim.setRGB(i, j2 - j, c.getRGB());
                ++i;
            }
            ++j;
        }
        System.out.printf("file 1: %s\nfile 2: %s\n%d fields with deviations.\n", fa[0], fa[1], ndiff);
    }

    private long getCrc(String s) {
        long cc = 0L;
        try {
            byte[] bb = s.getBytes("ISO-8859-1");
            CRC32 crc32 = new CRC32();
            crc32.reset();
            crc32.update(bb);
            cc = crc32.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cc;
    }

    private void createFrame() {
        this.frame = new JFrame();
        this.pnl = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.drawImage(GisViewLuc.this.currentbim, 0, 0, null);
            }
        };
        this.cbLocale = new JComboBox<String>(LOCALES);
        this.cbLocale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String buf = null;
                String loc = ((String)GisViewLuc.this.cbLocale.getSelectedItem()).toLowerCase();
                GisViewLuc.this.setTitle(loc);
                buf = loc.equalsIgnoreCase("de") ? GisViewLuc.LUC_DE : GisViewLuc.LUC_EN;
                String[] ss = buf.split("\n");
                try {
                    String[] stringArray = ss;
                    int n = ss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        int luc = Integer.parseInt(s.substring(0, 3));
                        Color c = (Color)GisViewLuc.this.mapColor.get(luc);
                        GisViewLuc.this.mapLuc.put(c.getRGB(), s);
                        ++n2;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        this.pnl.setPreferredSize(new Dimension(this.Nx, this.Ny));
        this.pnl.addMouseMotionListener(this.mml);
        this.pnl.addMouseListener(this.ml);
        this.pnl.setCursor(new Cursor(1));
        this.panel = new JPanel(new BorderLayout());
        this.scp = new JScrollPane(this.pnl);
        this.panel.add((Component)this.scp, "Center");
        this.lClassesUnknown = new JLabel("");
        this.lClassesUnknown.setForeground(Color.gray);
        this.pnlButtons = new JPanel();
        this.txt = new JTextField(60);
        this.txt.setEditable(true);
        this.txt.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    GisViewLuc.this.mouseTo(GisViewLuc.this.txt.getText());
                    e.consume();
                }
            }
        });
        this.pnlButtons.add(this.lClassesUnknown);
        this.pnlButtons.add(this.txt);
        this.pnlButtons.add(this.cbLocale);
        this.pnlButtons.add(new JLabel(" "));
        this.btnSave = new JButton("Save Picture...");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GisViewLuc.this.save_data(GisViewLuc.this.pnl);
            }
        });
        this.pnlButtons.add(this.btnSave);
        this.panel.add((Component)this.pnlButtons, "South");
        this.frame.setContentPane(this.panel);
        this.frame.setDefaultCloseOperation(3);
        URL u = GisViewLuc.class.getResource("logo.gif");
        if (u != null) {
            this.frame.setIconImage(this.frame.getToolkit().getImage(u));
        }
        this.setTitle(Locale.getDefault().getLanguage());
    }

    private void display(String fn) {
        try {
            if (fn.endsWith(".png")) {
                this.readPNG(fn);
            } else if (bExpert && fn.indexOf(";") > 0) {
                this.readZ0CDIFF(fn);
            } else if (fn.endsWith(".dmna")) {
                this.readZ0C(fn);
            } else {
                this.readLUC(fn);
            }
            System.runFinalization();
            System.gc();
            System.runFinalization();
            System.gc();
            this.currentbim = this.bim;
            this.createFrame();
            if (!bExpert) {
                this.pnlButtons.remove(this.btnSave);
            }
            this.setTitle(Locale.getDefault().getLanguage());
            if (this.nClassesUnknown > 0) {
                this.lClassesUnknown.setText("(" + this.nClassesUnknown + this.sClassesUnknown + ")");
            }
            Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setSize(new Dimension((int)(0.9 * (double)sz.width), (int)(0.9 * (double)sz.height)));
            this.frame.setLocationRelativeTo(null);
            this.frame.setVisible(true);
            this.cbLocale.setSelectedItem(Locale.getDefault().getLanguage());
            this.scp.getVerticalScrollBar().setUnitIncrement(this.Ny / 100);
            this.scp.getHorizontalScrollBar().setUnitIncrement(this.Nx / 100);
            this.zoomed = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString());
        }
    }

    private void save_data(JPanel pnl) {
        if (sFile.endsWith(".asc")) {
            this.chooser.setDialogTitle("Specify the name of the output file (PNG or DMN)");
        } else {
            this.chooser.setDialogTitle("Specify the name of the output file (PNG)");
        }
        int r = this.chooser.showSaveDialog(this.frame);
        if (r != 0) {
            return;
        }
        File f = this.chooser.getSelectedFile();
        String s = f.getPath();
        if (f.exists() && (r = JOptionPane.showOptionDialog(this.frame, "Overwrite existing file?", "Please select", 0, 3, null, new String[]{"Yes", "No"}, "No")) != 0) {
            return;
        }
        String xtn = s.substring(s.lastIndexOf(46) + 1);
        int width = pnl.getWidth();
        int height = pnl.getHeight();
        if (xtn.equalsIgnoreCase("png")) {
            BufferedImage bi = new BufferedImage(width, height, 6);
            Graphics2D g = bi.createGraphics();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHints(hints);
            pnl.paint(g);
            g.dispose();
            try {
                ImageIO.write((RenderedImage)bi, xtn, f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (sFile.endsWith(".asc") && xtn.equalsIgnoreCase("dmna")) {
            try {
                this.save_dmn(f.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.printf("*** invalid output, data not saved.\n", new Object[0]);
        }
    }

    private void save_dmn(String fn) {
        String[] sa = new String[9];
        System.out.printf("Converting to Z0 class register ...\n", new Object[0]);
        try {
            if (LUC_2_Z0C.length != 9) {
                throw new Exception("invalid dimension of LUC_2_Z0C");
            }
            int i = 0;
            while (i < 9) {
                sa[i] = " " + LUC_2_Z0C[i].trim() + " ";
                String valid = " 0123456789";
                int j = 0;
                while (j < sa[i].length()) {
                    if (valid.indexOf(sa[i].charAt(j)) < 0) {
                        throw new Exception("invalid char in LUC_2_Z0C entry: " + sa[i]);
                    }
                    ++j;
                }
                String[] saa = sa[i].trim().split("[ ]+");
                if (saa.length == 0) {
                    throw new Exception("invalid entries in LUC_2_Z0C entry: " + sa[i]);
                }
                int j2 = 0;
                while (j2 < saa.length) {
                    if (saa[j2].length() != 3) {
                        throw new Exception("invalid entries in LUC_2_Z0C entry: " + sa[i]);
                    }
                    ++j2;
                }
                ++i;
            }
            File fin = new File(sFile);
            String idnt = fin.getName();
            String ggcs = null;
            if (idnt.indexOf("gk") >= 0) {
                ggcs = "GK";
            } else if (idnt.indexOf("utm") >= 0) {
                ggcs = "UTM";
            } else {
                throw new Exception("can't determine GCCS from file name");
            }
            IBJarr arr = new IBJarr("Classes", 1, this.Ny);
            arr.setFirstIndex(0, 1);
            IBJhdr hdr = arr.getHeader();
            hdr.putString("creator ", String.valueOf(this.getClass().getName()) + " " + this.Version, true);
            hdr.putDate("created", IBJhdr.getDate(new Date()));
            hdr.putString("ggcs", ggcs, true);
            hdr.putDouble("xmin", this.X0, "%1.1f");
            hdr.putDouble("ymin", this.Y0, "%1.1f");
            hdr.putDouble("delta", this.Dd, "%1.1f");
            hdr.putString("vldf", "V", true);
            hdr.putString("sequ", "j-,i+", true);
            hdr.putInteger("buff", 1000000, "%1d");
            hdr.putString("mode", "text", true);
            hdr.putInteger("cmpr", 9, "%1d");
            arr.createArray("Classes%" + String.format("%d.%ds", this.Nx, this.Nx + 1));
            IBJarr.StringArray out = (IBJarr.StringArray)arr.getArray("Classes");
            StringBuffer sb = new StringBuffer();
            StringBuffer line = new StringBuffer(this.Nx + 1);
            String notfound = " ";
            int j = this.Ny - 1;
            while (j >= 0) {
                System.out.printf("%04d\r", j);
                line.setLength(0);
                int i2 = 0;
                while (i2 < this.Nx) {
                    int icolor = this.currentbim.getRGB(i2, j);
                    String label = this.mapLuc.get(icolor).substring(0, 3);
                    int iclass = -1;
                    int k = 0;
                    while (k < 9) {
                        if (sa[k].indexOf(" " + label + " ") >= 0) {
                            iclass = k + 1;
                            break;
                        }
                        ++k;
                    }
                    if (iclass < 0) {
                        if (notfound.indexOf(" " + label + " ") < 0) {
                            notfound = String.valueOf(notfound) + label + " ";
                        }
                        iclass = 0;
                    }
                    line.append(iclass);
                    ++i2;
                }
                out.set(line.toString(), 0, this.Ny - j);
                sb.append(String.valueOf(line.toString()) + "\u0000");
                --j;
            }
            if (notfound.trim().length() > 0) {
                System.out.printf("*** the following land use classes could not be assigned:\n%s\n", notfound.trim());
            }
            hdr.putString("idnt", String.valueOf(idnt) + String.format("(%x)", this.getCrc(sb.toString())), true);
            File f = new File(fn);
            IBJdmn.writeDmn(arr, f.getAbsolutePath());
            System.out.printf("Z0 class register written to %s.\n", f.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void zoom(int x, int y) {
        if (this.zoomed) {
            this.txt.setEditable(true);
            this.zoomed = false;
            this.X0 = this.X0org;
            this.Y0 = this.Y0org;
            this.Dd = this.Ddorg;
            this.Nx = this.Nxorg;
            this.Ny = this.Nyorg;
            this.currentbim = this.bim;
            this.pnl.setPreferredSize(new Dimension(this.Nx, this.Ny));
            this.pnl.updateUI();
        } else {
            this.txt.setEditable(false);
            this.zoomed = true;
            int fac = 50;
            this.X0org = this.X0;
            this.Y0org = this.Y0;
            this.Ddorg = this.Dd;
            this.Nxorg = this.Nx;
            this.Nyorg = this.Ny;
            if (this.bimz == null) {
                if (this.Nxz > this.Nx) {
                    this.Nxz = this.Nx;
                }
                if (this.Nyz > this.Ny) {
                    this.Nyz = this.Ny;
                }
                this.bimz = new BufferedImage(this.Nxz * fac, this.Nyz * fac, 2);
            }
            double[] da = this.mouseAt(x, y);
            this.Xorg = da[0];
            this.Yorg = da[1];
            y -= this.Nyz / 2;
            if ((x -= this.Nxz / 2) < 0) {
                x = 0;
            }
            if (x + this.Nxz >= this.Nx) {
                x = this.Nx - this.Nxz - 1;
            }
            if (y < 0) {
                y = 0;
            }
            if (y + this.Nyz >= this.Ny) {
                y = this.Ny - this.Nyz - 1;
            }
            da = this.mouseAt(x, y);
            this.X0 = da[0] - this.Dd * 0.5;
            this.Y0 = da[1] - (double)this.Nyz * this.Dd + this.Dd * 0.5;
            this.Nx = this.Nxz * fac;
            this.Ny = this.Nyz * fac;
            this.Dd = this.Ddorg / (double)fac;
            int i = x;
            while (i < x + this.Nxz) {
                int j = y;
                while (j < y + this.Nyz) {
                    int clr = this.bim.getRGB(i, j);
                    int ii = 0;
                    while (ii < fac) {
                        int jj = 0;
                        while (jj < fac) {
                            this.bimz.setRGB((i - x) * fac + ii, (j - y) * fac + jj, clr);
                            ++jj;
                        }
                        ++ii;
                    }
                    ++j;
                }
                ++i;
            }
            this.currentbim = this.bimz;
        }
        this.pnl.setPreferredSize(new Dimension(this.Nx, this.Ny));
        this.pnl.updateUI();
        this.pnl.repaint();
        this.scp.setViewportView(this.pnl);
        this.scp.repaint();
        this.mouseTo(String.format("%1.1f %1.1f", this.Xorg, this.Yorg));
    }

    private void mouseTo(String text) {
        double xm = -1.0;
        double ym = -1.0;
        try {
            String s = text.trim().replaceAll(",", ".");
            String[] sa = s.split("[ ;]+");
            xm = Double.parseDouble(sa[0]);
            ym = Double.parseDouble(sa[1]);
            if (xm < this.X0 || xm > this.X0 + (double)this.Nx * this.Dd) {
                xm = -1.0;
            }
            if (ym < this.Y0 || ym > this.Y0 + (double)this.Ny * this.Dd) {
                ym = -1.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            xm = -1.0;
            ym = -1.0;
        }
        if (xm < 0.0 || ym < 0.0) {
            System.out.printf("*** xm=%1.1f, ym=%1.1f, X0=%1.1f, Y0=%1.1f, Dd=%1.1f, Nx=%d, Ny=%d\n", xm, ym, this.X0, this.Y0, this.Dd, this.Nx, this.Ny);
            this.txt.setText("Invalid coordinate specification!");
            return;
        }
        int x = (int)((xm - this.X0 - 0.5 * this.Dd) / this.Dd + 0.5);
        int y = (int)((double)(this.Ny - 1) - (ym - this.Y0 - 0.5 * this.Dd) / this.Dd + 0.5);
        Rectangle viewrect = this.scp.getViewport().getViewRect();
        int xx = x;
        int yy = y;
        if ((x = (int)((double)x - viewrect.getWidth() / 2.0)) < 0) {
            x = 0;
        }
        if ((y = (int)((double)y - viewrect.getHeight() / 2.0)) < 0) {
            y = 0;
        }
        this.scp.getViewport().setViewPosition(new Point(x, y));
        this.pnl.requestFocus();
        viewrect = this.scp.getViewport().getViewRect();
        try {
            Robot r = new Robot();
            x = this.frame.getContentPane().getLocationOnScreen().x + xx - viewrect.x + 1;
            y = this.frame.getContentPane().getLocationOnScreen().y + yy - viewrect.y + 1;
            r.mouseMove(x, y);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double[] mouseAt(int x, int y) {
        if (x < 0 || x >= this.Nx || y < 0 || y >= this.Ny) {
            return null;
        }
        int ic = this.currentbim.getRGB(x, y);
        String label = this.mapLuc.get(ic);
        if (label == null) {
            label = "unknown";
        }
        double xm = this.X0 + (double)x * this.Dd + 0.5 * this.Dd;
        double ym = this.Y0 + (double)(this.Ny - 1 - y) * this.Dd + 0.5 * this.Dd;
        this.txt.setText(String.format(" %6.0f %6.0f : %s", xm, ym, label));
        double[] da = new double[]{xm, ym};
        return da;
    }

    private String getFile() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return f.isDirectory() || name.endsWith(".asc") || name.endsWith(".png") || name.endsWith(".dmna");
            }

            @Override
            public String getDescription() {
                return GisViewLuc.this.sFilter;
            }
        };
        this.chooser.setFileFilter(filter);
        int rc = this.chooser.showOpenDialog(this.frame);
        if (rc != 0) {
            System.exit(0);
        }
        return this.chooser.getSelectedFile().getPath();
    }

    private void setTitle(String locale) {
        if (this.frame == null) {
            return;
        }
        String s = sFile;
        if (this.lCrc > 0L) {
            s = String.valueOf(s) + String.format(" [%x]", this.lCrc);
        }
        if (locale.equalsIgnoreCase("de")) {
            this.btnSave.setText("Speichern");
            this.frame.setTitle("ViewLuc " + this.Version + " (C) 2011 Ing.-B\u00fcro Janicke - " + s);
            this.sFilter = "PNG-Bild (*.png), Landnutzungs-Kataster (*.asc) oder Z0-Klassen-Kataster (*.dmn)";
            this.sClassesUnknown = " Felder mit unbekannter Klasse";
            this.txt.setToolTipText(TOOLTIP_DE);
        } else {
            this.btnSave.setText("Save");
            this.frame.setTitle("ViewLuc " + this.Version + " (C) 2011 Janicke Consulting - " + s);
            this.sFilter = "PNG picture (*.png), land use register (*.asc), or Z0 class register (*.dmn)";
            this.sClassesUnknown = " fields with unknown classes";
            this.txt.setToolTipText(TOOLTIP_EN);
        }
    }

    public static void main(String[] args) {
        GisViewLuc g = new GisViewLuc();
        g.createFrame();
        sFile = null;
        bExpert = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("--expert")) {
                bExpert = true;
            } else if (args[i].startsWith("--input=")) {
                sFile = args[i].substring(8);
            }
            ++i;
        }
        if (sFile == null) {
            sFile = g.getFile();
        }
        g.display(sFile);
        System.runFinalization();
        System.gc();
        System.runFinalization();
        System.gc();
    }
}

