// ================================================================= IBJdcl.java
//
// Interface for ARR data classes
// ==============================
//
// Copyright 2005-2012 Janicke Consulting, 88662 Überlingen
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// History:
//
// 2006-11-21 lj first setup
// 2012-05-10 uj DataName
//
// =============================================================================

package de.janicke.ibjutil;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;

/**
 *
 * <p>Copyright 2005-2012 Janicke Consulting, 88662 Überlingen</p>
 * Defines the data types used by {@link IBJarr IBJarr} and a method to 
 * print messages into a log file.
 * @author Lutz Janicke, Ing.-Büro Janicke, Dunum
 * @version 2012-05-10 uj
 *
 */
public interface IBJdcl {
  /**
   * 
   * The data types used by {@link IBJarr IBJarr}.
   *
   */
  enum DataType {
    BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, STRING, TIME, DATE
  };
    
  public class DataDef {
    public DataType type;
    public boolean is_vector;
    
    public DataDef(DataType tp, boolean iv) {
      type = tp;
      is_vector = iv;
    }
    
    public static String DataName(DataType type) {
      if (type == DataType.BYTE)
        return "byte";
      else if (type == DataType.SHORT)
        return "short";
      else if (type == DataType.INTEGER)
        return "integer";
      else if (type == DataType.LONG)
        return "long";
      else if (type == DataType.FLOAT)
        return "float";
      else if (type == DataType.DOUBLE)
        return "double";
      else if (type == DataType.STRING)
        return "string";
      else if (type == DataType.TIME)
        return "time";
      else if (type == DataType.DATE)
        return "date";
      else
        return null;
    }
  }
  
  /**
   * 
   * Utility class for printing error messages.
   *
   */
  class ErrorLog {
    
    private PrintStream prn = System.err;
    private PrintWriter wrt = null;
    private PrintStream log = null;
    
    /**
     * Sets the print stream for displaying message.
     * @param ps the print stream.
     */
    public void setPrintStream(PrintStream ps) {
      prn = ps;
    }
    
    public PrintStream getPrintStream() {
      return prn;
    }
    
    /**
     * Sets the print writer for logging error messages.
     * @param pw the print writer.
     */
    public void setLogWriter(PrintWriter pw) {
      wrt = pw;
    }
    
    public void setLogStream(PrintStream ps) {
      log = ps;
      wrt = new PrintWriter(ps, true);
    }
    
    public PrintWriter getLogWriter() {
      return wrt;
    }
    
    public PrintStream getLogStream() {
      return log;
    }
    
    /**
     * Displays a message and writes it into the error log.
     * @param format
     * @param args
     */
    public void printf(String format, Object... args) {
      if (prn != null) {
        prn.printf(format, args);
        prn.flush();
      }
      if (wrt != null) {
        wrt.printf(format, args);
        wrt.flush();
      }
    }
    
    public void printf(Locale locale, String format, Object... args) {
      if (prn != null) {
        prn.printf(locale, format, args);
        prn.flush();
      }
      if (wrt != null) {
        wrt.printf(locale, format, args);
        wrt.flush();
      }
    }
    
    /**
     * Displays a String and writes it into the error log.
     * @param arg
     */
    public void println(String arg) {
      if (prn != null) {
        prn.println(arg);
        prn.flush();
      }
      if (wrt != null) {
        wrt.println(arg);
        wrt.flush();
      }
    }
    
    public void println() {
      if (prn != null) {
        prn.println();
        prn.flush();
      }
      if (wrt != null) {
        wrt.println();
        wrt.flush();
      }
    }

  }
  
  /**
   * Standard error log.
   */
  public ErrorLog errlog = new ErrorLog();
}
