/**
 *
 * Copyright (C) Janicke Consulting, Überlingen, Germany, 2013-2019
 * email: info@janicke.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
package de.janicke.meteo;

/**
 * Basic functions of a boundary layer model
 * 
 * @author ibj
 * 
 * last change: 2003-11-05 lj
 *
 */
abstract public class BLProfile {
  
  abstract public String getName();
  abstract public String getInfo();
  
  abstract public double getU( double z );
  abstract public double getR( double z );
  abstract public double getUst();
  
  abstract public double getSu( double z );
  abstract public double getSv( double z );
  abstract public double getSw( double z );

  abstract public double getKu( double z );
  abstract public double getKv( double z );
  abstract public double getKw( double z );
  
  
  //-------------------------------------------
  
  public void init() {}
  
  public double getHm() {
    return -1;
  }
  
  public double getVx( double z ) {
    double u = getU(z);
    double r = Math.toRadians(getR(z));
    return -u*Math.sin(r);
  }

  public double getVy( double z ) {
    double u = getU(z);
    double r = Math.toRadians(getR(z));
    return -u*Math.cos(r);
  }

  public double getTu( double z ) {
    double s = getSu(z);
    return getKu(z)/(s*s);
  }

  public double getTv( double z ) {
    double s = getSv(z);
    return getKv(z)/(s*s);
  }

  public double getTw( double z ) {
    double s = getSw(z);
    return getKw(z)/(s*s);
  }

  public double[] getVx( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getVx(zz[i]);
    return aa;
  }

  public double[] getVy( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getVy(zz[i]);
    return aa;
  }

  public double[] getSu( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getSu(zz[i]);
    return aa;
  }

  public double[] getU( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getU(zz[i]);
    return aa;
  }

  public double[] getR( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getR(zz[i]);
    return aa;
  }

  public double[] getSv( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getSv(zz[i]);
    return aa;
  }
  
  public double[] getSw( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getSw(zz[i]);
    return aa;
  }

  public double[] getKu( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getKu(zz[i]);
    return aa;
  }

  public double[] getKv( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getKv(zz[i]);
    return aa;
  }
  
  public double[] getKw( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getKw(zz[i]);
    return aa;
  }
  public double[] getTu( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getTu(zz[i]);
    return aa;
  }

  public double[] getTv( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getTv(zz[i]);
    return aa;
  }
  
  public double[] getTw( double zz[] ) {
    if (zz == null)  return null;
    int n = zz.length;
    double[] aa = new double[n];
    for (int i=0; i<n; i++)  aa[i] = getTw(zz[i]);
    return aa;
  }

}
