////////////////////////////////////////////////////////////////////////////////
//
// history
//
// 2021-10-07 uj distribution
// 
////////////////////////////////////////////////////////////////////////////////

/**
 * CheckedTextField
 * 
 * Utility class used by Besmin and Besmax
 *
 * Copyright (C) Umweltbundesamt Dessau-Roßlau, Germany, 2021
 * Copyright (C) Janicke Consulting, Überlingen, Germany, 2021
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

package de.janicke.fxutil;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.control.TextField;

public class CheckedTextField extends TextField {
    public CheckedTextField() {
      super();
      getStyleClass().add("checked-text-field");
    }
    
    public CheckedTextField(String s) {
      super(s);
      getStyleClass().add("checked-text-field");
    }
    
    public CheckedTextField(String s, String id, ChangeListener<String> listener) {
      super(s);
      getStyleClass().add("checked-text-field");
      setId(id);
      if (listener != null)
        textProperty().addListener(listener);
    }
    
    //
    
    private static final PseudoClass REJECTED_PSEUDO_CLASS = 
            PseudoClass.getPseudoClass("rejected");
  
    public BooleanProperty rejected = new BooleanPropertyBase(false) {
      @Override protected void invalidated() {
        pseudoClassStateChanged(REJECTED_PSEUDO_CLASS, get());
      }
      @Override public Object getBean() {
        return CheckedTextField.this;
      }
      @Override public String getName() {
        return "rejected";
      }
    };
    
    public boolean isRejected() {
      return rejected.get();
    }

    public BooleanProperty rejectedProperty() {
      return rejected;
    }
    
    public void setRejected(boolean val) {
      rejected.set(val);
    }
    
    //

    private static final PseudoClass INVALID_PSEUDO_CLASS = 
            PseudoClass.getPseudoClass("invalid");
  
    public BooleanProperty invalid = new BooleanPropertyBase(false) {
      @Override protected void invalidated() {
        pseudoClassStateChanged(INVALID_PSEUDO_CLASS, get());
      }
      @Override public Object getBean() {
        return CheckedTextField.this;
      }
      @Override public String getName() {
        return "invalid";
      }
    };
    
    public boolean isInvalid() {
      return invalid.get();
    }

    public BooleanProperty invalidProperty() {
      return invalid;
    }
    
    public void setInvalid(boolean val) {
      invalid.set(val);
    }
    
  }
