 /*==================================================================== TalBlm.h
 *
 * Meteorological boundary layer mode according to VDI 3783 Part 8 (2017)
 * ======================================================================
 *
 * Copyright (C) Umweltbundesamt, Dessau-Rolau, Germany, 2002-2019
 * Copyright (C) Janicke Consulting, 88662 berlingen, Germany, 2002-2019
 * Email: info@austal.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * last change: 2018-10-04 uj
 *
 *============================================================================*/

#ifndef  TALBLM_INCLUDE
#define  TALBLM_INCLUDE

#ifndef   IBJARY_INCLUDE
  #include "IBJary.h"
#endif

#ifndef   TALIO1_INCLUDE
  #include "TalIo1.h"
#endif

#define  DEFUCALM  0.5
#ifndef  NOTV
  #define  NOTV  -999.0
#endif

#define  BLMDEFVERS   53
#define  BLMINTDEF  3600																		//-2002-08-08
#define  BLMINTMIN    60
#define  BLMINTMAX  3600
#define  BLMDEFHA   10.0
#define  BLMDEFSIG   0.3
#define  BLMDEFLMO  99999
#define  BLMDEFHM    800
#define  BLMMOSMIN  -0.1
#define  BLMMOSMAX  0.05
#define  BLMSZ0     "0.5"
#define  BLMSTUMAX  "1200"
#define  BLMSTVMAX  "1200"
#define  BLMSTWMAX  "1200"

#define  BLMVKK     0.40
#define  BLMGRAV    9.8066       // gravitational acceleration (m/s2)
#define  BLMCPRESS  1004.1       // specific heat capacity at constant pressure (J/(kgK))
#define  BLMTZERO   273.15
#define  BLMDRYAD   -0.009766557 // g/cp
#define  BLMTMIN    -30.0        // minimum tempertature for vertical profile
#define  BLMTMAX    40.0         // maximum tempertature for vertical profile
#define  BLMHT      2.0          // height of temperature Ta
#define  BLMHT2     200.0        // height above which BLMGRAD2 applies
#define  BLMGRAD2   -0.0085      // temperature gradient in K/m above height BLMHT2
#define  BLMFCOR    1.1e-4       // default fcor (1/s)
#define  BLMFCORMIN 6.1618e-5    // fcor at 25 deg
#define  BLMFCORMAX 1.4580e-4    // fcor at 90 deg

typedef struct {
        float z, u, g, d, su, sv, sw, tu, tv, tw, suw, ths;
        } BLMREC;

typedef struct {
        long MetVers;
        float RghLen, ZplDsp, MonObLen, RezMol, MixDpt, Precep,   //-2011-11-21
              Class, Ustar, UsgCalc, UstCalc, ThetaGrad, PtmpGrad;
        float AnmXpos, AnmYpos, AnmZpos;
        float AnmHeight, WndSpeed, WndDir, SigmaU, SigmaV, SigmaW;
        float AnmHeightW;                                         //-2012-11-05
        int AnmGridNumber;
        float StatWeight, U10;
        long kta;
        float us, lmo, hm, cl, ths;
        char WindLib[256];
        int Wind, Wini, Diff, Turb;
        float HmMean[6], ZgMean;                                  //-2018-10-04
        float Fcor, HmNeutral, u2lH1, u2lK2, u2lFa, u2lUg;        //-2018-10-04
        float Ta, Rh;                                             //-2018-10-04
        float AvrTime;                                            //-2018-10-04                                 
        } BLMPARM;

extern BLMPARM *BlmPprm;
extern ARYDSC *BlmParr;
extern VARTAB *BlmPvpp;

//=============================== PROTOTYPES TALBLM ==========================

long BlmProfile(      /* Berechnung des Grenzschicht-Profils.               */
BLMPARM *p,           /* Eingabe-Daten (Grenzschicht-Parameter).            */
BLMREC *v );          /* Ausgabe-Daten (Wind-Varianzen und Korr.-Zeiten).   */

long BlmStability(    /* Berechnung von Mischungsschichthoehe und Stab.-Kl. */
BLMPARM *p );         /* Parameter der Grenzschicht.                        */

float BlmSrfFac(        /* factor to impose surface layer */
float z0,               /* roughness length               */
float d0,               /* zero plane displacement        */
float h )               /* height above ground            */
  ;
long BlmInit(           /* initialize server    */
long flags,             /* action flags         */
char *istr )            /* server options       */
  ;
long BlmServer(         /* server routine for BLM       */
char *s )               /* calling option               */
  ;
float BlmTemp( // temperature (C or K)
  float h,     // height above ground (m)
  float z0,    // roughness length (m)
  float d0,    // displacement height (m) 
  float ust,   // friction velocity (m/s)
  float lm,    // Obukhov length (m)
  float ta,    // temperature at height hta (C or K)
  int vers)    // boundary layer version
;
//==========================================================================//
#endif
