/*
 * pluris.h
 *
 *  Created on: 12.01.2016
 *      Author: ibj/lj
 */

#ifndef PLURIS_H_
#define PLURIS_H_

#define PLRMAXHEIGHT    800.0
#define PLRBREAKFACTOR    1.3

  typedef struct src {
    double hb;  // stack height (m)
    double dm;  // inner diameter (m)
    double ve;  // exhaust velocity (m/s)
    double te;  // exhaust temperature (C)
    double zq;  // water load (kg/kg dry)                          //-2018-09-10
    double sq;  // specific vapour content (kg/kg)
    double rq;  // relative humidity (%)
    double lq;  // specific liquid water content (kg/kg)
    double us;  // friction velocity (m/s) for break condition
    double lm;  // Obukhov length (m) for information
    double ta;  // ambient temperature (C)
  } PLRSRC;

  typedef struct pvl {
    double ha;  // anemometer height
    double ua;  // wind velocity
    double da;  // wind direction
    double ta;  // air temperature
    double ia;  // turbulence intensity
    double ra;  // relative humidity
    double ca;  // ambient concentration
  } PLRPVL;

  typedef struct prm {
    double sc;       // scaling length (m)
    double sd;       // scaled step size
    double se;       // scaled maximum distance
    int sn;          // number steps for listing
    int adjust_step; // dynamic step size (0: none, >0: step = rr/adjuststeps)
    double min_us;   // minimum u* for break condition
    int const_ust;   // use ust = const                              -2021-03-01
  } PLRPRM;

  typedef struct rsl {
    double vr;
    double tr;
    double dr;
  } PLRRSL;
  
  extern float PlrMaxHeight;
  extern float PlrBreakFactor;
  extern int PlrStDownwash;
  extern int PlrVerbose;
  extern FILE *PlrMessage;

  extern PLRPVL* _pvl(double ha, double ua, double da, double ta, double ia, double ra,
        double ca);

  extern PLRPRM* _prm(double sc, double sd, double se, int sn);

  extern char* str_prm(PLRPRM prm);

  extern char* str_pvl(PLRPVL pvl);

  extern char* str_src(PLRSRC src);

  extern char* str_rsl(PLRRSL rsl);
  
  extern char* str_version(void);
   
  /*
   * Run pluris to calculate plume rise.
   *
   * Arguments:
   * src pointer to source definition
   * NZ  number levels in meteorological profile
   * prf meteorological profile (array with NZ elements)
   * rsl pointer to result: Vptl and Tptl
   * 
   *
   * Returns:
   *  0 on success
   * -1 on initialization error
   */
    extern int run_pluris(PLRSRC* src, int NZ, PLRPVL* prf, PLRPRM* prm, 
        PLRRSL* rsl);

#endif /* PLURIS_H_ */
