/*===================================================================== TalCfg.c
 *
 * Configuration data
 * ==================
 *
 * Copyright (C) Umweltbundesamt, Dessau-Rolau, Germany, 2002-2019
 * Copyright (C) Janicke Consulting, 88662 berlingen, Germany, 2002-2019
 * Email: info@austal.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * last change:  2018-10-04 uj
 *
 *============================================================================*/

#include <stddef.h>
#include <string.h>

#include "TalCfg.h"
#include "TalCfg.nls"

char *CfgLanguage;
char *CfgDepString;                                               //-2011-11-23
char *CfgDryString;                                               //-2011-11-23
char *CfgWetString;                                               //-2011-11-23
char *CfgDayString;
char *CfgIndString;
char *CfgAddString;
char *CfgDevString;
char *CfgYearString;
char *CfgHourString;
char *CfgMntAddString;
char *CfgMntBckString;
char *CfgMntSctString;
char *CfgSeriesString;
char *CfgPrecString;                                              //-2018-10-04
int  CfgWet=0;                                                    //-2014-01-21

static char string[256];

char *CfgString() {
  strcpy(string, "/");
  strcat(string, _language_);
  strcat(string, "/");
  strcat(string, _add_string_);
  strcat(string, "/");
  strcat(string, _dev_string_);
  strcat(string, "/");
  strcat(string, _hour_string_);
  strcat(string, "/");
  strcat(string, _day_string_);
  strcat(string, "/");
  strcat(string, _ind_string_);
  strcat(string, "/");
  strcat(string, _year_string_);
  strcat(string, "/");
  strcat(string, _mnt_add_string_);
  strcat(string, "/");
  strcat(string, _mnt_sct_string_);
  strcat(string, "/");
  strcat(string, _mnt_bck_string_);
  strcat(string, "/");
  strcat(string, _series_);
  return string;
}

void CfgInit(void) {
  CfgLanguage=_language_;
  CfgDepString = _dep_string_;                                    //-2011-12-13
  CfgDryString = _dry_string_;                                    //-2011-11-23
  CfgWetString = _wet_string_;                                    //-2011-11-23
  CfgDayString = _day_string_;
  CfgIndString = _ind_string_;
  CfgAddString = _add_string_;
  CfgDevString = _dev_string_;
  CfgYearString = _year_string_;
  CfgHourString = _hour_string_;
  CfgMntAddString = _mnt_add_string_;
  CfgMntBckString = _mnt_bck_string_;
  CfgMntSctString = _mnt_sct_string_;
  CfgSeriesString = _series_;
  CfgPrecString = _prec_string_;
}

