// Analysieren der bodennahen Konzentration aus Windkanalmessungen: 
// Berechnung von Cy und Sy 
// 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

static int CHECK = 0;

static int Ny;
static double X, Yy[100], Cc[100], Uq, Hq, Eq;
static double Cm, Cy, Sy, Ym;
static char Path[256], InFile[256], OutFile[256], Buf[8000];

static FILE* ReadHeader( char *name ) {
  FILE *f;
  char fn[256], *ps=NULL, *pt;
  int j;
  strcpy(fn, Path);
  strcat(fn, name);
  f = fopen(fn, "rb");  
  if (!f) {
    printf("can't read file %s\n", fn);
    return NULL;
  }
  while (fgets(Buf, 8000, f)) {
    if (NULL != (ps=strstr(Buf, "x\\y")))  break;
  }
  if (!ps) {
    printf("header not found\n");
    fclose(f);
    return NULL;
  }
  pt = strtok(ps+3, " \t\r\n");
  Ny = 0;
  while (pt) {
    if (1 != sscanf(pt, "%lf", Yy+Ny)) {
      printf("can't read header\n");
      fclose(f);
      return NULL;
    }
    Ny++;
    if (Ny >= 100)  break;
    pt = strtok(NULL, " \t\r\n");
  }
  if (Hq <= 0)  Hq = 1;
  for (j=0; j<Ny; j++)  Yy[j] /= Hq;
  return f;
}

static double GaussDev( double *pp ) {
  double cm = pp[0];
  double sy = pp[1];
  double y0 = pp[2];
  double sum = 0;
  double cc, cg, y, d;
  double w2p = sqrt(2*3.1415926);
  int j;
  for (j=0; j<Ny; j++) {
    cc = Cc[j];
    if (cc < 0)  cc = 0;
    y = Yy[j];
    d = (y - y0)/sy;
    cg = cm*exp(-d*d/2);
    sum += (cc-cg)*(cc-cg);
  }
  return sum/Ny;
}

static double OptimizeParm( double *pp, double step, int k ) {
  double pl, pr, p0, p1, p2, dl, dr, d0, d1, d2;
  int n;
  p0 = pp[k];
  d0 = GaussDev(pp);
  p1 = p0 + step;
  pp[k] = p1;
  d1 = GaussDev(pp);
  if (d1 < d0) {
    p2 = p1 + step;
    pp[k] = p2;
    d2 = GaussDev(pp);
    while (d2 < d1) {
      p0 = p1;
      d0 = d1;
      p1 = p2;
      d1 = d2;
      p2 = p1 + step;
      pp[k] = p2;
      d2 = GaussDev(pp);
    }
  }
  else {
    p0 = p1 - step;
    if (p0<=0 && k<2) goto done;
    pp[k] = p0;
    d0 = GaussDev(pp);
    while (d0 < d1) {
      p2 = p1;
      d2 = d1;
      p1 = p0;
      d1 = d0;
      p0 = p1 - step;
      if (p0<=0 && k<2)  goto done;
      pp[k] = d0;
      d0 = GaussDev(pp);
    }
  }
  for (n=0; n<10; n++) {
    pl = 0.5*(p0 + p1);
    pp[k] = pl;
    dl = GaussDev(pp);
    if (dl < d1) {
      p2 = p1;
      d2 = d1;
      p1 = pl;
      d1 = dl;
    }
    else {
      pr = 0.5*(p1 + p2);
      pp[k] = pr;
      dr = GaussDev(pp);
      if (dr < d1) {
        p0 = p1;
        d0 = d1;
        p1 = pr;
        d1 = dr;
      }
      else {
        p0 = pl;
        d0 = dl;
        p2 = pr;
        d2 = dr;
      }
    }
  }
done:
  pp[k] = p1;
  return d1;
}
  

static int GaussApprox( char *s, double step ) {
  char *pt;
  int j, n;
  double parm[3];  // cm, sy, ym
  double d, cm, w2p = sqrt(2*3.1415926);
  if (Hq <= 0)  Hq = 1;
  pt = strtok(s, " \t\r\n");
  if (!pt)                            return  0;
  if (1 != sscanf(pt, "%lf", &X))     return -1;
  X /= Hq;
  for (j=0; j<Ny; j++) {
    pt = strtok(NULL, " \t\r\n");
    if (!pt)                          return -2;
    if (1 != sscanf(pt, "%lf", Cc+j)) return -3;
  }
  cm = 0;
  for (j=0; j<Ny; j++)
    if (Cc[j] > cm)  cm = Cc[j];
  parm[0] = cm;
  parm[1] = 0.5;
  parm[2] = 0;
  for (n=0; n<20; n++) {
    d = OptimizeParm(parm, step, 0);
    if (CHECK) printf("n=%2d, k=0, d=%12.5le, cm=%1.3lf, sy=%1.3lf, ym=%1.3lf\n", n, d, parm[0], parm[1], parm[2]);
    d = OptimizeParm(parm, step, 1);
    if (CHECK) printf("n=%2d, k=0, d=%12.5le, cm=%1.3lf, sy=%1.3lf, ym=%1.3lf\n", n, d, parm[0], parm[1], parm[2]);
    d = OptimizeParm(parm, step, 2);
    if (CHECK) printf("n=%2d, k=0, d=%12.5le, cm=%1.3lf, sy=%1.3lf, ym=%1.3lf\n", n, d, parm[0], parm[1], parm[2]);
  }
  Cm = parm[0];
  Sy = parm[1];
  Ym = parm[2];
  Cy = w2p*Sy*Cm;
  return 1;
}

int main( int argc, char *argv[] ) {
  char s[400], fn[256];
  int i, l, n;
  FILE *f, *g;
  if (argc < 2) {
    printf("usage: AnalyseTunnel <Path> -e<Q> -h<H> -i<input> -u<U> -o<output> \n");
    printf("input: table of experimental data\n");
    exit(0);
    }
  for (i=1; i<argc; i++) {
    strcpy(s, argv[i]);
    if (*s == '-') 
    switch(s[1]) {
        case 'e':  sscanf(s+2, "%lf", &Eq);
                   break;
        case 'h':  sscanf(s+2, "%lf", &Hq);
                   break;
        case 'i':  strcpy(InFile, s+2);
                   break;
        case 'u':  sscanf(s+2, "%lf", &Uq);
                   break;
        case 'o':  strcpy(OutFile, s+2);
                   break;
        default:   ;
        }
    else {
      strcpy(Path, s);
      }
    }
  l = strlen(Path);
  for (i=0; i<l; i++)  if (Path[i] == '\\')  Path[i] = '/';
  if (l>0 && Path[l-1]!='/')  strcat(Path, "/");
  f = ReadHeader(InFile);
  if (f == NULL) {
    printf("error reading header of file %s%s!\n", Path, InFile);
    exit(1);
    }
  strcpy(fn, Path);
  strcat(fn, OutFile);
  g = fopen(fn, "wb");
  if (!g) {
    printf("can't write file %s!\n", fn);
    exit(4);
  }
  fprintf(g, "AnalyseTunnel %s -i%s -o%s -h%1.0lf\n", Path, InFile, OutFile, Hq);
  fprintf(g, "Nr.     X/H Cm*H*H*U/Q   Cy*H*U/Q       Sy/H\n");
  n = 0;
  while (fgets(Buf, 8000, f)) {
    i = GaussApprox(Buf, 0.01);
    if (i < 1)  break;
    n++;
    fprintf(g, "%2d: %7.3lf    %7.3lf    %7.3lf    %7.3lf\n", n, X, Cm, Cy, Sy);
  }
  fclose(f);
  fclose(g);
  printf("%d profiles calculated\n", n);
  return 0;
}
  


