// Analysieren der bodennahen Konzentration: Berechnung von Cy und Sy 
// 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

static int Nx, Ny, TtlSz, Drop;
static float Xmin, Ymin, Delta, Uq, Hq, Eq;
static float *Data, *List;
static char *Header;
static char Path[256], InFile[256], OutFile[256], Buf[8000];

#define  CC(i,j)  Data[j-1+Ny*(i-1)]
#define  LL(i,l)  List[l-1+5*(i-1)]

static int ReadVar( char *buf, char *name, char *format, int nr, void *result )
  ;
  
static int ReadHeader( char *name ) {
  FILE *f;
  char fn[256];
  int l, lowb[3], hghb[3];
  strcpy(fn, Path);
  strcat(fn, name);
  f = fopen(fn, "rb");  if (!f)         return -1;
  while (fgets(Buf, 8000, f))  
    if (*Buf == '*')  break;
  if (*Buf != '*')                      return -10;
  l = ftell(f);
  Header = malloc(l+1);  if (!Header)   return -11;
  if (fseek(f, 0, SEEK_SET))            return -12;
  if (1 != fread(Header, l, 1, f))      return -13;
  fclose(f);
  if (3 != ReadVar(Header, "lowb", "%d", 3, lowb))    return -21;
  if (lowb[0]!=1 || lowb[1]!=1 || lowb[2]!=1)         return -22;
  if (3 != ReadVar(Header, "hghb", "%d", 3, hghb))    return -23;
  Nx = hghb[0];                              
  Ny = hghb[1];
  if (1 != ReadVar(Header, "xmin",  "%f", 1, &Xmin))  return -24;
  if (1 != ReadVar(Header, "ymin",  "%f", 1, &Ymin))  return -25;
  if (1 != ReadVar(Header, "delta", "%f", 1, &Delta)) return -26;
  if (1 != ReadVar(Header, "sequ",  "%s", 1, Buf))    return -27;
  if (strcmp(Buf, "k+,j-,i+"))                        return -28;
  return l;
}

static int ReadData( char *name, int l ) {
  FILE *f;
  int i, j;
  char fn[256], *pt;
  strcpy(fn, Path);
  strcat(fn, name);
  f = fopen(fn, "rb");  if (!f)             return -1;
  if (fseek(f, l, SEEK_SET))                return -10;
  TtlSz = 4*Nx*Ny;
  Data = malloc(TtlSz);  if (!Data)         return -11;
  for (j=Ny; j>0; j--) {
    if (!fgets(Buf, 8000, f))               return -12;
    pt = strtok(Buf, " \t");
    for (i=1; i<=Nx; i++) {
      if (!pt)                              return -13;
      if (1 != sscanf(pt, "%f", &CC(i,j)))  return -14;
      pt = strtok(NULL, " \t");
    }
  }
  fclose(f);
  return Nx*Ny;
}

static int StrIcmp( char *s1, char *s2, int n )
  {
  int i;
  if (!s1 || !s2)                          return 1;
  for (i=0; i<n; i++) {
    if (s1[i]==0 && s2[i]==0)              return 0;
    if (tolower(s1[i]) != tolower(s2[i]))  return 1;
    }
  return 0;
  }

static int ReadVar( char *buf, char *name, char *format, int nr, void *result )
  {
  int i, n, *pi, l;
  float *pf;
  double *pd;
  char *pc, *pe, *ps;
  l = strlen(name);  if (l<1 || l>79)           return -1;
  pc = buf;
  while (pc) {
    if (!StrIcmp(pc, name, l))  break;
    pc = strchr(pc, '\n');
    if (pc)  pc++;
    }
  if (!pc)                                      return 0;
  if      (!strcmp(format, "%d"))   pi = result;
  else if (!strcmp(format, "%f"))   pf = result;
  else if (!strcmp(format, "%lf"))  pd = result;
  else if (!strcmp(format, "%s"))   ps = result;
  else                                          return -2;
  pe = strchr(pc, '\n');
  if (pe)  l = pe-pc+1;
  else     l = strlen(pc);
  pe = malloc(l+1);  if (!pe)                   return -3;
  strncpy(pe, pc, l);
  pe[l] = 0;
  if (!strcmp(format, "%s")) {
    for (pc=pe+l-1; pc>pe; pc--)
      if (*pc <= ' ')  *pc = 0;
      else break;
    if (*pc == '\"')  *pc = 0;
    for (pc=pe+strlen(name); (*pc); pc++)
      if (*pc > ' ')  break;
    if (!*pc)                                   return 0;
    if (*pc == '\"')  pc++;
    strcpy(ps, pc);
    return 1;
  }
  pc = strtok(pe, " ,\t\r\n");  if (!pc)        return -4;
  for (n=0; n<nr; n++) {
    pc = strtok(NULL, " ,\t\r\n");
    if (!pc)  break;
    if      (!strcmp(format, "%d")) {
      i = sscanf(pc, format, pi);
      if (i == 1)  pi++;
      }
    else if (!strcmp(format, "%f")) {
      i = sscanf(pc, format, pf);
      if (i == 1)  pf++;
      }
    else if (!strcmp(format, "%lf")) {
      i = sscanf(pc, format, pd);
      if (i == 1)  pd++;
      }
    else                                        return -2;
    if (i != 1)  break;
    }
  free(pe);
  return n;
  }

int CalcSigY( void )
  {
  float y, dy, ym, syq, cmax, da, dj, sumy, sumc, w2p;
  int i, j;
  List = malloc(Nx*5*sizeof(float));  if (!List)  return -1;
  da = Delta*Delta/12;
  w2p = sqrt(2*3.1415926);
  for (i=1; i<=Nx; i++) {
    sumc = 0;
    sumy = 0;
    cmax = 0;
    for (j=1; j<=Ny; j++) {
      y = Ymin + (j-0.5)*Delta;
      sumc += CC(i,j);
      sumy += CC(i,j)*y;
      if (CC(i,j) > cmax)  cmax = CC(i,j);
    }
    ym = (sumc > 0) ? sumy/sumc : 0;
    sumy = 0;
    for (j=1; j<=Ny; j++) {
      dy = Ymin + (j-0.5)*Delta - ym;
      sumy += CC(i,j)*(dy*dy + da);
      }
    syq = (sumc > 0) ? sumy/sumc : 0;
    LL(i,1) = Xmin + (i-0.5)*Delta;
    LL(i,2) = sumc*Delta;
    LL(i,3) = sqrt(syq);
    LL(i,4) = (sumc > 0) ? LL(i,2)/(w2p*LL(i,3)) : 0;
    LL(i,5) = cmax;
    }
  return 0;
  }

int PrintList( char *name )
  {
  int i, i0, di;
  FILE *f;
  char fn[256];
  if (*name) {
    strcpy(fn, Path);
    strcat(fn, name);
    f = fopen(fn, "wb");
    if (!f) {
      printf("can't write to file %s!\n", fn);
      return -1;
      }
    }
  else f = stdout;
  if (Hq <= 0)  Hq = 1;
  if (Uq <= 0)  Uq = 1;
  if (Eq <= 0)  Eq = 1;
  if (Drop < 0)  Drop = 0;
  i0 = (Delta-Xmin)/Delta;
  di = 1 + Drop;
  fprintf(f, "AnalysePlume %s -i%s -o%s -d%d -e%10.2e -h%1.1f -u%1.1f\n",
            Path, InFile, OutFile, Drop, Eq, Hq, Uq);
  fprintf(f, "Nr.     X/H Cy*U*H/Q    Sy/H Ca*U*H*H/Q Cm*U*H*H/Q\n");
  for (i=i0; i<=Nx; i+=di)
    fprintf(f, "%3d %7.3f  %7.3f %7.3f    %7.3f    %7.3f\n",
           i, 
           LL(i,1)/Hq, 
           LL(i,2)*Uq*Hq/Eq, 
           LL(i,3)/Hq, 
           LL(i,4)*Uq*Hq*Hq/Eq,
           LL(i,5)*Uq*Hq*Hq/Eq
           );
  if (f != stdout)  fclose(f);
  return 0;
  }

int main( int argc, char *argv[] )
  {
  char s[400];
  int i, l, n;
  if (argc < 2) {
    printf("usage: AnalysePlume <Path> -e<Q> -h<H> -i<input> -u<U> -o<output> \n");
    printf("input: DMNA-file of austal2000\n");
    exit(0);
    }
  for (i=1; i<argc; i++) {
    strcpy(s, argv[i]);
    if (*s == '-') 
    switch(s[1]) {
        case 'd':  sscanf(s+2, "%d", &Drop);
                   break;
        case 'e':  sscanf(s+2, "%f", &Eq);
                   break;
        case 'h':  sscanf(s+2, "%f", &Hq);
                   break;
        case 'i':  strcpy(InFile, s+2);
                   break;
        case 'u':  sscanf(s+2, "%f", &Uq);
                   break;
        case 'o':  strcpy(OutFile, s+2);
                   break;
        default:   ;
        }
    else {
      strcpy(Path, s);
      }
    }
  l = strlen(Path);
  for (i=0; i<l; i++)  if (Path[i] == '\\')  Path[i] = '/';
  if (l>0 && Path[l-1]!='/')  strcat(Path, "/");
  i = ReadHeader(InFile);
  if (i < 0) {
    printf("error reading header of file %s%s! (%d)\n", Path, InFile, i);
    exit(1);
    }
  i = ReadData(InFile, i);
  if (i < 0) {
    printf("error reading data of file %s%s! (%d)\n", Path, InFile, i);
    exit(2);
    }
  i = CalcSigY(); 
  if (i < 0) {
    printf("can't analyse plume! (%d)\n", i);
    exit(3);
    }
  PrintList(OutFile);

  fprintf(stderr, "finished\n");
  return 0;
  }
