////////////////////////////////////////////////////////////////////////////////
//
// history
//
// 2021-10-07 uj distribution
// 
////////////////////////////////////////////////////////////////////////////////

/**
 * ProgressButton
 * 
 * Utility class used by Besmin and Besmax
 *
 * Copyright (C) Umweltbundesamt Dessau-Roßlau, Germany, 2021
 * Copyright (C) Janicke Consulting, Überlingen, Germany, 2021
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

package de.janicke.fxutil;

import java.util.LinkedList;
import java.util.List;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.paint.Color;

public class ProgressButton extends Button {
  
  private final Canvas canvas;
  private final GraphicsContext gc;
  //
  private Color done = Color.GREEN;
  private Color todo = Color.RED;
  private double progress;  // 0..1
  private boolean update;   // redraw even if 'progress' is not changed
  private Background background;
  private List<BackgroundFill> fills;

  public ProgressButton() {
    super();
    canvas = new Canvas();
    gc = canvas.getGraphicsContext2D();
    widthProperty().addListener((obs, old, val) -> {
      updateImage();
    });
    heightProperty().addListener((obs, old, val) -> {
      updateImage();
    });
    clearProgress();
  }

  public final void clearProgress() {
    canvas.setWidth(10);
    canvas.setHeight(10);
    gc.clearRect(0, 0, 10, 10);
    progress = -1;
    update = false;
    background = getBackground();
    if (background == null)
      return;
    fills = background.getFills();
    background = new Background(fills, null);
    setBackground(background);
  }

  public void setColors(Color todo, Color done) {
    this.todo = todo;
    this.done = done;
  }

  public void setProgress(double p) {
    background = getBackground();
    if (background == null)
      return;
    if (p < 0)
      p = 0;
    if (p > 1)
      p = 1;
    if (Math.round(p*100) == Math.round(progress*100) && !update)
      return;
    progress = p;
    double h = getHeight();
    double w = getWidth();
    //
    canvas.setWidth(w);
    canvas.setHeight(h);
    gc.setFill(todo);
    gc.fillRect(0, 0, w, h);
    if (p > 0) {
      gc.setFill(done);
      gc.fillRect(0, 0, p*w, h);
    }
    BackgroundImage image = new BackgroundImage(
        canvas.snapshot(null, null), 
        BackgroundRepeat.NO_REPEAT, 
        BackgroundRepeat.NO_REPEAT, 
        null, 
        null);
    fills = background.getFills();
    List<BackgroundImage> list = new LinkedList<>();
    list.add(image);
    setBackground(new Background(fills, list));
  }

  public double getProgress() {
    return progress;
  }

  private void updateImage() {
    if (progress >= 0) {
      update = true;
      setProgress(progress);
    }
  }
    
}
